<jsp:include page="../common/header.jsp">
	<jsp:param value="Storage_Provisioning_Policy_Details" name="title" />
	<jsp:param value="../common/css/jquery.loadmask.css" name="css"/>
	<jsp:param value="../common/css/table.css" name="css" />	
	<jsp:param value="../common/smartwizard/css/smart_wizard_vertical.css" name="css" />
	<jsp:param value="../common/css/custom-cb.css" name="css"/>
	<jsp:param value="../common/css/ui.spinner.css" name="css"/>
	<jsp:param value="css/storageprov.css" name="css" />	
	<jsp:param value="true" name="includeSecHeader" />
	<jsp:param value="Storage_Provisioning_Policy_Details" name="headerTitle" />
	<jsp:param value="true" name="bootstrapped" />
	<jsp:param value="true" name="includeTableSupport" />
	<jsp:param value="true" name="includeCustomSelect"/>
	<jsp:param value="../common/css/jquery.multiselect.css" name="css"/>
	<jsp:param value="true" name="includeHistory"/>
	<jsp:param value="My Storage:storageprovisioning/,Admin Operations:storageprovisioning/adminPage.do?AdminPage=Admin,Policies :storageprovisioning/adminPage.do?AdminPage=Policies" name="breadCrumbValues" />
</jsp:include>

<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>

<fmt:bundle basename="localization.StorageProvisioningMessages">
	<div id=policyDetails style="width:100%;" class="container">
		<div id='policyBasicDetails'>
			<div id="toolbarStorageDetails">
				<ul id="storagelistactions" class="storageactions">					
	                <li id="DELETE_POLICY" class="sprovaction dummyicon" title="<fmt:message key="storageprov.policies.deletepolicy" />"><span class="sprite icon-delete"></span></li>
	                <li id="EDIT_POLICY" class="sprovaction dummyicon" title="<fmt:message key="storageprov.policies.modifypolicy" />"><span class="sprite icon-edit"></span></li>		                
        		</ul>
			</div>
			<br/>						
			<br/>	
			<span style="font-weight:bold"><fmt:message key="storageprov.policies.label.general" /></span>
			<hr size="1">
			<ul class="blockrows">		
				<li class="infotype"><fmt:message key="storageDetails.label.name" /></li>
				<li class="infodesc">${policyDetails.policyName}</li>		
				<li class="infotype"><fmt:message key="storageprov.policies.label.policyType" /></li>
				<c:if test="${policyDetails.policyTypeId == 1}">
					<li class="infodesc"><fmt:message key="storageprov.policies.label.blockStorage" /></li>
				</c:if>		
				<li class="infotype"><fmt:message key="storageprov.policies.label.policyDescription" /></li>
				<li class="infodesc">${policyDetails.description}</li>		
				<li class="infotype"><fmt:message key="storageprov.policies.label.policyQuota" /></li>
				<li class="infodesc">${policyDetails.userQuotaInGB} <fmt:message key="storageprov.policies.label.GB" /></li>		
				<li class="infotype"><fmt:message key="storageprov.policies.label.expirationPeriod" /></li>
				<li class="infodesc">${policyDetails.expirationPeriod} <fmt:message key="storageprov.policies.label.days" /></li>		
			</ul>
		</div>
	</div>
	<br/><br/>
	<div id="storMapInfo">
		<br>
		<table id="storageMountInfo" class="clearFloat tablesorter">
			<thead>
				<tr>
					<th style="font-weight: bold;width: 60%;"><fmt:message key="storageprov.policies.label.storageEntityName" /></th>
					<th style="font-weight: bold;width: 40%;"><fmt:message key="storageprov.policies.label.selectionType" /></th>
				</tr>
			</thead>
			<tbody>
				<c:forEach items="${policyDetails.includeExcludeList.includeExcludeArrayList}" var="row">
					<tr>
					<c:if test="${row.flags == 1}">
						<c:if test="${row.selectionType == 1}">
							<td>${row.arrayName}</td>
							<td><fmt:message key="storageprov.policies.label.filers" /></td>
						</c:if>							
						<c:if test="${row.selectionType == 2}">
							<td>${row.reserve.reserveString}</td>
							<td><fmt:message key="storageprov.policies.label.vendor" /></td>
						</c:if>							
						<c:if test="${row.selectionType == 3}">
							<td>${row.arrayName}</td>
							<td><fmt:message key="storageprov.policies.label.wildCards" /></td>
						</c:if>
					</c:if>
					<c:if test="${row.flags == 2}">
						<td>${row.arrayName}</td>
						<td><fmt:message key="storageprov.policies.label.excludeFilter" /></td>
					</c:if>
						
					</tr>
				</c:forEach>
			</tbody>
		</table>
		<br>
		<table id="storageMountInfo" class="clearFloat tablesorter">
			<thead>
				<tr>
					<th style="font-weight: bold;width: 60%;"><fmt:message key="storageprov.policies.label.resourcePools" /></th>
					<th style="font-weight: bold;width: 40%;"><fmt:message key="storageprov.policies.label.includeExclude" /></th>
				</tr>
			</thead>
			<tbody>
				<c:forEach items="${policyDetails.includeExcludeList.includeExcludeStoragePoolList}" var="row">
					<tr>
						<c:if test="${row.flags == 1}">
							<td>${row.storagePoolName}</td>
							<td><fmt:message key="storageprov.policies.label.include" /></td>
						</c:if>
						<c:if test="${row.flags == 2}">
							<td>${row.storagePoolName}</td>
							<td><fmt:message key="storageprov.policies.label.exclude" /></td>
						</c:if>
					</tr>
				</c:forEach>
			</tbody>
		</table>
		<br>
		<table id="storageMountInfo" class="clearFloat tablesorter">
			<thead>
				<tr>
					<th style="font-weight: bold;width: 60%;"><fmt:message key="storageprov.policies.label.UserOrUserGroup" /></th>
					<th style="font-weight: bold;width: 40%;"><fmt:message key="storageprov.policies.label.UserType" /></th>
				</tr>
			</thead>
			<tbody>
				<c:forEach items="${policyDetails.userOrGroupList}" var="row">
					<tr>
						<td style="width:60%">${row.userOrGroupName}</td>
						<c:if test="${row.isGroup == 1}">
							<td style="width:40%"><fmt:message key="storageprov.policies.label.Group" /></td>
						</c:if>
						<c:if test="${row.isGroup == 0}">
							<td style="width:40%"><fmt:message key="storageprov.policies.label.User" /></td>
						</c:if>
					</tr>
				</c:forEach>
			</tbody>
		</table>
	</div>
	<div class="hide">
		 <div id="deletePolicyDialog" title="<fmt:message key="storageprov.policies.deletepolicy"/>">
			 <div>
			 	<p class="warning"><fmt:message key="storageprov.policies.deleteSelectedPolicy"/></p>
			 </div>	 	
		 </div>
	 </div>
	
	<div id="editPolicyDialogHolder" style="display:none;">
		<div id="editPolicyDialog" title="<fmt:message key="storageprov.policies.label.modifyPolicy"/>">
			<%@ include file="editPolicy.jsp" %>
		</div>	
	</div>
</fmt:bundle>

<jsp:include page="../common/footer.jsp">
	<jsp:param value="js/sprovBase.js" name="js" />
	<jsp:param value="js/validation.js" name="js" />
	<jsp:param value="../reports/js/tablebase.js" name="js" />
	<jsp:param value="js/sprovBase.js" name="js" />
	<jsp:param value="js/policyDetails.js" name="js" />
	<jsp:param value="js/editPolicy.js" name="js" />
	<jsp:param value="../common/smartwizard/js/jquery.smartWizard.js" name="js" />
	<jsp:param value="../common/js/jquery.multiselect.min.js" name="js"/>
	<jsp:param value="true" name="bootstrapped" />
</jsp:include>		