<jsp:include page="../common/header.jsp">
	<jsp:param value="Host_Details" name="title" />
	<jsp:param value="../common/css/templatestyles.css" name="css" />
	<jsp:param value="css/applicationstyles.css" name="css" />	
	<jsp:param value="../common/css/headerstyles.css" name="css" />
	<jsp:param value="../common/css/jquery.loadmask.css" name="css"/>
	<jsp:param value="../common/css/table.css" name="css" />	
	<jsp:param value="../common/smartwizard/css/smart_wizard_vertical.css" name="css" />
	<jsp:param value="../common/css/custom-cb.css" name="css"/>
	<jsp:param value="../common/css/ui.spinner.css" name="css"/>
	<jsp:param value="css/storageprov.css" name="css" />	
	<jsp:param value="true" name="includeSecHeader" />
	<jsp:param value="Host_Details" name="headerTitle" />
	<jsp:param value="true" name="includeTableSupport" />
	<jsp:param value="true" name="includeCustomSelect"/>
	<jsp:param value="true" name="includeHistory"/>
	<jsp:param value="My Storage:storageprovisioning/index.jsp" name="breadCrumbValues" />
</jsp:include>

<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>

<fmt:bundle basename="localization.StorageProvisioningMessages">
	<div id=hostDetails style="width:100%;" class="container">
		<div id="hostInfo">
			<div id="toolbarHostDetails">
				<ul id="storagelistactions" class="storageactions">					
	                <li id="RENEW_ACTION_HOSTPAGE" class="disabledActions sprovaction dummyicon" title="<fmt:message key="storageDetails.actions.renew" />"><span class="sprite icon-renew"></span></li>
	                <li id="UNMAP_ACTION_HOSTPAGE" class="disabledActions sprovaction dummyicon" title="<fmt:message key="storageDetails.actions.unmount" />"><span class="sprite storageprovisioning-sprovunmount"></span></li>			                
	                <li id="EDIT_ACTION_HOSTPAGE" class="disabledActions sprovaction dummyicon" title="<fmt:message key="storageDetails.actions.editLun" />"><span class="sprite icon-edit"></span></li>
	                <li id="REASSIGN_ACTION_HOSTPAGE" class="disabledActions sprovaction dummyicon" title="<fmt:message key="storageDetails.actions.reassign" />"><span class="sprite icon-share"></span></li>		                
        		</ul>
			</div>
			<br/>						
			<br/>						
			<span style="font-weight:bold">General</span>
			<hr size="1">	
			<ul class="blockrows">		
				<li class="infotype"><fmt:message key="hostDetails.label.hostname" /></li>
				<li class="infodesc">${hostName}</li>		
				
				<li class="infotype"><fmt:message key="hostDetails.label.lunsMapped" /></li>
				<li class="infodesc">${totalLuns}</li>				
			</ul>
		</div>
		<br>
		<div id="hostMapInfo">
			<br>
			<span style="font-weight:bold">LUNs mapped to this Host</span>
			<hr size="1">
			<table id="hostToLunInfo" class="clearFloat tablesorter">
				<thead>
					<tr>
						<th>
							<div data-id="" class="hostToLunCheckBoxAll custom-cb unchecked" data-state="unchecked"></div>
						</th>
						<th style="font-weight: bold">LUN Name</th>
						<th style="font-weight: bold">Protocol</th>						
					</tr>
				</thead>
				<tbody>
					<c:forEach items="${hostDetails.lunList[0].mountList}" var="row">
						<tr>
							<td>
								<div data-id="${row.lunId}" class="hostToLunCheckBox custom-cb unchecked" data-state="unchecked"></div>						
							</td>
							<td>${row.errorString}</td>
							<c:if test="${row.protocolId == 3}">
								<td>ISCSI</td>
							</c:if>							
							<c:if test="${row.protocolId == 4}">
								<td>FC</td>
							</c:if>
						</tr>
					</c:forEach>
				</tbody>
			</table>
		</div>	
		<br>
	</div>	
</fmt:bundle>

<jsp:include page="../common/footer.jsp">
	<jsp:param value="../reports/js/tablebase.js" name="js" />
	<jsp:param value="js/sprovBase.js" name="js" />
	<jsp:param value="../common/smartwizard/js/jquery.smartWizard.js" name="js" />
	<jsp:param value="../common/js/ui.spinner.min.js" name="js"/>
	<jsp:param value="../common/js/jquery.loadmask.min.js" name="js"/> 
	<jsp:param value="../common/js/custom-cb.js" name="js"/>
	<jsp:param value="../common/js/encoder.js" name="js" />
</jsp:include>		