<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<fmt:bundle basename="localization.StorageProvisioningMessages">
<form id="editPolicyForm" name="editPolicy" method="post" action="editPolicy.do">
	<div id="wizardEditPolicy" class="swMain">
	  	<ul>
	    	<li><a href="#step-1">
	          <span class="stepDesc">
	             <fmt:message key="storageprov.policies.label.general" />
	          </span>
	      	</a></li>
	    	<li><a href="#step-2">
	          <span class="stepDesc">
	             <fmt:message key="storageprov.policies.label.policyConfig" />
	          </span>
	      	</a></li>
	      	<li><a href="#step-3">
	          <span class="stepDesc">
	             <fmt:message key="storageprov.policies.label.arrays" />
	          </span>
	      	</a></li>
	      	<li><a href="#step-4">
	          <span class="stepDesc">
	             <fmt:message key="storageprov.policies.label.resourcePools" />
	          </span>
	      	</a></li>
	      	<li><a href="#step-5">
	          <span class="stepDesc">
	             <fmt:message key="storageprov.policies.label.users" />
	          </span>
	      	</a></li>
	    	<li><a href="#step-6">
	          <span class="stepDesc">
	             <fmt:message key="spwizard.label.summary" />
	          </span>
	      	</a></li>	      	
	  	</ul>	
		<div id="editPolicyGeneralStep" class="step">
			<label for="policyName"><fmt:message key="storageprov.policies.label.policyName" /></label>
			<input id="policyName" placeholder="<fmt:message key="storageprov.policies.label.policyName" />" class="input_field_12em" type="text" name="policyName" maxlength="100"/>	
			
			<label for="policyType"><fmt:message key="storageprov.policies.label.policyType" /></label>
 			<select id="policyType"  class="customSelection" name="policyType"></select>
			
		</div>
		<div id="editPolicyConfigureStep" class="step">
		
			<label for="policyQuota"><fmt:message key="storageprov.policies.label.policyQuota" /></label>
			<input id="policyQuota" class="input_field_12em" type="text" name="policyQuota" maxlength="100"/>	
			
			<label for="policyDescription"><fmt:message key="storageprov.policies.label.policyDescription" /></label>		
			<textarea id="policyDescription" placeholder="Policy Description" name="policyDescription" rows="3" maxlength="50"></textarea>
		
			<label for="policyExpiration"><fmt:message key="storageprov.policies.label.policyExpirationPeriod" /></label>
			<input id="policyExpiration" class="input_field_12em datepicker" name="policyExpiration" maxlength="100"/>
	
			
		</div>
		<div id="editPolicyArraySelectionStep" class="step">
			
			<div id="includeList">
				<label id="Select" for="policyType"><fmt:message key="storageprov.policies.label.includeType" /></label>
	 			
				<input type="radio" name="storageIncludeType" value="filers" checked="checked" onclick="showStorageSelectionOptions(this);"> <fmt:message key="storageprov.policies.label.filers" />
				<input type="radio" name="storageIncludeType" value="vendor" onclick="showStorageSelectionOptions(this);"> <fmt:message key="storageprov.policies.label.vendor" />
				<input type="radio" name="storageIncludeType" value="regularExpression" onclick="showStorageSelectionOptions(this);"> <fmt:message key="storageprov.policies.label.wildCards" />
	 			
	 			
	 			<div id="filerOptions">
	 				<label for="filerIncludeFiler"><fmt:message key="storageprov.policies.label.filers" /></label>	
		 			<select id="selectArray"  class="customSelection" name="selectArray">
						<!-- <option id="0" value="NONE">Select Array</option> -->
					</select>
	 			</div>
					
	 			<div id="vendorSpecificOptions" style="display: none;">
	 				<label for="vendorIncludeFiler"><fmt:message key="storageprov.policies.label.vendor" /></label>	
	 				<select id="selectVendorType"  class="customSelection" name="vendorType">
						<!-- <option id="0" value="NONE">Select Vendor</option> -->
					</select>
	 			</div>
	 			
	 			<div id="regularExpressionOptions" style="display: none;">
					<label for="regularExpressionIncludeFilter"><fmt:message key="storageprov.policies.label.includeFilter" /></label>		
					<textarea id="regularExpressionIncludeFilter" style="margin:10px;" placeholder="Include Filter" name="includeFilter" rows="3" maxlength="50"></textarea>
	 			</div>
	 			
	 			
			</div>
			
			<div id="excludeList">  
				<label for="excludeFilter"><fmt:message key="storageprov.policies.label.filerExcludeFilter" /></label>		
				<textarea id="excludeFilter" style="margin:10px;" placeholder="Exclude Filter" name="includeFilter" rows="3" maxlength="50"></textarea>
				<label></label>		
				<label class="excludeFilterHelpText"><fmt:message key="storageprov.policies.label.filerExcludeFilterHelpText" /></label>
			</div>
		
		
		</div>
		<div id="editPolicyResourcePoolSelectionStep" class="step">
			<label id="resourcePoolType" for="resourcePoolType"><fmt:message key="storageprov.policies.label.resourcePools" /></label>
 			<select id="selectResourcePool"  class="customSelection" name="resourcePoolType">
			</select>
			
			<label for="resourcePoolExcludeFilter"><fmt:message key="storageprov.policies.label.excludeFilter" /></label>		
			<textarea id="resourcePoolExcludeFilter" style="margin:10px;" placeholder="Exclude Filter" name="includeFilter" rows="3" maxlength="50"></textarea>
			<label></label>		
				<label class="excludeFilterHelpText"><fmt:message key="storageprov.policies.label.filerExcludeFilterHelpText" /></label>
			
			<label id="resourcePoolType" for="resourcePoolType"><fmt:message key="storageprov.policies.label.resourcePoolsPreviouslySelected" /></label>	
			<label id="resourcePoolPreviouslySelected" style="margin:10px;"></label>
				
		</div>	
		<div id="editPolicyUserSelectionStep" class="step">
			<label id="SelectUser" for="policyType"><fmt:message key="storageprov.policies.label.selectUserType" /></label>
	 			
			<input type="radio" name="userIncludeType" value="userGroups" checked="checked" onclick="showUserSelectionOptions(this);"> <fmt:message key="storageprov.policies.label.userGroups" />
			<input type="radio" name="userIncludeType" value="users" onclick="showUserSelectionOptions(this);"> <fmt:message key="storageprov.policies.label.users" />
			
			<div id="userGroupSelectionDiv"> 
				<label id="userGroups" for="selectUserGroups"><fmt:message key="storageprov.policies.label.userGroups" /></label>
	 			<select id="selectUserGroups"  class="customSelection" name="selectUserGroups"></select>
			</div>

			<div id="userSelectionDiv" style="display: none;"> 
				<label id="user" for="selectUsers"><fmt:message key="storageprov.policies.label.users" /></label>
	 			<select id="selectUsers"  class="customSelection" name="selectUsers"></select>
			</div>
			
			
				
		</div>	
		<div id="editPolicySummaryStep" class="step">
			<table id="resultsTable" class="tablesorter">
			    <tbody id="storagePolicyTableBody">
			    </tbody>
		    </table>
		</div> 	
	</div>
</form>
</fmt:bundle>