<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>

<fmt:bundle basename="localization.SoftwareStoreMessages">
	
	<nav class="navigation" data-ng-if="!$ctrl.isCategoryView() && $ctrl.categories">
		<div class="home-category-wrapper">
			<a data-ui-sref="home({fl: $ctrl.params.fl})" class="home-category"
				data-ng-class="{active: $ctrl.isActive(0)}">
				<span class="icon"> <span class="glyphicon glyphicon-home home-icon"></span>

				</span> <span class="content category-name"><fmt:message key="store.home"/></span> 
			</a>
		</div>
		<div data-ng-repeat="category in $ctrl.categories" class="category-item">
			<a href="{{'#' + category.id}}_nav" data-ui-sref="category({categoryId: category.id, fl: $ctrl.params.fl})" data-ng-style="{{$ctrl.colorCode(category)}}" 
				 data-ng-class="{active: $ctrl.isActive(category.id)}">
				<span class="icon" data-ng-style="{{$ctrl.colorCode(category)}}"> <img class="icon-app"
					data-ng-src="{{category.iconSmall}}" width="75%" alt="">

				</span> <span class="content category-name" >{{category.name}}</span>
			</a>
		</div>
	</nav> 
	<nav class="navigation" data-ng-if="$ctrl.isCategoryView() && $ctrl.categories">
		<div class="home-category-wrapper">
			<a data-ui-sref="home({fl: $ctrl.params.fl})" class="home-category"
				data-ng-class="{active: $ctrl.isActive(0)}">
				<span class="icon"> <span class="glyphicon glyphicon-home home-icon"></span>

				</span> <span class="content category-name"><fmt:message key="store.home"/></span> 
			</a>
		</div>
		<div class="category-item">
			<a class="active-category" data-ui-sref="category({categoryId: $ctrl.activeCategory().id, fl: $ctrl.params.fl})" data-ng-class="{active: $ctrl.isActive($ctrl.activeCategory().id)}" data-ng-style="{{$ctrl.colorCode($ctrl.activeCategory())}}">
				<span class="icon" data-ng-style="{{$ctrl.colorCode($ctrl.activeCategory())}}"> <img class="icon-app"
					data-ng-src="{{$ctrl.activeCategory().iconSmall}}" width="75%" alt="">

				</span> <span class="content category-name">{{$ctrl.activeCategory().name}}</span> 
			</a>
			<div class="subcategories-block">
				<%-- <div class="subcategory-header"><fmt:message key="store.categories"/></div> --%>
				<ul class="subcategories">
					<li data-ng-repeat="subcategory in $ctrl.activeCategory().subcategories" class="subcategory-item">
						<a class="subcategory" data-ui-sref="subcategory({categoryId: subcategory.categoryId, subcategoryId: subcategory.id, fl: $ctrl.params.fl})" 
							data-ng-class="{active: $ctrl.isActiveSubCategory(subcategory.categoryId, subcategory.id)}"
							data-ng-style="{{$ctrl.colorCode($ctrl.activeCategory(), true, $ctrl.isActiveSubCategory(subcategory.categoryId, subcategory.id))}}">
						{{subcategory.name}} </a>
					</li>
				</ul>
			</div>
		</div>
	</nav>

</fmt:bundle>

