<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>

<fmt:bundle basename="localization.SoftwareStoreMessages">

<div class="row search-row" data-ng-if="$ctrl.level != 'services'">
	<store-search ng-show="{{!isDetails}}"></store-search>
	<div class="upload-button-section">
		<button data-ng-if="$ctrl.isCommunityCategory" class="upload-button" data-ng-click="$ctrl.launchUploadForm()">
			<span class="glyphicon glyphicon-upload"></span>
			<span>
				<fmt:message key="store.developer.community.upload" />
			</span>
		</button>
	</div>
</div>
<store-breadcrumb ng-show="$ctrl.level != 'home'"></store-breadcrumb>
<div data-ng-switch="$ctrl.level">
	<div data-ng-switch-when="home">
		<jsp:include page="all-categories.jsp"></jsp:include>
	</div>
	<div data-ng-switch-when="services">
		<jsp:include page="all-services.jsp"></jsp:include>
	</div>
	<div data-ng-switch-when="category">
		<div data-ng-if="$ctrl.hasSubCategoryView()">
			<jsp:include page="all-subcategories.jsp"></jsp:include>
		</div>
		<div data-ng-if="!$ctrl.hasSubCategoryView()">
			<jsp:include page="all-packages.jsp"></jsp:include>
		</div>
	</div>
	<div data-ng-switch-when="filtered-package-level">
		<jsp:include page="all-packages.jsp"></jsp:include>
	</div>
	<div data-ng-switch-default>
		<jsp:include page="all-packages.jsp"></jsp:include>
	</div>
</div>
</fmt:bundle>