<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>

<fmt:bundle basename="localization.SoftwareStoreMessages">

	<ul class="home-category-group">
		<li data-ng-repeat="row in $ctrl.results" data-ng-show="$ctrl.results.length != 0">
			<div class="row">
				<ul class="category-rows">
					<li class="col-md-6 category-row home-category-row" data-ng-repeat="item in row">
						<div class="row">
						
						<h3 class="page-header"
							data-ng-init="$rootScope.activeCategory = (item.category.name)">
							{{item.category.name}}<a class="view-all-link"
								data-ng-class="{'hidden': $ctrl.isHidden() }"
								data-ui-sref="category({categoryId: item.category.id, fl: $ctrl.fl})"><fmt:message key="store.view-all"/></a>
						</h3>
						<ul class="app-list">
							<!-- being::app -->
							<li class="col-xs-6 col-sm-6 col-md-12 col-lg-6 app-tile" 
								data-ng-repeat="storePackage in item.packages">
								<div class="app-tile-thumb">
									<div class="thumbIcon">
										<img alt="" data-ng-src="{{storePackage.icon || storePackage.subCategory.icon || item.category.icon}}" width="100%" data-ui-sref="details({packageId: storePackage.id, categoryId: storePackage.category.id, subcategoryId: storePackage.subCategory.id})" class="pkg-thumb-icon">
										<span data-ng-if="storePackage.action.id === 'UPDATE'" class="update-tick update-found" 
												title="<fmt:message key='store.update.available'/>"></span>
									</div>
									<div class="actionBtn">
										<a data-ng-click="$ctrl.tryDownload(storePackage)" class="">{{storePackage.action.name}}</a>
									</div>
								</div>
								<div class="app-tile-info">
									<div class="pkg-info pkg-title small"
										title="{{storePackage.name}}">
										<a data-ui-sref="details({packageId: storePackage.id, categoryId: storePackage.category.id, subcategoryId: storePackage.subCategory.id})"><span class="pkg-name-span">{{storePackage.name}}</span></a>
										<!-- <a target="_blank"
											href="packageDetails.do?packageId={{storePackage.id}}&status=0&type=details"><span>{{storePackage.name}}</span></a> -->
										<!-- <a data-ng-href="#!/details/{{storePackage.id}}"><span>{{storePackage.name}}</span></a> -->
										<!-- <a data-ui-sref="details({packageId: storePackage.id})"><span>{{storePackage.name}}</span></a> -->
									</div>
									<!-- <div class="pkg-info pkg-category small">{{storePackage.category.name}}</div> -->
									<div class="pkg-info pkg-rel small"><fmt:message key="store.label.release_date"/>
										{{ $ctrl.getDateDisplayString(storePackage.validFrom) }}</div>
									<div class="pkg-info pkg-ver small" data-ng-show="{{storePackage.action.id == 'DOWNLOAD' && storePackage.platforms.length == 1}}"><fmt:message key="store.label.size" />
										{{(storePackage.platforms ? storePackage.platforms[0].size : 0) | bytes }}</div>
										
									<div class="premium-package" data-ng-if="storePackage.group == 'PREMIUM'" title="<fmt:message key='store.pkg.premium.package'/>">
										<svg id="premium-package-icon" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" width="16" height="18" viewBox="0 0 16 18">
											<path class="cls-blue" d="M14,0H2A2,2,0,0,0,0,2V16a2,2,0,0,0,2,2H14a2,2,0,0,0,2-2V2A2,2,0,0,0,14,0ZM10.4,13.2a2.8,2.8,0,0,1-1.7.7v1.2H7.7V13.9a2.6,2.6,0,0,1-1.8-.8,2.7,2.7,0,0,1-.6-1.9H6.4a1.8,1.8,0,0,0,.4,1.3,1.7,1.7,0,0,0,1.3.5,1.9,1.9,0,0,0,1.3-.4,1.3,1.3,0,0,0,.5-1,1.3,1.3,0,0,0-.4-.9,3.5,3.5,0,0,0-1.3-.7,4.3,4.3,0,0,1-1.9-1,2.3,2.3,0,0,1-.6-1.6,2.3,2.3,0,0,1,.6-1.6,2.5,2.5,0,0,1,1.6-.8V3.5h.9V4.8a2.4,2.4,0,0,1,1.6.9,3.1,3.1,0,0,1,.6,2H9.8a2.1,2.1,0,0,0-.4-1.4,1.3,1.3,0,0,0-1.1-.5,1.5,1.5,0,0,0-1.1.4,1.4,1.4,0,0,0-.4,1,1.3,1.3,0,0,0,.4,1,3.7,3.7,0,0,0,1.3.7l1.5.7a2.3,2.3,0,0,1,.8.8,2.4,2.4,0,0,1,.2,1.1A2.3,2.3,0,0,1,10.4,13.2Z"/></svg>
									</div>
									<div class="proactive-package" data-ng-if="storePackage.group == 'PROACTIVE_SUPPORT'" title="<fmt:message key='store.pkg.proactive.package'/>">
										<svg id="proactive-package-icon" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16"><path class="cls-green" d="M8,0a8,8,0,1,0,8,8A8,8,0,0,0,8,0Zm2.8,8.6a3.5,3.5,0,0,1-2.3.7H6.4v3.5H5.2V3.9H8.5a3.3,3.3,0,0,1,2.3.7,2.5,2.5,0,0,1,.8,2A2.5,2.5,0,0,1,10.8,8.6Z"/><path class="cls-green" d="M8.6,4.9H6.4V8.4H8.5a2.1,2.1,0,0,0,1.4-.4,1.6,1.6,0,0,0,.5-1.3,1.7,1.7,0,0,0-.5-1.3A2,2,0,0,0,8.6,4.9Z"/></svg>
									</div>
									<!-- <div class="pkg-info pkg-rating">
											<span class="sprite icon-favorite"></span> <span
												class="sprite icon-favorite"></span> <span
												class="sprite icon-favorite"></span> <span
												class="sprite icon-favorite"></span> <span
												class="sprite icon-favorite"></span>
										</div> -->
								</div>
							</li>
							<!-- end::app -->
						</ul>
						</div>
					</li>
				</ul>
			</div>
		</li> 
		<li data-ng-show="$ctrl.results.length == 0 && $ctrl.searchIsActive">
				<div class="no-results">
					<div class="no-results-icon">
					<span class='sprite softwarestore-store-grey'></span>
				</div>
				<div class="no-results-text">
					<h4><fmt:message key="store.search.no_results.message"/></h4>
					<span><fmt:message key="store.search.no_results.message.suggestion"/></span>
				</div>
			</div>
		</li>
	</ul>

</fmt:bundle>