<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>

<fmt:bundle basename="localization.SoftwareStoreMessages">

<store-breadcrumb></store-breadcrumb>

<div class="row details-container">
	<div class="category-header" ng-show="$ctrl.dcpackage">
		<h1>{{$ctrl.dcpackage.category.name}}</h1>
	</div>
	<div class="col-sm-3 col-xs-12 col-md-2" ng-show="$ctrl.dcpackage">
		<div class="row">
		  <!-- <div class="details-icon">
		  </div> -->
		  <div class="thumbnail">
		      <img ng-src="{{$ctrl.dcpackage.icon || $ctrl.category.icon}}" alt="" width="100%" height="100%">
		      <span class="update-tick update-found" data-ng-if="$ctrl.dcpackage.action.id === 'UPDATE'"></span>
		    </div>
		  <div>
		  	<button data-ng-click="$ctrl.tryDownload($ctrl.dcpackage)" class="actionbtn details-actionBtn"><span data-ng-bind-html="$ctrl.dcpackage.action.name"></span></button>
		  </div>
		</div>
		<div class="row info-row" ng-cloak>
			<ul>
				<li class="pkg-info-item" ng-if="$ctrl.dcpackage.subCategory.name"><span class="pkg-info"><fmt:message key="store.package.details.category" />:</span>
					<span class="pkg-info-val" data-ng-attr-title="{{$ctrl.dcpackage.subCategory.name}}">{{$ctrl.dcpackage.subCategory.name}}</span>
				</li>
				<li class="pkg-info-item"><span class="pkg-info"><fmt:message key="store.package.details.release_date" />:</span>
					<span class="pkg-info-val" data-ng-attr-title="{{ $ctrl.getDateDisplayString($ctrl.dcpackage.validFrom) }}">{{ $ctrl.getDateDisplayString($ctrl.dcpackage.validFrom) }}</span>
				</li>
				<%-- <li class="pkg-info-item"><span class="pkg-info"><fmt:message key="store.pkg.released_in" />:</span>
					<span class="pkg-info-val" data-ng-attr-title="{{$ctrl.dcpackage.version}}">{{$ctrl.dcpackage.version}}</span>
				</li> --%>

				<li data-ng-if="!$ctrl.hasMoreThanOnePlatform()" class="pkg-info-item"><span class="pkg-info"><fmt:message key="store.package.details.file_name" />:</span>
					<span class="pkg-info-val" data-ng-attr-title="{{$ctrl.fileInfo.location}}">{{$ctrl.fileInfo.location}}</span>
				</li>
				<li data-ng-if="!$ctrl.hasMoreThanOnePlatform()" class="pkg-info-item"><span class="pkg-info"><fmt:message key="store.package.details.size" />:</span>
					<span class="pkg-info-val" data-ng-attr-title="{{$ctrl.fileInfo.size | bytes}}">{{$ctrl.fileInfo.size | bytes}}</span>
				</li>

				<fmt:bundle basename="localization.DownloadCenterMessages">
					<li data-ng-if="!$ctrl.hasMoreThanOnePlatform()" class="pkg-info-item"><span class="pkg-info"><fmt:message key="package.checksum" />:</span>
						<span class="pkg-info-val" data-ng-attr-title="{{$ctrl.fileInfo.checksum}}">{{$ctrl.fileInfo.checksum}}</span>
					</li>
				</fmt:bundle>

				<li class="pkg-info-item" data-ng-if="$ctrl.dcpackage.localRevision"><span class="pkg-info"><fmt:message key="store.pkg.installed_version" />:</span>
					<span class="pkg-info-val" data-ng-attr-title="{{$ctrl.dcpackage.localRevision}}">
						{{$ctrl.dcpackage.localRevision}}
					</span>
				</li>

				<li class="pkg-info-item" data-ng-if="$ctrl.dcpackage.revision">
					<span class="pkg-info" data-ng-if="$ctrl.dcpackage.localRevision"><fmt:message key="store.pkg.available_version" />:</span>
					<span class="pkg-info" data-ng-if="!$ctrl.dcpackage.localRevision"><fmt:message key="store.pkg.version" />:</span>
					<span class="pkg-info-val" data-ng-attr-title="{{$ctrl.dcpackage.revision}}">
						{{$ctrl.dcpackage.revision}}
					</span>
				</li>

				<li class="pkg-info-item" data-ng-if="$ctrl.dcpackage.revision && $ctrl.dcpackage.whatsNew">
					<span class="pkg-info"><fmt:message key="store.package.details.whatsNew" />:</span>
					<span class="pkg-info-val" data-ng-attr-title="{{$ctrl.dcpackage.whatsNew}}">
						{{$ctrl.dcpackage.whatsNew}}
					</span>
				</li>

				<li data-ng-if="$ctrl.isPricingApplicable()" class="pkg-info-item"><span class="pkg-info"><fmt:message key="store.package.details.pricing" />:</span>
					<span class="pkg-info-val" data-ng-attr-title="{{$ctrl.dcpackage.group}}">
						{{$ctrl.dcpackage.groupLabel}}
					</span>
				</li>
				<li class="pkg-info-item"><span class="pkg-info"><fmt:message key="store.package.details.author" />:</span>
					<span class="pkg-info-val" data-ng-attr-title="{{$ctrl.dcpackage.vendor.name}}">{{$ctrl.dcpackage.vendor.name}}</span>
				</li>
				<li class="pkg-info-item" data-ng-if="$ctrl.dcpackage.minCommCellVersion"><span class="pkg-info"><fmt:message key="store.pkg.compatible_commcell" />:</span>
					<span class="pkg-info-val" data-ng-attr-title="{{$ctrl.dcpackage.minCommCellVersion}}">
						{{$ctrl.dcpackage.minCommCellVersion}}
					</span>
				</li>
			</ul>

		</div>
	</div>
	<div class="col-sm-9 col-xs-12 col-md-10">
		<div>
			<h1 class="pkg-main-title">{{$ctrl.dcpackage.name}}</h1>
			<p class="pkg-main-desc" data-ng-bind-html="$ctrl.detailsHtml"></p>
			<p class="pkg-main-desc pkg-learn-more" data-ng-if="$ctrl.showLearnMore">
				<a data-ng-show="$ctrl.showLearnMore" target="_blank" data-ng-href="{{$ctrl.fileInfo.readMeLocation}}">
					<fmt:message key="store.package.details.learn_more" />
				</a>
			</p>
			<h2 class="pkg-sample-screenshot-header" data-ng-if="$ctrl.showSampleHeader">
				<fmt:message key="store.package.details.sample_screenshot" />
			</h2>
			<iframe id="readmeFrame" src="about:blank" class="readmeFrame" frameBorder="0"></iframe>
			<div>
				<!-- data-ng-show="!!$ctrl.readme"  -->
			</div>

			<div data-ng-if="$ctrl.hasMoreThanOnePlatform()">
				<h2 class="secondary-title"><fmt:message key="store.available.downloads" /></h2>
				<jsp:include page="../dialog/multiple-downloads.jsp" />
			</div>

			<div data-ng-if="$ctrl.dcpackage.otherVersions.length > 0" class="all-versions-section">
				<h2 class="secondary-title"><fmt:message key="store.pkg.other_versions" /></h2>
				<table class="all-downloads">
					<thead class="all-downloads-header">
						<tr class="all-downloads-row all-downloads-col-header-row">
							<th class="all-downloads-col all-downloads-col-title"><fmt:message key="store.package.details.release_date" /></th>
							<th class="all-downloads-col all-downloads-col-title"><fmt:message key="store.pkg.released_in" /></th>
							<th class="all-downloads-col all-downloads-col-title last-col"></th>
						</tr>
					</thead>
					<tbody>
						<tr class="all-downloads-row" data-ng-class-odd="'odd-row'" data-ng-class-even="'even-row'" data-ng-repeat="versionItem in $ctrl.dcpackage.otherVersions">
							<td class="all-downloads-col">{{versionItem.validFrom ? $ctrl.getDateDisplayString(versionItem.validFrom) : ''}}</td>
							<td class="all-downloads-col">{{versionItem.version}}</td>
							<td class="all-downloads-col last-col"><a data-ui-sref="details({ packageId: versionItem.id, categoryId: versionItem.category.id, subcategoryId: versionItem.subCategory.id})">Details</a></td>
						</tr>
					</tbody>
				</table>
			</div>

		</div>
	</div>

</div>

</fmt:bundle>