<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8" />
<!-- Always force latest IE rendering engine (even in intranet) & Chrome Frame
       Remove this if you use the .htaccess -->
<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
<meta name="viewport" content="width=device-width, initial-scale=1.0" />
<meta name="description" content="" />
<meta name="author" content="CommVault">

<jsp:include page="../../common/jquery.jsp" />
<link rel="stylesheet" href="${pageContext.request.contextPath}/common/css/jquery.loadmask.css?${applicationScope.BUILD_TS}"/>
<link rel="stylesheet" href="${pageContext.request.contextPath}/common/css/templatestyles.css?${applicationScope.BUILD_TS}" />
<link rel="stylesheet" href="${pageContext.request.contextPath}/common/css/cvdialog.css?${applicationScope.BUILD_TS}" />
<link rel="stylesheet" href="${pageContext.request.contextPath}/softwarestore/loginframe/css/appStoreLogin.css?${applicationScope.BUILD_TS}" />
<link rel="stylesheet" href="${pageContext.request.contextPath}/common/css/sprites.css?${applicationScope.BUILD_TS}" />
<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/common/js/encoder.js?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/softwarestore/loginframe/js/appStoreLogin.js?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/common/js/jquery.loadmask.cv.js?${applicationScope.BUILD_TS}"/></script>
</head>
<fmt:bundle basename="localization.CustomReportsMessages">
		    <div id="content">
			    	<form method="POST" action="../applications" id="loginForm">
			 			<label class="label" for="username"><fmt:message key="Cloud_User_Name" /></label>
			 				<input type="text" id="username" name="username" class="textbox"/>
			 			<br/>
			 			<label class="label" for="password"><fmt:message key="Password" /></label>
						<input type="password" id="password" autocomplete="off" name="password" class="textbox"/>
						<label class="label hidden" id="cloudAutoLoginMessage"><fmt:message key="Attempting_SSO" /></label>
						<div class="errorMsg hiddenClass"><span id="errorText">Unknown Error.</span></div>
						<div id="loginOptions">
							<ul>
								<li id="forgotPassword" class="cloudLink" data-url="https://cloud.commvault.com/webconsole/login/forgotPassword.jsp">Forgot Password? </li>
								<li id="ulSeparator">|</li>
								<li id="registerAccount" class="cloudLink" data-url="https://cloud.commvault.com/commcellregistration-form.jsp">Register</li>
							</ul>
						</div>
					</form>
			</div>
			<div class="buttonbar">
							<button type="button" id="loginbtn" class="mainBtn buttonContents okSaveClick loginBtn"><fmt:message key="Login" /></button>
							<button type="button" id="cancelbtn" class="buttonContents dialogCancel cancelBtn"><fmt:message key="Cancel" /></button>
							<div class="clearfloat"></div>
			</div>

</fmt:bundle>
