<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="lcv" %>
<div id="appStoreLogin" style="display:none;" >
	<iframe id="loginframe" src="" width="300px" height="275px"></iframe>
</div>
<a id="reportStoreUpdateAll" class="reportStoreUpdateAll" style="display:none;">Update All<span id="reportStoreNumUpdates"></span></a>
<script nonce="${sessionScope.cspNonce}" >
	var localMsg = localMsg || {};
	${lcv:jsLocalize("localMsg", "localization.ReportsMessages", null)};
	
</script>

<style>
body .ui-dialog .ui-dialog-titlebar {
	background: none repeat scroll 0 0 white;
	border-bottom: 1px solid #DDDDDD;
	border-radius: 0 0 0 0;
	color: #006699;
	font-size: 1.2em;
	margin-bottom: 5px;
	padding: 15px 1em 0 15px;
}

body .ui-dialog .ui-dialog-titlebar-close {
	display: block;
}

.ui-dialog .ui-dialog-content {
	padding: 0em 1em;
}

.ui-dialog {
	border-radius: 4px;
}
body .ui-dialog-titlebar {
	color: #fff;
}

#loginframe {
	border: 1px solid transparent;
}

</style>
<script nonce="${sessionScope.cspNonce}"  type="text/javascript">
	window.redirectToAppStoreHome=true;
	var storeCategory = '${param.category}';
	var storeSubCategory = '${param.subcategory}';
	
	$(document).ready(function(){
		
		$("#appStoreLogin").dialog({
		    autoOpen: false,
		    //show: { effect: 'toggle', duration: 400 },
		    //hide: { effect: 'toggle', duration: 400 },
		    modal: true,
		    yesText : localMsg.save, noText : localMsg.cancel,
		    open: function (ev, ui) {
		      $('#loginframe').attr('src','${pageContext.request.contextPath }/softwarestore/loginframe/appStoreLogin.jsp?category=' + storeCategory + '&subcat=' + storeSubCategory);
		    },
		    height: 'auto',
		    width: 'auto',
		    resizable: false,
		    title: localMsg["CustomReport.LogonToStore"],
		    close: function(event, ui) {
				if(!window.redirectToAppStoreHome)
					window.location.href=cvUtil.getContextPath()+'/applications'; //redirect to applications home if dialog is closed on authentication page
			}
		  });

		$('body').off('click', '#appStoreLink').on('click', '#appStoreLink', function(e){
			e.preventDefault();
			checkAppStoreAuthentication();
		});
		
		$("#workflowLink").click(function(e){
			e.preventDefault();
			checkAppStoreAuthentication();
		});
		
//		cvUtil.addTimerTask(function(){
//			cvUtil.loadPageWithGET(cvUtil.getContextPath()+'/customReports/appstoreLoginHeartBeat.do', {}, function(){});
//		}, cvUtil.SESSION_TIMEOUT-10000); //send it in 10 seconds in advance
	});
function checkAppStoreAuthentication(){
	window.location.href=cvUtil.getContextPath() + "/softwarestore/store.do?category=" + storeCategory + "&subcat=" + storeSubCategory;
}
function showLogin(position){
	//if(position)
	//	$("#appStoreLogin").dialog("option", 'position', position);
	

	$("#appStoreLogin").dialog("open");	
}
function closeIFrame(){
     $('#appStoreLogin').dialog('close');
}
function showReportStoreUpdateAllButton(parentSelector, numberOfAvailableUpdates,category, callback){
	var button=$("#reportStoreUpdateAll");
	$(parentSelector).append(button);
	button.show();
	button.click(function(){
		//show spinner image
		$("#appstorecontentbody").mask();
		$.ajax({
			url: cvUtil.getContextPath()+'/customReports/updateAllFromAppstore.do?category=' + category,
			global: false,
			complete:function(){
				$( "#appstorecontentbody" ).unmask();
			  	callback();
			  },
			success: function(data){		
				if(data.data)
					data=data.data;
				else
					console.log(data);
				if(data.msg)
					cvUtil.toast(data.msg);
				if(data.errorMessage)
					cvUtil.errorToast(data.errorMessage + "\n" + data.detailedErrors);
			}
		});	
	});
	return button;
}
</script>	