<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>


<fmt:bundle basename="localization.SoftwareStoreMessages">

<fmt:message var="storeTitle" key="store.title"/>

<c:set var="turnOnSearchEngineIndex" value="${applicationScope.SWStoreIsCVStore}" />

<jsp:include page="../common/header.jsp">
	<jsp:param value="false" name="includeHistory" />
	<jsp:param value="true" name="storeApp" />
	<jsp:param value="true" name="bootstrapped" />
	<jsp:param value="false" name="intro" />
	<jsp:param value="${turnOnSearchEngineIndex}" name="turnOnSearchEngineIndex"/>
	<jsp:param value="${pageContext.request.contextPath}/common/js/moment.js" name="js" />
	<jsp:param value="${pageContext.request.contextPath}/softwarestore/css/main.css" name="css" />
	<jsp:param value="${pageContext.request.contextPath}/softwarestore/css/sidebar.css" name="css" />
	<jsp:param value="${pageContext.request.contextPath}/softwarestore/css/details.css" name="css" />
	<jsp:param value="${pageContext.request.contextPath}/softwarestore/css/animations.css" name="css" />
	<jsp:param value="true" name="enableLoginLink" />
	<jsp:param value="${storeTitle}" name="titleLocalized" />
	<jsp:param value="Software_Store_App" name="headerTitle" />
	<jsp:param value="Software_Store_App" name="primaryheaderTitle" />
</jsp:include>
<jsp:include page="headerIncludes.jsp" flush="true" />

<div class="store-app-entry" data-ng-app="storeApp" data-ng-controller="StoreCtrl">
	<div id="loading-bar-container"></div>
	<div style="margin-top:50px"></div>
	<ui-view name="banner"></ui-view>
	<ui-view name="filterBand"></ui-view>
	<!-- begin::main container -->
	<div class="container-fluid main-container">
		<div class="row content-row">
			<div class="hidden-xs col-sm-3 col-md-2 opt-wrapper" data-ng-show="{{!isDetails}}">
				<ui-view name="sidebar"></ui-view>
				<ui-view name="autoupdates"></ui-view>
			</div>
			<!-- <ui-view name="sidebar"  class="hidden-xs col-sm-3 col-md-2 opt-wrapper" ng-show="{{!isDetails}}"></ui-view> -->
			<ui-view name="packageList"  class="col-xs-12 col-sm-9 col-md-10 results-wrapper" ng-show="{{!isDetails}}"></ui-view>
			<ui-view name="detailsView" class="col-xs-12 col-sm-12 col-md-12 details-wrapper" ng-show="{{isDetails}}"></ui-view>
		</div>
	</div>
	<!-- end::main container -->
	<span us-spinner="{radius:30, width:5, length: 10, lines: 17, scale: 0.75}"></span>
</div>

<jsp:include page="footerIncludes.jsp" flush="true" />
<jsp:include page="../common/footer.jsp" >
	<jsp:param value="true" name="bootstrapped" />
	<jsp:param value="false" name="intro" />
</jsp:include>

</fmt:bundle>

