<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>

<fmt:bundle basename="localization.SoftwareStoreMessages">

				<table class="all-downloads">
					<thead class="all-downloads-header">
						<tr class="all-downloads-row all-downloads-col-header-row">
							<th class="all-downloads-col all-downloads-col-title"><fmt:message key="store.pkg.platform" /></th>
							<th class="all-downloads-col all-downloads-col-title"><fmt:message key="store.package.details.file_name" /></th>
							<th class="all-downloads-col all-downloads-col-title"><fmt:message key="store.package.details.size" /></th>
							<fmt:bundle basename="localization.DownloadCenterMessages">
								<th class="all-downloads-col all-downloads-col-title"><fmt:message key="package.checksum" /></th>
							</fmt:bundle>
							<th class="all-downloads-col all-downloads-col-title last-col"></th>
						</tr>
					</thead>
					<tbody>
						<tr class="all-downloads-row" data-ng-class-odd="'odd-row'" data-ng-class-even="'even-row'" data-ng-repeat="platform in $ctrl.dcpackage.platforms">
							<td class="all-downloads-col">{{platform.name}}</td>
							<td class="all-downloads-col">{{platform.location}}</td>
							<td class="all-downloads-col">{{platform.size | bytes}}</td>
							<td class="all-downloads-col">{{platform.checksum}}</td>
							<td class="all-downloads-col last-col"><a data-ng-click="$ctrl.tryDownload($ctrl.dcpackage, platform.id, platform.pkgPlatformMapId)"><span data-ng-bind-html="$ctrl.dcpackage.action.name"></span></a></td>
						</tr>
					</tbody>
				</table>

</fmt:bundle>