<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@  taglib uri="../WEB-INF/cvtaglib.tld" prefix="cv" %>

<fmt:bundle basename="localization.SoftwareStoreMessages">

<fmt:message var="storeTitle" key="store.title"/> 

<jsp:include page="../common/header.jsp">
	<jsp:param value="true" name="bootstrapped" />
	<jsp:param value="${storeTitle}" name="headerTitleLocalized" />
	<jsp:param value="${storeTitle}" name="titleLocalized" />
	<jsp:param value="true" name="storeApp" />
	<jsp:param value="css/activity.css" name="css" />
	<jsp:param value="Software_Store_App" name="primaryheaderTitle" />
</jsp:include>	

<jsp:include page="../reportsplus/reportHeader.jsp">
	<jsp:param value="webconsole" name="applicationName" />
	<jsp:param value="false" name="includeImport" />
	<jsp:param value="false" name="includeBootstrapCss" />
	<jsp:param name="subApplicationName" value="store" />
</jsp:include>	

<div id="reportArea">
	<h1 class="store-title"><fmt:message key="store.activity.header" /></h1>
	<div class="store-description"><fmt:message key="store.activity.description" /></div>
	<div id="ng-app" data-ng-app="reports" data-ng-controller="reportsCtrl" data-ng-init="init('', 'Software Store Activity',false)" class="store-updates-table">
		<div id="pageDiv" data-ng-controller="pageController" class="maskLayer" data-ng-class="{'isMasked':masked}" >
			<div data-ng-include="'${pageContext.request.contextPath}/reportsplus/templates/reportComponents/viewerPage.jsp'"></div>
		</div>
	</div>
</div>

<jsp:include page="../common/footer.jsp">  
	<jsp:param value="true" name="bootstrapped" />
</jsp:include>

</fmt:bundle>