var qb = qb || {}; //qb is the namespace for SOLR Query Builder and processor
/*
 * qb.sv is the base object for search view(Data table) related operations TODO: 1. require js implementation
 * to make sure qb.base is defined before defining qb.sv
 */

qb.sv = (function() {
	//priate properties, start
	var _solrParams = qb.base.getSolrParams();
	var _solrProps = qb.base.getSolrProps();

	//priate properties, end
	//private member functions, start
	/* request for data table parameters */
	function _getSearchRequest(id, dtParams, config) {
		var req = this.getCurrentSearchReq();
		// prepare fl
		var listOfFields = [];
		$.each(dtParams.columns, function(i, eachConfig) {
			if (eachConfig.visible === undefined || eachConfig.visible) {
				listOfFields.push(eachConfig.data);
			}
		});
		req[_solrParams.FIELDS] = listOfFields;

		// prepare sort
		if (!$.isEmptyObject(dtParams.order)) {
			var sortParams = [];
			$.each(dtParams.order, function(i, eachOrder) {
				sortParams.push(dtParams.columns[eachOrder.column].data + " " + eachOrder.dir);
			});
			req[_solrParams.SORT] = sortParams.join(",");
		}

		//because cvDataGrid will send 'pageIndex' while datatables will send 'start'
		if (dtParams.start == undefined) {
			req[_solrParams.START] = dtParams.pageIndex;
		} else {
			req[_solrParams.START] = dtParams.start;
		}

		req[_solrParams.ROWS] = dtParams.length;

		if (config.enableHighlighting && !$.isEmptyObject(config.highlightParams)) {
			this.appendHighlightQuery(req, config.highlightParams, config.highlightKey);
		}
		if (config.rawQuery) {
			this.appendRawQuery(req, config.rawQuery);
		}
		return req;
	}
	/*
	 * request for facet operations for now same method has been used for getting fq and facet request TODO:
	 * check if we can separate it out
	 */
	function _getFacetRequest(id, facetConfig, facetReq, isPrepareFQ) {
		var self = this;
		var req = this.getCurrentSearchReq(), fqArr = [];
		if ($.isEmptyObject(facetReq)) {
			facetReq = {};
		}
		if (!$.isEmptyObject(facetConfig) || !$.isEmptyObject(facetReq)) {
			req[_solrParams.FACET] = true;
			req[_solrParams.FACET_SIZE] = true;

			var facetFieldsArr = [], facetQueryArr = [];
			$.each(facetConfig, function(i, eachConfig) {
				var fName = eachConfig.fieldName;
				var eachfacetQueryArr = [];
				var isPredefinedSet = false;
				if (!$.isEmptyObject(eachConfig.predefinedValues)) {
					isPredefinedSet = true;
					eachfacetQueryArr = self.getFacetQueryForPredefinedValues(eachConfig);
				} else {
					req = $.extend(req, self.getBaseFacetReqObj(eachConfig));
				}
				var fqPrefix = facetPrefix = "";
				if (!$.isEmptyObject(facetReq[fName]) && !$.isEmptyObject(facetReq[fName].selectedValues)) {
					var tagName = "tag_" + i;
					var eachFqArr = [];
					fqPrefix = "{!tag=" + tagName + "}";
					facetPrefix = "{!ex=" + tagName + "}";

					$.each(facetReq[fName].selectedValues, function(ii, eachValueObj) {
						var fqStr = self.getFqStr(fName, eachValueObj);
						var facetQueryStr = self.getFacetQueryStr(fName, eachValueObj);
						eachFqArr.push(fqStr);
						/*
						 * Need below logic to eliminate the user defined values if it already added by
						 * predefined values eachfacetQueryArr will have {!key=<key> fieldname:<condition>
						 * facetQueryStr will have fieldname:<condition> So iterate over the array and
						 * eliminate duplicate
						 */
						var isAlreadyAdded = false;
						for (var i = 0; i < eachfacetQueryArr.length; i++) {
							if (eachfacetQueryArr[i].indexOf(facetQueryStr) > -1) {
								isAlreadyAdded = true;
								break;
							}
						}
						if (!isAlreadyAdded) {
							eachfacetQueryArr.push(facetQueryStr);
						}
					});

					/*
					 * If there are selected values, and if there are predefined value, make sure that the
					 * predefined ones have an {!ex} predefined ones will already have {!key=<key>
					 * <condition>}
					 */
					eachfacetQueryArr = $.map(eachfacetQueryArr, function(facetQuery) {
						var tagIndex = facetQuery.indexOf("!");
						if (tagIndex != -1) {
							return facetQuery.slice(0, tagIndex + 1) + "ex=" + tagName + " " +
									facetQuery.slice(tagIndex + 1);
						} else {
							return facetQuery;
						}
					});

					if (isPrepareFQ && !$.isEmptyObject(eachFqArr)) {
						var joinedFq = eachFqArr.join(_solrParams.FQ_OR);
						if (joinedFq.indexOf("{!") !== -1) {
							var index = joinedFq.indexOf("!");
							joinedFq = joinedFq.slice(0, index + 1) + "tag=" + tagName + " " +
									joinedFq.slice(index + 1);
							fqArr.push(joinedFq);
						} else {
							fqArr.push(fqPrefix + joinedFq);
						}
					}
				}
				if (!isPredefinedSet) {
					facetFieldsArr.push(facetPrefix + fName);
				}
				facetQueryArr = facetQueryArr.concat(eachfacetQueryArr);
			});
			if (!$.isEmptyObject(facetQueryArr)) {
				req[_solrParams.FACET_QUERY] = facetQueryArr;
			}
			if (!$.isEmptyObject(facetFieldsArr)) {
				req[_solrParams.FACET_FIELD] = facetFieldsArr;
			}
		}
		//if (!$.isEmptyObject(fqArr))
		//in search view all facets are under the control of cvFacetsView, so overwrite the fq
		//ideally fq has to be merged based on the field name
		if (isPrepareFQ) {
			req[_solrParams.FILTER_QUERY] = fqArr;
		}
		return req;
	}
	function _processFacetResponse(id, facetConfigs, facetReq, isPrepareFQ, seResp) {
		var self = this;
		var seFacetFieldsResp = [];
		var seFacetQueryResp = [];
		var facetQueryResp = {};
		var respToReturn = {};
		if (!$.isEmptyObject(seResp) && !$.isEmptyObject(seResp["facet_counts"]) &&
				!$.isEmptyObject(seResp["facet_counts"])) {
			seFacetFieldsResp = seResp["facet_counts"]["facet_fields"];
			seFacetQueryResp = seResp["facet_counts"]["facet_queries"];
		}
		if (!$.isEmptyObject(seFacetQueryResp)) {
			// process the response and convert to array of objects similar to facet_fields structure
			// e.g: (protocolName_disp:"Fibre Channel"): 107970
			$.each(seFacetQueryResp, function(key, c) {

				var arr = cvSearchUtil.splitByFirstChar(key, ":");
				if (arr && arr.length == 2) {
					var fieldName = arr[0];
					//when key specified arr[1] is the key e.g. mtm:today, pushtype:success,
					//when no key specified, arr[1] is the vaue
					var keyOrValue = arr[1];

					facetConfig = cvSearchUtil.getObjectByKeyValue(facetConfigs, {
						fieldName : fieldName
					});

					if (!facetQueryResp[fieldName]) {
						facetQueryResp[fieldName] = [];
					}

					var paramObj = {
						value : keyOrValue,
						count : c
					};
					if (facetConfig.predefinedValues) {
						var pvObj = facetConfig.predefinedValues.facets[keyOrValue];
					}
					if (!$.isEmptyObject(pvObj)) {
						paramObj = $.extend(paramObj, pvObj);
					} else {
						//TODO: Make trim and rvalues work with arrays
						if (!$.isArray(keyOrValue)) {
							keyOrValue = cvSearchUtil.trim(keyOrValue, "\"", "\""); // trim if there are double quotes, for simple facet
							paramObj.value = keyOrValue = cvSearchUtil.trim(keyOrValue, "[", "]"); //trim if there are square braces, for range facet
							rValues = keyOrValue.split(_solrParams.RANGE_OP);
						}

						if (rValues && rValues.length == 2) {
							var startVal = rValues[0];
							var endVal = rValues[1];
							if (facetConfig && facetConfig.renderer && facetConfig.renderer.type == "date") {
								startVal = moment.utc(self.getDateFromSEDate(startVal), _solrProps.dtFormat);
								endVal = moment.utc(self.getDateFromSEDate(endVal), _solrProps.dtFormat);
							}
							paramObj.start = startVal;
							paramObj.end = endVal;
						}
					}
					facetQueryResp[fieldName].push(paramObj);
				}
			});
		}
		// process facet_fields
		if (!$.isEmptyObject(seFacetFieldsResp)) {
			$.each(seFacetFieldsResp, function(fName, eachResp) {
				var isFacetReqHasThisField = !$.isEmptyObject(facetReq) && !$.isEmptyObject(facetReq[fName]);
				var facetValues = [];
				for (var i = 0; i < eachResp.length;) {
					var v = eachResp[i++];
					var c = eachResp[i++];
					if (v !== undefined && v !== "") {
						facetValues.push({
							value : v,
							count : c,
							selected : isFacetReqHasThisField ? cvSearchUtil
									.isObjectByKeyValueExist(facetReq[fName].selectedValues, "value", v) : false
						});
					}
				}
				respToReturn[fName] = facetValues;
			});
		}
		/*
		 * include facet values that are selected by user but not returned from the search engine. because we
		 * need to intimate the user that their selection yields in zero count
		 */
		if (!$.isEmptyObject(facetQueryResp)) {
			$.each(facetQueryResp, function(fName, eachResp) {
				var facetValues = respToReturn[fName];
				if ($.isEmptyObject(facetValues)) {
					facetValues = [];
				}
				var additionalFacetValues = [];
				$
						.each(eachResp,
								function(ind, eachValueObj) {
									var objFromFacetQuery = undefined;
									if ($.isEmptyObject(eachValueObj)) {
										return;
									}
									var objToCompare = {};
									// use typeof instead of simple check because when start/end = 0, logic will go wrong
									if (typeof (eachValueObj.start) !== "undefined" &&
											typeof (eachValueObj.end) !== "undefined") {
										eachValueObj.isRange = true;
										objToCompare = {
											start : eachValueObj.start,
											end : eachValueObj.end
										};
									} else {
										objToCompare = {
											value : (!$.isArray(eachValueObj.value) ? self
													.unEscapeSpecialChars(eachValueObj.value) : eachValueObj.value)
										};
										eachValueObj.value = objToCompare.value;
									}
									// make sure the selection/range doesn't exist in the facet_fields
									if ($.isEmptyObject(cvSearchUtil.getObjectByKeyValue(facetValues, objToCompare))) {
										// find the object from selectedValues
										objFromSelection = (facetReq[fName] && !$
												.isEmptyObject(facetReq[fName].selectedValues)) ? cvSearchUtil
												.getObjectByKeyValue(facetReq[fName].selectedValues, objToCompare)
												: undefined;
										if (objFromSelection) {
											objFromSelection = $.extend(objFromSelection, eachValueObj);
											objFromSelection.selected = true;
											additionalFacetValues.push(objFromSelection);
										} else {
											additionalFacetValues.push(eachValueObj);
										}
									}
								});
				$.merge(facetValues, additionalFacetValues);
				respToReturn[fName] = facetValues;
			});
		}

		return respToReturn;
	}
	/*
	 * base will call this method with response pushed to the array of input to the getSearchRequest method so
	 * make sure you receive the response followed by the inputs of getSearchRequest
	 */
	function _processSearchResponse(id, dtParams, config, seResp) {
		console.time("ParsingSearchResponse");
		var respToReturn = {
			recordsTotal : 0,
			recordsFiltered : 0,
			data : []
		};
		if (!$.isEmptyObject(seResp)) {
			if (dtParams.draw) {
				respToReturn.draw = dtParams.draw;
			} else {
				respToReturn.draw = 0;
			}

			if (!$.isEmptyObject(seResp.response)) {
				if (!$.isEmptyObject(seResp.response.docs)) {
					respToReturn.data = seResp.highlighting && seResp.response.docs ? this
							.mapHightlightResp(seResp.response.docs, seResp.highlighting) : seResp.response.docs;
					respToReturn.recordsTotal = respToReturn.recordsFiltered = seResp.response.numFound;
				} else if (!$.isEmptyObject(seResp.error)) {
					respToReturn.recordsTotal = respToReturn.recordsFiltered = 0;
					console.log(seResp.error.msg);
					alert(seResp.error.msg);
				}
			}
		}
		console.timeEnd("ParsingSearchResponse");
		return respToReturn;
	}

	//private member functions, end
	var public = {
		//public properties, start

		//public properties, end
		//public member functions, start
		getSearchRequest : _getSearchRequest,
		getFacetRequest : _getFacetRequest,
		processSearchResponse : _processSearchResponse,
		processFacetResponse : _processFacetResponse,
	//public member functions, end
	};
	return public;
})();
//extend the base functionalities from qb.base
qb.sv = $.extend(true, {}, qb.base, qb.sv);
