var qb = qb || {}; // qb is the namespace for SOLR Query Builder and processor
/*
 * qb.rv is the base object for reports view(Custom reports) related operations
 */

qb.rv = (function() {
	// priate properties, start
	var _solrParams = qb.base.getSolrParams();
	// priate properties, end
	// private member functions, start

	function _getAggType(agg) {
		switch (agg) {
		case "CountDistinct":
			return "unique";
		case "Count":
		case "Sum":
		case "Avg":
		case "Min":
		case "Max":
			return agg.toLowerCase();
		default:
			return false;
		}
	}
	function _getSortDir(dir) {
		return dir.toLowerCase();
	}
	function _getAggKey(config) {
		var agg = config.aggrType;
		return agg.toLowerCase() !== "count" ? (agg + "_" + config.column) : _getAggType(agg);
	}
	function _getAggQuery(id, config) {
		var qObj;
		var agg = config.aggrType;
		if(agg.toLowerCase() !== "count")
		{
			qObj = {
				"key" : agg + "_" + config.column,
				"q" : _getAggType(agg) + "(" + qb.base.getFieldName(id, config.column) + ")"
			}			
		}		
		return qObj;
	}
	function _getIdForValue(val) {
		return ("" + val).replace(/\s/g, "");
	}
	// currently writing this function specific to CR
	// later might move to base
	function _setDateRangeFacetQuery(req, config) {
		var interval = config.timeGrouping;
		var numPoints = 50; // it has to be property from chart; check if u can
		// use numPointsToDisplay
		req["mincount"] = 1;
		var dtObj = this.getDateFilterApplied(config.column, numPoints);
		if (dtObj && dtObj.start && dtObj.end && dtObj.gap) {
			req["start"] = dtObj.start;
			req["end"] = dtObj.end;
			req["gap"] = "+" + dtObj.gap;
		} else {
			req["start"] = config.minDate;
			req["gap"] = config.gap;
			req["end"] = config.maxDate;
		} 
		//to include end of the range in the last bucket and have last bucket end == range quuery end.
		req["hardend"] = true;
		req["include"] = "edge";
		// req["gap"] = encodeURIComponent(req["gap"]);
	}

	function _getSortObj(id, sortOpts, dimensionsList, measuresList, i) {
		var sReq;
		var isSort = sortOpts && sortOpts.sortAxis && sortOpts.sortAxis.toLowerCase() !== 'none';
		if (isSort) {
			sReq = {};
			if (sortOpts.sortAxis === 'XAxis') {
				sReq.index = _getSortDir(sortOpts.direction);
			} else if (i === dimensionsList.length - 1 && sortOpts.sortAxis === 'YAxis') {
				// sorting on YAxis(aggregation) is applicable for only the leaf
				// facet request. so take the last object from measuresList
				sReq[_getAggKey(measuresList[measuresList.length - 1])] = _getSortDir(sortOpts.direction);
			}
		}
		return sReq;
	}

	function _fillLimitAndOffset(req, limitObj) {
		if (limitObj) {
			if (limitObj.hasOwnProperty("maxPoints") || limitObj.hasOwnProperty("includeAll")) {
				req.limit = limitObj.includeAll ? -1 : parseInt(limitObj.maxPoints);
			}
			// Add offset
			if (limitObj.hasOwnProperty("offset")) {
				req.offset = limitObj.offset;
			}
		}
	}

	function _fillFacetQueryForAppliedFilters(id,filtersMap, eachConfig, jsonFReq, isPageBuilder) {
		var self = this;
		$.each((filtersMap || []), function(fName, fieldObj) {
			if (fName === eachConfig.column) {
				$.each((fieldObj.include || []), function(index, value) {
					
					if (typeof value === "object") {
						return;
					}
					var isEmptyValue = eachConfig.showEmptyValues && value === self.getQueryForEmptyVal();
					var fName_value = "_" + fName + "_" + isEmptyValue ? eachConfig.emptyValueLabel : value;
					jsonFReq[fName_value] = {
						"type" : "query",
						"q" : ""
					};
					jsonFReq[fName_value].q = self.getFilterQuery(id, fName, value+"", "", true);
					jsonFReq[fName_value].domain = {};
					if(isPageBuilder)
						jsonFReq[fName_value].domain[_solrParams.JSON_FACET_EXCLUDE_TAGS] = [ "tag_page_override" ];
					jsonFReq[fName_value][_solrParams.FACET] = {};
					$.each((eachConfig.aggrTypes || []), function(index, aggrType) {
						eachConfig.aggrType = aggrType;
						var aggQ = _getAggQuery(id, eachConfig);
						if (aggQ) {
							jsonFReq[fName_value][_solrParams.FACET][aggQ.key] = aggQ.q;
						}
					});
				});
			}
		});
	}
	function _getFacetRequest(id, measuresList, dimensionsList, otherParams) {
		otherParams = typeof otherParams === 'undefined' ? {} : otherParams;
		var sortOpts = otherParams.sortOpts;
		var filtersMap = otherParams.filtersMap;
		var isFlat = otherParams.isFlat;
		var isPageBuilder = otherParams.isPageBuilder;
		var isAVoidFQ = otherParams.isAVoidFQ;
		var doNotExclude = otherParams.doNotExclude;
		var inputParams = otherParams.inputParams;
		var customFilterQuery = otherParams.customFilterQuery;
		var skipAllFilters = otherParams.skipAllFilters;
		var self = this;
		var req = this.getCurrentSearchReq();
		if(skipAllFilters)
			req.fq = [];
		var fqArrs = undefined;
		if (!isAVoidFQ) {
			fqArrs = this.getFilterQueryFromFiltersMap(id, filtersMap, true, undefined, true);
		}
		if (fqArrs) {
			if ($.isEmptyObject(req.fq)) {
				req.fq = fqArrs;
			} else {
				req.fq = req.fq.concat(fqArrs);
			}
		}

		if(!req.fq)
			req.fq = [];

		if(!$.isEmptyObject(customFilterQuery)) 
			req.fq.push(customFilterQuery);
		
		
		if (!$.isEmptyObject(measuresList) || !$.isEmptyObject(dimensionsList)) {
			req[_solrParams.FACET] = true;
			var jsonFReq = {}, prevReq = {}, fReq = {}, sReq = {};
			var isPrevQueryReq = false;
			var fillInnerMostAggr = true;
			for (var i = 0; i < dimensionsList.length; i++) {
				var eachConfig = dimensionsList[i];
				var actualFName = eachConfig.column, fName = qb.base.getFieldName(id, eachConfig.column);

				var limitObj = eachConfig.numPointsToDisplay;
				var isRange = eachConfig.timeGrouping && eachConfig.timeGrouping.toLowerCase() !== 'none' ? true
						: false;
				var isQuery = (eachConfig.customGroupsAvailable && !$.isEmptyObject(eachConfig.groups)) ? true : false;
				var eachReq = {
					type : isQuery ? _solrParams.JSON_FACET_QUERY : (isRange ? _solrParams.JSON_FACET_RANGE
							: _solrParams.JSON_FACET_TERMS),
					domain : {},
					numBuckets : true,
					mincount : eachConfig.minCount ? eachConfig.minCount : 1
				};
				if (eachConfig.prefix) {
					eachReq["prefix"] = eachConfig.prefix;
				}
				var excludeTags = [];
				if (isFlat) {
					if (isPageBuilder) {
						excludeTags.push(_solrParams.TAG_PREFIX + "page_" + actualFName);
						excludeTags.push(_solrParams.TAG_PREFIX + actualFName);
						excludeTags.push("tag_page_override");
					} else if (eachConfig.customGroupsAvailable) {
						excludeTags.push(_solrParams.TAG_PREFIX + "group_" + actualFName);
						excludeTags.push(_solrParams.TAG_PREFIX + actualFName);
					} else {
						excludeTags.push(_solrParams.TAG_PREFIX + actualFName);
					}						
					excludeTags.push(_solrParams.TAG_PREFIX + "exclude_" + actualFName);											
					
				} else {
					$.each(dimensionsList, function(ii, dimension) {
						if (dimension.customGroupsAvailable) {
							excludeTags.push(_solrParams.TAG_PREFIX + "group_" + dimension.column);
						} else {
							excludeTags.push(_solrParams.TAG_PREFIX + dimension.column);
						}
					});
				}
				if (!doNotExclude) {
					eachReq.domain[_solrParams.JSON_FACET_EXCLUDE_TAGS] = excludeTags;
				}
				if (isQuery) {
					var queryReq = {};
					var notFilter = [];
					$.each(eachConfig.groups, function(j, eachGroup) {
						if (eachGroup.groupValues) {
							var filterVal = [ {
								'groupName' : eachGroup.groupName,
								'groupValues' : eachGroup.groupValues
							} ];
							eachReq["q"] = self.getFilterQuery(id, fName, filterVal, "", false);
							notFilter.push("-(" + eachReq.q + ")");
							queryReq["_" + actualFName + "_" + eachGroup.groupName] = $.extend({}, eachReq);
						}
					});
					if (eachConfig.includeUngrouped) {
						if (eachConfig.ungroupedLabel) {
							// facet query ; others use case
							eachReq["q"] = notFilter.join(_solrParams.FQ_AND);
							queryReq["_" + actualFName + "_" + eachConfig.ungroupedLabel] = $.extend({}, eachReq)
						} else {
							// terms facet; show the values as is
							var ungroupedReq = {};
							ungroupedReq.type = _solrParams.JSON_FACET_TERMS;
							ungroupedReq.numBuckets = true;
							ungroupedReq.domain = {
								filter : notFilter
							};
							ungroupedReq.field = fName;
							_fillLimitAndOffset(ungroupedReq, limitObj);
							queryReq[actualFName] = $.extend({}, ungroupedReq)
						}
					}
				} else {
					eachReq["field"] = eachConfig.facetFieldTagName ? eachConfig.facetFieldTagName : fName;
					_fillLimitAndOffset(eachReq, limitObj);

					// sorting is not applicable for facet query
					var sReq = _getSortObj(id, sortOpts, dimensionsList, measuresList, i);
					if (!$.isEmptyObject(sReq)) {
						eachReq[_solrParams.SORT] = sReq;
					}
					if (eachConfig.sortDirection) {
						var dimensionSort = {};
						dimensionSort['index'] = _getSortDir(eachConfig.sortDirection);
						eachReq[_solrParams.SORT] = dimensionSort;
					}
					if (isRange) {
						self.setDateRangeFacetQuery(eachReq, eachConfig);
					}
				}
				if (i > 0 && !isFlat) {
					// TODO: this logic works only for two levels, generalize it
					// to make it work for all cases
					if (isPrevQueryReq) {
						$.each(prevReq, function(key, obj) {
							obj[_solrParams.FACET] = {};
							if (isQuery) {
								obj[_solrParams.FACET] = $.extend({}, queryReq);
							} else {
								obj[_solrParams.FACET][actualFName] = eachReq;
							}
						});
					} else {
						if (isQuery) {
							prevReq[_solrParams.FACET] = $.extend({}, queryReq);
							prevReq = queryReq;
						} else {
							prevReq[_solrParams.FACET] = {};
							prevReq[_solrParams.FACET][actualFName] = eachReq;
							prevReq = eachReq;
						}
					}
				} else {
					if (isQuery) {
						if(!isFlat)
							jsonFReq = {}
						jsonFReq = $.extend(jsonFReq, queryReq);
						prevReq = jsonFReq;
						isPrevQueryReq = true;
					} else {
						jsonFReq[actualFName] = eachReq;
						prevReq = jsonFReq[actualFName];
						isPrevQueryReq = false;
					}
					if (isFlat) { // TODO: check if existing code changes can
						// be used here
						if (isQuery) {
							$.each(eachConfig.groups, function(j, eachGroup) {
								if (eachGroup.groupValues) {
									var fGroupName = "_" + actualFName + "_" + eachGroup.groupName;
									jsonFReq[fGroupName][_solrParams.FACET] = {};
									$.each(eachConfig.measureDataFields, function(index, measure) {
									$.each(measure.aggrTypes, function(index, aggrType) {
										measure.aggrType = aggrType;
										var aggQ = _getAggQuery(id, measure);						
										if (aggQ) {
											jsonFReq[fGroupName][_solrParams.FACET][aggQ.key] = aggQ.q;
										}
									});
								});
								}
							});
							if (eachConfig.includeUngrouped) {
								var fGroupName = actualFName;
								if (eachConfig.ungroupedLabel) 
									fGroupName = "_" + actualFName + "_" + eachConfig.ungroupedLabel;
								
								jsonFReq[fGroupName][_solrParams.FACET] = {};
								$.each(eachConfig.measureDataFields, function(index, measure) {
									$.each(measure.aggrTypes, function(index, aggrType) {
										measure.aggrType = aggrType;
										var aggQ = _getAggQuery(id, measure);						
										if (aggQ) {
											jsonFReq[fGroupName][_solrParams.FACET][aggQ.key] = aggQ.q;
										}
									});
								});								
							}
						} else {
							jsonFReq[actualFName][_solrParams.FACET] = {};

							if (typeof eachConfig.measureDataFields === 'undefined' ||
									$.isEmptyObject(eachConfig.measureDataFields)) {
								var aggQ = _getAggQuery(id, eachConfig);
								if (aggQ) {
									jsonFReq[actualFName] = aggQ.q;
								} else {
									// to get count of a field (excluding
									// missing)
									var schemaObj = self.getSchemaObj(id, fName);
									var fType = schemaObj.origType;
									var isNumericField = self.isNumberRangeAllowed(fType) || self.isDecimalRangeAllowed(fType);
									jsonFReq[actualFName] = {
										"query" : fName + (isNumericField ? ":[* TO *]" : ":*")
									};
								}
							} else {
								$.each(eachConfig.measureDataFields, function(index, measure) {
									$.each(measure.aggrTypes, function(index, aggrType) {
										measure.aggrType = aggrType;
										var aggQ = _getAggQuery(id, measure);
										if (aggQ) {
											jsonFReq[actualFName][_solrParams.FACET][aggQ.key] = aggQ.q;
										}
									});
								});
								if (eachConfig.sort && !$.isEmptyObject(eachConfig.sort)) {
									jsonFReq[actualFName][_solrParams.SORT] = {};
									if (eachConfig.sort.sortField.indexOf("Count_") === -1) {
										jsonFReq[actualFName][_solrParams.SORT][eachConfig.sort.sortField] = eachConfig.sort.sortDirection;
									} else {
										jsonFReq[actualFName][_solrParams.SORT]['count'] = eachConfig.sort.sortDirection;
									}
								}
							}
						}
						self.fillFacetQueryForAppliedFilters(id, filtersMap, eachConfig, jsonFReq, isPageBuilder);
						if(eachConfig.showEmptyValues) {
							//add empty value facet
							var schemaObj = self.getSchemaObj(id, fName);
							var dataType = schemaObj.origType || schemaObj.type;
							var value = self.getQueryForEmptyVal();
							var fName_value = "_" + actualFName + "_" + eachConfig.emptyValueLabel;
							jsonFReq[fName_value] = {
								"type" :  _solrParams.JSON_FACET_QUERY,
								"domain" : jsonFReq[actualFName].domain
							};
							jsonFReq[fName_value][_solrParams.FACET] = {};
							jsonFReq[fName_value][_solrParams.QUERY]= self.getSOLRExpr(id, fName, value, dataType, true, true);
							$.each(eachConfig.measureDataFields, function(index, measure) {
								$.each(measure.aggrTypes, function(index, aggrType) {
									measure.aggrType = aggrType;
									var aggQ = _getAggQuery(id, measure);
									if (aggQ) {
										jsonFReq[fName_value][_solrParams.FACET][aggQ.key] = aggQ.q;
									}
								});
							});
						}
					}
				}
				if (eachConfig.doNotFillAggr) {
					fillInnerMostAggr = false;
				}
			}

			/*
			 * construct the facet object for aggregation and then insert into
			 * the facet request inner most object(s) e.g. facet : {
			 * CountDistinct_field1 : "unique(field1)" , Sum_field1 :
			 * "sum(field1)"}
			 */
			var aggFacetReq = {};
			var sortObj = {};
			if (!isFlat) {
				$.each(measuresList, function(i, eachConfig) {
					if ($.isEmptyObject(eachConfig.aggrTypes)) {
						eachConfig.aggrTypes = [ eachConfig.aggrType ];
					}
					$.each((eachConfig.aggrTypes || []), function(index, aggrType) {
						eachConfig.aggrType = aggrType;
						var aggQ = _getAggQuery(id, eachConfig);
						if (aggQ) {						
							aggFacetReq[aggQ.key] = aggQ.q;
						}
						if (eachConfig.sortOrder) {
							sortObj[aggQ ? aggQ.key : "count"] = _getSortDir(eachConfig.sortOrder);
						}
					});
				});
				if (!$.isEmptyObject(aggFacetReq)) {
					_fillAggFacetReq(jsonFReq, aggFacetReq, sortObj, fillInnerMostAggr);
				}
			}

			req[_solrParams.JSON_FACET] = JSON.stringify(jsonFReq);
		}
		this.fillInputParams(id, req, inputParams);
		return req;
	}
	function _fillInputParams(id, req, inputParams) {
		var self = this;
		var fq;
		if (!$.isEmptyObject(inputParams)) {
			$.each(inputParams, function(index, eachInput) {
				if (!$.isEmptyObject(eachInput.values) && typeof (eachInput.values[0]) !== "undefined") {
					fq = self.getFilterQuery(id, eachInput.inputId, eachInput.values);
					if (!$.isEmptyObject(fq) && fq !== "") {
						if (req.hasOwnProperty(eachInput.name)) {
							req[eachInput.name].push(fq);
						} else {
							req[eachInput.name] = [ fq ];
						}
					}
				}
			});
		}
	}
	/*
	 * 1. when there are more than one dimension, aggregation request has to be
	 * in the leaf facet request 2. when there is facet query, aggregation
	 * request has to be in all the facet query objects fillInnerMostAggr - will
	 * not work for third level
	 */
	function _fillAggFacetReq(jsonFReq, aggFacetReq, sortObj, fillInnerMostAggr) {
		if ($.isEmptyObject(jsonFReq)) {
			return;
		}
		$.each(jsonFReq, function(fKey, fReq) {
			// Do not fill sort object for facet query by checking for "q"
			if (!$.isEmptyObject(sortObj) && !fReq.hasOwnProperty("sort") && !fReq.hasOwnProperty("q")) {
				fReq["sort"] = sortObj;
			}
			if (!fReq.hasOwnProperty(_solrParams.FACET)) {
				if (typeof fReq === "object") {
					fReq[_solrParams.FACET] = $.extend({}, aggFacetReq);
				}
			} else {
				fReq[_solrParams.FACET] = $.extend(fReq[_solrParams.FACET], aggFacetReq);
				if (fillInnerMostAggr) {
					_fillAggFacetReq(fReq[_solrParams.FACET], aggFacetReq);
				}
			}
		});
	}
	/*
	 * convert the facet query response(if found) into facet terms/range
	 * response so that the recursive processing remains the same. also this
	 * function merges the facet query response into facet response's bucket if
	 * same dimension is found
	 */
	function _checkAndConvertFacetQueryResp(id, fRespObj, currDim, sortReq) {
		var dimKey = currDim.column;
		var includeMissingGroups = currDim.includeMissingGroups;
		var bucketsArr = [], prefix = "_" + dimKey + "_";
		var isFacetQueryFound = false, fqRespMap = {};
		function _addToBucket(cgKey, cgValObj) {
			var eachValObj = {
				val : cgKey.substring(prefix.length),
			};
			$.each(cgValObj, function(eachKey, eachObj) {
				if (eachKey !== "val") {
					eachValObj[eachKey] = eachObj;
				}
			});
			if (eachValObj.count > 0 || (eachValObj.count === 0 && includeMissingGroups)) {
				bucketsArr.push(eachValObj);
			}
		}
		if (($.isEmptyObject(sortReq) && currDim.sortOrder === "NONE") && !$.isEmptyObject(currDim.groups)) {
			var cgKey;
			// when sort order is none, make sure the response is in the same
			// order as how it defined in the custom group
			$.each(currDim.groups, function(i, eachGroup) {
				cgKey = prefix + eachGroup.groupName;
				if (fRespObj.hasOwnProperty(cgKey)) {
					_addToBucket(cgKey, fRespObj[cgKey]);
					delete fRespObj[cgKey];
				}
			});
		}
		// have to iterate the remaining keys in fRespObj for ungrouped category
		$.each(fRespObj, function(key, obj) {
			// if it starts with _dimensionKey_, then it is facet query
			if (key.indexOf(prefix) === 0) {
				isFacetQueryFound = true;
				_addToBucket(key, obj);
				delete fRespObj[key];
			}
		});

		if (fRespObj[dimKey] && fRespObj[dimKey].hasOwnProperty("buckets") &&
				!$.isEmptyObject(fRespObj[dimKey].buckets)) {
			// terms/range facet already exist, so merge them
			bucketsArr = bucketsArr.concat(fRespObj[dimKey].buckets);
		}
		// do client side sorting in case of facet query
		if (isFacetQueryFound && !$.isEmptyObject(sortReq)) {
			var sortKey = Object.keys(sortReq)[0];
			var sortDir = sortReq[sortKey];
			sortKey = sortKey === "index" ? "val" : sortKey;
			bucketsArr = cvSearchUtil.sortArrayByKey(bucketsArr, sortKey, sortDir);
		}
		if (!fRespObj.hasOwnProperty(dimKey)) {
			fRespObj[dimKey] = {};
		}
		fRespObj[dimKey].buckets = bucketsArr;
	}
	
	function _isFacetRespFound(bucketObj, dimKey) {
		return bucketObj.hasOwnProperty(dimKey) || (new RegExp("_" + dimKey + "_.*")).test(Object.keys(bucketObj));
	}

	function _recurseFacetResponse(id, fRespObj, isRespInObjFmt, dimensionsList, measuresList, dimIndex, valArr, arr,
			moreInfo, sortOpts) {
		var buckets, eachArrOrObj, eachBucket, v1, v2;
		var currDimKey = dimensionsList[dimIndex].column;
		var nextDimKey = dimIndex + 1 < dimensionsList.length ? dimensionsList[dimIndex + 1].column : undefined;
		_checkAndConvertFacetQueryResp(id, fRespObj, dimensionsList[dimIndex], _getSortObj(id, sortOpts,
				dimensionsList,
				measuresList,
				dimIndex));
		if (fRespObj[currDimKey] && fRespObj[currDimKey].hasOwnProperty("buckets") &&
				!$.isEmptyObject(fRespObj[currDimKey].buckets)) {
			buckets = fRespObj[currDimKey].buckets;
			moreInfo[currDimKey] = moreInfo.hasOwnProperty(currDimKey) ? moreInfo[currDimKey] : {
				values : [],
				keyMap : {}
			};
			if (nextDimKey && _isFacetRespFound(buckets[0], nextDimKey)) {
				dimIndex++;
				for (var i = 0; i < buckets.length; i++) {
					// subfacet; recursive case
					eachBucket = buckets[i];
					v1 = eachBucket["val"];
					if (isRespInObjFmt) {
						valArr[currDimKey] = v1;
					} else {
						valArr[dimIndex - 1] = v1;
					}
					// storing all the values in moreInfo
					moreInfo[currDimKey].values.push(v1);
					_recurseFacetResponse(id, eachBucket,
							isRespInObjFmt,
							dimensionsList,
							measuresList,
							dimIndex,
							valArr,
							arr,
							moreInfo);
				}
			} else {
				if (isRespInObjFmt) {
					eachArrOrObj = $.extend({}, valArr);
				}
				for (var i = 0; i < buckets.length; i++) {
					eachBucket = buckets[i];
					v2 = eachBucket["val"];
					// base case; no more sub facets, all measures response will
					// be available
					if (!isRespInObjFmt) {
						eachArrOrObj = valArr.concat([ v2 ]);
					}
					// storing all the values in moreInfo
					moreInfo[currDimKey].keyMap[_getIdForValue(v2)] = v2;
					// need to lookup measuresList to know if count is required
					// or not and to know the order of the stats value
					// e.g. User might have dropped measures like
					// CountDistinct(bikeId), Count(Gender), Sum(tripduration)
					// response will be having count : x, CountDistinct_bikeId :
					// y and Sum_tripduration : z
					// so you need to go through the measures array to maintain
					// the order
					// if the chart would accept JSON instead of ARRAY, then no
					// need of this looping
					$.each(measuresList, function(i, eachConfig) {
						if ($.isEmptyObject(eachConfig.aggrTypes)) {
							eachConfig.aggrTypes = [ eachConfig.aggrType ];
						}
						$.each((eachConfig.aggrTypes || []), function(index, aggrType) {
							eachConfig.aggrType = aggrType;
							var aggVal = eachBucket[_getAggKey(eachConfig)] || 0;
							if (isRespInObjFmt) {
								// if more measure has been sent, 
								//then this will be the last measure's status value
								eachArrOrObj[_getIdForValue(v2)] = aggVal;
							} else {
								eachArrOrObj.push(aggVal);
							}
						});
					});
					if (!isRespInObjFmt) {
						arr.push(eachArrOrObj);
					}
				}
				if (isRespInObjFmt) {
					arr.push(eachArrOrObj);
				}
			}
		}
	}
	function _getFlatResponse(id, dimensionsList, facetResp) {
		$.each(dimensionsList, function(index, dimension) {			
			_checkAndConvertFacetQueryResp(id, facetResp, dimension);
			
		});
		return facetResp;
	}
	function _processFacetResponse(id, measuresList, dimensionsList, otherParams, seResp) {
		var sortOpts = otherParams.sortOpts;
		var isRespInObjFmt = otherParams.isRespInObjFmt;
		var constructGroupStructure = otherParams.constructGroupStructure;
		var isFlat = otherParams.isFlat;
		var resp = {
			data : {
				records : [],
				groups : [], // TODO: test
				moreInfo : {}
			},
			timeGroup : !$.isEmptyObject(seResp.response) ? seResp.response.timeGroup : ""
		};
		if ($.isEmptyObject(seResp) || $.isEmptyObject(seResp.facets)) {
			return resp;
		}
		if (!isFlat && !constructGroupStructure) {
			var respArr = [];// this will be array of arrays
			try {
				_recurseFacetResponse(id, seResp.facets,
						isRespInObjFmt,
						dimensionsList,
						measuresList,
						0,
						isRespInObjFmt ? {} : [],
						respArr,
						resp.data.moreInfo,
						sortOpts);
				resp.data.records = respArr;
			} catch (e) {
				console.error(e);
			}
		} else if (!isFlat) {
			var facetBuckets = seResp.facets;
			var groupLevels = [];
			var groupStructure = [];
			var level = 0;

			_constructGroupStructure(id, facetBuckets,
					level,
					groupLevels,
					groupStructure,
					dimensionsList,
					measuresList,
					sortOpts);
			resp.data.groups = groupStructure;
			angular.forEach(dimensionsList, function(group, idx) {
				if (seResp.facets.hasOwnProperty(group.column)) {
					resp.totalRecordCount = seResp.facets[group.column].numBuckets;
				}
			});
		} else if (isFlat) {
			return _getFlatResponse(id, dimensionsList, seResp.facets);
		}
		return resp;

	}
	function _constructGroupStructure(id, facetBuckets, level, groupLevels, groupStructure, dimensionsList, measuresList,
			sortOpts) {
		_checkAndConvertFacetQueryResp(id, facetBuckets, dimensionsList[level], _getSortObj(id, sortOpts,
				dimensionsList,
				measuresList,
				level));
		for ( var groupKey in facetBuckets) {
			if (typeof facetBuckets[groupKey] === "object") {
				var subBuckets = facetBuckets[groupKey].buckets;
				for (var i = 0; i < subBuckets.length; i++) {
					var kendoGroupObj = {};
					var subBucket = subBuckets[i];
					var aggregate = _getAggregatesByField(subBucket, measuresList);
					kendoGroupObj.field = groupKey;
					kendoGroupObj.aggregates = $.extend(true, {}, aggregate);
					kendoGroupObj.items = [];
					kendoGroupObj.value = subBucket.val;
					kendoGroupObj.count = subBucket.count;

					kendoGroupObj.hasSubgroups = false;
					level = groupLevels.length;
					for (var j = 0; j < dimensionsList.length; j++) {
						var group = dimensionsList[j];
						if (_isFacetRespFound(subBucket, group.column)) {
							kendoGroupObj.hasSubgroups = true;
							break;
						}
					}
					var obj = {};
					obj[level] = kendoGroupObj;
					groupLevels.push(obj);
					var recurse = false;
					if (kendoGroupObj.hasSubgroups) {
						level++;
						_constructGroupStructure(id, subBucket,
								level,
								groupLevels,
								groupStructure,
								dimensionsList,
								measuresList,
								sortOpts);
						recurse = false;
					} else if (level > 0) {
						var len = groupLevels.length / 2;
						for (var k = groupLevels.length; k > len; k--) {
							var groupObj = groupLevels[k - 1][k - 1];
							var prevGroupObj = groupLevels[k - 2][k - 2];
							prevGroupObj.items.push(groupObj);
							var obj = {};
							obj[k - 2] = prevGroupObj;
							groupLevels.splice(k - 2, 1, obj);
							groupLevels.splice(k - 1, 1);
						}
						recurse = true;
					}
					if (!recurse) {
						groupStructure.push(groupLevels[0][0]);
						groupLevels = [];
					}
				}

			}
		}

	}

	function _getAggregatesByField(groupBucket, measuresList) {
		var fieldAggregate = {};
		for (var i = 0; i < measuresList.length; i++) {
			var groupMeasure = measuresList[i];
			var column = groupMeasure.column;
			var aggrType = groupMeasure.aggrType;
			var aggregateField = aggrType;
			var aggrObj = {};

			if (aggrType.toLowerCase() != "count") {
				aggregateField = aggrType + "_" + column;
			} else {
				aggregateField = aggrType.toLowerCase();
			}
			for ( var key in groupBucket) {
				if (key == aggregateField) {
					aggrObj[aggrType.toLowerCase()] = groupBucket[key];
					break;
				} else {
					aggrObj[aggrType.toLowerCase()] = 0;
				}
			}
			if ($.isEmptyObject(fieldAggregate[column])) {
				fieldAggregate[column] = {};
			}
			$.extend(true, fieldAggregate[column], aggrObj);
		}
		return fieldAggregate;
	}

	/* request to get only facet aggregation values; not facet values */
	function _getFacetFnRequest(id, measuresList, filtersMap) {
		var req = this.getCurrentSearchReq();
		var fqArrs = this.getFilterQueryFromFiltersMap(id, filtersMap, true, undefined, true);
		if (!$.isEmptyObject(fqArrs)) {
			if ($.isEmptyObject(req.fq)) {
				req.fq = fqArrs;
			} else {
				req.fq = req.fq.concat(fqArrs);
			}
		}
		measuresList = $.extend(true, [], measuresList);
		if (!$.isEmptyObject(measuresList)) {
			req[_solrParams.FACET] = true;
			var jsonFReq = {};
			$.each(measuresList, function(i, eachConfig) {
				if (!eachConfig.aggrTypes) {
					eachConfig.aggrTypes = [ eachConfig.aggrType ];
				}
				$.each((eachConfig.aggrTypes || []), function(index, aggrType) {
					eachConfig.aggrType = aggrType;
					var aggQ = _getAggQuery(id, eachConfig);
					if (aggQ) {
						jsonFReq[aggQ.key] = aggQ.q;
					}
				});
			});
			req[_solrParams.JSON_FACET] = JSON.stringify(jsonFReq);
		}
		return req;
	}

	/* returns array of aggregation values requested by the client */
	function _processFacetFnResponse(id, measuresList, filtersMap, seResp) {
		var self = this;
		var resp = {
			data : []
		};
		if ($.isEmptyObject(seResp) || $.isEmptyObject(seResp.facets)) {
			return resp;
		}
		var aggs = [];
		$.each(measuresList, function(i, eachConfig) {
			if (!eachConfig.aggrTypes) {
				eachConfig.aggrTypes = [ eachConfig.aggrType ];
			}
			$.each((eachConfig.aggrTypes || []), function(index, aggrType) {
				eachConfig.aggrType = aggrType;
				aggs.push(seResp.facets[_getAggKey(eachConfig)]);
			});
		});
		resp.data = aggs;
		return resp;
	}



	/* request for ng-table parameters */
	function _getSearchRequest(id, tableParams, filtersMap, inputParams) {
		var self = this;
		var req = this.getCurrentSearchReq();
		//we have functionality to filter the report by selected table rows. And table filters should get applied 
		//to all components except table component for which we applying filters. 
		//so below code is to get filter from other components except table. other wise table will end up showing just selected row.
		if(tableParams.excludeTableRowFilters) {
			var commonFilterMap = this.getFilterMap();
			if(!$.isEmptyObject(commonFilterMap))
			var fqArrNormal = this.getFilterQueryFromFiltersMap(id,
				commonFilterMap.normal,
				true,
				"normal",
				true,
				undefined,
				tableParams.excludeTableRowFilters
				);
			var fqArrOverride = this.getFilterQueryFromFiltersMap(id,
				commonFilterMap.override,
				true,
				"override",
				true,
				undefined,
				tableParams.excludeTableRowFilters
				);
			req.fq = (fqArrNormal || []).concat(fqArrOverride || []);
		} 

		var fqArrs = this.getFilterQueryFromFiltersMap(id, filtersMap, true, undefined, true);
		if (!$.isEmptyObject(fqArrs)) {
			if ($.isEmptyObject(req.fq)) {
				req.fq = fqArrs;
			} else {
				req.fq = req.fq.concat(fqArrs);
			}
		}
		if ($.isEmptyObject(req.fq)) {
			req.fq = [];
		}
		if (tableParams.customFilterQuery) {
			req.fq.push(tableParams.customFilterQuery);
		}
		// prepare fl
		var listOfFields = [], fName;
		if (!$.isEmptyObject(tableParams.columns)) {
			$.each(tableParams.columns, function(i, eachConfig) {
					fName = self.getFieldName(id, eachConfig.dataField);
					// when there is field mapping, component still look for the
					// old field name, so do field aliasing
					fName = fName === eachConfig.dataField ? fName : (eachConfig.dataField + ":" + fName);
					listOfFields.push(fName);			
			});
		}
		// for row selection feature in data table, we need unique id
		listOfFields.push("contentid");
		req[_solrParams.FIELDS] = listOfFields;
		if (tableParams.offset !== undefined) {
			req[_solrParams.START] = tableParams.offset;
		}
		req[_solrParams.ROWS] = tableParams.limit;

		// prepare sort
		if (!$.isEmptyObject(tableParams.sort)) {
			var sortParams = [];
			$.each(tableParams.sort, function(i, eachOrder) {
				var sortFieldName = self.getFieldName(id, eachOrder.columnId);
				var sortField = self.getSchemaObj(id, sortFieldName+"_sort");
				if(sortField.fieldName)
					sortFieldName = sortField.fieldName;
				sortParams.push(sortFieldName + " " + _getSortDir(eachOrder.direction));
			});
			req[_solrParams.SORT] = sortParams.join(",");
		}

		// prepare fq for local filters;
		if (!$.isEmptyObject(tableParams.filters)) {
			var fqArr = [];
			// isExact is undefined in case of kendo grid drill down case
			// isExact is false in case of kendo tree grid drill down case;
			// because we need wild card support
			var isExact = tableParams.isExact === undefined || tableParams.isExact;
			$.each(tableParams.filters, function(i, fObj) {
				fqArr.push(self.getFilterQuery(id, fObj.columnId, fObj.fValue, undefined, isExact));
			});
			req[_solrParams.FILTER_QUERY] = req[_solrParams.FILTER_QUERY].concat(fqArr);
		} else {
			// fq will not be reset as it has to be current global fq
			// req[_solrParams.FILTER_QUERY] = [];
		}

		this.fillInputParams(id, req, inputParams);
		return req;
	}

	function _processSearchResponse(id, tableParams, filtersMap, inputParams, seResp) {
		console.time("ParsingSearchResponse");
		var respToReturn = {
			recordsCount : 0,
			totalRecordCount : 0,
			records : [],
			columns : tableParams.columns
		};
		// TODO: start here, refer onSuccessGetDataForDataSet
		if (!$.isEmptyObject(seResp)) {
			if (!$.isEmptyObject(seResp.response)) {
				respToReturn.totalRecordCount = seResp.response.numFound;
				if (!$.isEmptyObject(seResp.response.docs)) {
					respToReturn.records = seResp.highlighting ? this.mapHightlightResp(seResp.response.docs,
							seResp.highlighting) : seResp.response.docs;
					respToReturn.recordsCount = respToReturn.records.length;
				} else if (!$.isEmptyObject(seResp.error)) {
					respToReturn.recordsCount = respToReturn.totalRecordCount = 0;
					console.log(seResp.error.msg);
					alert(seResp.error.msg);
				} else if (!$.isEmptyObject(seResp.facets)) {
					var isRespInObjFmt = false;
					respToReturn.facets = seResp.facets;
					var respArr = [];// this will be array of arrays
					try {
						_recurseFacetResponse(id, seResp.facets,
								isRespInObjFmt,
								tableParams.dimensions,
								[],
								0,
								isRespInObjFmt ? {} : [],
								respArr,
								{});
						respToReturn.records = respArr;
					} catch (e) {
						console.error(e);
					}
				}
				// if (!$.isEmptyObject(seResp.response.docs))
			} else if (!$.isEmptyObject(seResp.grouped)) {
				respToReturn.grouped = seResp.grouped;
			}
		}
		console.timeEnd("ParsingSearchResponse");
		return respToReturn;
	}

	function _getCustomQueryRequest(id, customQuery, inputParams) {
		var self = this;
		var req = this.getCurrentSearchReq();
		$.each(customQuery, function(key, value) {
			if (key === "fq") {
				if ($.isEmptyObject(req.fq)) {
					req.fq = [];
				}
				req.fq.push(value);
			} else {
				req[key] = JSON.stringify(value);
			}
		});
		this.fillInputParams(id, req, inputParams);
		return req;
	}

	function _processCustomQueryResponse(id, customQuery, inputParams, seResp) {
		return seResp;
	}
	function _getRequestParams(id, measureList, dimensionsList, otherParams) {
		var req = this.getCurrentSearchReq();
		var reqParams = otherParams.reqParams;
		if($.isEmptyObject(reqParams)) {
			reqParams = {
				reqType : "GET"
			} 
		}
		reqParams.filterQuery = Array.isArray(req.fq) && req.fq.length > 0 ? req.fq.join(",") : "";
		return reqParams;
	}
	// private member functions, end
	var public = {
		// public properties, start

		// public properties, end
		// public member functions, start
		getFacetRequest : _getFacetRequest,
		processFacetResponse : _processFacetResponse,
		getSearchRequest : _getSearchRequest,
		processSearchResponse : _processSearchResponse,
		getFacetFnRequest : _getFacetFnRequest,
		processFacetFnResponse : _processFacetFnResponse,
		setDateRangeFacetQuery : _setDateRangeFacetQuery,
		getCustomQueryRequest : _getCustomQueryRequest,
		processCustomQueryResponse : _processCustomQueryResponse,
		fillInputParams : _fillInputParams,
		fillFacetQueryForAppliedFilters : _fillFacetQueryForAppliedFilters,
		getRequestParams: _getRequestParams
	// public member functions, end
	};
	return public;
})();
// extend the base functionalities from qb.base
qb.rv = $.extend(true, {}, qb.base, qb.rv);
