/*!
 * jQuery plugin
 * Component for search results view
 */
;
(function(factory) {
	var getDependencyMissingMsg = function(dependency) {
		return "cvSearchResultsView depends on " + dependency +
				" and seems to be missing. Please include necessary files.";
	};
	if (!jQuery) {
		throw getDependencyMissingMsg('jQuery');
	} else if (!$.fn.dataTable) {
		throw getDependencyMissingMsg('jquery datatable');
	} else if (typeof (cvSearchUtil) === "undefined") {
		throw getDependencyMissingMsg('cvSearchUtil');
	} else if (typeof (cvFormatters) === "undefined") {
		throw getDependencyMissingMsg('cvFormatters');
	} else {
		factory(jQuery);
	}

}(function($) {
	"use strict";
	$.fn.DataTable.ext.oApi._fnLog = function(settings, level, msg, tn) {
		msg = 'DataTables warning: ' + (settings !== null ? 'table id=' + settings.sTableId + ' - ' : '') + msg;

		if (tn) {
			msg += '. For more information about this error, please see ' + 'http://datatables.net/tn/' + tn;
		}
		console.log(msg);
	};

	$.fn.cvSearchResultsView = function(qbId, searchResultConfig, schema) {
		return this.each(function() {
			var $this = $(this), data = $this.data('cvSearchResultsView');
			if (!data) {
				$this.data('cvSearchResultsView', new SearchResultsView(this, qbId, searchResultConfig, schema));
			}
		});
	};
	$.fn.cvSearchResultsView.id = 0;
}));
function SearchResultsView(element, qbId, config, schema) {
	this.$element = $(element);
	this._qbId = qbId;
	this._origConfig = config;
	this._origSchema = schema;
	this._config = $.extend(true, {}, this.defaults, config);
	this._id = $.fn.cvSearchResultsView.id++;
	this.columnConfig = this.getColumnConfig(this._config);
	this.isEditable = this._config.isEditable;
	var contextPath = config.contextPath;
	this.contextPath = contextPath ? (contextPath.lastIndexOf("/") > 0 ? contextPath : contextPath + "/") : "";
	this.render();
};

SearchResultsView.prototype.Constants = {
	ID_PREFIX : "cvSearchGridView_",
	GRID_VIEW_CLASS : "cvSearchGridView",
	DATA_TABLE_CLASS : "cvSearchGridViewTable",
	FORMAT_OPTIONS_CONTAINER_ID : "cvFormatOptions",
	FORMAT_COMBO : "formatComboBox",
	DISPLAY_INPUT_ID : "displayNameInput",
	SETTINGS_BACK_BTN : "backBtn",
	SETTINGS_SAVE_BTN : "settingsSaveBtn",
	SETTINGS_BOTTOM_BUTTONS_PANEL : "bottom-button-panel",
	SETTINGS_LEFT_PANE : "settingsLeftPane",
	SETTINGS_RIGHT_PANE : "settingsRightPane",
	animationDuration : 250,
	ViewTypes : {
		GRID : "grid",
		LIST : "list",
	},
	cvDataGrid_Name : "cvDataGrid",
	cvSearchResultsView_Name : "cvSearchResultsView",
	SETTINGS_TMPL_PATH : "searchcomponents/templatehtml/cvGridSettings.html",
	SETTINGS_FORMAT_TMPL_PATH : "searchcomponents/templatehtml/cvSearchSettingsFormatter.html",
	HELP_TEXT_TMPL_PATH : "searchcomponents/templatehtml/cvSearchSettingsHelp.html",
	RENDERER_SETTINGS_ID : "cvSearchGridViewSettings_" + "extraSettings",
	HELP_BUTTON : "settingsHelpBtn",
	SETTINGS_HELP_TEXT : "settingsHelpText",
	VISIBILITY_BTN_ID : "visibilityCheckbox",
	SELECT_ALL_VIS : "allVisCheckbox",
	SETTINGS_RIGHT_PANE_HEADER : "settingsRightPaneHeader",

	supportedRenderers : {
		none : {
			value : "none",
			dispName : "None"
		},
		date : {
			value : "date",
			dispName : "Date"
		},
		size : {
			value : "size",
			dispName : "Size"
		},
		link : {
			value : "link",
			dispName : "Link"
		},
		unc : {
			value : "unc",
			dispName : "UNC"
		},
		number : {
			value : "number",
			dispName : "Number"
		},
		highlighter : {
			value : "highlighter",
			dispName : "Row HighLighter"
		},
		cellHighlighter : {
			value : "cellHighlighter",
			dispName : "Cell Highlighter"
		},
		bool : {
			value : "boolean",
			dispName : "Boolean"
		}
	},

	formatOptionsTemplates : null,
	formatHelpTemplates : null,
	formatOptionsIds : {
		visibilityOptions : "visibilityOptions",
		displayNameOptions : "displayNameOptions",
		formatTypeCombo : "formatTypeCombo",
		linkFormatOptions : "linkFormatOptions",
		dateFormatOptions : "dateFormatOptions",
		sizeFormatOptions : "sizeFormatOptions",
		uncFormatOptions : "uncFormatOptions",
		numberFormatOptions : "numberFormatOptions",
		highlightFormatOptions : "highlightFormatOptions",
		highlightRuleRow : "highlightRuleRowTemplate",
		booleanOptions : "booleanOptions"
	},
};

//For storing things to pop when back button is pressed in column settings
SearchResultsView.prototype.settingsBackBtnHiddenStack = new Array(0);
SearchResultsView.prototype.settingsBackBtnShownStack = new Array(0);

SearchResultsView.prototype.templates = {
	gridTmpl : function(id, className, colConfig) {
		var headerTRHtml = "<tr>";
		$.each(colConfig, function(index, eachConfig) {
			headerTRHtml += "<th>" + (eachConfig.dispName ? eachConfig.dispName : eachConfig.fieldName) + "</th>";
		});
		headerTRHtml += "</tr>";
		var tableHtml = "<table id='" + id + "' class='table table-bordered " + className + "' width='100%'>";
		tableHtml += "<thead>" + headerTRHtml + "</thead>";
		tableHtml += "<tfoot>" + headerTRHtml + "</tfoot>";
		tableHtml += "</table>";
		return tableHtml;
	},
	listTmpl : function(id, className) {
		return "<div id='" + id + "' class='" + className + "'></div>";
	},
	rendererApplyBtn : "<button id='" + SearchResultsView.prototype.Constants.SETTINGS_SAVE_BTN +
			"' class=' btn btn-default'>Save</button>",
	settingsBackBtnTmpl : "<button id='" + SearchResultsView.prototype.Constants.SETTINGS_BACK_BTN +
			"' class = 'btn btn-default'>Back</button>",
	settingsSaveBtnTmpl : "<button id='" + SearchResultsView.prototype.Constants.SETTINGS_SAVE_BTN +
			"' class='btn btn-default'>Save</button>",
	helpButton : "<div id='" + SearchResultsView.prototype.Constants.HELP_BUTTON +
			"' class='glyphicon glyphicon-question-sign'></div>"
};

SearchResultsView.prototype.defaults = {
	isEditable : false,
	viewType : SearchResultsView.prototype.Constants.ViewTypes.GRID,
	tableConfig : {
		dom : 'RJ<"pull-left"i><"pull-left refreshBtnDiv"><"pull-right settingsBtnDiv"><"pull-right"l><"clearfix">t<"pull-left"i><"pull-left refreshBtnDiv"><"pull-right"p><"clearfix">',
		processing : true,
		serverSide : true,
		searching : false,
		// "responsive" : true
		pageLength : 20,
		lengthMenu : [ 20, 50, 100, 500 ],
		order : [],
		scrollX : true,
		autoWidth : true
	}
};

SearchResultsView.prototype.render = function() {
	try {
		if (this._config.viewType === SearchResultsView.prototype.Constants.ViewTypes.GRID) {
			gridElm = $(this.templates.gridTmpl(this.Constants.ID_PREFIX + this._id,
					this.Constants.GRID_VIEW_CLASS,
					this.columnConfig));
		} else {
			gridElm = $(this.templates.listTmpl(this.Constants.ID_PREFIX + this._id, this.Constants.GRID_VIEW_CLASS));
		}
		this.$element.append(gridElm);
		this.attachListeners();
	} catch (e) {
		console.error(e);
	}
};
SearchResultsView.prototype.clear = function() {
	$("#" + this.getIdStr()).remove();
	$("#" + this.getIdStr() + "_wrapper").remove(); // datatable
};
SearchResultsView.prototype.getIdStr = function() {
	return this.Constants.ID_PREFIX + this._id;
};
SearchResultsView.prototype.mask = function() {
	if (this._config.viewType === SearchResultsView.prototype.Constants.ViewTypes.GRID) {
		//concatenating "_wrapper" to mask the table with headers
		$("#" + this.getIdStr() + "_wrapper").mask("");
	} else {
		$("#" + this.getIdStr()).mask("");
	}
};
SearchResultsView.prototype.unmask = function() {
	if (this._config.viewType === SearchResultsView.prototype.Constants.ViewTypes.GRID) {
		//concatenating "_wrapper" to unmask the table with headers
		$("#" + this.getIdStr() + "_wrapper").unmask();
	} else {
		$("#" + this.getIdStr()).unmask();
	}
};
SearchResultsView.prototype.destroy = function() {
	$("#" + this.Constants.ID_PREFIX + "modal").remove();
};
SearchResultsView.prototype.attachListeners = function() {
	var self = this;
	var ev = cvSearchConstants.EventConstants.RELOAD_SEARCH_RESULTS_VIEW;
	this.$element.off(ev).on(ev, function(event) {
		self.reloadGridView();
	});
	this.$element.off('remove').on('remove', function(e) {
		self.destroy();
	});
};
SearchResultsView.prototype.getDTConfig = function() {
	var dtConfig = $.extend(true, {}, this.defaults.tableConfig, this._config.tableConfig);
	// merge any configuration from _config to default dt config
	if (this._config.viewType === SearchResultsView.prototype.Constants.ViewTypes.LIST) {
		dtConfig.fnItemTmpl = this._config.fnItemTmpl;
	}
	return dtConfig;
};

SearchResultsView.prototype.getConfig = function() {
	var self = this;
	var dtConfig = this.getDTConfig();
	dtConfig.columns = this.getColumnConfigInDTFormat(this.columnConfig);
	dtConfig.ajax = function(dtParams, fn, oSettings) {
		self.fillVisibilityInfo(dtParams.columns);
		self.mask();
		qb.sv.doSearch(self._qbId, dtParams, self._config, function(dtResp, reqObj) {
			/*
			 * Whenever the table gets updated, the search params used to do so are saved. When exporting,
			 * this search params are used to create the file -> Whatever is in the table gets exported.
			 */
			$.each(self.columnConfig, function(indx, column) {
				if (column.renderer && column.renderer.type === "date") {
					var searchParams = JSON.parse(reqObj.params).searchParams;
					var DateFormat = {};
					var timeZone = {};
					DateFormat["key"] = "clientDateTime";
					DateFormat["value"] = column.renderer.fmt;
					timeZone["key"] = "clientTimezone";
					timeZone["value"] = cvUtil.getTimeZone();
					searchParams.push(DateFormat);
					searchParams.push(timeZone);
					var tempObj = {};
					tempObj["searchParams"] = searchParams;
					tempObj["isTimeZoneMappingRequired"] = true;
					reqObj.params = JSON.stringify(tempObj);
					return;
				}
			});
			self.$element.trigger(cvSearchConstants.EventConstants.CACHE_SEARCH_PARAMS, [ reqObj.params ]);
			self.unmask();
			console.time("DataTable");
			fn(dtResp);
			console.timeEnd("DataTable");
		});
	};
	dtConfig.initComplete = function(settings, json) {
		self.onGridInitComplete(settings, json);
	};
	dtConfig.colReorder = {
		reorderCallback : function() {
			self.onGridReOrder(this.s.mouse.fromIndex, this.s.mouse.toIndex);
		}
	}
	return dtConfig;
};
SearchResultsView.prototype.onGridInitComplete = function(settings, json) {
	if (this._config.viewType === SearchResultsView.prototype.Constants.ViewTypes.GRID &&
			$.fn.DataTable.isDataTable("#" + this.getIdStr())) {
		var dtWrapper = $(("#" + this.getIdStr()) + "_wrapper");
		$("div.settingsBtnDiv", dtWrapper).empty().append(this.getEditSettingsBtn());
		$("div.refreshBtnDiv", dtWrapper).empty().append(this.getRefreshSettingsBtn());
	}
};
SearchResultsView.prototype.onGridReOrder = function(from, to) {
	if (from == to) {
		return;
	}
	var dt = $(("#" + this.getIdStr())).DataTable();
	if (from < to) {
		for (var i = from + 1; i <= to; i++) {
			this.columnConfig[i].dispOrder = i - 1;
		}
	} else {
		for (var i = to; i < from; i++) {
			this.columnConfig[i].dispOrder = i + 1;
		}
	}

	this.columnConfig[from].dispOrder = to;
	this.columnConfig = cvSearchUtil.sortArrayByKey(this.columnConfig, "dispOrder");
};
SearchResultsView.prototype.getConfigToSave = function() {
	var config = {};
	config.tableConfig = this.getCurrentDTConfig();
	config.columnConfig = $.extend(true, [], this.columnConfig);
	$.each(config.columnConfig, function(i, obj) {
		delete obj.schema;
	})
	return config;
};
SearchResultsView.prototype.getCurrentDTConfig = function() {
	var tableConfig = {};
	if ($.fn.DataTable.isDataTable("#" + this.getIdStr())) {
		var dt = $(("#" + this.getIdStr())).DataTable();
		tableConfig.order = dt.order();
		tableConfig.pageLength = dt.page.len();
	}
	return tableConfig;
};
SearchResultsView.prototype.reloadGridView = function() {
	var self = this;
	var gridElm = $(("#" + this.getIdStr()));
	if (this._config.viewType === SearchResultsView.prototype.Constants.ViewTypes.GRID) {
		if (!$.fn.DataTable.isDataTable("#" + this.getIdStr())) {
			gridElm.dataTable(this.getConfig());
			gridElm.on("column-sizing.dt", uiControls.util.getDTResizeHandler(this.getIdStr()));
		} else {
			gridElm.DataTable().ajax.reload();
		}
	} else {
		var gridObj = gridElm.data(self.Constants.cvDataGrid_Name);
		if (gridObj) {
			gridObj.reloadGridView(true);
		} else {
			gridElm.cvDataGrid(this.getConfig());
		}
	}
};
SearchResultsView.prototype.getCellDisplayValue = function(data, config) {
	if (typeof data === "undefined" || data === null || data === "") {
		return cvSearchMessages.NotAvailable;
	}

	if ($.isArray(data)) {
		return data.join("<br>");
	}

	var node = $("<span/>").attr("title", data);
	if (config && config.renderer && config.renderer.dispType == "html") {
		node.html(data);
	} else {
		node.text(data);
	}
	return node[0].outerHTML;
};

SearchResultsView.prototype.getColumnConfig = function() {
	if (this._config.columnConfig && this._config.columnConfig.length > 0 &&
			this._config.columnConfig[0].hasOwnProperty("dispOrder")) {
		return cvSearchUtil.sortArrayByKey(this._config.columnConfig, "dispOrder");
	}
	//do not sort by field name. fix for MR
	var colConfig = $.extend(true, [], this._config.columnConfig);
	$.each(colConfig, function(i, eachConfig) {
		eachConfig.dispOrder = i;
	});
	return colConfig;
};

SearchResultsView.prototype.getColumnConfigInDTFormat = function(colConfig) {
	var configArray = new Array();
	var noOfCols = colConfig.length;
	$.each(colConfig, function(index, eachConfig) {
		var obj = {};
		if (!(eachConfig.schema.stored || eachConfig.schema.docValues)) {
			return;
		}
		if (eachConfig.fieldName) {
			obj.data = eachConfig.fieldName;
		}
		if (eachConfig.visible !== undefined) {
			obj.visible = eachConfig.visible;
		}
		obj.orderable = eachConfig.isSortable;

		var renderer = eachConfig.renderer;
		if (renderer) {
			obj.render = function(data, type, row, meta) {
				if ($.isArray(data) && renderer.type != 'unc') {
					var returnVal = "";
					for (var i = 0; i < data.length; i++) {
						returnVal += cvFormatters.getDisplayValue(data[i], renderer, meta, row) + "<br>";
					}
					return returnVal;
				} else {
					return cvFormatters.getDisplayValue(data, renderer, meta, row);
				}
			};
		} else {
			obj.render = function(data, type, row, meta) {
				return SearchResultsView.prototype.getCellDisplayValue(data, eachConfig);
			};
		}
		configArray.push(obj);
	});
	return configArray;
};
SearchResultsView.prototype.fillVisibilityInfo = function(columns) {
	var self = this;
	$.each(columns, function(i, eachCol) {
		eachCol.visible = $.grep(self.columnConfig, function(o) {
			return o.fieldName === eachCol.data;
		})[0].visible;
	});
};
SearchResultsView.prototype.getEditSettingsBtn = function() {
	var self = this;
	var btn = $("<button class='btn btn-default'></button>");
	btn.text(cvSearchMessages.ColumnSettings);
	btn.on("click", function(event, eventData) {
		self.onEditSettingsBtnClick();
	});
	return btn;
};

SearchResultsView.prototype.getRefreshSettingsBtn = function() {
	var self = this;
	var btn = $("<span class='glyphicon glyphicon-repeat'></span>");
	btn.on("click", function(event, eventData) {
		var gridElm = $(("#" + self.getIdStr()));
		gridElm.DataTable().ajax.reload();
	});
	return btn;
};

SearchResultsView.prototype.onEditSettingsBtnClick = function() {
	var self = this;
	var dlgId = this.Constants.ID_PREFIX + "modal";
	var dlg = $("#" + dlgId);
	var settGridId = "cvGridSettingsTable";
	if (dlg.length == 0) {
		dlg = $("<div id='" + dlgId + "'/>");
		dlg.appendTo("body").cvModal();
		$(".modal-body", dlg)
				.html(uiControls.util.getDataTableHtml(settGridId, this.getGridSettingsDTConfig().columns));

		var extraSettings = $("<div id='" + this.Constants.RENDERER_SETTINGS_ID + "'/>");
		extraSettings.appendTo(".modal-body", dlg);
	}

	var settGridElm = $("table#" + settGridId, dlg);
	$(".modal-title", dlg).text(cvSearchMessages.ColumnSettings);
	$(".modal-footer .okBtn", dlg).text(cvSearchMessages.ApplyBtnText).off("click").on("click", function(e) {

		//Pressing apply automatically saves changes
		$("#" + self.Constants.SETTINGS_SAVE_BTN).trigger("click");

		self.tmpColumnConfig = $.extend(true, [], self.savedColumnConfig);

		self._config.tableConfig = self.getCurrentDTConfig();
		self.setColConfigFromGridSettingsDT(settGridId, settGridElm);
		self.clear();
		self.render();
		self.reloadGridView();
	});

	$(".modal", dlg).modal('show').off('shown.bs.modal').on('shown.bs.modal', function(e) {
		self.initGridSettingsTable(settGridId, settGridElm);
	});

	$(".modal", dlg).off("hide.bs.modal").on("hide.bs.modal",
			function(e) {

				//removing the 'save' and 'back' buttons.
				//If we don't do it here, then these buttons will stay there when the user press 'cancel'
				$("#" + self.Constants.ID_PREFIX + "modal").find("." + self.Constants.SETTINGS_BOTTOM_BUTTONS_PANEL)
						.children("#" + self.Constants.SETTINGS_BACK_BTN).remove();
				$("#" + self.Constants.ID_PREFIX + "modal").find("." + self.Constants.SETTINGS_BOTTOM_BUTTONS_PANEL)
						.children("#" + self.Constants.SETTINGS_SAVE_BTN).remove();

			});
};
SearchResultsView.prototype.getGridSettingsDTConfig = function() {
	var self = this;
	var settDtConfig = {
		dom : '<"pull-left"f><"pull-right"l><"clearfix"><"row"<"col-md-12"t>><"pull-left"i><"pull-right"p><"clearfix">',
		pageLength : 10,
		lengthMenu : [ [ 10, 20, 50, -1 ], [ 10, 20, 50, "All" ] ],
		language : {
			search : "_INPUT_",
			searchPlaceholder : "Find..."
		},
		order : []
	};
	settDtConfig.columns = [
			{
				data : "visible",
				dispName : "<div align='center'>Show</div><div align='center'><input type='checkbox' style='text-align: center;' id='allVisCheckbox' checked='checked'></div>",
				orderable : true,
				width : "15%",
				searchable : false,
				className : 'text-center',
				render : function(data, type, row, meta) {
					var isVisible = (typeof data === "undefined" || data) ? true : false;
					var htm = "<input data-colIndex='" + meta.row + "' class='showHideCheck' type='checkbox' ";
					if (isVisible) {
						htm += "checked='checked'";
					}
					htm += ">";
					return htm;
				}
			},
			{
				data : "fieldName",
				dispName : "Field Name",
				orderable : true,
				width : "35%",
				className : "fieldNameTd",
				render : function(data, type, row) {
					return "<div>" + data + "</div>"
				}
			},
			{
				data : "dispName",
				dispName : "Display Name",
				orderable : true,
				width : "30%",
				render : function(data, type, row) {
					if (typeof data === "undefined") {
						return "<div>" + row.fieldName + "</div>";
					} else {
						return "<div>" + data + "</div>";
					}
				}
			},
			{
				data : "renderer.type",
				dispName : "Formatter",
				width : "20%",
				className : 'format-rule',
				render : function(data, type, row, meta) {
					return self.getRendererString(data, meta.row);
				},
			},
			{
				data : "visible",
				dispName : "visibilitySorter",
				visible : false,
				render : function(data, type, row, meta) {
					var isVisible = (typeof data === "undefined" || data) ? true : false;
					if (isVisible) {
						return 1;
					} else {
						return 0;
					}
				}
			} ];

	settDtConfig.columnDefs = [ {
		targets : [ 0 ],
		iDataSort : 4
	} ];

	return settDtConfig;
};

SearchResultsView.prototype.getFormatOptionsTemplate = function(elementId) {
	return $(this.Constants.formatOptionsTemplates).filter("#" + elementId).html();
};

SearchResultsView.prototype.onRendererBtn = function(targetDOM, tableElm, rowIndex) {
	var $dialog = $('#' + this.Constants.ID_PREFIX + "modal");
	$(".modal-title", $dialog).append("<span id='colname'> - " + this.tmpColumnConfig[rowIndex].fieldName + "</span>");

	//so that we can slide it in
	targetDOM.hide();

	if (!$("#" + this.Constants.SETTINGS_LEFT_PANE).length) {
		$("<div id='" + this.Constants.SETTINGS_LEFT_PANE + "'' class='col-sm-4'></div>").appendTo(targetDOM);
	}

	if (!$("#" + this.Constants.SETTINGS_RIGHT_PANE).length) {
		$("<div id='" + this.Constants.SETTINGS_RIGHT_PANE + "'' class='col-sm-8'></div>").appendTo(targetDOM);
	}

	var leftPane = targetDOM.children("#" + this.Constants.SETTINGS_LEFT_PANE);
	var rightPane = targetDOM.children("#" + this.Constants.SETTINGS_RIGHT_PANE);
	var height = targetDOM.parent().css("height");

	height = parseInt(height);
	leftPane.css("height", height.toString());

	this.addDisplayNameInput(leftPane);
	this.addRendererOptions(leftPane);
	this.addVisibilityOptions(leftPane, rowIndex);

	this.attachListenersForFormatOptionsCombo(tableElm, targetDOM, rowIndex);

	targetDOM.show("slide", {
		direction : "right"
	}, this.Constants.animationDuration);

};

SearchResultsView.prototype.addRendererOptions = function(targetDOM) {

	var formatId = "#" + this.Constants.FORMAT_OPTIONS_ID;
	var formatHTML = this.getFormatOptionsTemplate(this.Constants.formatOptionsIds.formatTypeCombo);

	$(formatHTML).appendTo(targetDOM);
};

SearchResultsView.prototype.addDisplayNameInput = function(targetDOM) {

	var formatHTML = this.getFormatOptionsTemplate(this.Constants.formatOptionsIds.displayNameOptions);
	$(formatHTML).appendTo(targetDOM);

};

SearchResultsView.prototype.addVisibilityOptions = function(targetDOM, rowIndex) {

	var formatHTML = this.getFormatOptionsTemplate(this.Constants.formatOptionsIds.visibilityOptions);
	$(formatHTML).appendTo(targetDOM);

	var vis = this.tmpColumnConfig[rowIndex].visible;
	$("#" + this.Constants.VISIBILITY_BTN_ID).attr("checked", vis);
};

SearchResultsView.prototype.getHelpText = function(option) {
	var returnHtml = null;

	switch (option) {

	case this.Constants.supportedRenderers.none.value: {
		returnHtml = $(this.Constants.formatHelpTemplates).filter("#rendererHelp").html();
		break;
	}
	case this.Constants.supportedRenderers.date.value: {
		returnHtml = $(this.Constants.formatHelpTemplates).filter("#dateHelp").html();
		break;
	}
	case this.Constants.supportedRenderers.size.value: {

		returnHtml = $(this.Constants.formatHelpTemplates).filter("#sizeHelp").html();
		break;
	}
	case this.Constants.supportedRenderers.link.value: {
		returnHtml = $(this.Constants.formatHelpTemplates).filter("#linkHelp").html();
		break;
	}
	case this.Constants.supportedRenderers.unc.value: {
		returnHtml = $(this.Constants.formatHelpTemplates).filter("#uncHelp").html();
		break;
	}
	case this.Constants.supportedRenderers.number.value: {
		returnHtml = $(this.Constants.formatHelpTemplates).filter("#numberHelp").html();
		break;
	}
	case this.Constants.supportedRenderers.highlighter.value: {
		returnHtml = $(this.Constants.formatHelpTemplates).filter("#rowHighlighterHelp").html();
		break;
	}
	case this.Constants.supportedRenderers.cellHighlighter.value: {
		returnHtml = $(this.Constants.formatHelpTemplates).filter("#cellHighlighterHelp").html();
		break;
	}
	case this.Constants.supportedRenderers.bool.value: {
		returnHtml = $(this.Constants.formatHelpTemplates).filter("#booleanHelp").html();
		break;
	}
	}

	return returnHtml;
};

SearchResultsView.prototype.addHelpText = function(targetDOM, option) {

	var self = this;

	if (!this.Constants.formatHelpTemplates) {
		$.when($.get(this.contextPath + this.Constants.HELP_TEXT_TMPL_PATH)).done(function(html) {
			self.Constants.formatHelpTemplates = html;
			self.addHelpText(targetDOM, option);
		});

		return;
	}

	var html = this.getHelpText(option);

	targetDOM.html(html);
};

SearchResultsView.prototype.initGridSettingsTable = function(tableId, tableElm) {
	var self = this;
	this.tmpColumnConfig = $.extend(true, [], this.columnConfig);

	//Used to save config after user presses 'save' button. Discarded if cancel is pressed
	this.savedColumnConfig = $.extend(true, [], this.columnConfig);
	//resetting this stack so that back button behaves as expected
	this.settingsBackBtnHiddenStack.length = 0;

	if (!$.fn.DataTable.isDataTable("#" + tableId)) {
		// one time init
		tableElm.dataTable(this.getGridSettingsDTConfig());
		tableElm.on("draw.dt", function() {
			$("#" + tableId + "_wrapper div.dataTables_filter input").focus();
		});

		this.attachListenersForProperties(tableElm);
	} else if ($("#" + tableId + "_wrapper").is(":hidden")) {

		$(".modal-body").find("#" + this.Constants.RENDERER_SETTINGS_ID).html("");
		$("#" + tableId + "_wrapper").show();
	}

	if (!this.Constants.formatOptionsTemplates) {
		//when loading the first time
		$.when($.get(this.contextPath + this.Constants.SETTINGS_FORMAT_TMPL_PATH)).done(function(html) {
			self.Constants.formatOptionsTemplates = html;
		});
	}

	tableElm.DataTable().search("").clear().rows.add(this.tmpColumnConfig).draw();
};

SearchResultsView.prototype.initFormatOptions = function(option, renderer, targetDOM, tableElm, rowIndex) {

	var self = this;

	targetDOM.show();

	if (!targetDOM.children('#' + this.Constants.FORMAT_OPTIONS_CONTAINER_ID).length) {
		targetDOM.append("<div id='" + this.Constants.FORMAT_OPTIONS_CONTAINER_ID + "' class=''></div");
	}

	var parentDOM = $("#" + self.Constants.FORMAT_OPTIONS_CONTAINER_ID).parent();
	if (!parentDOM.children('#' + self.Constants.SETTINGS_RIGHT_PANE_HEADER).length) {
		parentDOM.prepend("<div id='" + self.Constants.SETTINGS_RIGHT_PANE_HEADER + "' class='col-sm-12'></div>");
	}
	var headerDOM = $("#" + self.Constants.SETTINGS_RIGHT_PANE_HEADER);

	var optionsTargetDOM = $("#" + this.Constants.FORMAT_OPTIONS_CONTAINER_ID).html("");

	var title = "None";

	if (option == this.Constants.supportedRenderers.none.value) {

		//we don't want to add the 'help' button nor the attach listeners
		//if renderer is none. So its safe to return from here
		this.addHelpText(optionsTargetDOM, option);
		var titleElement = $("<div><span style='font-size: 20px;'>No renderers selected</span></div>");
		headerDOM.prepend(titleElement);

		this.attachListenersForFormatOptions(tableElm, targetDOM, rowIndex);
		return;
	} else if (option == this.Constants.supportedRenderers.date.value) {

		var html = this.getFormatOptionsTemplate(self.Constants.formatOptionsIds.dateFormatOptions);
		title = this.Constants.supportedRenderers.date.dispName;
		optionsTargetDOM.append(html);
		if (renderer && renderer.type == option) {
			$("#" + this.Constants.FORMAT_OPTIONS_CONTAINER_ID).find("select.date-format").val(renderer.fmt);
		}
	} else if (option == this.Constants.supportedRenderers.size.value) {
		var html = self.getFormatOptionsTemplate(self.Constants.formatOptionsIds.sizeFormatOptions);
		title = this.Constants.supportedRenderers.size.dispName;
		optionsTargetDOM.append(html);

		if (renderer && renderer.type == option) {
			$("#" + this.Constants.FORMAT_OPTIONS_CONTAINER_ID).find("select#sizeSource").val(renderer.source);
			$("#" + this.Constants.FORMAT_OPTIONS_CONTAINER_ID).find("select#sizeTarget").val(renderer.target);
		}
	}

	else if (option == this.Constants.supportedRenderers.link.value) {

		var html = self.getFormatOptionsTemplate(self.Constants.formatOptionsIds.linkFormatOptions);
		title = this.Constants.supportedRenderers.link.dispName;
		optionsTargetDOM.append(html);

		if (renderer && renderer.type == option) {
			$("#" + this.Constants.FORMAT_OPTIONS_CONTAINER_ID).find(".link-string textarea").text(renderer.linkString);
		}

		this.attachListenersLinkFormat();
	} else if (option == this.Constants.supportedRenderers.unc.value) {

		var html = self.getFormatOptionsTemplate(self.Constants.formatOptionsIds.uncFormatOptions);
		title = this.Constants.supportedRenderers.unc.dispName;

		optionsTargetDOM.append(html);

		if (renderer && renderer.type == option) {
			$("#" + this.Constants.FORMAT_OPTIONS_CONTAINER_ID).find("#uncSource").val(renderer.uncString);
		}

		this.attachListenersUNCFormat();
	} else if (option == this.Constants.supportedRenderers.number.value) {
		title = this.Constants.supportedRenderers.number.dispName;

	} else if (option == this.Constants.supportedRenderers.highlighter.value ||
			option == this.Constants.supportedRenderers.cellHighlighter.value) {

		var html = self.getFormatOptionsTemplate(self.Constants.formatOptionsIds.highlightFormatOptions);
		if (option == this.Constants.supportedRenderers.highlighter.value) {
			title = this.Constants.supportedRenderers.highlighter.dispName;
		} else {
			title = this.Constants.supportedRenderers.cellHighlighter.dispName;
		}

		optionsTargetDOM.append(html);

		if (renderer && renderer.type == option) {
			$("#highlightDataType").val(renderer.dataType);
			for (var i = 0; i < renderer.highlightRuleList.length; i++) {

				var currentRule = renderer.highlightRuleList[i];
				var newRowHtml = self.getFormatOptionsTemplate(self.Constants.formatOptionsIds.highlightRuleRow);
				$("#highlightRuleContainer").append(newRowHtml);

				var $newRow = $("#highlightRuleContainer .highlightRuleRow").last();
				self.addHighlightOperatorsToRow($newRow, renderer.dataType);

				$newRow.find(".oper-button").attr("value", currentRule.operator);
				$newRow.find("input.thresholdValue").val(currentRule.threshold);
				$newRow.find("input.highlightColor-back").val(currentRule.highlightColorBack);
				$newRow.find("input.highlightColor-fore").val(currentRule.highlightColorFore);
			}
		}

		this.attachListenersHighlighter();
	} else if (option == this.Constants.supportedRenderers.bool.value) {

		var html = this.getFormatOptionsTemplate(self.Constants.formatOptionsIds.booleanOptions);
		title = this.Constants.supportedRenderers.bool.dispName;

		optionsTargetDOM.append(html);

		if (renderer && renderer.type == option) {
			$("#booleanTypeSelector").val(renderer.booleanType);
		}
	}

	var titleElement = $("<div><span style='font-size: 17px;'>" + title + this.templates.helpButton + "</span></div>");
	headerDOM.prepend(titleElement);

	this.attachListenersForFormatOptions(tableElm, targetDOM, rowIndex);

};

SearchResultsView.prototype.getColList = function() {

	//code for autocomplete in link formatter goes here

	var settGridId = "cvGridSettingsTable";
	var table = $("#" + settGridId).DataTable();

	//getting contents of the 'field Name' column
	var colList = table.column(1).data();

	return colList;
};

SearchResultsView.prototype.attachListenersLinkFormat = function() {

	var colList = this.getColList();

	//words in curly braces would be highlighted.
	$(".link-string textarea").highlightTextarea({
		words : [ {
			color : '#B8DFB2',
			words : '{(.+?)}'
		} ]
	});

	$(".link-string textarea").textcomplete([ {
		match : /{(\w{2,})$/,
		search : function(term, callback) {
			callback($.map(colList, function(name) {
				return name.toLowerCase().indexOf(term.toLowerCase()) == 0 ? name : null;
			}));
		},
		index : 1,
		replace : function(name) {
			return '{' + name + '}';
		}
	} ], {
		maxCount : 20,
		debounce : 100
	});
};

SearchResultsView.prototype.attachListenersUNCFormat = function() {

	var colList = this.getColList();
	$("#" + this.Constants.FORMAT_OPTIONS_CONTAINER_ID).find("#uncSource").highlightTextarea({
		words : [ {
			color : '#B8DFB2',
			words : '{(.+?)}'
		} ]
	});

	$("#" + this.Constants.FORMAT_OPTIONS_CONTAINER_ID).find("#uncSource").textcomplete([ {
		match : /{(\w{2,})$/,
		search : function(term, callback) {
			callback($.map(colList, function(name) {
				return name.toLowerCase().indexOf(term.toLowerCase()) == 0 ? name : null;
			}));
		},
		index : 1,
		replace : function(name) {
			return '{' + name + '}';
		}
	} ]);
};

SearchResultsView.prototype.addHighlightOperatorsToRow = function(newRow, dataType) {

	var entries = null;
	var menu = newRow.find(".oper-button");

	if (dataType == "string") {
		entries = "<option value='&#61;' selected='selected'>Equals</option>"
				+ "<option value='!='>Not equals</option>" + "<option value='contains'>Contains</option>"
				+ "<option value='notcontains'>Not contains</option>" + "<option value='wildcard'>Wildcard</option>"
				+ "<option value='regex'>Regex</option>";
		menu.append(entries);
	} else if (dataType == "number") {
		entries = "<option value='&#61;' selected='selected'>Equals</option>"
				+ "<option value='!='>Not equals</option>" + "<option value='&lt;'>Less than</option>"
				+ "<option value='&gt;'>Greater than</option>";
		menu.append(entries);
	}

};

SearchResultsView.prototype.attachListenersHighlighter = function() {

	var self = this;

	$("#btnNewHighlightRule").off("click").on("click", function() {
		var newRow = $(self.getFormatOptionsTemplate(self.Constants.formatOptionsIds.highlightRuleRow));
		newRow.appendTo($("#highlightRuleContainer"));
		newRow.find(".highlightColor-back").val("#ffff00");
		self.addHighlightOperatorsToRow(newRow, $("#highlightDataType").val());
	});

	$("#highlightDataType").off("change").on("change", function() {
		$("#highlightRuleContainer").empty();
	});

	$("#highlightRuleContainer").on("click",
			".dropdown-menu li",
			function() {
				$(this).parent().parent().children(".oper-button-text").text($(this).text()).attr("value",
						$(this).data('value'));
			});

	$("#highlightRuleContainer").on("click", ".highlightRuleRow .btn-close", function() {
		$(this).parents(".highlightRuleRow").remove();
	});

	$("#highlightRuleContainer").on("keypress", "input", function(e) {
		if (e.keyCode == 13) {
			event.preventDefault();
		}
	});
};

SearchResultsView.prototype.backButtonAction = function(domList, action, sliding) {

	if (!$.isArray(domList)) {

		if (action == 'show') {
			if (sliding) {
				domList.show("slide", {
					direction : "left"
				}, this.Constants.animationDuration);
			} else {
				domList.show();
			}
		} else if (action == 'hide') {
			if (sliding) {
				domList.hide("slide", {
					direction : "right"
				}, this.Constants.animationDuration);
			} else {
				domList.hide();
			}
		}
		return;
	} else {
		if (action == 'show') {
			for (var i = 0; i < domList.length; i++) {
				if (sliding) {
					domList[i].show("slide", {
						direction : "left"
					}, this.Constants.animationDuration);
				} else {
					domList[i].show();
				}
			}
		} else if (action == 'hide') {
			for (var i = 0; i < domList.length; i++) {
				if (sliding) {
					domList[i].slide("slide", {
						direction : "right"
					}, this.Constants.animationDuration);
				} else {
					domList[i].hide();
				}
			}
		}
	}
};

SearchResultsView.prototype.attachBottomButtonListeners = function() {

	var self = this;

	/*
	 * The logic behind the back button.
	 * 
	 * We have two stacks - hidden stack and shown stack. When we hide some DOM objects inorder to show new
	 * ones, we put the just hidden elements to the 'hidden' stack. Later on, when we press the 'back' button,
	 * we pop the 'hidden' stack and call .show() on the popped object.
	 * 
	 * The 'shown' stack is needed because a pop() on the 'shown' stack will give us the elements that should
	 * be HIDDEN when we press back button.
	 */
	$("." + self.Constants.SETTINGS_BOTTOM_BUTTONS_PANEL).find("#" + this.Constants.SETTINGS_BACK_BTN).off("click")
			.on("click", function() {

				var toShow = self.settingsBackBtnHiddenStack.pop();
				var toHide = self.settingsBackBtnShownStack.pop();

				if ($.isArray(toHide)) {
					for (var i = 0; i < toHide.length; i++) {
						toHide[i].html("");
					}
				} else {
					toHide.html("");
				}

				self.backButtonAction(toHide, 'hide');

				//back button clears the html content of the settings div
				//That's ok because we are appending the html again, not just calling "show" on hidden divs

				self.backButtonAction(toShow, 'show', true);

				self.handleBottomButtonPanel();
			});

};

SearchResultsView.prototype.attachListenersForFormatOptionsCombo = function(tableElm, targetDOM, rowIndex) {

	var self = this;
	var table = tableElm.DataTable();

	$("#" + this.Constants.FORMAT_COMBO).off("change").on("change", function() {

		var renderer = null;
		if ((data = table.row(rowIndex).data())) {
			renderer = data.renderer;
		}

		var selectedFormatter = $("#" + self.Constants.FORMAT_COMBO).val();

		var rightPane = targetDOM.find("#" + self.Constants.SETTINGS_RIGHT_PANE);

		$("#" + self.Constants.SETTINGS_RIGHT_PANE).html("");

		self.initFormatOptions(selectedFormatter, renderer, rightPane, tableElm, rowIndex);

	});
};

SearchResultsView.prototype.attachListenersForFormatOptions = function(tableElm, targetDOM, rowIndex) {

	var self = this;
	var table = tableElm.DataTable();

	$("#" + this.Constants.HELP_BUTTON).off("click").on("click", function() {

		$(this).toggleClass("selected");

		if ($(this).hasClass("selected")) {
			var parentDOM = $("#" + self.Constants.FORMAT_OPTIONS_CONTAINER_ID).parent();
			var toHide = $("#" + self.Constants.FORMAT_OPTIONS_CONTAINER_ID);

			if (!parentDOM.children('#' + self.Constants.SETTINGS_HELP_TEXT).length) {
				parentDOM.append("<div id='" + self.Constants.SETTINGS_HELP_TEXT + "' class='col-sm-12'></div>");
			}

			var toShow = $("#" + self.Constants.SETTINGS_HELP_TEXT);

			toHide.hide();

			var currentOption = $("#" + self.Constants.FORMAT_COMBO).val();
			self.addHelpText(toShow, currentOption);

			toShow.show();

			//disabling the save button.
			//We will never have to enable this manually because all buttons in the footer are destroyed
			//on pressing 'Back' button and created again.
			$("#" + self.Constants.SETTINGS_SAVE_BTN).prop("disabled", true);
		} else {

			var toShow = $("#" + self.Constants.FORMAT_OPTIONS_CONTAINER_ID);
			var toHide = $("#" + self.Constants.SETTINGS_HELP_TEXT);

			toHide.hide();
			toShow.show();
		}

	});

	$("." + this.Constants.SETTINGS_BOTTOM_BUTTONS_PANEL).find("#" + this.Constants.SETTINGS_SAVE_BTN).off("click")
			.on("click",
					function() {

						//var colConfigObj = self.tmpColumnConfig[rowIndex];
						var tmpConfig = self.savedColumnConfig[rowIndex];
						var colConfigObj = $.extend(true, {}, tmpConfig);

						colConfigObj.renderer = {
							type : $("#" + self.Constants.FORMAT_COMBO).val()
						};

						if (colConfigObj.renderer.type == self.Constants.supportedRenderers.date.value) {
							colConfigObj.renderer.fmt = $("#" + self.Constants.FORMAT_OPTIONS_CONTAINER_ID)
									.find("select.date-format").val();
						} else if (colConfigObj.renderer.type == self.Constants.supportedRenderers.link.value) {
							colConfigObj.renderer.linkString = $("#" + self.Constants.FORMAT_OPTIONS_CONTAINER_ID)
									.find(".link-string textarea").val();
						} else if (colConfigObj.renderer.type == self.Constants.supportedRenderers.size.value) {
							colConfigObj.renderer.source = colConfigObj.renderer.fmt = $("#" +
									self.Constants.FORMAT_OPTIONS_CONTAINER_ID).find("select#sizeSource").val();
							colConfigObj.renderer.target = colConfigObj.renderer.fmt = $("#" +
									self.Constants.FORMAT_OPTIONS_CONTAINER_ID).find("select#sizeTarget").val();
						} else if (colConfigObj.renderer.type == self.Constants.supportedRenderers.unc.value) {
							colConfigObj.renderer.uncString = colConfigObj.renderer.fmt = $("#" +
									self.Constants.FORMAT_OPTIONS_CONTAINER_ID).find("#uncSource").val();
						} else if (colConfigObj.renderer.type == self.Constants.supportedRenderers.number.value) {
							colConfigObj.renderer.numberUnit = colConfigObj.renderer.fmt = $("#" +
									self.Constants.FORMAT_OPTIONS_CONTAINER_ID).find("#numberUnit").val();
						} else if (colConfigObj.renderer.type == self.Constants.supportedRenderers.highlighter.value ||
								colConfigObj.renderer.type == self.Constants.supportedRenderers.cellHighlighter.value) {

							colConfigObj.renderer.highlightDataType = $("#highlightDataType").val();
							colConfigObj.renderer.highlightRuleList = [];
							colConfigObj.renderer.dataType = $("#highlightDataType").val();

							$("#highlightRuleContainer .highlightRuleRow").each(function(index, row) {
								var rule = {};

								rule.operator = $(this).find(".oper-button").attr("value");
								rule.threshold = $(this).find("input.thresholdValue").val();
								rule.highlightColorBack = $(this).find("input.highlightColor-back").val();
								rule.highlightColorFore = $(this).find("input.highlightColor-fore").val();
								if (rule.operator == 'regex') {

									var isValid = true;
									try {
										if (rule.threshold[0] == '/') {
											var re = cvFormatters.parseRegExpInput(rule.threshold);
										} else {
											var re = cvFormatters.parseRegExpInput("/" + rule.threshold + "/i");
										}
									} catch (e) {
										isValid = false;
									}

									if (!isValid) {
										alert("Invalid Regular Expression");
										return;
									}
								}

								colConfigObj.renderer.highlightRuleList.push(rule);
							});
						} else if (colConfigObj.renderer.type == self.Constants.supportedRenderers.bool.value) {

							colConfigObj.renderer.booleanType = $("#booleanTypeSelector").val();
						}

						var displayName = $("#" + self.Constants.DISPLAY_INPUT_ID).val();
						colConfigObj.dispName = displayName;
						colConfigObj.visible = $("#" + self.Constants.VISIBILITY_BTN_ID).is(":checked");

						var rowData = table.rows().data();
						rowData[rowIndex] = colConfigObj;
						table.rows().clear();
						table.rows.add(rowData).draw();
						self.savedColumnConfig[rowIndex] = colConfigObj;

						$("#" + self.Constants.SETTINGS_BACK_BTN).trigger("click");
					});
};

SearchResultsView.prototype.attachListenersForProperties = function(tableElm) {
	var self = this;

	tableElm.on("blur", "input.dispNameInput", function() {
		self.tmpColumnConfig[$(this).data("colindex")].dispName = $(this).val();
	});

	tableElm.on("change", "select.rendererType", function() {
		var colConfigObj = self.tmpColumnConfig[$(this).data("colindex")];
		var v = $(this).val();
		if (v) {
			colConfigObj.renderer = {
				type : v
			};
		} else {
			delete colConfigObj.renderer;
		}
	});
	tableElm.on("change", "input.showHideCheck", function() {
		self.savedColumnConfig[$(this).data("colindex")].visible = $(this).is(":checked");
	});

	tableElm.find("tbody").off("click", "td")
			.on("click",
					"td",
					function() {

						if ($(this).children('.showHideCheck').length) {
							return;
						}
						var $dialog = $('#' + self.Constants.ID_PREFIX + "modal");
						var parentDOM = $("#cvGridSettingsTable_wrapper").parent();
						var currentHeight = $("#cvGridSettingsTable_wrapper").css("height");
						var toHide = $("#cvGridSettingsTable_wrapper");
						var rowIndex = $(this).parent().find(".btn-format-renderer").data('colindex');
						var currentFormatRule = $(this).parents('tr').find('.btn-format-renderer').text();

						//or else the model window shrinks when we hide the table
						parentDOM.css("min-height", currentHeight);

						self.settingsBackBtnHiddenStack.push(toHide);
						toHide.hide();

						var targetDOM = parentDOM.find("#" + self.Constants.RENDERER_SETTINGS_ID);

						self.onRendererBtn(targetDOM, tableElm, rowIndex);

						//we will be showing targetDOM next
						//So next time we press back, this div should hide
						//see the back button event handler for more
						self.settingsBackBtnShownStack.push([
								targetDOM,
								$(".modal-title", $dialog).find("#colname:visible") ]);

						self.handleBottomButtonPanel();

						var dispName = self.tmpColumnConfig[rowIndex].dispName;
						if (dispName == undefined) {
							dispName = self.tmpColumnConfig[rowIndex].fieldName;
						}

						$("#" + self.Constants.DISPLAY_INPUT_ID).val(dispName);
						$("#" + self.Constants.FORMAT_COMBO).val(self.rendererNameToVal(currentFormatRule))
								.attr('selected', 'selected');
						$("#" + self.Constants.FORMAT_COMBO).trigger("change");

					});

	tableElm.find("#allVisCheckbox").off("click").on("click", function(e) {

		var table = tableElm.dataTable();

		//right now, our visibility check boxes occuppy the first column
		//change visColNum if we decide to move the vis checkbox col
		var visColNum = 0;
		var checked = $(this).is(":checked");

		var nodes = $(".showHideCheck", tableElm);

		$.each(nodes, function(index, checkbox) {
			var $checkbox = $(checkbox);
			$checkbox.attr("checked", checked);
			self.savedColumnConfig[$checkbox.data("colindex")].visible = checked;
		});

		e.stopPropagation();
	});
};

SearchResultsView.prototype.rendererNameToVal = function(name) {
	for ( var key in this.Constants.supportedRenderers) {
		if (this.Constants.supportedRenderers.hasOwnProperty(key)) {
			if (name == this.Constants.supportedRenderers[key].dispName) {
				return this.Constants.supportedRenderers[key].value;
			}
		}
	}
};

SearchResultsView.prototype.setColConfigFromGridSettingsDT = function(tableId, tableElm) {
	this.columnConfig = $.extend(true, [], this.tmpColumnConfig);
};
SearchResultsView.prototype.getRendererTypeCombo = function(type, rowIndex) {
	var htm = "<select data-colIndex='" + rowIndex + "' class='rendererType form-control input-sm'>";
	$.each(SearchResultsView.prototype.Constants.supportedRenderers, function(i, obj) {
		htm += "<option value='" + obj.value + "'";
		if (obj.value === type) {
			htm += " selected";
		}
		htm += ">" + obj.dispName + "</option>";
	});
	htm += "</select>";
	return htm;
};
SearchResultsView.prototype.getRendererString = function(type, rowIndex) {

	var htm = "<span class='btn-format-renderer' data-colIndex='" + rowIndex + "'>";
	if (!type) {
		htm += "None";
	} else {
		for ( var key in this.Constants.supportedRenderers) {
			if (this.Constants.supportedRenderers.hasOwnProperty(key)) {
				if (type == this.Constants.supportedRenderers[key].value) {
					htm += this.Constants.supportedRenderers[key].dispName;
				}
			}
		}
	}

	htm += "</span>";

	return htm;
};

SearchResultsView.prototype.handleBottomButtonPanel = function() {

	var backBtn = "<button type='button' class='btn btn-default backBtn'>Back</button>";

	if (this.settingsBackBtnHiddenStack.length == 0) {
		$("#" + this.Constants.ID_PREFIX + "modal").find("." + this.Constants.SETTINGS_BOTTOM_BUTTONS_PANEL)
				.children("#" + this.Constants.SETTINGS_BACK_BTN).remove();
		$("#" + this.Constants.ID_PREFIX + "modal").find("." + this.Constants.SETTINGS_BOTTOM_BUTTONS_PANEL)
				.children("#" + this.Constants.SETTINGS_SAVE_BTN).remove();
	}

	else if (this.settingsBackBtnHiddenStack.length > 0) {
		$("#" + this.Constants.ID_PREFIX + "modal").find("." + this.Constants.SETTINGS_BOTTOM_BUTTONS_PANEL)
				.children("#" + this.Constants.SETTINGS_BACK_BTN).remove();
		$("#" + this.Constants.ID_PREFIX + "modal").find("." + this.Constants.SETTINGS_BOTTOM_BUTTONS_PANEL)
				.children("#" + this.Constants.SETTINGS_SAVE_BTN).remove();
		$("#" + this.Constants.ID_PREFIX + "modal")
				.find("." + this.Constants.SETTINGS_BOTTOM_BUTTONS_PANEL + " .okBtn")
				.before(this.templates.settingsSaveBtnTmpl);
		$("#" + this.Constants.ID_PREFIX + "modal")
				.find("." + this.Constants.SETTINGS_BOTTOM_BUTTONS_PANEL + " .okBtn")
				.before(this.templates.settingsBackBtnTmpl);
	}

	this.attachBottomButtonListeners();
};
