/*
 * List of all UI Strings used across search components
 * Use closure instead of prototype as there will be only one instance of this class.
 */
var localMsg = localMsg || {};
var cvSearchMessages = (function() {

	return {
		/* Search components can be used outside of webconsole too, so having strings for fallback case */
		NotAvailable : localMsg.NotApplicable || "N/A",
		EmptyMsg : localMsg.EmptyMsg || "No data to display.",
		EmptySuggestionsMsg : localMsg.EmptySuggestionsMsg || "No matching value found.",
		NoFacetsMsg : localMsg.NoFacetsMsg || "No filters to display.",
		SearchInputPlaceHolder : localMsg.SearchInputPlaceHolder || "Search text...",
		ComboBoxSelectText : localMsg.Select || "Select",
		SuggestBoxFilterText : localMsg.Filter || "Filter",
		RangeFacetStartText : localMsg.From || "from",
		RangeFacetEndText : localMsg.To || "to",
		ParsingErrorMsg : localMsg.ParsingErrorMsg || "Something went wrong while parsing the response.",
		AddFilter : localMsg.AddFilter || "Add Filter",
		SaveSettings : localMsg.SaveSettings || "Save View Settings",
		ColumnSettings : localMsg.ColumnSettings || "Column Settings",
		FacetSettingsTitle : localMsg.FacetSettingsTitle || "Filter Settings",
		GetRestApiBtnText : localMsg.GetRestApiBtnText || "Get REST API",
		RestApiTitle : localMsg.RestApiTitle || "REST API",
		CopySnippetLabel : localMsg.CopySnippetLabel || "Press Ctrl+C or Cmd+C to copy.",
		SaveBtnText : localMsg.Save || "Save",
		SaveAsBtnText : localMsg.SaveAs || "Save As",
		ApplyBtnText : localMsg.Apply || "Apply",
		AddBtnText : localMsg.Add || "Add",
		BuildMyReportBtnText : localMsg.BuildMyReportBtnText || "Visualize",
		RendererSettings : "Renderer",
		notDateMsg : "The selected field is not of the type \'date\'",
		ExportBtnText : localMsg.Export || "Export"
	};
}());
