/*
 *  Use closure instead of prototype as there will be only one instance of this class.
 */

var cvSearchConstants = (function() {

	return {
		suggestBoxProps : "autocorrect='off' autocapitalize='off' autocomplete='off'",
		/*
		 * Common templates across components
		 */
		templates : {
			emptySuggestionsTmpl : function() {
				return "<div class='" + cvSearchConstants.CssConstants.EMPTY_SUGGESTION_CLASS + "'>" +
						cvSearchMessages.EmptySuggestionsMsg + "</div>";
			}
		},
		/*
		 * Common CSS classes
		 */
		CssConstants : {
			SUGGEST_BOX_CLASS : "cvSuggestBox",
			EMPTY_SUGGESTION_CLASS : "cvEmptySuggestionDiv"
		},
		/*
		 * List of all events TODO: Use namespacing. Refer
		 * http://lucisferre.net/2012/08/19/three-useful-jquery-event-binding-tips/
		 */
		EventConstants : {
			RELOAD_SEARCH_VIEW : "reload.SearchView",
			RELOAD_SEARCH_RESULTS_VIEW : "reload.SearchResultsView",
			RELOAD_FACETS_VIEW : "reload.FacetsView",

			ON_SEARCH_KEYWORD_CHANGE : "onSearchKeywordChange",
			ON_FACET_SELECTED : "onFacetSelected",
			ON_FACET_ADD_CLICK : "onFacetAddClick",
			ON_FACET_DELETED : "onFacetDeleted",
			ON_FACET_REQUEST_CHANGE : "onFacetRequestChange",
			ON_SEARCH_RESPONSE_RECEIVED : "onSearchResponseReceived",
			ON_SEARCH_SETTINGS_CHANGED : "onSearchSettingsChanged",
			ON_FACETS_VIEW_REPAINT : "onFacetViewRepaint",
			RELOAD_SEARCH_RESULTS_VIEW : "reloadSearchResultsView",
			ON_BUILD_MY_REPORT_CLICKED : "onBuildMyReportClicked",
			ON_EXPORT_CLICKED : "onExportClicked",
			CACHE_SEARCH_PARAMS : "cacheSearchParams"
		}
	};
}());
