/*!
 * jQuery plugin
 * Component for search box
 */
;
(function(factory) {
	var getDependencyMissingMsg = function(dependency) {
		return "cvSearchBox depends on " + dependency + " and seems to be missing. Please include necessary files.";
	};
	if (!jQuery)
		throw getDependencyMissingMsg('jQuery');
	else if (!$.fn.typeahead)
		throw getDependencyMissingMsg('jQuery typeahead');
	else
		factory(jQuery);

}(function($) {
	"use strict";

	$.fn.cvSearchBox = function(qbId, config) {
		return this.each(function() {
			var $this = $(this), data = $this.data('cvSearchBox');
			if (!data) {
				$this.data('cvSearchBox', new SearchBox(this, qbId, config));
			}
		});
	};
	$.fn.cvSearchBox.id = 0;
}));
function SearchBox(element, qbId, config) {
	this._id = $.fn.cvSearchBox.id++;
	this.$element = $(element);
	this._qbId = qbId;
	this._origConfig = config;
	this._config = $.extend({}, this.defaults, config);
	this.suggestReqUrl = qb.sv.getKeywordSuggestReqStr(qbId);
	this.render();
};

SearchBox.prototype.defaults = {
	noOfSuggestionsToShow : 10,
	enableSuggestions : true
};
SearchBox.prototype.Constants = {
	ID_PREFIX : "cvSearchBox_",
	CLASS_NAME : "cvSearchSuggestBox"
};

SearchBox.prototype.templates = {
	searchBoxTmpl : function(id, className, placeHolderText) {
		return ("<input type='search' id='" + id + "' placeholder='" + placeHolderText +
				"' class='typeahead form-control " + cvSearchConstants.CssConstants.SUGGEST_BOX_CLASS + " " +
				className + "' " + cvSearchConstants.suggestBoxProps + "/>");

	}
};
SearchBox.prototype.getIdStr = function() {
	return this.Constants.ID_PREFIX + this._id;
};
SearchBox.prototype.focus = function() {
	$("#" + this.getIdStr()).focus();
};
SearchBox.prototype.attachEventHandlers = function(elm) {
	var self = this;
	var submitKeywordChange = function(e) {
		var thisObj = e.target;
		var keyword = $(thisObj).val();
		qb.sv.setKeyword(self._qbId, keyword);
		$(thisObj).trigger(cvSearchConstants.EventConstants.RELOAD_SEARCH_VIEW);
	};
	elm.on('keypress', function(e) {
		if (e.which === 13) {
			if (self._config.enableSuggestions)
				$(this).typeahead('close');
			submitKeywordChange(e);
		}
	});
	if (this._config.enableSuggestions)
		elm.on('typeahead:selected', function(e) {
			submitKeywordChange(e);
		});
};
SearchBox.prototype.render = function() {
	var self = this;
	try {
		var sBoxElm = $(this.templates.searchBoxTmpl(this.Constants.ID_PREFIX + this._id,
				this.Constants.CLASS_NAME,
				cvSearchMessages.SearchInputPlaceHolder));
		this.$element.append(sBoxElm);
		if (this._config.enableSuggestions) {
			var sBoxBh = new Bloodhound({
				datumTokenizer : Bloodhound.tokenizers.obj.whitespace('value'),
				queryTokenizer : Bloodhound.tokenizers.whitespace,
				limit : self._config.noOfSuggestionsToShow,
				//TODO: check if you can fire the suggestion request instead of the component
				remote : {
					url : this.suggestReqUrl,
					filter : function(resp) {
						return qb.sv.getSuggestionFromSearchResp(resp);
					}
				}
			});
			sBoxBh.initialize();
			sBoxElm.typeahead({
				minLength : self.defaults.minLength,
				highlight : true
			}, {
				displayKey : "value",
				source : sBoxBh.ttAdapter(),
			/*
			 * Commenting the empty msg support as the suggestions are returned only after configured. So
			 * showing the empty msg is misleading the user
			 * 
			 * templates : { empty : cvSearchConstants.templates.emptySuggestionsTmpl() }
			 */
			});
		}
		this.attachEventHandlers(sBoxElm);
	} catch (e) {
		console.error(e);
	}
};
