<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.SeaMessages">
	<!-- View Web info template, start -->
	<div data-templateId="tmpl_view_datasources_web" class="form-horizontal" style="display: none">
		<c:if test="${not requestScope.useSeaServer}">
			<div class="form-group">
				<label for="dsEngine" class="col-lg-2 control-label"><fmt:message key="AnalyticsEngine" /></label>
				<div class="col-lg-10">
					<p class="form-control-static" id="dsEngine"></p>
				</div>
			</div>
		</c:if>
		<div class="form-group">
			<label for="dsUrl" class="col-lg-2 control-label">URL</label>
			<div class="col-lg-10">
				<p class="form-control-static" id="dsUrl"></p>
			</div>
		</div>
		<%@ include file="sourcecommontemplate.jsp" %>
	</div>
	<div data-templateId="wizard_web" class="form-horizontal experimental-wizard" style="display: none">
		<div class="form-horizontal cvWizard-step col-lg-12" data-step="1">
			<div class='step-indicator col-lg-1'><div class='number-circle'>1</div></div>
			<div class='step-content col-lg-11'><jsp:include page="basedstemplate.jsp"></jsp:include></div>
			<div class='button-holder'></div>
		</div>
		<div class="form-horizontal cvWizard-step col-lg-12" data-step="2">
			<div class='step-indicator col-lg-1'><div class='number-circle'>2</div></div>
			<div class='step-content col-lg-11'>
				<div class="form-group" data-userinput="true">
					<label for="dsUrl" class="col-lg-3 control-label"><fmt:message key="URL" /></label>
					<div class="col-lg-7">
						<div class="required-icon">
							<div class="text">*</div>
						</div>
						<textarea class="form-control" rows="5" id="dsUrl" data-required="true" data-validate="true"
							data-validationtype="url" data-multivalued="true" data-multivaluedseparator="\s+"></textarea>
						<span class="help-block"><fmt:message key="Example" />&nbsp;http://example.com&nbsp;<fmt:message
								key="MultipleUrlHint" /></span>
					</div>
				</div>
				<div class="form-group" data-userinput="true">
					<label for="dsDomainName" class="col-lg-3 control-label"><fmt:message key="DomainName" /></label>
					<div class="col-lg-5">
						<input type="text" id="dsDomainName" class="form-control">
					</div>
				</div>
				<div class="form-group" data-userinput="true">
					<label for="dsUserName" class="col-lg-3 control-label"><fmt:message key="Username" /></label>
					<div class="col-lg-5">
						<input type="text" id="dsUserName" class="form-control">
					</div>
				</div>
				<div class="form-group" data-userinput="true">
					<label for="dsPassword" class="col-lg-3 control-label"><fmt:message key="Password" /></label>
					<div class="col-lg-5">
						<input type="password" id="dsPassword" class="form-control" data-validate="true" data-validationtype="password">
					</div>
				</div>
			</div>
			<div class='button-holder'></div>
		</div>

		<div class="form-horizontal cvWizard-step col-lg-12" data-step="3">
			<div class='step-indicator col-lg-1'><div class='number-circle'>3</div></div>
			<div class='step-content col-lg-11'>
				<div>
					<div id="webAdvanceOptionsPanel">
						<div class="advancedOptionsDiv">
							<div class="form-group" data-userinput="true">
								<label for="dsIncludePath" class="col-lg-3 control-label"><fmt:message key="IncludePaths" /></label>
								<div class="col-lg-7">
									<textarea class="form-control" rows="5" id="dsIncludePath" data-validate="true" data-validationtype="url"
										data-multivalued="true" data-multivaluedseparator="\s+"></textarea>
									<span class="help-block"><fmt:message key="Example" />&nbsp;http://example.com/page1&nbsp;<fmt:message
											key="MultipleUrlHint" /></span>
								</div>
							</div>
							<div class="form-group" data-userinput="true">
								<label for="dsExcludePath" class="col-lg-3 control-label"><fmt:message key="ExcludePaths" /></label>
								<div class="col-lg-7">
									<textarea class="form-control" rows="5" id="dsExcludePath" data-validate="true" data-validationtype="url"
										data-multivalued="true" data-multivaluedseparator="\s+"></textarea>
									<span class="help-block"><fmt:message key="Example" />&nbsp;http://example.com/page2&nbsp;<fmt:message
											key="MultipleUrlHint" /></span>
								</div>
							</div>
							<div class="form-group" data-userinput="true">
								<label for="dsCrawlDepth" class="col-lg-3 control-label"><fmt:message key="CrawlDepth" /></label>
								<div class="col-lg-5">
									<input type="number" id="dsCrawlDepth" class="form-control" value="5" min="1" max="10">
								</div>
							</div>
						</div>
					</div>
					<div class="form-group">
						<label for="dsCrawl" class="col-lg-3 control-label">
							<fmt:message key="CrawlOption" />
						</label>
						<div class="col-lg-7">
							<div class="checkbox">
								<label> 
									<input type="checkbox" id="dsCrawl"> 
									<fmt:message key="StartCrawlingNow" />
								</label>
							</div>
						</div>
					</div>
				</div>
				<div class='button-holder'></div>
			</div>
		</div>
		
		<div id='collapsedText'>
				<label class='step-content-header' data-step='1'><fmt:message key="DataSourceName" /></label>
				<label class='step-content-header' data-step='2'><fmt:message key="WebSiteURLS" /></label>
				<label class='step-content-header' data-step='3'><fmt:message key="AdvancedOptions" /></label>
		</div>
	</div>
	<!-- View Web info template, end -->
</fmt:bundle>
