<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.SeaMessages">
<!-- View blank info template, start -->
	<div data-templateId="tmpl_view_datasources_twitter"
		class="form-horizontal" style="display: none">
		<c:if test="${not requestScope.useSeaServer}">
			<div class="form-group">
				<label for="dsEngine" class="col-lg-2 control-label"><fmt:message
						key="AnalyticsEngine" /></label>
				<div class="col-lg-10">
					<p class="form-control-static" id="dsEngine"></p>
				</div>
			</div>
		</c:if>
		<div class="form-group">
			<label for="crawlType" class="col-lg-2 control-label"><fmt:message
					key="TwitterCrawlType" /></label>
			<div class="col-lg-6">
				<p class="form-control-static" id="crawlType"></p>
			</div>
		</div>
		<div class="form-group" id="userNameDiv" style="display: none">
			<label for="userNameValue" class="col-lg-2 control-label"><fmt:message
					key="UserScreenName" /></label>
			<div class="col-lg-6">
				<p class="form-control-static" id="userNameValue"></p>
			</div>
		</div>
		<div class="form-group" id="dateRangeDiv" style="display: none">
			<label for="dateRangeValue" class="col-lg-2 control-label"><fmt:message
					key="DateRange" /></label>
			<div class="col-lg-6">
				<p class="form-control-static" id="dateRangeValue"></p>
			</div>
		</div>
		<div class="form-group" id="hashTagsDiv" style="display: none">
			<label for="hashTagsValue" class="col-lg-2 control-label"><fmt:message
					key="HashTags" /></label>
			<div class="col-lg-6">
				<p class="form-control-static" id="hashTagsValue"></p>
			</div>
		</div>
		<div class="form-group" id="streamingKeywordDiv" style="display: none">
			<label for="keywordValue" class="col-lg-2 control-label"><fmt:message
					key="StreamingKeyword" /></label>
			<div class="col-lg-6">
				<p class="form-control-static" id="keywordValue"></p>
			</div>
		</div>
		<%@ include file="sourcecommontemplate.jsp"%>
	</div>

	<div data-templateId="wizard_twitter"
		class="form-horizontal experimental-wizard" style="display: none">
		<div class="form-horizontal cvWizard-step col-lg-12" data-step="1">
			<div class='step-indicator col-lg-1'>
				<div class='number-circle'>1</div>
			</div>
			<div class='step-content col-lg-11'>
				<jsp:include page="basedstemplate.jsp"></jsp:include>
			</div>
			<div class='button-holder'></div>
		</div>
		<div class="form-horizontal cvWizard-step col-lg-12" data-step="2">
			<div class='step-indicator col-lg-1'>
				<div class='number-circle'>2</div>
			</div>
			<div class='step-content col-lg-11'>
				<div class = 'form-group'>
					<div class="col-lg-7 col-lg-offset-2">
						<input type="image" id="twitterLoginButton" src="sea/img/twitter_signIn.png" />
						<div>
							<h5 id="loggedInUserInfo"></h5>
						</div>
					</div>
				</div>
			</div>
			<div class='button-holder'></div>
		</div>
		<div class="form-horizontal cvWizard-step col-lg-12" data-step="3">
			<div class='step-indicator col-lg-1'>
				<div class='number-circle'>3</div>
			</div>
			<div class='step-content col-lg-11'>
				<div class = 'form-group'>
					<label for="crawlUser" class="col-lg-3 control-label"><fmt:message key="WhatToCrawl" /></label>
					<div class="col-lg-5">
						<label class="radio-inline"> <input id="crawlUser" name="crawlWhat" type="radio" value="profileCrawl">
							<fmt:message key="ProfileCrawl" /></label>
						<label class="radio-inline"> <input id="crawlLive" name="crawlWhat" type="radio" value="liveCrawl">
							<fmt:message key="LiveStreaming" /></label>
					</div>
				</div>
				<div class='form-group'>
					<div id="crawlWhatDiv_profileCrawl" class="crawlWhatDiv col-lg-12">
						<div class="form-group">
							<label for="userScreenName" class="col-lg-3 control-label"><fmt:message key="UserScreenName" /></label>
							<div class="col-lg-5">
								<div class="required-icon">
									<div class="text">*</div>
								</div>
								<input type="text" id="userScreenName" class="form-control" data-required="true">
							</div>
						</div>
						<div class="form-group">
							<label class="col-lg-3 control-label"><fmt:message key="DateRange" /></label>
							<div class="col-lg-2">
								<div class="inner-addon right-addon">
									<i class="glyphicon glyphicon-calendar"></i>
									<input id="dateRangePicker" type="text" class="form-control">
								</div>
							</div>
						</div>
						<div class="form-group">
							<label for="hashTags" class="col-lg-3 control-label"><fmt:message key="HashTags" /></label>
							<div class="col-lg-5">
								<input id="hashTags" type="text" class="form-control"/>
							</div>
						</div>
						<div class="form-group">
							<label class="col-lg-3 control-label"><fmt:message
									key="IncrementalCrawl" /></label>
							<div class="col-lg-7">
								<div class="input-group">
									<input id="twitterIncrementalCrawl" type="checkbox"
										class="cvToggle switchHint"
										data-switch-hint-class="IncrementalCrawlHint" checked><label
										for="twitterIncrementalCrawl"></label>
								</div>
								<span class="help-block IncrementalCrawlHint"><fmt:message
										key="IncrementalCrawlHintEnable" /></span>
							</div>
						</div>
					</div>
					<div id="crawlWhatDiv_liveCrawl" class="crawlWhatDiv col-lg-12" style="display: none">
						<div class="form-group">
							<label for="liveKeyword" class="col-lg-3 control-label"><fmt:message key="StreamingKeyword" /></label>
							<div class="col-lg-5">
								<div class="required-icon">
									<div class="text">*</div>
								</div>
								<input type="text" id="liveKeyword" class="form-control" data-required="true">
							</div>
						</div>
						<div class="form-group">
							<label for="trendingTopics" class="col-lg-3 control-label"><fmt:message key="TrendingTopics" /></label>
							<div class="col-lg-7">
								<div id = "trendingTopics"></div>
								<button class="btn btn-primary pull-right showMoreOrLess" id="showMore"><fmt:message key="ShowMore" /></button>
								<button class="btn btn-primary pull-right showMoreOrLess" id="showLess" style="display: none"><fmt:message key="ShowLess" /></button>
							</div>
						</div>
						<div class="form-group">
							<label for="dsCrawl" class="col-lg-3 control-label"><fmt:message
									key="CrawlOption" /></label>
							<div class="col-lg-7">
								<div class="checkbox">
									<label> <input type="checkbox" id="dsCrawl"> <fmt:message
											key="StartCrawlingNow" />
									</label>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class='button-holder'></div>
		</div>
		
		<div id='collapsedText'>
				<label class='step-content-header' data-step='1'><fmt:message key="DataSourceName" /></label>
				<label class='step-content-header' data-step='2'><fmt:message key="Login" /></label>
				<label class='step-content-header' data-step='3'><fmt:message key="CrawlSpecifications" /></label>				
		</div>
	</div>
</fmt:bundle>