<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.SeaMessages">
	<!-- View DB info template, start -->
	<div data-templateId="tmpl_view_datasources_salesforce"
		class="form-horizontal" style="display: none">
		<c:if test="${not requestScope.useSeaServer}">
			<div class="form-group">
				<label for="dsEngine" class="col-lg-2 control-label"><fmt:message
						key="AnalyticsEngine" /></label>
				<div class="col-lg-10">
					<p class="form-control-static" id="dsEngine"></p>
				</div>
			</div>
		</c:if>
		<div class="form-group">
			<label for="dsUserName" class="col-lg-2 control-label"><fmt:message
					key="Username" /></label>
			<div class="col-lg-6">
				<p class="form-control-static" id="dsUserName"></p>
			</div>
		</div>
		<div class="form-group">
			<label for="dsTableName" class="col-lg-2 control-label"><fmt:message
					key="TableName" /></label>
			<div class="col-lg-10">
				<p class="form-control-static" id="dsTableName"></p>
			</div>
		</div>
		<%@ include file="sourcecommontemplate.jsp" %>
	</div>
	<div data-templateId="wizard_salesforce" class="form-horizontal experimental-wizard" style="display: none">
		<div class="form-horizontal cvWizard-step col-lg-12" data-step="1">
			<div class='step-indicator col-lg-1'><div class='number-circle'>1</div></div>
			<div class='step-content col-lg-11'><jsp:include page="basedstemplate.jsp"></jsp:include></div>
			<div class='button-holder'></div>
		</div>
		<div class="form-horizontal cvWizard-step col-lg-12" data-step="2">
			<div class='step-indicator col-lg-1'><div class='number-circle'>2</div></div>
			<div class='step-content col-lg-11'>
				<div class="form-group">
					<label for="dsUserName" class="col-lg-3 control-label"><fmt:message
							key="Username" /></label>
					<div class="col-lg-5">
						<div class="required-icon">
							<div class="text">*</div>
						</div>
						<input type="text" id="dsUserName" class="form-control">
					</div>
				</div>
				<div class="form-group">
					<label for="dsPassword" class="col-lg-3 control-label"><fmt:message
							key="Password" /></label>
					<div class="col-lg-5">
						<div class="required-icon">
							<div class="text">*</div>
						</div>
						<input type="password" id="dsPassword" class="form-control">
					</div>
				</div>
				<div class="form-group">
					<label for="dsSecurityToken" class="col-lg-3 control-label"><fmt:message
							key="SecurityToken" /></label>
					<div class="col-lg-5">
						<div class="required-icon">
							<div class="text">*</div>
						</div>
						<input type="password" id="dsSecurityToken" class="form-control">
					</div>
				</div>
			</div>
			<div class='button-holder'></div>
		</div>
		<div class="form-horizontal cvWizard-step col-lg-12" data-step="3">
			<div class='step-indicator col-lg-1'><div class='number-circle'>3</div></div>
			<div class='step-content col-lg-11'>
				<div id="dbMetaDataPanel" class="form-horizontal" style="display: none;">
					<label class="selectTableLabel"><fmt:message key="EnterTable" /></label>

					<div class="styled-select">
						<input id="tableList" class="form-control no-autofocus">
						</input>
					</div>
					<div class="autocomplete-container">
					</div>
				</div>
			</div>
			<div class='button-holder'></div>
		</div>
		<div class="form-horizontal cvWizard-step col-lg-12" data-step="4">
			<div class='step-indicator col-lg-1'><div class='number-circle'>4</div></div>
			<div class='step-content col-lg-11'>
				<div class="table-content saveButton"><table class="display table table-bordered dataTable" id="table_data" style="width:100%;"></table></div>
				<div class="form-group incrementalDiv">
					<label class="col-lg-3 control-label"><fmt:message
									key="IncrementalCrawl" /></label>
					<div class='col-lg-7 checkbox'>
						<label> <input type="checkbox" id="dsIncCrawl"
							checked> <fmt:message key="EnableIncrementalCrawl" />
						</label>
					</div>
				</div>
				<div class="form-group">
					<label for="dsCrawl" class="col-lg-3 control-label">
						<fmt:message key="CrawlOption" />
					</label>
					<div class="col-lg-7">
						<div class="checkbox">
							<label> 
								<input type="checkbox" id="dsCrawl"> 
								<fmt:message key="StartCrawlingNow" />
							</label>
						</div>
					</div>
				</div>
				<!-- <div class="form-group">
					<label class="col-lg-3 control-label"><fmt:message
							key="RetainVersions" /></label>
					<div class="col-lg-7">
						<div class="input-group">
							<input id="isRetainVersions" type="checkbox"
								class="cvToggle switchHint"
								data-switch-hint-class="RetainVersionsHintSalesforce"><label
								for="isRetainVersions"></label>
						</div>
						<span class="help-block RetainVersionsHintSalesforce"><fmt:message
								key="RetainVersionsHintSalesforceDisable" /></span>
					</div>
				</div> -->
			</div>
			<div class='button-holder'></div>
		</div>
		
		<div id='collapsedText'>
				<label class='step-content-header' data-step='1'><fmt:message key="DataSourceName" /></label>
				<label class='step-content-header' data-step='2'><fmt:message key="ConnectionDetails" /></label>
				<label class='step-content-header' data-step='3'><fmt:message key="TableName" /></label>
				<label class='step-content-header' data-step='4'><fmt:message key="SelectColumns" /></label>
		</div>
	</div>
	<!-- View salesforce info template, end -->
</fmt:bundle>
