<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.SeaMessages">
	<!-- View ldap info template, start -->
	<div data-templateId="tmpl_view_datasources_ldap"
		class="form-horizontal" style="display: none">
		<div class="form-group">
			<label for="dsDomainController" class="col-lg-2 control-label"><fmt:message
					key="DomainController" /></label>
			<div class="col-lg-6">
				<p class="form-control-static" id="dsDomainController"></p>
			</div>
		</div>
		<div class="form-group">
			<label for="dsUserName" class="col-lg-2 control-label"><fmt:message
					key="Username" /></label>
			<div class="col-lg-6">
				<p class="form-control-static" id="dsUserName"></p>
			</div>
		</div>
		<div class="form-group accessNodeElement" style="display: none">
			<label for="dsAccessNode" class="col-lg-2 control-label"><fmt:message
					key="AccessNode" /></label>
			<div class="col-lg-6">
				<p class="form-control-static" id="dsAccessNode"></p>
			</div>
		</div>
		<%@ include file="sourcecommontemplate.jsp"%>
	</div>
	<!-- New/Edit ldap template, start -->
	<div data-templateId="wizard_ldap"
		class="form-horizontal experimental-wizard" style="display: none">
		<div class="form-horizontal cvWizard-step col-lg-12" data-step="1">
			<div class='step-indicator col-lg-1'>
				<div class='number-circle'>1</div>
			</div>
			<div class='step-content col-lg-11'><jsp:include
					page="basedstemplate.jsp"></jsp:include></div>
			<div class='button-holder'></div>
		</div>
		<div class="form-horizontal cvWizard-step col-lg-12" data-step="2">
			<div class='step-indicator col-lg-1'>
				<div class='number-circle'>2</div>
			</div>
			<div class='step-content col-lg-11'>
				<div class="form-group" data-userinput="true">
					<label for="dsDomainController" class="col-lg-3 control-label"><fmt:message
							key="DomainController" /></label>
					<div class="col-lg-5">
						<div class="required-icon">
							<div class="text">*</div>
						</div>
						<input type="text" id="dsDomainController" data-required="true" class="form-control">
					</div>
				</div>
				<div class="form-group" data-userinput="true">
					<label for="dsUserName" class="col-lg-3 control-label"><fmt:message
							key="Username" /></label>
					<div class="col-lg-5">
						<div class="required-icon">
							<div class="text">*</div>
						</div>
						<input type="text" id="dsUserName" data-required="true" class="form-control">
					</div>
				</div>
				<div class="form-group" data-userinput="true">
					<label for="dsPassword" class="col-lg-3 control-label"><fmt:message
							key="Password" /></label>
					<div class="col-lg-5">
						<div class="required-icon">
							<div class="text">*</div>
						</div>
						<input type="password" id="dsPassword" data-required="true" class="form-control">
					</div>
				</div>
				<div id="ldapClientInfoHolder" class="form-group">
					<label for="ldapClientListCombo" class="col-lg-3 control-label"><fmt:message
							key="AccessNode" /><span class="glyphicon glyphicon-info-sign additional-info-icon"
								data-toggle="popover"
								data-content="<fmt:message key='LdapAccessNodePlaceholder' />"
								aria-hidden="true"></span></label>
					<div class="col-lg-5">
						<select id="ldapClientListCombo" class="form-control"></select>
					</div>
				</div>
				<div class="form-group">
					<label class="col-lg-3 control-label"><fmt:message
							key="SecuredLDAP" /></label>
					<div class="col-lg-7">
						<div class="input-group">
							<input id="isSecuredLDAP" type="checkbox"
								class="cvToggle"><label
								for="isSecuredLDAP"></label>
						</div>
						<span class="help-block SecuredLDAPHint"><fmt:message
								key="SecuredLDAPHint" /></span>
					</div>
				</div>
				<div class='button-holder'></div>
			</div>
		</div>
		<div class="form-horizontal cvWizard-step col-lg-12" data-step="3">
			<div class='step-indicator col-lg-1'>
				<div class='number-circle'>3</div>
			</div>
			<div class='step-content col-lg-11'>
				<div class="table-content saveButton">
					<table class="display table table-bordered dataTable" id="table_data" style="width:100%;"></table>
				</div>
				<div class="form-group">
					<label for="dsCrawl" class="col-lg-3 control-label">
						<fmt:message key="CrawlOption" />
					</label>
					<div class="col-lg-7">
						<div class="checkbox">
							<label> 
								<input type="checkbox" id="dsCrawl"> 
								<fmt:message key="StartCrawlingNow" />
							</label>
						</div>
					</div>
				</div>
			</div>
			<div class='button-holder'></div>
		</div>
		<div id='collapsedText'>
			<label class='step-content-header' data-step='1'><fmt:message key="DataSourceName" /></label> 
			<label class='step-content-header' data-step='2'><fmt:message key="ConnectionDetails" /></label> 
			<label class='step-content-header' data-step='3'><fmt:message key="SelectSearchBase" /></label>
		</div>
	</div>
	<!-- New/Edit DB template, end -->
</fmt:bundle>