<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.SeaMessages">
	<!-- View blank info template, start -->
	<div data-templateId="tmpl_view_datasources_facebook"
		class="form-horizontal" style="display: none">
		<c:if test="${not requestScope.useSeaServer}">
			<div class="form-group">
				<label for="dsEngine" class="col-lg-2 control-label"><fmt:message
						key="AnalyticsEngine" /></label>
				<div class="col-lg-10">
					<p class="form-control-static" id="dsEngine"></p>
				</div>
			</div>
		</c:if>
		<div class="form-group">
			<label for="crawlType" class="col-lg-2 control-label"><fmt:message
					key="FBCrawlType" /></label>
			<div class="col-lg-6">
				<p class="form-control-static" id="crawlType"></p>
			</div>
		</div>
		<div class="form-group" id="crawlfbIdDiv" style="display: none">
			<label for="crawlfbId" class="col-lg-2 control-label"><fmt:message
					key="FacebookProfileId" /></label>
			<div class="col-lg-6">
				<p class="form-control-static" id="crawlfbId"></p>
			</div>
		</div>
		<div class="form-group">
			<label for="crawlEntities" class="col-lg-2 control-label"><fmt:message
					key="FBCrawlEntity" /></label>
			<div class="col-lg-6">
				<p class="form-control-static" id="crawlEntities"></p>
			</div>
		</div>
		<%@ include file="sourcecommontemplate.jsp"%>
	</div>

	<div data-templateId="wizard_facebook"
		class="form-horizontal experimental-wizard" style="display: none">
		<div class="form-horizontal cvWizard-step col-lg-12" data-step="1">
			<div class='step-indicator col-lg-1'>
				<div class='number-circle'>1</div>
			</div>
			<div class='step-content col-lg-11'><jsp:include
					page="basedstemplate.jsp"></jsp:include></div>
			<div class='button-holder'></div>
		</div>
		<div class="form-horizontal cvWizard-step col-lg-12" data-step="2">
			<div class='step-indicator col-lg-2'>
				<div class='number-circle'>2</div>
			</div>
			<div class='step-content col-lg-11'>
				<div class='form-group'>
					<label for="socialbtn" class="col-lg-3 control-label"></label>
					<div class='col-lg-7'>
					<!-- Scope is the permissions that the application has to obtain from the user. These permissions cannot be changed very frequently as based on the permissions the app will go through approvals. -->
						<fb:login-button class='socialbtn'
							scope='public_profile,user_friends,email,user_about_me,user_actions.books,user_actions.fitness,user_actions.music,user_actions.news,user_actions.video,user_birthday,user_education_history,user_events,user_games_activity,user_hometown,user_likes,user_location,user_managed_groups,user_photos,user_posts,user_relationships,user_relationship_details,user_religion_politics,user_tagged_places,user_videos,user_website,user_work_history,read_custom_friendlists,read_insights,manage_pages,pages_show_list'
							data-show-faces='true' data-auto-logout-link='true'
							data-size='large'>
						</fb:login-button>
					</div>
				</div>
			</div>
			<div class='button-holder'></div>
		</div>
		<!-- Below step to get input and validate -->
		<div class="form-horizontal cvWizard-step col-lg-12" data-step="3">
			<div class='step-indicator col-lg-2'>
				<div class='number-circle'>3</div>
			</div>
			<div class='step-content col-lg-11'>
				<div class='form-group'>
					<label for="crawlUser" class="col-lg-3 control-label"><fmt:message
							key="WhatToCrawl" /></label>
					<div class='col-lg-7'>
						<div class="radio">
							<label> <input type="radio" id="crawlUser"
								name="crawlWhat" checked
								onchange="$('#fbId').prop('disabled',this.checked);"> <fmt:message
									key="FBCurrentUser" />
							</label> &nbsp; <label> <input type="radio" id="crawlPage"
								name="crawlWhat"
								onchange="$('#fbId').prop('disabled',!this.checked);"> <fmt:message
									key="Page" />
							</label>
						</div>
					</div>
				</div>
				<div class="form-group">
					<label for="fbId" class="col-lg-3 control-label"><fmt:message
							key="FBProfileId" /></label>
					<div class='col-lg-5'>
						<input type="text" id="fbId" disabled='true' class="form-control">
					</div>
				</div>

				<div class='data-source form-group'>
					<label for="fbCrawlSelections" class="col-lg-3 control-label"><fmt:message
							key="FacebookEntitiesToCrawl" /></label>
					<div class='col-lg-7 no-padding'>
						<select id="fbCrawlSelections"
							class='data-source-list form-control' multiple="multiple">
							<option value="user" class="disabled-MultiselectFBDS" disabled
								selected><fmt:message key="User" /></option>
							<option value="page" class="disabled-MultiselectFBDS" disabled
								selected><fmt:message key="Page" /></option>
							<option value="post" class="disabled-MultiselectFBDS" disabled
								selected><fmt:message key="Post" /></option>
							<option value="album"><fmt:message key="Album" /></option>
							<option value="event"><fmt:message key="Event" /></option>
							<option value="photo"><fmt:message key="Photo" /></option>
							<option value="video"><fmt:message key="Video" /></option>
							</select>
					</div>
				</div>
				<div class="form-group">
					<label for="dsCrawl" class="col-lg-3 control-label"><fmt:message
							key="CrawlOption" /></label>
					<div class="col-lg-7">
						<div class="checkbox">
							<label> <input type="checkbox" id="dsCrawl"> <fmt:message
									key="StartCrawlingNow" />
							</label>
						</div>
					</div>
				</div>
			</div>
			<div class='button-holder'></div>
		</div>
		<div id='collapsedText'>
			<label class='step-content-header' data-step='1'><fmt:message key="DataSourceName" /></label>
			<label class='step-content-header' data-step='2'><fmt:message key="Login" /></label>
			<label class='step-content-header' data-step='3'><fmt:message key="CrawlOption" /></label>
		</div>
	</div>
</fmt:bundle>
