<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.SeaMessages">
	<div data-templateId="tmpl_view_datasources_csv"
		class="form-horizontal" style="display: none">
		<c:if test="${not requestScope.useSeaServer}">
			<div class="form-group">
				<label for="dsEngine" class="col-lg-2 control-label"><fmt:message
						key="AnalyticsEngine" /></label>
				<div class="col-lg-10">
					<p class="form-control-static" id="dsEngine"></p>
				</div>
			</div>
		</c:if>
		<div class="form-group">
			<label for="dsCsvLocation" class="col-lg-2 control-label"><fmt:message
					key="CSVFiles" /></label>
			<div class="col-lg-10">
				<p class="form-control-static" id="dsCsvLocation"></p>
			</div>
		</div>
		<div class="form-group">
			<label for="dsColSeparator" class="col-lg-2 control-label"><fmt:message
					key="ColumnSeparator" /></label>
			<div class="col-lg-10">
				<p class="form-control-static" id="dsColSeparator"></p>
			</div>
		</div>
		<div class="form-group">
			<label for="dsCSVCols" class="col-lg-2 control-label"><fmt:message
					key="Columns" /></label>
			<div class="col-lg-10">
				<p class="form-control-static" id="dsCSVCols"></p>
			</div>
		</div>
		<%@ include file="sourcecommontemplate.jsp"%>
	</div>
	<div data-templateId="wizard_csv"
		class="form-horizontal experimental-wizard" style="display: none">
		<div class="form-horizontal cvWizard-step col-lg-12" data-step="1">
			<div class='step-indicator col-lg-1'>
				<div class='number-circle'>1</div>
			</div>
			<div class='step-content col-lg-10'><jsp:include
					page="basedstemplate.jsp"></jsp:include></div>
			<div class='button-holder'></div>
		</div>
		<div class="form-horizontal cvWizard-step col-lg-12" data-step="2">
			<div class='step-indicator col-lg-1'>
				<div class='number-circle'>2</div>
			</div>
			<div class='step-content col-lg-10'>
				<div id="csvProps">
					<div id="dsCsvLocationDiv" class="form-group">
						<input type="hidden" id="dsCSVUploadPath"></input> <label
							for="dsCsvLocation" class="col-lg-3 control-label"><fmt:message
								key="CSVFiles" /></label>
						<div class="col-lg-7">
							<label class="radio-inline"> <input name="csvLocType"
								type="radio" value="upload" checked="checked"> <fmt:message
									key="UploadCSVFiles" /></label> <label class="radio-inline"> <input
								name="csvLocType" type="radio" value="folder"> <fmt:message
									key="CSVFolderLoc" />
							</label>
						</div>
					</div>
					<div id="" class="form-group">
						<div id="csvLocTypeDiv_upload"
							class="csvLocTypeDiv col-lg-7 col-lg-offset-3">
							<div class="required-icon">
								<div class="text">*</div>
							</div>
							<div id="dsCsvLocation" autocomplete="off"
								class="form-control textbox" readonly="readonly"></div>
							<div id="uploadLink" class="btn uploadLinkDiv">
								<fmt:message key="Upload" />
							</div>
						</div>
						<div id="csvLocTypeDiv_folder"
							class="csvLocTypeDiv col-lg-7 col-lg-offset-3"
							style="display: none">

							<div class="form-group">
								<label for="folderPath" class="col-lg-3 control-label"><fmt:message
										key="FolderPath" /></label>
								<div class="col-lg-9">
									<div class="required-icon">
										<div class="text">*</div>
									</div>
									<input type="text" id="folderPath" class="form-control">
									<span class="help-block"><fmt:message
											key="CSVFolderLocHint" /></span>
								</div>
							</div>

							<div class="form-group">
								<label for="csvUserName" class="col-lg-3 control-label"><fmt:message
										key="Username" /></label>
								<div class="col-lg-9">
									<input type="text" id="csvUserName" class="form-control">
								</div>
							</div>
							<div class="form-group">
								<label for="csvPassword" class="col-lg-3 control-label"><fmt:message
										key="Password" /></label>
								<div class="col-lg-9">
									<input type="password" id="csvPassword" class="form-control">
								</div>
							</div>
						</div>
					</div>
					<div id="dsColSeparatorDiv" class="form-group"
						data-userinput="true">
						<label for="dsColSeparator" class="col-lg-3 control-label"><fmt:message
								key="ColumnSeparator" /></label>
						<div class="col-lg-7">
							<div class="pull-left">
								<label class="radio-inline"> <input name="colSepGroup"
									type="radio" value="," checked="checked"> <fmt:message
										key="Comma" /></label> <label class="radio-inline"> <input
									name="colSepGroup" type="radio" value="SPACE"> <fmt:message
										key="Space" /></label> <label class="radio-inline"> <input
									name="colSepGroup" type="radio" value="TAB"> <fmt:message
										key="Tab" /></label> <label class="radio-inline"><input
									name="colSepGroup" type="radio" value="others"> <fmt:message
										key="Others" /></label>
							</div>
							<div class="pull-left">
								<input type="text" id="dsColSeparator"
									class="form-control input-sm input-inline dsColSepInput"
									style="display: none">
							</div>
						</div>
					</div>
					<div class="form-group">
						<label for="csvHeaderInfo" class="col-lg-3 control-label"><fmt:message
								key="HeaderInformation" /></label>
						<div class="col-lg-7">
							<div class="checkbox">
								<label> <input type="checkbox" id="dsFirstRowAsColNames"
									checked> <fmt:message key="IsFirstRowColumnName" />
								</label>
							</div>
						</div>
					</div>
					<div id="dsCSVColsDiv" class="form-group" data-userinput="true">
						<label for="dsCSVCols" class="col-lg-3 control-label"><fmt:message
								key="Columns" /></label>
						<div class="col-lg-7">
							<textarea id="dsCSVCols" autocomplete="off" class="form-control"
								data-validate="true"></textarea>
							<span class="help-block"><fmt:message key="ColumnsHint" /></span>
						</div>
					</div>
				</div>
			</div>
			<div class='button-holder'></div>
		</div>
		<div class='form-horizontal cvWizard-step col-lg-12' data-step="3">
			<div class='step-indicator col-lg-1'>
				<div class='number-circle'>3</div>
			</div>
			<div class='step-content col-lg-10'>
				<div class="form-group summary csv-preview-div">
					<!-- Enable data type detect option only on isDetectDataTypeEnabled key set to true -->
					<c:choose>
						<c:when test="${requestScope.isDetectDataTypeEnabled}">
							<div class="form-group detect-data-type-div">
								<label class="col-lg-3 control-label"><fmt:message
										key="EnableDataTypeDetection" /><a
									id="dataTypeDetectionPopover"
									class="glyphicon glyphicon-info-sign additional-info-icon"
									title="<fmt:message key='EnableDataTypeDetectionHintHeader'/>"
									data-content="<fmt:message key='EnableDataTypeDetectionHintText'/>"></a></label>
								<div class="col-lg-7">
									<div class="input-group">
										<input id="isDTAutoDetect" type="checkbox" class="cvToggle">
										<label for="isDTAutoDetect"></label>
									</div>
								</div>
							</div>
						</c:when>
					</c:choose>
					<div class="form-group">
						<div class="col-lg-12" id="dsCSVPreview"></div>
					</div>
					<div class="form-group">
						<label class="col-lg-3 control-label"><fmt:message
								key="IncrementalCrawl" /></label>
						<div class="col-lg-7">
							<div class="input-group">
								<input id="isIncrementalCrawl" type="checkbox"
									class="cvToggle switchHint"
									data-switch-hint-class="IncrementalCrawlHint"><label
									for="isIncrementalCrawl"></label>
							</div>
							<span class="help-block IncrementalCrawlHint"><fmt:message
									key="IncrementalCrawlHintDisable" /></span>
						</div>
					</div>
					<div class="form-group" data-userinput="true">
						<label for="incrPrimaryKey" class="col-lg-3 control-label"><fmt:message
								key="PrimaryKey" /></label>
						<div class="col-lg-5">
							<input type="text" id="incrPrimaryKey" class="form-control"
								data-required-if="isIncrementalCrawl">
						</div>
					</div>
					<div class="form-group">
						<label for="dsCrawl" class="col-lg-3 control-label">
							<fmt:message key="CrawlOption" />
						</label>
						<div class="col-lg-7">
							<div class="checkbox">
								<label> 
									<input type="checkbox" id="dsCrawl"> 
									<fmt:message key="StartCrawlingNow" />
								</label>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class='button-holder'></div>
		</div>			
			
		<div id='collapsedText'>
				<label class='step-content-header' data-step='1'><fmt:message key="DataSourceName" /></label>
				<label class='step-content-header' data-step='2'><fmt:message key="CSVFileDetails" /></label>
				<label class='step-content-header' data-step='3'><fmt:message key="CSVPreview" /></label>
		</div>
	</div>
	<script type="text/javascript" src="../../common/thirdPartyV2/purify.min.js"></script>
</fmt:bundle>
