<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.SeaMessages">
	<div id="confirmDelete" class="modal fade" role="dialog" tabindex="-1">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal">
						<span aria-hidden="true">&times;</span><span class="sr-only"><fmt:message
								key="Close" /></span>
					</button>
					<h4 class="modal-title">
						<fmt:message key="DeleteDataSource" />
					</h4>
				</div>
				<div class="modal-body">
					<div class="form-horizontal">
						<div class="form-group">
							<div class="col-lg-12">
								<div class="form-control-static confirmDeleteMsg"></div>
								<div class="radio">
									<label><input type="radio" name="deleteOption"
										id="crawlDeleteChk" checked> <fmt:message
											key="DeleteCrawledData" /></label>
								</div>
								<span class="help-block"> <fmt:message
										key="DeleteCrawledDataHint" />
								</span>
								<div class="radio">
									<label><input type="radio" name="deleteOption"
										id="permDeleteChk"> <fmt:message
											key="PermanentlyDelete" /></label>
								</div>
								<span class="help-block"> <fmt:message
										key="PermanentlyDeleteHint" />
								</span>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" data-dismiss="modal"
						class="btn btn-primary deleteBtn">
						<fmt:message key="Delete" />
					</button>
					<button type="button" data-dismiss="modal" class="btn cancelBtn">
						<fmt:message key="Cancel" />
					</button>
				</div>
			</div>
		</div>
	</div>

	<div id="confirmDeleteField" class="modal fade" role="dialog"
		tabindex="-1">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal">
						<span aria-hidden="true">&times;</span><span class="sr-only"><fmt:message
								key="Close" /></span>
					</button>
					<h4 class="modal-title">
						<fmt:message key="DeleteField" />
					</h4>
				</div>
				<div class="modal-body">
					<div class="form-horizontal">
						<div class="form-group">
							<div class="col-lg-12">
								<div class="form-control-static confirmDeleteMsg"></div>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" data-dismiss="modal"
						class="btn btn-primary deleteBtn">
						<fmt:message key="Delete" />
					</button>
					<button type="button" data-dismiss="modal" class="btn">
						<fmt:message key="Cancel" />
					</button>
				</div>
			</div>
		</div>
	</div>
	<div id="confirmDeleteHandler" class="modal fade" role="dialog"
		tabindex="-1">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal">
						<span aria-hidden="true">&times;</span><span class="sr-only"><fmt:message
								key="Close" /></span>
					</button>
					<h4 class="modal-title">
						<fmt:message key="DeleteHandler" />
					</h4>
				</div>
				<div class="modal-body">
					<div class="form-horizontal">
						<div class="form-group">
							<div class="col-lg-12">
								<div class="form-control-static confirmDeleteMsg"></div>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" data-dismiss="modal"
						class="btn btn-primary deleteBtn">
						<fmt:message key="Delete" />
					</button>
					<button type="button" data-dismiss="modal" class="btn">
						<fmt:message key="Cancel" />
					</button>
				</div>
			</div>
		</div>
	</div>
	<div id="promptCrawl" class="modal fade" role="dialog" tabindex="-1">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal">
						<span aria-hidden="true">&times;</span><span class="sr-only"><fmt:message
								key="Close" /></span>
					</button>
					<h4 class="modal-title">
						<fmt:message key="Crawl" />
					</h4>
				</div>
				<div class="modal-body">
					<div class="form-horizontal">
						<div class="form-group">
							<div class="col-lg-12">
								<div class="form-control-static promptCrawlMsg"></div>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" data-dismiss="modal"
						class="btn btn-primary yesBtn">
						<fmt:message key="Yes" />
					</button>
					<button id="notNowBtn" type="button" data-dismiss="modal" class="btn">
						<fmt:message key="NotNow" />
					</button>
				</div>
			</div>
		</div>
	</div>
	<div id="deleteCrawledData" class="modal fade" role="dialog"
		tabindex="-1">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal">
						<span aria-hidden="true">&times;</span><span class="sr-only"><fmt:message
								key="Close" /></span>
					</button>
					<h4 class="modal-title">
						<fmt:message key="DeleteCrawledData" />
					</h4>
				</div>
				<div class="modal-body">
					<div class="form-horizontal">
						<div class="form-group">
							<div class="col-lg-12">
								<div class="form-control-static deleteCrawledDataMsg">
									<fmt:message key="DeleteCrawledDataPrimaryKeyMsg" />
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" data-dismiss="modal"
						class="btn btn-primary deleteBtn">
						<fmt:message key="Delete" />
					</button>
					<button type="button" data-dismiss="modal" class="btn cancelBtn">
						<fmt:message key="Cancel" />
					</button>
				</div>
			</div>
		</div>
	</div>
	<div id="deleteOnlyDS" class="modal fade" role="dialog" tabindex="-1">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal">
						<span aria-hidden="true">&times;</span><span class="sr-only"><fmt:message
								key="Close" /></span>
					</button>
					<h4 class="modal-title">
						<fmt:message key="DeleteFederatedSearch" />
					</h4>
				</div>
				<div class="modal-body">
					<div class="form-horizontal">
						<div class="form-group">
							<div class="col-lg-12">
								<div class="form-control-static confirmDeleteMsg"></div>
								<span class="help-block"> <fmt:message
										key="DeleteFederatedSearchHint" />
								</span>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" data-dismiss="modal"
						class="btn btn-primary deleteBtn">
						<fmt:message key="Delete" />
					</button>
					<button type="button" data-dismiss="modal" class="btn cancelBtn">
						<fmt:message key="Cancel" />
					</button>
				</div>
			</div>
		</div>
	</div>

	<div id="handlerRestApi" class="modal fade" role="dialog" tabindex="-1">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal">
						<span aria-hidden="true">&times;</span><span class="sr-only"><fmt:message
								key="Close" /></span>
					</button>
					<h4 class="modal-title">
						<fmt:message key="RESTAPI" />
					</h4>
				</div>
				<div class="modal-body">
					<div class="form-horizontal">
						<div class="form-group">
							<div class="col-lg-12">
								<div class="form-control-static rest-api-container">
									<textarea class='rest-api form-control' style='resize: none;'></textarea>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" data-dismiss="modal" class="btn btn-primary">
						<fmt:message key="Ok" />
					</button>
					<button type="button" data-dismiss="modal" class="btn">
						<fmt:message key="Cancel" />
					</button>
				</div>
			</div>
		</div>
	</div>
	<div id="shareDataSourceModal" class="modal fade" role="dialog"
		tabindex="-1">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal">
						<span aria-hidden="true">&times;</span><span class="sr-only"><fmt:message
								key="Close" /></span>
					</button>
					<h4 class="modal-title">
						<fmt:message key="ShareDataSource" />
					</h4>
				</div>
				<div class="modal-body">
					<div class="form-horizontal">
						<div class="form-group">
							<div class="col-lg-12">
								<div class="share-body">
									<div class="invite-people">
										<div class="row">

											<div class="col-xs-8">
												<div class="textbox inputTextContainer">
													<span class="progressIcon" style="display:none;"></span>
													<div class="inputRealContainer">
														<input type="text" class="form-control userfield"
															placeholder="<fmt:message key="InvitePeopleHint" />">
													</div>
												</div>
											</div>
											<div class="col-xs-4 shareDropdown">
												<button class="btn btn-default dropdown-toggle"
													type="button" data-toggle="dropdown" aria-haspopup="true"
													aria-expanded="true" value="View">
													View <span class="caret"></span>
												</button>
												<ul class="dropdown-menu" aria-labelledby="dropdownMenu1">
													<li><label class="checkbox-inline checkbox-click"><input
															type="checkbox" class="modeCheckbox" disabled="disabled"
															checked="checked" value="<fmt:message key="View" />"
															disabled> <fmt:message key="View" /><span
															class="ico-eye2 list-iconSm mr"></span></label></li>
													<li><label class="checkbox-inline checkbox-click"><input
															type="checkbox" class="modeCheckbox"
															value="<fmt:message key="Edit" />"> <fmt:message
																key="Edit" /><span
															class="ico-pencil list-iconSm mr"></span></label></li>
													<li><label class="checkbox-inline checkbox-click"><input
															type="checkbox" class="modeCheckbox"
															value="<fmt:message key="Share" />"> <fmt:message
																key="Share" /><span
															class="ico-share2 list-iconSm mr"></span></label></li>
												</ul>
											</div>
										</div>
										<div class="col-lg-9 userSuggestions">
											<table class="userSuggestionsTable">
												<tbody id="userSuggestionsTableBody">
											</table>
										</div>
									</div>
								</div>
								<div class="shared-users">
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-primary" id="shareDsButton">
						<fmt:message key="Share" />
					</button>
					<button type="button" data-dismiss="modal" class="btn">
						<fmt:message key="Cancel" />
					</button>
				</div>
			</div>
		</div>
	</div>
	<div id="shareHandlerModal" class="modal fade" role="dialog"
		tabindex="-1">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal">
						<span aria-hidden="true">&times;</span><span class="sr-only"><fmt:message
								key="Close" /></span>
					</button>
					<h4 class="modal-title">
						<fmt:message key="ShareHandler" />
					</h4>
				</div>
				<div class="modal-body">
					<div class="form-horizontal">
						<div class="form-group">
							<div class="col-lg-12">
								<div class="share-body">
									<div class="invite-people">
										<div class="row">

											<div class="col-lg-8">
												<div class="textbox inputTextContainer">
													<span class="progressIcon" style="display:none;"></span>
													<div class="inputRealContainer">
														<input type="text" class="form-control userfield"
															placeholder="<fmt:message key="InvitePeopleHint" />">
													</div>
												</div>
											</div>
											<div class="col-lg-4 shareDropdown">
												<button class="btn btn-default dropdown-toggle"
													type="button" data-toggle="dropdown" aria-haspopup="true"
													aria-expanded="true" value="View">
													View <span class="caret"></span>
												</button>
												<ul class="dropdown-menu" aria-labelledby="dropdownMenu1">
													<li><label class="checkbox-inline checkbox-click"><input
															type="checkbox" class="modeCheckbox" disabled="disabled"
															checked="checked" value="<fmt:message key="View" />"
															checked disabled> <fmt:message key="View" /><span
															class="ico-eye2 list-iconSm mr"></span></label></li>
													<li><label class="checkbox-inline checkbox-click"><input
															type="checkbox" class="modeCheckbox"
															value="<fmt:message key="Execute" />"> <fmt:message
																key="Execute" /><span
															class="ico-play list-iconSm mr"></span></label></li>
													<li><label class="checkbox-inline checkbox-click"><input
															type="checkbox" class="modeCheckbox"
															value="<fmt:message key="Edit" />"> <fmt:message
																key="Edit" /><span
															class="ico-pencil list-iconSm mr"></span></label></li>
													<li><label class="checkbox-inline checkbox-click"><input
															type="checkbox" class="modeCheckbox"
															value="<fmt:message key="Share" />"> <fmt:message
																key="Share" /><span
															class="ico-share2 list-iconSm mr"></span></label></li>
												</ul>
											</div>
										</div>
										<div class="col-lg-8 userSuggestions">
											<table class="userSuggestionsTable">
												<tbody id="userSuggestionsTableBody">
											</table>
										</div>
									</div>
								</div>
								<div class="shared-users" id="handler-shared-users">

								</div>

							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" data-dismiss="modal"
						class="btn btn-danger btn-sm " id="stopShareDsButton" class="stopShareDsButton">
						<fmt:message key="StopShare" />
					</button>
					<button type="button" class="btn btn-primary" id="shareDsButton">
						<fmt:message key="Share" />
					</button>
					<button type="button" data-dismiss="modal" class="btn">
						<fmt:message key="Cancel" />
					</button>
				</div>
			</div>
		</div>
	</div>
	<div id="disableSqlAccessConfirm" class="modal fade" role="dialog"
		tabindex="-1">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal">
						<span aria-hidden="true">&times;</span><span class="sr-only"><fmt:message
								key="Close" /></span>
					</button>
					<h4 class="modal-title">
						<fmt:message key="sql.access.disable" />
					</h4>
				</div>
				<div class="modal-body">
					<div class="form-horizontal">
						<div class="form-group">
							<div class="col-lg-12">
								<div class="form-control-static confirmMsg">
									<fmt:message key="sql.access.disable.confirm.msg" />
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" data-dismiss="modal"
						class="btn btn-primary okBtn">
						<fmt:message key="Yes" />
					</button>
					<button type="button" data-dismiss="modal" class="btn cancelBtn">
						<fmt:message key="No" />
					</button>
				</div>
			</div>
		</div>
	</div>
	<div id="entityExtractionSettings" class="modal fade" role="dialog"
		tabindex="-1">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal">
						<span aria-hidden="true">&times;</span><span class="sr-only"><fmt:message
								key="Close" /></span>
					</button>
					<h4 class="modal-title">
						<fmt:message key="EntitySettings" />
					</h4>
				</div>
				<div class="modal-body">
					<div class="form-horizontal">
						<div class="form-group">
							<div class="col-lg-6">
								<label for="entityHandler"><fmt:message key="EntityHandler" /></label>
								<select	class="form-control mt" id="entityHandler">
								</select>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" data-dismiss="modal"
						class="btn btn-primary saveEntityHandler">
						<fmt:message key="Save" />
					</button>
					<button type="button" data-dismiss="modal" class="btn">
						<fmt:message key="Cancel" />
					</button>
				</div>
			</div>
		</div>
	</div>
</fmt:bundle>
