<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.SeaMessages">
	<div class="form-group">
		<label for="authType" class="col-lg-3 control-label"><fmt:message key="Authorization"/></label>
		<div class="col-lg-5">
			<select id="authType" class="form-control">
                <option value="NONE"><fmt:message key="NoAuth"/></option>
                <option value="BASIC"><fmt:message key="BasicAuth"/></option>
                <option value="OAUTH1"><fmt:message key="OAuth1"/></option>
                <option value="OAUTH2"><fmt:message key="OAuth2"/></option>
                <option value="COMMVAULT"><fmt:message key="CommvaultAuth"/></option>
            </select>
		</div>
	</div>
	<div class="authDivs basicDiv">
		<div class="form-group" data-userinput="true">
			<label for="basicAuthUserName" class="col-lg-3 control-label"><fmt:message key="UserCredentials"/></label>
			<div class="col-lg-5">
				<div class="row noLftRghtMargin">
					<div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 noLftRghtPadding">
						<input id="basicAuthUserName" type="text" class="form-control" data-required="true" placeholder="Username"/>
					</div>
					<div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 noLftRghtPadding">
						<div class="inner-addon right-addon joint-input-lft-bdr">
							<i class="glyphicon glyphicon-eye-open basicAuthPasswordIcon"></i>
							<i class="glyphicon glyphicon-eye-close basicAuthPasswordIcon" style="display: None;"></i>
							<input id="basicAuthUserPassword" type="password" class="form-control joint-input" placeholder="Password"/>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="authDivs oauth1Div">
		<div class="form-group" data-userinput="true">
			<label for="oauth1ConsumerKey" class="col-lg-3 control-label"><fmt:message key="APIKey"/></label>
			<div class="col-lg-5">
				<input id="oauth1ConsumerKey" type="text" class="form-control" data-required="true"/>
			</div>
		</div>
		<div class="form-group" data-userinput="true">
			<label for="oauth1ConsumerSecret" class="col-lg-3 control-label"><fmt:message key="APISecret"/></label>
			<div class="col-lg-5">
				<input id="oauth1ConsumerSecret" type="text" class="form-control" data-required="true"/>
			</div>
		</div>
		<div class="form-group" data-userinput="true">
			<label for="oauth1AuthUrl" class="col-lg-3 control-label"><fmt:message key="AuthUrl"/></label>
			<div class="col-lg-5">
				<div class="row noLftRghtMargin">
					<div class="col-lg-3 col-md-3 col-sm-3 col-xs-3 noLftRghtPadding">
						<select class="form-control">
	                		<option value="GET">GET</option>
	                	</select>
					</div>
					<div class="col-lg-9 col-md-9 col-sm-9 col-xs-9 noLftRghtPadding">
						<input id="oauth1AuthUrl" type="text" class="form-control joint-input" data-required="true"/>
					</div>
				</div>
			</div>
		</div>
		<div class="form-group" data-userinput="true">
			<label for="oauth1RequestTokenUrl" class="col-lg-3 control-label"><fmt:message key="RequestTokenUrl"/></label>
			<div class="col-lg-5">
				<div class="row noLftRghtMargin">
					<div class="col-lg-3 col-md-3 col-sm-3 col-xs-3 noLftRghtPadding">
						<select id="oauth1RequestTokenVerb" class="form-control">
	                		<option value="GET">GET</option>
	                		<option value="POST">POST</option>
	                	</select>
					</div>
					<div class="col-lg-9 col-md-9 col-sm-9 col-xs-9 noLftRghtPadding">
						<input id="oauth1RequestTokenUrl" type="text" class="form-control joint-input" data-required="true"/>
					</div>
				</div>
			</div>
		</div>
		<div class="form-group" data-userinput="true">
			<label for="oauth1AccessTokenUrl" class="col-lg-3 control-label"><fmt:message key="AccessTokenUrl"/></label>
			<div class="col-lg-5">
				<div class="row noLftRghtMargin">
					<div class="col-lg-3 col-md-3 col-sm-3 col-xs-3 noLftRghtPadding">
						<select id="oauth1AccessTokenVerb" class="form-control">
	                		<option value="GET">GET</option>
	                		<option value="POST">POST</option>
	                	</select>
					</div>
					<div class="col-lg-9 col-md-9 col-sm-9 col-xs-9 noLftRghtPadding">
						<input id="oauth1AccessTokenUrl" type="text" class="form-control joint-input" data-required="true"/>
					</div>
				</div>
			</div>
		</div>
		<div class="form-group">
			<label for="oauth1SignatureMethod" class="col-lg-3 control-label"><fmt:message key="SignatureMethod"/></label>
			<div class="col-lg-5">
				<select id="oauth1SignatureMethod" class="form-control">
					<option value="HMACSha1"><fmt:message key="HMACSHA1"/></option>
		            <option value="Plaintext"><fmt:message key="Plaintext"/></option>
		        </select>
			</div>
		</div>
	</div>

	<div class = "authDivs oauth2Div">
		<div class="form-group">
			<label for="oauth2CallbackUrl" class="col-lg-3 control-label"><fmt:message key="CallbackUrl"/></label>
			<div class="col-lg-5">
				<p id="oauth2CallbackUrl"></p>
				<span class="help-block">Set this as the callback url in your app settings page</span>
			</div>
		</div>
		<div class="form-group oauth2PasswordGrantField" data-userinput="true">
			<label for="oauth2UserName" class="col-lg-3 control-label"><fmt:message key="UserCredentials"/></label>
			<div class="col-lg-5">
				<div class="row noLftRghtMargin">
					<div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 noLftRghtPadding">
						<input id="oauth2UserName" type="text" class="form-control" data-required="true" placeholder="Username"/>
					</div>
					<div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 noLftRghtPadding">
						<div class="inner-addon right-addon joint-input-lft-bdr">
							<i class="glyphicon glyphicon-eye-open oauth2PassowrdIcon"></i>
							<i class="glyphicon glyphicon-eye-close oauth2PassowrdIcon" style="display: None;"></i>
							<input id="oauth2UserPassword" type="password" class="form-control joint-input" placeholder="Password"/>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="form-group" data-userinput="true">
			<label for="oauth2ConsumerKey" class="col-lg-3 control-label"><fmt:message key="APIKey"/></label>
			<div class="col-lg-5">
				<input id="oauth2ConsumerKey" type="text" class="form-control" data-required="true"/>
			</div>
		</div>
		<div class="form-group" data-userinput="true">
			<label for="oauth2ConsumerSecret" class="col-lg-3 control-label"><fmt:message key="APISecret"/></label>
			<div class="col-lg-5">
				<input id="oauth2ConsumerSecret" type="text" class="form-control" data-required="true"/>
			</div>
		</div>
		<div class="form-group">
			<label for="oauth2AuthUrl" class="col-lg-3 control-label"><fmt:message key="AuthUrl"/></label>
			<div class="col-lg-5">
				<div class="row noLftRghtMargin">
					<div class="col-lg-3 col-md-3 col-sm-3 col-xs-3 noLftRghtPadding">
						<select class="form-control">
	                		<option value="GET">GET</option>
	                	</select>
					</div>
					<div class="col-lg-9 col-md-9 col-sm-9 col-xs-9 noLftRghtPadding">
						<input id="oauth2AuthUrl" type="text" class="form-control joint-input"/>
					</div>
				</div>
			</div>
		</div>
		<div class="form-group" data-userinput="true">
			<label for="oauth2AccessTokenUrl" class="col-lg-3 control-label"><fmt:message key="AccessTokenUrl"/></label>
			<div class="col-lg-5">
				<div class="row noLftRghtMargin">
					<div class="col-lg-3 col-md-3 col-sm-3 col-xs-3 noLftRghtPadding">
						<select id="oauth2AccessTokenVerb" class="form-control">
	                		<option value="GET">GET</option>
	                		<option value="POST">POST</option>
	                	</select>
					</div>
					<div class="col-lg-9 col-md-9 col-sm-9 col-xs-9 noLftRghtPadding">
						<input id="oauth2AccessTokenUrl" type="text" class="form-control joint-input" data-required="true"/>
					</div>
				</div>
			</div>
		</div>
		<div class="form-group">
			<label for="oauth2Scope" class="col-lg-3 control-label"><fmt:message key="Scope"/></label>
			<div class="col-lg-5">
				<input id="oauth2Scope" type="text" class="form-control"/>
			</div>
		</div>
		<div class='form-group'>
			<label for="authHeaders" class="col-lg-3 control-label"><fmt:message key="AuthParams" /></label>
			<div id='authHeaders' class='col-lg-5 parentHeaderDiv'>
				<div class="http-header input-group">
					<input class="header-key form-control" placeholder="Key">
					<span class="input-group-addon">-</span>
					<input class="header-value form-control joint-input" placeholder="Value">
					<span class="glyphicon input-group-addon glyphicon-plus btn-add-header joint-input"></span>
					<span class="glyphicon input-group-addon glyphicon-trash btn-remove-header"></span>
				</div>
			</div>
		</div>
		<div class="form-group">
			<label for="oauth2GrantType" class="col-lg-3 control-label"><fmt:message key="GrantType"/></label>
			<div class="col-lg-5">
				<select id="oauth2GrantType" class="form-control">
					<option value="authorization_code"><fmt:message key="AuthorizationCode"/></option>
		            <option value="client_credentials"><fmt:message key="ClientCredentials"/></option>
		            <option value="password"><fmt:message key="Password"/></option>
		        </select>
			</div>
		</div>
	</div>

	<div class="authDivs commvaultDiv">
		<div class='form-group' data-userinput="true">
			<label for="webServiceUrl" class="col-lg-3 control-label"><fmt:message key="LoginUrl" /></label>
			<div class='col-lg-5'>
				<div class="row noLftRghtMargin">
					<div class="col-lg-3 col-md-3 col-sm-3 col-xs-3 noLftRghtPadding">
						<select class="form-control">
	                		<option value="POST">POST</option>
	                	</select>
					</div>
					<div class="col-lg-9 col-md-9 col-sm-9 col-xs-9 noLftRghtPadding">
						<input type="text" id="webServiceUrl" class="form-control joint-input" data-required="true">
					</div>
				</div>
			</div>
		</div>
		<div class="form-group" data-userinput="true">
			<label for="cvAuthUserName" class="col-lg-3 control-label"><fmt:message key="UserCredentials"/></label>
			<div class="col-lg-5">
				<div class="row noLftRghtMargin">
					<div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 noLftRghtPadding">
						<input id="cvAuthUserName" type="text" class="form-control" data-required="true" placeholder="Username"/>
					</div>
					<div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 noLftRghtPadding">
						<div class="inner-addon right-addon joint-input-lft-bdr">
							<i class="glyphicon glyphicon-eye-open cvAuthPasswordIcon"></i>
							<i class="glyphicon glyphicon-eye-close cvAuthPasswordIcon" style="display: None;"></i>
							<input id="cvAuthUserPassword" type="password" class="form-control joint-input" placeholder="Password"/>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</fmt:bundle>