var uploadFile = (function() {
	var uploadedFiles = [];
	var formElm = null;
	var assignBrowse = function(container) {
		formElm = $("<form class='uploadForm' method='POST' enctype='multipart/form-data'/>");
		var inputElm = $("<input type='file' name='csvList' multiple class='uploadLinkInput' accept='.csv,.zip,.rar'/>");
		inputElm.on("change", function(changeEvent) {
			var fileList = changeEvent.target.files;
			if (typeof fileList !== "undefined" && fileList !== null
					&& fileList.length > 0) {
				formElm.trigger("submit");
			}
			changeEvent.stopPropagation();
			changeEvent.target.value = null;
			return;
		});
		formElm.append(inputElm);
		container.append(formElm);
	};
	var onInit = function() {
		assignBrowse($("#uploadLink"));
	};

	var uploadAction = function(dsId, clientId, event, fnCallBack) {
		initUpload(dsId, fnCallBack);
		event.stopPropagation();
	};

	var initUpload = function(dsId, fnCallBack) {
		formElm.ajaxForm({
			url : cvFormatters.formatString(sea.services.uploadUrl, [ dsId ]),
			success : function(resp) {
				$(sea.containerId).unmask();
				sea.services.parseResponse(resp, function(result) {
					var uploadedFiles = result;
					if (!$.isEmptyObject(uploadedFiles)) {
						var filePath = uploadedFiles[0];
						var dir = filePath.substr(0, filePath
								.lastIndexOf('\\'));
						var truncatedFilePaths = [];
						$.each(uploadedFiles, function(index, value) {
							var fileName = value
									.substr(value.lastIndexOf('\\') + 1);
							if (!fileName)
								fileName = value;
							truncatedFilePaths.push(fileName);
						});
						$("#dsCsvLocation").val(truncatedFilePaths.join("\n"));
						fnCallBack({
							uploadPath : dir
						});
					}
				}, function(errResp) {
					$("#dsCsvLocation").val("");
				});
			},
			error : function(resp) {
				$(sea.containerId).unmask();
				alert(resp);
			},
			beforeSend : function() {
				$(sea.containerId).mask("");
			}
		});
	};
	var doStartUpload = function() {

	};
	var onUploadComplete = function() {
		$("#uploadLink").removeClass("disabledActions");
		$("#dsCsvLocation").val(uploadedFiles.join("\n"));

	};
	var reset = function() {
		uploadedFiles = [];
		destPath = "";
	};
	return {
		init : onInit,
		uploadAction : uploadAction
	};
})();