var sea = sea || {};

sea.webhookController = (function() {

	var containerId = sea.containerId;

	//Id for Webhook template
	var webhookId = "#webhookDSTemplate";

	var webhookBodyId;
	var handlersData;
	var webhookCounter;

	// This is used to update the datasource when saving the webhook configuration.
	var datasourceObj;

	// function to initialize webhook component
	function init(holder, dsId, corename) {

		// setting it to 0 on page load so it increments accordingly on populating the panels.
		webhookCounter = 0;
		handlersData = {};

		// First make the call to get webhook config from the datasource properties.
		sea.services.getDataSource(corename, dsId, true, function(dsObj) {

			datasourceObj = dsObj;
			// Get all the handlers associated with the datasource.
			sea.services.getHandlers(dsId, undefined, function(resp) {
				var handlers = resp.handlerInfos;
				if (handlers !== undefined && handlers !== null) {
					$.each(handlers, function(i, handler) {
						handlersData[handler.handlerId] = handler.handlerName;
					});
				}

				if (datasourceObj.properties.dswebhookconfig === undefined) {
					// If there is no webhook config property stored in datasource properties display new webhook panel.
					addWebhook(holder);
				} else {
					// Populate the webhook panels from the config property.
					var webhookConfig = cvUtil.parseJSON(datasourceObj.properties.dswebhookconfig);
					showWebhookInputData(webhookConfig, holder);
					if (webhookCounter < 1) {
						$("#addFirstWebhook", holder).show();
					}
				}
			}, null, $(holder));
		}, null, $(holder));

		$("#saveWebhookDetails", holder).off("click").on("click", function() {
			updateDatasource(holder);
		});

		$("#addFirstWebhook", holder).off("click").on("click", function() {
			$(this).hide();
			addWebhook(holder, null, null);
		});
	}

	//gets invoked when the user clicks on the Webhooks submenu.
	var onViewWebhookPage = function(corename, dsName, dsId) {
		var $wrapper = $("<div id='webhook_wrapper' class='wrapper_class'></div>");
		$(containerId).append($wrapper);
		var idPrefix = corename + "_webhookView";
		webhookBodyId = "#" + idPrefix + "_body";
		var $webhookBody = $("<div id='" + idPrefix + "_body'></div>");

		// Toolbar with submenu nav
		var webhookHeader = uiControls.util.getTemplate("tmpl_SubMenuToolbar", "div");
		webhookHeader.attr("id", idPrefix + "_header").appendTo("#webhook_wrapper");
		var webhookToolbar = new ToolBar("#webhook_wrapper", idPrefix + "_toolbar", localMsg.WebHooks);

		// Add a separate div to have all the webhook panels under it.
		$webhookBody.appendTo("#webhook_wrapper");

		// Add a save button Div to save the changes made to Webhook.
		var $webhookFooterDiv = $("#webhookFooterDiv").clone().removeAttr('id').show();
		$webhookFooterDiv.appendTo("#webhook_wrapper");

		init(containerId, dsId, corename);
	};

	function addWebhook(holder, currentElement, cb) {
		var webhookDiv = $(webhookId).clone().removeAttr('id').show();
		if (currentElement) {
			webhookDiv.insertAfter(currentElement);
		} else {
			$(webhookBodyId, holder).append(webhookDiv);
		}

		// To minimize and maximize each webhook panel
		$(".collapse-webhook-src, .webhook-template-title", webhookDiv).off("click").on("click", function() {
			$(".webhook-inputs", webhookDiv).slideToggle("fast", "linear");
			$(".collapse-webhook-src", webhookDiv).toggle();
		});

		// On add WebHook button click
		$(".add-webhook-src", webhookDiv).off("click").on("click", function() {
			addWebhook(holder, webhookDiv);
		});

		// On remove webhook button click
		$(".remove-webhook-src", webhookDiv).off("click").on("click", function() {
			$(this).parents('.webhook-ds-template').remove();
			// Decrementing the counter on deletion of a webhook panel
			webhookCounter--;

			// If all webhooks deleted display a button to add.
			if (webhookCounter === 0) {
				$("#addFirstWebhook", holder).show();
			}
		});

		// Adding a dropdown of handlers for each webhook panel
		var options = "<option value=''>Select</option>";
		$.each(handlersData, function(key, val) {
			options += "<option value='" + key + "'>" + val + "</option>";
		});
		$('#webhookHandler', webhookDiv).append(options);

		// To use CvToggle the id for each must be unique, appending a counter to the id.
		var webconsoleToggleId = 'webconsoleUrlToggle' + webhookCounter;
		$("#webconsoleUrlToggle", webhookDiv).attr('id', webconsoleToggleId);
		$(".webconsoleToggleLabel", webhookDiv).each(function() {
			$(this).attr('for', webconsoleToggleId);
		});

		$("#" + webconsoleToggleId, webhookDiv).off('click').on('click', function() {
			$(".webconsoleToggleHint", webhookDiv).toggle();
		});

		// Incrementing the counter on addition of a webhook panel
		webhookCounter++;
		initializeAuthComponents(webhookDiv);

		// callback to populate the webhook panel after adding one.
		if (cb) {
			cb(webhookDiv);
		}
	}

	function initializeAuthComponents(holder) {

		//Not providing Oauth1 and Oauth2's Authorization Grant type in the first cut.
		$("#authType option[value='OAUTH1']", holder).remove();
		$("#oauth2GrantType option[value='authorization_code']", holder).remove();
		sea.auth.init(holder);
	}

	function getWebhookInputData(holder) {
		var webhookData = [];
		var valid = true;

		$(webhookBodyId + " .webhook-ds-template", holder).each(function(i, holderDiv) {
			var config = {};
			try {
				validateInputs($(holderDiv));
			} catch (e) {
				cvUtil.toast("Missing required field");
				valid = false;
				return false;
			}

			config.webhookUrl = $("#webhookUrl", holderDiv).val();
			config.authProperties = sea.auth.getData(holderDiv, config.webhookUrl);
			config.isWebconsoleUrl = $("#webconsoleUrlToggle" + i, holderDiv).is(":checked");
			config.handlerId = parseInt($("#webhookHandler", holderDiv).val());

			webhookData.push(config);
		});

		if (valid) {
			return webhookData;
		} else {
			return null;
		}
	}

	function validateInputs(holder) {
		var $elms = $(".form-group[data-userinput=true]", holder);
		var webhookInputsDiv = $('.webhook-inputs', holder);
		var isHidden = webhookInputsDiv.is(":hidden");

		// If the webhook panel is hidden showing it so that we can validate the inputs.
		webhookInputsDiv.show();
		var isRequired = null;

		$elms.each(function(idx, eachElm) {
			var $eachElm = $(eachElm);
			var $input = null;
			$input = $eachElm.find("input[type=text],input[type=password],input[type=number],textarea,select");
			if ($input.length === 0) {
				return;
			}
			$eachElm.removeClass("has-error");
			$input.each(function(index, eachInput) {
				var $eachInput = $(eachInput);
				isRequired = $eachInput.data("required");
				var inputVal = $.trim($eachInput.val());

				if (isRequired === true && inputVal.length === 0) {
					if (!$eachInput.is(":hidden")) {
						// If validation failed i.e missing field, hide the panel if it was hidden earlier.
						if (isHidden) {
							webhookInputsDiv.hide();
						}
						// if the panel is hidden expand the panel.
						if (webhookInputsDiv.is(":hidden")) {
							$('.collapse-webhook-src:visible', holder).trigger('click');
						}

						// scrolling to the panel where there is a validation failure.
						$('html, body').animate({
							scrollTop : holder.offset().top
						}, 'slow');

						throw new SeaException.RequiredFieldException($eachElm);
					}
				}
			});
		});

		if (isHidden) {
			webhookInputsDiv.hide();
		}
	}

	// function to populate the webhook page from the webhook configuration stored in the datasource property.
	function showWebhookInputData(webhookConfig, holder) {
		var webHooksCount = webhookConfig.length;
		for (var i = 0; i < webHooksCount; i++) {
			(function(index) {
				addWebhook(holder, null, function(holderDiv) {
					var config = webhookConfig[index];
					$("#webhookUrl", holderDiv).val(config.webhookUrl);

					// if the handler gets deleted we display no handler selected to the user on visiting this page.
					if (handlersData[config.handlerId]) {
						$("#webhookHandler", holderDiv).val(config.handlerId);
					}
					sea.auth.populateData(config.authProperties, holderDiv);
					if (config.isWebconsoleUrl) {
						$("#webconsoleUrlToggle" + index, holderDiv).trigger("click");
					}
				});
			})(i);
		}
	}

	function updateDatasource(holder) {
		getRequestObject(holder, function(resp) {
			if (resp.valid === true) {
				sea.services.createDataSource(resp.data, true, function() {
					cvUtil.toast(localMsg.DataSourceUpdated);
				}, function(resp, msg) {
					alert(msg);
				}, $(holder));
			}
		});
	}

	// function to create a request object to update datasource.
	function getRequestObject(holder, cb) {
		var reqData = {};
		var resp = {};
		resp.valid = false;

		reqData.name = datasourceObj.displayName;
		reqData.type = datasourceObj.dataSourceType;
		reqData.corename = "" + datasourceObj.coreId;
		reqData.engineId = datasourceObj.engineId;
		reqData.description = datasourceObj.description;

		var webhookProps = getWebhookInputData(holder);
		datasourceObj.properties.dswebhookconfig = JSON.stringify(webhookProps);
		reqData.properties = datasourceObj.properties;
		reqData.id = datasourceObj.datasourceId;
		reqData.operationType = sea.constants.Operations.MODIFY;

		if (webhookProps !== null) {
			resp.valid = true;
		}
		resp.data = reqData;

		cb(resp);
	}

	return {
		showWebhookPage : onViewWebhookPage
	};

})();