var sea = sea || {};

sea.util = (function() {
	var ua = window.navigator.userAgent;
	var isIE = (ua.indexOf("MSIE ") > 0);
	var isIEBelow10 = isIE && (ua.indexOf("MSIE 1") == -1);
	/*
	 * get the parameter value from the query string if query string is not passed, it gets the parameter
	 * value from URL
	 */
	var getQueryVariable = function(variable, query) {
		if (typeof query == "undefined" || query == "") {
			var searchStr = window.location.search.substring(1);
			var hashStr = window.location.hash.substring(1);
			// in case of ie, get the parameters from hash string
			if (isIE && typeof hashStr !== "undefined" && hashStr !== "") {
				query = hashStr;
				var ind = query.indexOf("?", 0);
				if (ind >= 0) {
					query = query.substring(ind + 1);
				}
			} else {
				query = searchStr;
			}
		}
		var vars = query.split('&');
		for (var i = 0; i < vars.length; i++) {
			var pair = vars[i].split('=');
			if (decodeURIComponent(pair[0]) == variable) {
				return decodeURIComponent(pair[1]);
			}
		}
	};
	var getQueryString = function(req) {
		var returnStr = "?";
		$.each(req, function(k, v) {
			returnStr += k + "=" + v + "&";
		});
		return returnStr.substring(0, returnStr.length - 1);
	};
	var getContentWithShowMoreLink = function(str, len) {
		var returnHtml = $("<div class='text-expander'>");
		if (typeof (str) === "string" && str.length > len) {
			var firstHalf = str.substring(0, len);
			var secondHalf = str.substring(len + 1);
			var firstHalfElm = $("<span class='first-half'>" + firstHalf + "</span>");
			var secondHalfElm = $("<span class='second-half' style='display:none'>" + secondHalf + "</span>");
			var ellipsisElm = $("<span class='ellipsis'>...</span>");
			var showMoreLink = $("<span class='show-more-link' data-action='show'>" + localMsg.More + "</span>");
			$(showMoreLink).click(function() {
				var container = $(this).parent();
				var action = $(this).attr("data-action");
				if (action === "show") {
					$(".second-half", container).css("display", "inline");
					$(".ellipsis", container).css("display", "none");
					$(this).text(localMsg.Less);
					$(this).attr("data-action", "hide");
				} else {
					$(".second-half", container).css("display", "none");
					$(".ellipsis", container).css("display", "inline");
					$(this).text(localMsg.More);
					$(this).attr("data-action", "show");
				}
			});
			returnHtml.append(firstHalfElm);
			returnHtml.append(secondHalfElm);
			returnHtml.append(ellipsisElm);
			returnHtml.append(showMoreLink);
		} else {
			returnHtml.append(str);
		}
		return returnHtml;
	};
	var isUrlValid = function(inputValue) {
		var urlRegex = /(ftp|http|https):\/\/(\w+:{0,1}\w*@)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%@!\-\/]))?/;
		var retVal = true;
		// need this check if an input field is not-required but we need to
		// validate
		if (inputValue && inputValue.length > 0) {
			retVal = urlRegex.test(inputValue);
		}
		return retVal;
	};
	var prependZeroForSingleDigit = function(val) {
		if (typeof (val) !== "undefined" && val != null && val < 10) {
			val = "0" + val;
		}
		return val;
	};
	var isNAN = function(inputValue) {
		var reg = new RegExp('^\\d*$');
		var retVal = true;
		if (inputValue && inputValue.length != 0) {
			retVal = reg.test(inputValue);
		}
		return retVal;
	};

	var handleError = function(message) {
		util.notify(message, true);
		return exText;
	};

	var validateInputsAndGetData = function(holder) {
		var $elms = $(".form-group[data-userinput=true]", holder);
		var dataObj = {};
		var regExp = null;
		var isRequired = null, isRequiredIf = null;
		var validate = null;
		var validationType = null;
		var multiValued = null;
		var multiValueSeparator = null;
		$elms.each(function(idx, eachElm) {
			var $eachElm = $(eachElm);
			var $input = null;
			$input = $eachElm.find("input[type=text],input[type=password],input[type=number],textarea,select");
			if ($input.length === 0) {
				return;
			}
			$eachElm.removeClass("has-error");
			$input.each(function(index, eachInput) {
				var $eachInput = $(eachInput);
				isRequired = $eachInput.data("required");
				var hiddenValidation = $eachInput.data("data-hiddenvalidation");
				var isRequiredIfId = $eachInput.data("requiredIf");
				if (isRequiredIfId) {
					isRequiredIf = holder.find("#" + isRequiredIfId).is(":checked");
				}
				validate = $eachInput.data("validate");
				validationType = $eachInput.data("validationtype"); // normalize
				multiValued = $eachInput.data("multivalued"); //
				multiValueSeparator = new RegExp($eachInput.data("multivaluedseparator")); //
				var inputId = $eachInput.attr("id");
				var inputVal = $.trim($eachInput.val());

				var valid = false;
				// check for html5 validity
				if ((typeof ($eachInput[0].checkValidity) === "function") && !$eachInput[0].checkValidity()) {
					throw new SeaException.InvalideInputException($eachElm);
				}

				if ((isRequired === true || isRequiredIf === true) && inputVal.length === 0) {
					if ($eachInput.is(":hidden")) {
						if (hiddenValidation) {
							throw new SeaException.RequiredFieldException($eachElm);
						}
					} else {
						throw new SeaException.RequiredFieldException($eachElm);
					}
				}

				if (validate === true) {
					if (multiValued) {
						inputVal = inputVal.split(multiValueSeparator);
					}
					var msg = null;
					if (validationType && validationType === "regex") {
						msg = $eachInput.data("regex-msg");
					}
					if (!validatedByType(validationType, inputVal, $eachInput.data("regex"))) {
						throw new SeaException.InvalideInputException($eachElm, msg);
					}
				}

				// if no exceptions are thrown in before checks
				valid = true;
				if (valid && inputId !== undefined) {
					dataObj[inputId] = inputVal;
				}
			});
		});
		return dataObj;
	};
	var validatedByType = function(validationType, inputVal, regExStr) {
		var retVal = null;
		switch (validationType) {
		case "url":
			for (var i = 0; i < inputVal.length; i++) {
				retVal = sea.util.isUrlValid($.trim(inputVal[i]));
			}
			return retVal;
			break;
		case "number":
			if (inputVal && inputVal.length > 0) {
				if (inputVal < 1 || inputVal > 10) {
					retVal = false;
				} else {
					retVal = !isNaN(inputVal);
				}
			} else {
				retVal = true;
			}
			break;
		case "domainUsername":
			if (inputVal && inputVal.length > 0) {
				var inputArr = inputVal.split("\\");
				if (inputArr && inputArr.length == 2) {
					retVal = true;
				} else {
					retVal = false;
				}
			}
			break;
		case "password":
			if (inputVal && inputVal.length > 6) {
				retVal = true;
			} else {
				retVal = false;
			}
		case "regex":
			var regExp = new RegExp(regExStr);
			retVal = true;
			if (regExp && !regExp.test(inputVal)) {
				retVal = false;
			}
			break;
		default:
			retVal = true;
			break;
		}
		return retVal;
	};
	var getHandlebarHtml = function(tmplId, model) {
		var source = $("#" + tmplId).html();
		var template = Handlebars.compile(source);
		return template(model);
	};
	var getLocationOrigin = function() {
		return location.origin ? location.origin : (location.protocol + "//" + location.host);
	};
	var getXmlAsString = function(xmlDom) {
		return (typeof XMLSerializer !== "undefined") ? (new window.XMLSerializer()).serializeToString(xmlDom)
				: xmlDom.xml;
	};
	var getVisulaizeLink = function(dsId, dsType, hObj) {
		return cvUtil.getContextPath() + "/reportsplus/?id=" + dsId + "&hid=" + hObj.handlerId + "&hn=" +
				hObj.handlerName + "&type=" + dsType + "&endpoint=datacube";
	};
	var getLocalizedString = function(key) {
		if (localMsg.hasOwnProperty(key)) {
			return localMsg[key];
		}
		return key;
	};
	return {
		getQueryVariable : getQueryVariable,
		getQueryString : getQueryString,
		isUrlValid : isUrlValid,
		prependZeroForSingleDigit : prependZeroForSingleDigit,
		getContentWithShowMoreLink : getContentWithShowMoreLink,
		isNAN : isNAN,
		handleError : handleError,
		validateInputsAndGetData : validateInputsAndGetData,
		getHandlebarHtml : getHandlebarHtml,
		getLocationOrigin : getLocationOrigin,
		getXmlAsString : getXmlAsString,
		getVisulaizeLink : getVisulaizeLink,
		getLocalizedString : getLocalizedString
	};

})();