function TwitterHandler() {
	this.type = sea.constants.DSTypes.TWITTER;
	this.displayName = sea.DSTypeConstants.getDSObject(this.type).dsDispName;
	this.consumerKey = null;
	this.consumerSecret = null;
	this.accessToken = null;
	this.accessTokenSecret = null;
	this.twitterAuthenticateUrl = "https://api.twitter.com/oauth/authenticate";
	this.twitterRequestTokenUrl = "https://api.twitter.com/oauth/request_token";
	this.twitterAccessTokenUrl = "https://api.twitter.com/oauth/access_token";
	this.callbackUrl = sea.util.getLocationOrigin() + cvUtil.getContextPath() + "/authcallback.do";
	this.fieldNames = null;
	this.authResponseProps = {};
}

TwitterHandler.prototype.initializeStep = function(step, holder, isEdit) {

	var self = this;
	switch (step) {
	case 2:
		if (self.fieldNames === null) {
			if (isEdit) {
				sea.services.getDSSchema(this.datasourceId, function(resp) {
					self.fieldNames = sea.schemaController.getDeleteableFields(resp.schemaFields,false,false,true);
				});
			} else {
				self.getSchemaFieldNames(holder);
			}
		}
		break;
	case 3:
		reqObj = {
			type : self.type,
			engineId : parseInt(self.dsEngine),
			properties : {
				consumerKey : self.consumerKey,
				consumerSecret : self.consumerSecret,
				accessToken : self.accessToken,
				accessTokenSecret : self.accessTokenSecret,
				metaInfoReqType : "getTrendingTopics"
			}
		};
		sea.services.getMetaInfo(reqObj, function(resp) {
			$("#showLess").hide();
			$("#showMore").show();
			var trendingTopics = null;
			var nameValues = resp.nameValueMaps.nameValues;
			for ( var i in nameValues) {
				var map = nameValues[i];
				if (map.name === "trendingTopics") {
					trendingTopics = map.values;
				}
			}
			if (trendingTopics !== null) {
				var length = trendingTopics.length, index = 0, count;
				var tableView = "<div class='table-responsive'><table class='table'>";
				while (index < length) {
					if (index < 20) {
						tableView += "<tr>";
					} else {
						tableView += "<tr class='extraTrends' style='display : none'>";
					}
					for (count = 0; count < 4; count++) {
						if (trendingTopics[index] !== undefined) {
							tableView += "<td>" + trendingTopics[index] + "</td>";
						}
						index++;
					}
					tableView += "</tr>";
				}
				tableView += "</table></div>";
				$("#trendingTopics").empty().append(tableView);

				$('#trendingTopics td').off('hover').on('hover', function () {
				    $(this).toggleClass("table-cell-hover");
				}).off('click').on('click', function() {
					$("#liveKeyword", holder).tagsinput('add', $(this).text());
				});

				$(".showMoreOrLess").off('click').on("click", function() {
					$(".showMoreOrLess").toggle("fast");
					$(".extraTrends").toggle("fast");
				});
			} else {
				$("#trendingTopics").empty().append("<p>Trending Topics Unavailable</p>");
				$("#showMore").hide();
				cvUtil.errorToast(localMsg.CouldNotGetTrendingTopics);
			}
		}, function(resp) {
			$("#trendingTopics").empty().append("<p>Trending Topics Unavailable</p>");
			$("#showMore").hide();
			cvUtil.errorToast(localMsg.CouldNotGetTrendingTopics);
		}, holder);
		break;
	}
};

TwitterHandler.prototype.getAccessTokens = function(holder, callbackurl) {
	var self = this;
	var reqData = {
		type : self.type,
		engineId : parseInt(self.dsEngine),
		properties : {
			metaInfoReqType : "getTokens",
			authProps : {
				apiKey : self.consumerKey,
				apiSecret : self.consumerSecret,
				authorizationUrl : self.twitterAuthenticateUrl,
				requestTokenVerb : "GET",
				requestTokenUrl : self.twitterRequestTokenUrl,
				accessTokenVerb : "GET",
				accessTokenUrl : self.twitterAccessTokenUrl,
				signatureMethod : "HMACSha1",
				callbackUrl : callbackurl,
				url : "https://api.twitter.com/1.1/account/verify_credentials.json",
				authType : "OAUTH1",
				oauthRequestType : "authUrlRequest"
			}
		}
	};

	sea.services.getMetaInfo(reqData, function(resp) {
		var error = true;
		if (resp !== undefined && resp.additionalInfos !== undefined && resp.additionalInfos.nameValues !== undefined) {
			self.PopulateAuthEntitiesFromResponse(resp.additionalInfos.nameValues);
			if (self.authResponseProps.authUrl !== undefined) {
				error = false;
				window.open(self.authResponseProps.authUrl, "_blank", "top=300,left=700,width=600,height=300");
				$(window).off("message").on("message", function(event) {
					var originUrl = event.originalEvent.origin + cvUtil.getContextPath() + "/authcallback.do";
					if (originUrl === self.callbackUrl) {

						reqData.properties.authProps.oauthRequestType = "authTokenRequest";
						reqData.properties.authProps.requestToken = self.authResponseProps.token;
						reqData.properties.authProps.requestTokenSecret = self.authResponseProps.tokenSecret;
						reqData.properties.authProps.oauthVerifier = event.originalEvent.data.oauthVerifier;

						sea.services.getMetaInfo(reqData, function(resp) {
							if (resp !== undefined && resp.additionalInfos !== undefined && resp.additionalInfos.nameValues !== undefined) {
								self.PopulateAuthEntitiesFromResponse(resp.additionalInfos.nameValues);
								self.accessToken = self.authResponseProps.token;
								self.accessTokenSecret = self.authResponseProps.tokenSecret;
								var loggedInUsername = self.authResponseProps.loggedInUser;

								if(loggedInUsername) {
									var userInfoDisplay = "You are logged in <a target='_blank' href='https://twitter.com/" + loggedInUsername + "'>" + loggedInUsername + "</a>";
								} else {
									var userInfoDisplay = "You are logged in";
								}
								document.getElementById("loggedInUserInfo").innerHTML = userInfoDisplay;
							}
						}, null, holder);
					}
				});
			}
		}
		if(error) {
			cvUtil.errorToast(localMsg.TwitterAppWrongConfigured);
		}
	}, null, holder);
};

TwitterHandler.prototype.PopulateAuthEntitiesFromResponse = function(nameValuesArray) {
	var self = this;
	for ( var i in nameValuesArray) {
		var map = nameValuesArray[i];
		if (map.value) {
			self.authResponseProps[map.name] = map.value;
		}
	}
};

TwitterHandler.prototype.getConsumerKeyAndSecret = function(holder) {
	var self = this;
	sea.services.getAppDetails(self.type, function(resp) {
		if (resp) {
			try {
				self.consumerKey = resp.properties[0].propertyValue;
				self.consumerSecret = resp.properties[1].propertyValue;
			} catch (e) {
				console.error(e);
				cvUtil.errorToast(localMsg.TwitterAppNotFound);
			}
		} else {
			cvUtil.errorToast(localMsg.TwitterAppNotFound);
		}
	}, null, holder);
};

TwitterHandler.prototype.initDSSpecificComponents = function(holder, isEdit, fnCallBack) {
	var self = this;
	if (!isEdit) {
		$("#crawlUser", holder).prop('checked', true);
		$("div.crawlWhatDiv").hide();
		$("div#crawlWhatDiv_profileCrawl").show();
	}

	$("input[name=crawlWhat]", holder).off("change").on("change", function() {
		$("div.crawlWhatDiv").hide();
		$("div#crawlWhatDiv_" + $(this).val()).show();
		if ($(this).val() === "liveCrawl") {
			$("input#liveKeyword").focus();
		} else {
			$("input#userScreenName").focus();
		}
	});

	var startingDate = moment().subtract(7, 'days');
	var endingDate = moment();

	$("#dateRangePicker").daterangepicker({
		startDate : startingDate,
		endDate : endingDate,
		showDropdowns : true,
		format : "YYYY-MM-DD",
		maxDate : new Date()
	}).off("keydown").on("keydown", function(e) {
		if (e.which === 8 || e.which === 46) {
			$(this).val("");
		} else {
			return false;
		}
	});
	$(".daterangepicker_start_input, .daterangepicker_end_input").hide();

	$("#hashTags").tagsinput();
	$("#liveKeyword").tagsinput();

	$(".bootstrap-tagsinput input").attr('style', 'width: 100% !important');
	$(".bootstrap-tagsinput").children().data('proceedToNextStep', false);

	self.getConsumerKeyAndSecret(holder);
	$("#twitterLoginButton").click(function() {
		self.getAccessTokens(holder, self.callbackUrl);
	});
	fnCallBack({
		"callBack" : true
	});
};

TwitterHandler.prototype.getDate = function(holder, isFromDate) {
	var dateRange = $("#dateRangePicker", holder).val();
	if (dateRange !== undefined && dateRange !== "") {
		if (isFromDate) {
			return dateRange.split(" - ")[0];
		} else {
			return dateRange.split(" - ")[1];
		}
	} else {
		return "";
	}
};

TwitterHandler.prototype.fetch = function(step, holder) {
	var fetchedData = {};
	switch (step) {
	case 1:
		fetchedData = this.fetchBasicDetails(holder);
		break;
	case 2:
		fetchedData = {
			properties : {
				consumerKey : this.consumerKey,
				consumerSecret : this.consumerSecret,
				accessToken : this.accessToken,
				accessTokenSecret : this.accessTokenSecret
			}
		};
		break;
	case 3:
		fetchedData = {
			properties : {
				isLive : $("#crawlLive", holder).is(":checked"),
				userScreenName : $("#userScreenName", holder).val(),
				fromDate : this.getDate(holder, true),
				toDate : this.getDate(holder, false),
				hashTags : $("#hashTags", holder).tagsinput('items'),
				streamingKeyword : $("#liveKeyword", holder).val(),
				always_incremental : $("#twitterIncrementalCrawl", holder).is(":checked")
			},
			dsCrawl : $("#dsCrawl", holder).is(":checked")
		};
		break;
	
	}
	this.updateProperties(fetchedData);
	return fetchedData;
};

TwitterHandler.prototype.validateStep = function(step, holder, aggregatedInput, callback, isEdit, dsObj) {

	var self = this;
	try {
		sea.util.validateInputsAndGetData(holder);
	} catch (e) {
		callback(false);
		return;
	}

	switch (step) {
	case 1:
		if (self.consumerKey === null || self.consumerSecret === null) {
			cvUtil.errorToast(localMsg.TwitterAppNotFound);
			callback(false);
		} else {
			if (!isEdit) {
				this.isDatasourceNameExists(holder, callback);
			} else {
				callback(true);
			}
		}
		break;
	case 2:
		if (self.accessToken === null || self.accessTokenSecret === null) {
			cvUtil.errorToast(localMsg.UserNotLoggedIn);
			callback(false);
		} else {
			callback(true);
		}
		break;
	case 3:
		if ($("#crawlUser", holder).is(":checked")) {
			var screenName = $("#userScreenName", holder).val();
			if (screenName !== undefined && screenName !== "") {
				callback(true);
			} else {
				cvUtil.errorToast(localMsg.UserNameNotGiven);
				callback(false);
			}
		} else {
			var liveKeyword = $("#liveKeyword", holder).val();
			if (liveKeyword !== null && liveKeyword !== undefined && liveKeyword !== "") {
				callback(true);
			} else {
				cvUtil.errorToast(localMsg.StreamingKeywordNotGiven);
				callback(false);
			}
		}
		break;
	default:
		callback(true);
		break;
	}
};

TwitterHandler.prototype.submit = function(isEdit, dsObj, holder) {
	if (!isEdit) {
		this.create(null, holder);
	} else {
		this.update(null, dsObj, holder);
	}
};

TwitterHandler.prototype.populateDSSpecificProperties = function(props, holder, onEdit) {
	var dateRange;
	if (onEdit) {
		$("div.crawlWhatDiv").hide();
		$("#twitterIncrementalCrawl", holder).attr("checked", props.always_incremental).change();
		if (props.isLive) {
			$("#crawlLive", holder).prop("checked", true);
			$("#liveKeyword", holder).tagsinput('add', props.streamingKeyword);
			$("div#crawlWhatDiv_liveCrawl").show();
		} else {
			$("#crawlUser", holder).prop("checked", true);
			$("#userScreenName", holder).val(props.userScreenName);
			if (props.fromDate !== undefined) {
				dateRange = props.fromDate + " - " + props.toDate;
				$("#dateRangePicker", holder).val(dateRange);
			}
			$("#hashTags", holder).tagsinput('add', props.hashTags.toString());
			$("div#crawlWhatDiv_profileCrawl").show();
		}
		
	} else {
		if (props.isLive) {
			$("#crawlType", holder).text(localMsg.LiveStreaming);
			$("#streamingKeywordDiv", holder).show();
			$("#keywordValue", holder).text(props.streamingKeyword);
		} else {
			$("#crawlType", holder).text(localMsg.ProfileCrawl);
			$("#userNameDiv", holder).show();
			$("#userNameValue", holder).text(props.userScreenName);
			if (props.hashTags.length > 0) {
				$("#hashTagsDiv", holder).show();
				$("#hashTagsValue", holder).text(props.hashTags.toString());
			}
			if (props.fromDate !== undefined) {
				$("#dateRangeDiv", holder).show();
				dateRange = props.fromDate + "    to    " + props.toDate;
				$("#dateRangeValue", holder).text(dateRange);
			}
		}
	}
};

TwitterHandler.prototype.getSchemaFieldNames = function(holder) {
	var self = this;
	reqObj = {
		type : self.type,
		engineId : parseInt(self.dsEngine),
		properties : {
			metaInfoReqType : "getSchemaFieldNames"
		}
	};
	sea.services.getMetaInfo(reqObj, function(resp) {
		var nameValues = resp.nameValueMaps.nameValues;
		for ( var i in nameValues) {
			var map = nameValues[i];
			if (map.name === "fieldNames") {
				self.fieldNames = map.values;
			}
		}
	}, null, holder);
};

