function SocialHandler(type) {
	this.appId = null;
	this.appSecret = null;
	this.accessToken = null;

	//Hierarchy is DataSourceHandler -> SocialHandler -> FacebookHandler
	return SocialHandler.prototype[type]();
}

SocialHandler.prototype.submit = function(isEdit, dsObj, holder) {
	//accesstoken populated by service specific code. See facebookHandler.js
	this.properties.accessToken = this.accessToken;

	if (!isEdit)
		this.create(null, holder);
	else
		this.update(null, dsObj, holder);
};

SocialHandler.prototype.facebook = function() {
	//fromPrototype is defined in datasourceHandler.js.
	return fromPrototype(SocialHandler.prototype, new FacebookHandler());
};
