var sea = sea || {};

sea.services = (function() {
	var dCubeCoreUrl = cvUtil.getContextPath() + "/server/";
	var serviceBaseUrl = cvUtil.getContextPath() + "/api/dcube/";
	var APIs = {
		GET_ENGINES : dCubeCoreUrl + "getAnalyticsEngines.do",
		GET_ANALYTICS_ENGINE_DETAILS : dCubeCoreUrl + 'getEngineDetails.do',
		GET_ANALYTICS_REPORTS : cvUtil.getContextPath() + '/server/getAnalyticsReports',
		GET_ALL_DATASOURCES : dCubeCoreUrl + "listDataSources.do",
		GET_DB_DRIVERS : dCubeCoreUrl + "getDBDrivers.do",
		GET_DATASOURCE : dCubeCoreUrl + "getDataSource.do", 
		CREATE_DATASOURCE : dCubeCoreUrl + "createDataSource.do",
		DELETE_DATASOURCE : dCubeCoreUrl + "deleteDataSource.do",
		DELETE_CRAWLED_DATA : dCubeCoreUrl + "deleteCrawledData.do",
		SCHEDULE_DATASOURCE : dCubeCoreUrl + "scheduleDataSource.do",
		GET_DS_SCHEMA : dCubeCoreUrl + "getDSSchema.do", 	
		CREATE_FIELD : dCubeCoreUrl + "createField.do",
		DELETE_FIELD : dCubeCoreUrl + "deleteField.do", 
		GET_CRAWL_HISTORY : dCubeCoreUrl + "getCrawlHistory.do", 
		GET_CRAWL_STATUS : dCubeCoreUrl + "getCrawlStatus.do", 
		CRAWL : dCubeCoreUrl + "crawl.do", 
		GET_SEARCH_VIEW : dCubeCoreUrl + "getSearchView.do", 
		CREATE_SEARCH_VIEW : dCubeCoreUrl + "createSearchView.do",
		DELETE_SEARCH_VIEW : dCubeCoreUrl + "deleteSearchView.do", 
		DO_SEARCH : serviceBaseUrl + "search/{0}/{1}", //{0} - dsIdOrCoreName, {1} - handler name
		DO_HANDLER_SEARCH : serviceBaseUrl + "handler/{0}/{1}", //{0} - handlerId, {1} - handler name
		GET_UPLOAD_INFO : dCubeCoreUrl + "getUploadInfo.do", 
		DO_UPLOAD : dCubeCoreUrl + "doUpload.do", 
		META_INFO : dCubeCoreUrl + "getMetaInfo.do",
		GET_AD_USER_SUGGESTION : dCubeCoreUrl + "getADUserSuggestion.do", 
		GET_DS_SHARE_USERS : dCubeCoreUrl + "getDataSourceShareUsers.do", 
		GET_USERS_PERMISSIONS : dCubeCoreUrl + "getUserPermissions.do", 
		ADD_DS_SHARE_USER : dCubeCoreUrl + "addDataSourceShareUser.do",
		CONFIGURE_CVDRILL_SERVER : dCubeCoreUrl + "configureCvDrillServer.do",
		SAVE_HANDLER : dCubeCoreUrl + "saveHandler.do",				
		GET_ALL_HANDLERS : dCubeCoreUrl + "getAllHandlers.do",
		DELETE_HANDLER : dCubeCoreUrl + "deleteHandler.do",
		EXECUTE_HANDLER : serviceBaseUrl + "handler/{0}/{1}", //{0} - handlerId, {1} - handlerName

		CREATE_FEDERATED : dCubeCoreUrl + "createFederatedSearch.do",		
		EXECUTE_FEDERATED : dCubeCoreUrl + "executeFederatedSearch.do",
		GET_SEARCH_PARAMS : dCubeCoreUrl + "getSearchParams.do",		

		SAVE_MY_REPORT : cvUtil.getContextPath() + "/server/saveReport.do",
		GET_REPORT_VIEW : dCubeCoreUrl + "getReportView.do", 
		SAVE_MY_REPORT : cvUtil.getContextPath() + "/server/saveReport.do",
		IS_DATASOURCE_NAME_EXISTS : dCubeCoreUrl + "isDatasourceNameExists.do",
		GET_APP_DETAILS : dCubeCoreUrl + "getAppDetails.do",
		GET_ACCESS_TOKEN_FB : dCubeCoreUrl + "getAccessTokenFB.do",
		GET_HANDLER_DYNAMIC_PARAMS : dCubeCoreUrl + "getDynamicParams.do",
		ADD_FIELD_TYPE : dCubeCoreUrl + "addFieldType.do",		
		GET_COMMCELLS: dCubeCoreUrl + "getCommcells.do",
		GET_CONTENT_ANALYZER_CLOUD: dCubeCoreUrl + "getContentAnalyzerCloud.do",
		GET_ALL_ENTITIES: dCubeCoreUrl + "getAllEntities.do",
		GET_TWITTER_OAUTH : dCubeCoreUrl + "getTwitterOAuth.do",
		GET_TWITTER_ACCESS_TOKENS : dCubeCoreUrl + "getTwitterAccessTokens.do",
		GET_ALL_CLIENTS : dCubeCoreUrl + "getAllClients.do", 
		GET_FS_INCLUDE_FILTERS : dCubeCoreUrl + "getFSIncludeFilters.do",
		GET_ALL_DATASOURCES_BASIC_INFO : dCubeCoreUrl + "getBasicDataSourcesInfo.do",
		GET_ALL_ENTITIES_BY_CATEGORY : dCubeCoreUrl + "getEntitiesByCategory.do",
		GET_PLAN_DETAILS : dCubeCoreUrl + "getPlanDetails.do", 

		//APIs which are getting used in reports 
		GET_HANDLER_SCHEMA : dCubeCoreUrl + "getHandlerSchema.do?handlerId={0}", 
		GET_HANDLERS_BASIC_INFO : dCubeCoreUrl + "getHandlersBasicInfo.do",
		GET_FEDERATED_BASIC_INFO : dCubeCoreUrl + "getFederatedBasicInfo.do",
		GET_HANLDER : dCubeCoreUrl + "getHandler.do",
		GET_FEDERATED : dCubeCoreUrl + "getFederatedSearch.do",
		GET_DEFAULT_HANDLER : dCubeCoreUrl + "getDefaultHandler.do?dsId={0}", 
		EXPORT_SEARCH_VIEW : dCubeCoreUrl + "export.do",
		GET_EXPORT_STATUS : dCubeCoreUrl + "getExportStatus.do",
		DOWNLOAD_EXPORTED : dCubeCoreUrl + "doExportDownload.do",
		
	};
	var mask = function(elm) {
		try {
			if (elm) {
				if (elm.find("div.modal").length > 0) {
					$(".okBtn", elm).attr("disabled", "disabled");
					$(".progressMsg", elm).show();
				} else {
					elm.mask("");
				}
			}
		} catch (e) {
		}
	};
	var unmask = function(elm) {
		try {
			if (elm) {
				if (elm.find("div.modal").length > 0) {
					$(".okBtn", elm).removeAttr("disabled");
					$(".progressMsg", elm).hide();
				} else {
					elm.unmask();
				}
			}
		} catch (e) {
		}
	};
	var parseResponse = function(resp, successCallback, errorCallback, elmToMask) {
		unmask(elmToMask);
		if (resp != undefined) {
			var isSuccess = true;
			var msg = undefined;
			//simplify the logic once sea impl returns the error as same as webserver impl
			var errObj = resp;
			if (resp.error || resp.errorObj) {
				errObj = resp.error || resp.errorObj;
			}
			msg = errObj.errLogMessage || errObj.errorMessage || errObj.errorMsg;
			if (errObj.errorCode && errObj.errorCode !== 0) {
				isSuccess = false;
			}
			if (isSuccess) {
				if (msg) {
					cvUtil.toast(msg);
				}
				if (resp.response) {
					resp = resp.response;
				}
				successCallback(resp);
			} else {
				if (!msg) {
					msg = localMsg.NoErrorFromServerMsg;
				}
				if (errorCallback) {
					errorCallback(resp, msg);
				} else {//show the message only if the caller didn't handle it
					alert(msg);
				}
			}
		} else {
			alert(localMsg.NoResponseErrorMsg); //have to call success callback with error object
		}
	};

	return {
		searchServerUrl : APIs.DO_SEARCH,
		searchViaHandlerUrl : APIs.DO_HANDLER_SEARCH,
		uploadUrl : APIs.DO_UPLOAD,
		parseResponse : parseResponse,
		getAllDataSources : function(type, ignoreFedSearch, cb, errCb, elmToMask) {
			mask(elmToMask);
			var xhr = cvUtil.loadPageWithGET(APIs.GET_ALL_DATASOURCES, {
				"dsType" : type,
				"ignoreFedSearch" : ignoreFedSearch
			}, function(data) {
				parseResponse(data.datasourceList, cb, errCb, elmToMask);
			});
			cvUtil.ajaxReqQueue.push(xhr);
		},
		getDataSource : function(coreName, dsId, isEdit, cb, errCb, elmToMask) {
			mask(elmToMask);
			var dsId = sea.isUseSeaServer ? coreName : dsId;
			var xhr = cvUtil.loadPageWithGET(APIs.GET_DATASOURCE,{
				dsIdOrCoreName: dsId,
				isEdit : isEdit
			}, function(data) {
				parseResponse(data, cb, errCb, elmToMask);
			});
			cvUtil.ajaxReqQueue.push(xhr);
		},

		getPlanDetails : function(planId, cb, errCb, elmToMask) {
			mask(elmToMask);
			var xhr = cvUtil.loadPageWithGET(APIs.GET_PLAN_DETAILS, {planId:planId}, function(data) {
				parseResponse(data, cb, errCb, elmToMask);
			});
						
		},
		getEntitiesByCategory : function(cb, errCb, elmToMask) {
			mask(elmToMask);
			var successFunc = function(data) {
				var resp = JSON.stringify(data);
				window.sessionStorage.setItem("entitiesList", resp);
				if (cb) {
					cb(data);
				}
			};
			var cachedEntities = window.sessionStorage.getItem("entitiesList");
			if (cachedEntities == undefined || $.isEmptyObject(cachedEntities)) {
				var xhr = cvUtil.loadPageWithGET(APIs.GET_ALL_ENTITIES_BY_CATEGORY, null, function(data) {
					parseResponse(data, successFunc, errCb, elmToMask);
				});
				
			}
			else
			{
				unmask(elmToMask);
				if(cb) {
					cb($.parseJSON(cachedEntities));
				}
			}						
		},

		getDataSourcesBasicInfo : function(dsType,handlersOnly,retriveURL, cb, errCb, elmToMask) {
			mask(elmToMask);
			var req = {
				"type" : dsType,
				"handlersOnly" : handlersOnly,
				"retrieveurl" : retriveURL
			};
			var xhr = cvUtil.loadPageWithGET(APIs.GET_ALL_DATASOURCES_BASIC_INFO, req, function(data) {
				parseResponse(data, cb, errCb, elmToMask);
			});
						
		},

		createDataSource : function(reqObj, isEdit, cb, errCb, elmToMask) {
			mask(elmToMask);
			var req = {
				"isEdit" : isEdit,
				"reqPayload" : JSON.stringify(reqObj)
			};
			var xhr = cvUtil.loadPage(APIs.CREATE_DATASOURCE, req, function(data) {
				parseResponse(data, cb, errCb, elmToMask);
			}, function(xhr, ajaxOptions, thrownError) {
				unmask(elmToMask);
			}, {
				callType : "POST",
				timeout : 610000
			//server timeout 10 mins
			});
			cvUtil.ajaxReqQueue.push(xhr);
		},
		deleteDataSource : function(reqObj, cb, errCb, elmToMask) {
			mask(elmToMask);
			var req = {				
				"reqPayload" : JSON.stringify(reqObj)
			};
			var xhr = cvUtil.loadPageWithPOST(APIs.DELETE_DATASOURCE, req, function(data) {
				parseResponse(data, cb, errCb, elmToMask);
			});
			cvUtil.ajaxReqQueue.push(xhr);
		},
		deleteCrawledData : function(reqObj, cb, errCb, elmToMask) {
			mask(elmToMask);
			var req = {				
				"reqPayload" : JSON.stringify(reqObj)
			};
			var xhr = cvUtil.loadPageWithPOST(APIs.DELETE_CRAWLED_DATA, req, function(data) {
				parseResponse(data, cb, errCb, elmToMask);
			});
			cvUtil.ajaxReqQueue.push(xhr);
		},
		getAllClients : function(indexServerId, datasourceType, cb, errCb, elmToMask) {
			var cacheKey = "clientInfo_" + indexServerId + "_" + datasourceType;
			mask(elmToMask);
			var req = {
					"datasourceType" : datasourceType,
					"indexServerId" : indexServerId
				};
			var successFunc = function(data) {
				var resp = JSON.stringify(data);
				window.sessionStorage.setItem(cacheKey, resp);
				if (cb) {
					cb(data);
				}
			};
			var cachedClientInfo = window.sessionStorage.getItem(cacheKey);
			if (cachedClientInfo === undefined || $.isEmptyObject(cachedClientInfo)) {

				var xhr = cvUtil.loadPageWithGET(APIs.GET_ALL_CLIENTS, req, function(data) {

					parseResponse(data, successFunc, errCb, elmToMask);
				});

			}
			else {
				unmask(elmToMask);
				if(cb) {
					cb($.parseJSON(cachedClientInfo));
				}
			}

			
		},
		getDBDrivers : function(engineId, coreName, cb, errCb, elmToMask) {
			mask(elmToMask);
			var key = (typeof engineId !== undefined && engineId != null) ? engineId
					: (typeof coreName !== undefined && coreName != null) ? coreName : "";
			var successFunc = function(data) {
				var drivers = cvUtil.parseJSON(data.drivers);
				var resp = JSON.stringify(drivers.sort());
				window.sessionStorage.setItem(sea.constants.DS_DRIVERS_KEY_PREFIX + key, resp);
				if (cb) {
					cb(resp);
				}
			};
			var driversFromCache = window.sessionStorage.getItem(sea.constants.DS_DRIVERS_KEY_PREFIX + key);
			if ($.isEmptyObject(driversFromCache)) {
				var req = {
					"engineIdOrCoreName" : key
				};
				var xhr = cvUtil.loadPageWithGET(APIs.GET_DB_DRIVERS, req, function(data) {
					parseResponse(data, successFunc, errCb, elmToMask);
				});
				cvUtil.ajaxReqQueue.push(xhr);
			} else {
				//console.log("Got DB drivers from session storage...");
				if (cb) {
					cb(driversFromCache);
				}
			}
		},
		getCommcells : function(reqObj, cb, errCb, elmToMask) {
			mask(elmToMask);
			var commcellId = 0;
			if(!reqObj)
				reqObj = {};
			var successFunc = function(data) {
				var resp = JSON.stringify(data);
				window.sessionStorage.setItem(sea.constants.COMMCELL, resp);
				if (cb) {
					cb(data);
				}
			};
			var errorFunc = function(data,msg) {
				if(data.error.errorCode === 1121) {
					var commcellList = JSON.stringify(data);
					window.sessionStorage.setItem(sea.constants.COMMCELL, commcellList);
				}
				if (errCb) {
					errCb(data,msg);
				}
			};
			var commcellsFromCache = $.parseJSON(window.sessionStorage.getItem(sea.constants.COMMCELL));
			if ($.isEmptyObject(commcellsFromCache)) {
				reqObj.commcellId = commcellId
				var xhr = cvUtil.loadPageWithGET(APIs.GET_COMMCELLS, reqObj, function(data) {
					parseResponse(data, successFunc, errorFunc, elmToMask);
					
				});
				cvUtil.ajaxReqQueue.push(xhr);
			}
			else
			{
				unmask(elmToMask);
				if (commcellsFromCache.commcellList === null && errCb)
					errCb(commcellsFromCache,commcellsFromCache.error.errLogMessage);
				else if(cb) {
					cb(commcellsFromCache);
				}
			}

		},
		getFSIncludeFilters : function(cb,errCb,elmToMask) {
			mask(elmToMask);			
			var successFunc = function(data) {
				var resp = JSON.stringify(data);
				window.sessionStorage.setItem("FSIncludeFilters", resp);
				cb(data);
			};
			var filtersFromCache = $.parseJSON(window.sessionStorage.getItem("FSIncludeFilters"));
			if ($.isEmptyObject(filtersFromCache)) {
			
				cvUtil.loadPageWithGET(APIs.GET_FS_INCLUDE_FILTERS,
					null,
					function(data) {
						parseResponse(data, successFunc, errCb, elmToMask);
					});
			} else {
				unmask(elmToMask);
				cb(filtersFromCache);
			}
			
		},
		getFederatedBasicInfo : function(cb, errCb, elmToMask)  {
			mask(elmToMask);
			var xhr = cvUtil.loadPageWithGET(APIs.GET_FEDERATED_BASIC_INFO,
					null,
					function(data) {
						parseResponse(data, cb, errCb, elmToMask);
					});
			cvUtil.ajaxReqQueue.push(xhr);
		},
		
		scheduleDataSource : function(reqObj, cb, errCb, elmToMask) {
			mask(elmToMask);
			var req = {
				"reqPayload" : JSON.stringify(reqObj)
			};
			var xhr = cvUtil.loadPageWithPOST(APIs.SCHEDULE_DATASOURCE, req, function(data) {
				parseResponse(data, cb, errCb, elmToMask);
			});
			cvUtil.ajaxReqQueue.push(xhr);
		},
		getDSSchema : function(dsId, cb, errCb, elmToMask) {
			mask(elmToMask);
			var req = {
				dataSourceId:dsId
			};			
			var xhr = cvUtil.loadPageWithGET(APIs.GET_DS_SCHEMA, req, function(
					data) {
				parseResponse(data, cb, errCb, elmToMask);
			});
			cvUtil.ajaxReqQueue.push(xhr);
		},
		getHandlerSchema : function(handlerId, cb, errCb, elmToMask) {
			mask(elmToMask);
			var xhr = cvUtil.loadPageWithGET(cvFormatters.formatString(APIs.GET_HANDLER_SCHEMA, [ handlerId ]),
					null,
					function(data) {
						parseResponse(data, cb, errCb, elmToMask);
					});
			cvUtil.ajaxReqQueue.push(xhr);
		},
		createField : function(reqObj, coreName, isEdit, cb, errCb, elmToMask) {
			mask(elmToMask);
			var req = {
				"isEdit" : isEdit,
				"coreName" : coreName,
				"reqPayload" : JSON.stringify(reqObj)
			};
			var xhr = cvUtil.loadPageWithPOST(APIs.CREATE_FIELD, req, function(data) {
				parseResponse(data, cb, errCb, elmToMask);
			});
			cvUtil.ajaxReqQueue.push(xhr);

		},
		deleteField : function(dsId, fieldName, cb, errCb, elmToMask) {
			mask(elmToMask);
			var req = {
				dsId:dsId,
				fieldName:fieldName
			}
			var xhr = cvUtil.loadPageWithPOST(APIs.DELETE_FIELD,
					req,
					function(data) {
						parseResponse(data, cb, errCb, elmToMask);
					});
			cvUtil.ajaxReqQueue.push(xhr);

		},
		getCrawlHistory : function(dsId, cb, errCb, elmToMask) {
			mask(elmToMask);
			var xhr = cvUtil.loadPageWithGET(APIs.GET_CRAWL_HISTORY,
					{dsId:dsId},
					function(data) {
						parseResponse(data, cb, errCb, elmToMask);
					});
			cvUtil.ajaxReqQueue.push(xhr);
		},
		crawl : function(dsId, action, cb, errCb, elmToMask) {
			mask(elmToMask);
			var xhr = cvUtil.loadPageWithPOST(APIs.CRAWL, {dsId:dsId, action:action}, function(
					data) {
				parseResponse(data, cb, errCb, elmToMask);
			});
			cvUtil.ajaxReqQueue.push(xhr);
		},
		getCrawlStatus : function(dsId, jobId, cb, errCb, elmToMask) {
			mask(elmToMask);
			var req = {
				dsId:dsId
			};
			if (jobId !== 0) {
				req.jobId = jobId;
			}
			var xhr = cvUtil.loadPageWithGET(APIs.GET_CRAWL_STATUS, req, function(data) {
						parseResponse(data, function(resp) {
							// change this once web server implementation also returns map as response
							if (resp && resp[dsId]) {
								cb(resp[dsId]);
							} else {
								cb(resp);
							}
						}, errCb, elmToMask);
					});

			cvUtil.ajaxReqQueue.push(xhr);

		},
		getEngines : function(isAll, cb, errCb, elmToMask) {
			var key = sea.constants.DS_ENGINES_KEY_PREFIX;
			mask(elmToMask);
			if (isAll) {
				key = sea.constants.DS_ALL_ENGINES_KEY_PREFIX;
			}
			var successFunc = function(data) {
				var resp = JSON.stringify(data);
				window.sessionStorage.setItem(key, resp);
				if (cb) {
					cb(data);
				}
			};
			var enginesFromCache = window.sessionStorage.getItem(key);
			if ($.isEmptyObject(enginesFromCache)) {
				var xhr = cvUtil.loadPageWithGET(APIs.GET_ENGINES, {
					"isAll" : isAll
				}, function(data) {
					parseResponse(data, successFunc, errCb, elmToMask);
				});
				cvUtil.ajaxReqQueue.push(xhr);
			} else {
				//console.log("Got engines from session storage...");
				if (cb) {
					cb(JSON.parse(enginesFromCache));
				}
			}
		},
		getEngineDetails : function(cloudId, type, cb, errCb, elmToMask) {
			mask(elmToMask);
			var req = {};
			if (typeof cloudId !== undefined) {
				req.cloudId = cloudId;

			}
			if (type) {
				req.type = type;
			}
			cvUtil.loadPageWithGET(APIs.GET_ANALYTICS_ENGINE_DETAILS, req, function(engineDetails) {
				var error = engineDetails.error;
				if (error && error.errorCode > 0) {
					cvUtil.errorToast(error.errLogMessage);
				} else {
					parseResponse(engineDetails, cb, errCb, elmToMask);
				}
			});
		},
		getAnalyticsReports : function(cloudId, cb, errCb, elmToMask) {
			mask(elmToMask);
			cvUtil.loadPageWithGET(APIs.GET_ANALYTICS_REPORTS, {
				"cloudId" : cloudId
			}, function(data) {
				parseResponse(data, cb, errCb, elmToMask);
			});
		},
		getSearchView : function(dsId, viewId, cb, errCb, elmToMask) {
			mask(elmToMask);
			var req = {
				dsId:dsId
			};
			if (typeof viewId !== undefined) {
				req.viewId = viewId;
			}
			var xhr = cvUtil.loadPageWithGET(APIs.GET_SEARCH_VIEW, req, function(
					data) {
				parseResponse(data, cb, errCb, elmToMask);
			});
			cvUtil.ajaxReqQueue.push(xhr);
		},
		saveSearchView : function(dsId, reqObj, cb, errCb, elmToMask) {
			mask(elmToMask);
			var req = {
				"dsId" : dsId,
				"searchViewName" : reqObj.searchViewName,
				"viewInfo" : JSON.stringify(reqObj.viewInfo)
			};
			if (reqObj.viewId) {
				req.viewId = reqObj.viewId;
			}
			if (reqObj.attribute) {
				req.attribute = reqObj.attribute;
			}
			var xhr = cvUtil.loadPageWithPOST(APIs.CREATE_SEARCH_VIEW, req, function(data) {
				parseResponse(data, cb, errCb, elmToMask);
			});
			cvUtil.ajaxReqQueue.push(xhr);
		},
		deleteSearchView : function(dsId, viewId, cb, errCb, elmToMask) {
			mask(elmToMask);
			var req = {
				dsId:dsId
			};
			if (viewId) {
				req.viewId = viewId;
			}
			var xhr = cvUtil.loadPageWithPOST(APIs.DELETE_SEARCH_VIEW,
					req,
					function(data) {
						parseResponse(data, cb, errCb, elmToMask);
					});
			cvUtil.ajaxReqQueue.push(xhr);
		},
		getUploadInfo : function(dsId, cb, errCb, elmToMask) {
			mask(elmToMask);
			var xhr = cvUtil.loadPageWithGET(APIs.GET_UPLOAD_INFO, {dsId:dsId}, function(
					data) {
				parseResponse(data, cb, errCb, elmToMask);
			});
			cvUtil.ajaxReqQueue.push(xhr);
		},
		getMetaInfo : function(reqObj, cb, errCb, elmToMask) {
			mask(elmToMask);
			var req = {
				"reqPayload" : JSON.stringify(reqObj)
			};
			var xhr = cvUtil.loadPageWithPOST(APIs.META_INFO, req, function(data) {
				parseResponse(data, cb, errCb, elmToMask);
			});
			cvUtil.ajaxReqQueue.push(xhr);
		},
		getADUserSuggestion : function(name, cb) {
			var xhr = cvUtil.loadPageWithGET(APIs.GET_AD_USER_SUGGESTION,{name:name},
					function(data) {
						parseResponse(data, cb, null, null);
					});
			cvUtil.ajaxReqQueue.push(xhr);
		},
		getDataSourceShareUsers : function(dsId, type, cb, errCb, elmToMask) {
			mask(elmToMask);
			var req = {
				dsId: dsId,
				type: type
			}
			var xhr = cvUtil.loadPageWithGET(APIs.GET_DS_SHARE_USERS,
					req,
					function(data) {
						parseResponse(data, cb, errCb, elmToMask);
					});
			cvUtil.ajaxReqQueue.push(xhr);
		},
		getUserPermissions : function(dsId, type, cb, errCb, elmToMask) {
			mask(elmToMask);
			var req = {
				dsId: dsId,
				type: type
			}
			var xhr = cvUtil.loadPageWithGET(APIs.GET_USERS_PERMISSIONS,
					req,
					function(data) {
						parseResponse(data, cb, errCb, elmToMask);
					});
			cvUtil.ajaxReqQueue.push(xhr);
		},
		addDataSourceShareUser : function(reqObj, cb, errCb, elmToMask) {
			mask(elmToMask);
			var req = {
				"reqPayload" : JSON.stringify(reqObj)
			};
			var xhr = cvUtil.loadPageWithPOST(APIs.ADD_DS_SHARE_USER, req, function(data) {
				parseResponse(data, cb, errCb, elmToMask);
			});
			cvUtil.ajaxReqQueue.push(xhr);
		},
		configureSqlAccess : function(reqObj, cb, errCb, elmToMask) {
			mask(elmToMask);
			var xhr = cvUtil.loadPageWithPOST(APIs.CONFIGURE_CVDRILL_SERVER, reqObj, function(data) {
				parseResponse(data, cb, errCb, elmToMask);
			}, function(xhr, ajaxOptions, thrownError) {
				unmask(elmToMask);
			});
			cvUtil.ajaxReqQueue.push(xhr);
		},

		saveHandler : function(reqObj, cb, errCb, elmToMask) {
			mask(elmToMask);
			var req = {
				"reqPayload" : JSON.stringify(reqObj)
			};
			var xhr = cvUtil.loadPageWithPOST(APIs.SAVE_HANDLER, req, function(data) {
				parseResponse(data, cb, errCb, elmToMask);
			});
			cvUtil.ajaxReqQueue.push(xhr);
		},
		getHandlersBasicInfo : function(dsId, handlerId, cb, errCb, elmToMask) {
			mask(elmToMask);
			var req = {};
			if (dsId != undefined) {
				req.dataSourceId = dsId;
			}
			if (handlerId != undefined) {
				req.handlerId = handlerId;
			}

			var xhr = cvUtil.loadPageWithGET(APIs.GET_HANDLERS_BASIC_INFO, req, function(data) {

				parseResponse(data, cb, errCb, elmToMask);
			});

			cvUtil.ajaxReqQueue.push(xhr);
		},
		getHandlers : function(dsId, handlerId, cb, errCb, elmToMask) {

			mask(elmToMask);
			var req = {};
			if (dsId != undefined) {
				req.dataSourceId = dsId;
			}
			if (handlerId != undefined) {
				req.handlerId = handlerId;
			}

			var xhr = cvUtil.loadPageWithGET(APIs.GET_HANLDER, req, function(data) {

				parseResponse(data, cb, errCb, elmToMask);
			});

			cvUtil.ajaxReqQueue.push(xhr);
		},

		deleteHandler : function(handlerId, cb, errCb, elmToMask) {
			mask(elmToMask);
			var req = {};
			if (typeof handlerId !== undefined) {
				req.handlerId = handlerId;
			}

			var xhr = cvUtil.loadPageWithPOST(APIs.DELETE_HANDLER,
					req,
					function(data) {
						parseResponse(data, cb, errCb, elmToMask);
					});
			cvUtil.ajaxReqQueue.push(xhr);
		},

		executeHandler : function(handlerId, handlerName, req, cb, errCb, elmToMask) {
			mask(elmToMask);
			var xhr = cvUtil.loadPageWithGET(cvFormatters
					.formatString(APIs.EXECUTE_HANDLER, [ handlerId, handlerName ]), req, function(data) {
				unmask(elmToMask);
				cb(data);
			});
			cvUtil.ajaxReqQueue.push(xhr);
		},

		createFederatedSearch : function(reqObj, isEdit, cb, errCb, elmToMask) {
			mask(elmToMask);
			var req = {
				"reqPayload" : JSON.stringify(reqObj),
				"isEdit" : isEdit
			};
			var xhr = cvUtil.loadPageWithPOST(APIs.CREATE_FEDERATED, req, function(data) {
				parseResponse(data, cb, errCb, elmToMask);
			});
			cvUtil.ajaxReqQueue.push(xhr);
		},

		getFederatedSearch : function(datasourceId, cb, errCb, elmToMask) {
			mask(elmToMask);
			var req = {
				"datasourceId" : datasourceId
			};

			var xhr = cvUtil.loadPageWithGET(APIs.GET_FEDERATED, req, function(data) {
				parseResponse(data, cb, errCb, elmToMask);
			});
			cvUtil.ajaxReqQueue.push(xhr);
		},

		executeFederatedSearch : function(fedId, fedName, cb, errCb, elmToMask) {
			mask(elmToMask);
			var req = {
				federateSearchId : fedId,
				federateSearchName : fedName
			};
		},

		getSearchParams : function(cb, errCb, elmToMask) {
			var dfr = $.Deferred();
			mask(elmToMask);
			var xhr = cvUtil.loadPageWithGET(APIs.GET_SEARCH_PARAMS, null, function(data) {
				parseResponse(data, cb, errCb, elmToMask);
				dfr.resolve();
			});
			cvUtil.ajaxReqQueue.push(xhr);
			return dfr.promise();
		},

		getDefaultHandler : function(dsId, cb, errCb, elmToMask) {
			var req = {};
			var xhr = cvUtil.loadPageWithGET(cvFormatters.formatString(APIs.GET_DEFAULT_HANDLER, [ dsId ]),
					null,
					function(data) {
						parseResponse(data, cb, errCb, elmToMask);
					});
			cvUtil.ajaxReqQueue.push(xhr);
		},
		saveMyReport : function(reqObj, cb, errCb, elmToMask) {
			mask(elmToMask);
			var req = {
				"reportJson" : JSON.stringify(reqObj),
				"isPreview" : false
			};
			var xhr = cvUtil.loadPageWithPOST(APIs.SAVE_MY_REPORT, req, function(data) {
				unmask(elmToMask);
				var resp = $.parseJSON(data);
				var newWindow = window.open(cvUtil.getContextPath() + "/reportsplus/index.jsp?reportId=" +
						resp.report.customReportId, "_blank");
				//newWindow.focus();
				//window.location = "reportsplus/index.jsp?reportId="+resp.report.customReportId;
			});
			cvUtil.ajaxReqQueue.push(xhr);
		},
		getReportView : function(dsId, viewId, cb, errCb, elmToMask) {
			mask(elmToMask);
			var req = {
				dsId:dsId
			};
			if (typeof viewId !== undefined) {
				req.viewId = viewId;
			}
			var xhr = cvUtil.loadPageWithGET(APIs.GET_REPORT_VIEW, req, function(
					data) {
				parseResponse(data, cb, errCb, elmToMask);
			});
			cvUtil.ajaxReqQueue.push(xhr);
		},

		isDatasourceNameExists : function(dsName, cb, errCb, elmToMask) {
			mask(elmToMask);
			var req = {
				datasourceName : dsName
			};

			var xhr = cvUtil.loadPageWithGET(APIs.IS_DATASOURCE_NAME_EXISTS, req, function(data) {
				parseResponse(data, cb, errCb, elmToMask);
			});
			cvUtil.ajaxReqQueue.push(xhr);
		},

		getAppDetails : function(type, cb, errCb, elmToMask) {
			mask(elmToMask);
			var req = {
				datasourceType : type
			};
			var xhr = cvUtil.loadPageWithGET(APIs.GET_APP_DETAILS, req, function(data) {
				parseResponse(data, cb, errCb, elmToMask);
			});
			cvUtil.ajaxReqQueue.push(xhr);
		},

		getAccessTokenFB : function(appId, appSecret, oAuthToken, cb, errCb, elmToMask) {
			mask(elmToMask);
			var req = {
				"appId" : appId,
				"appSecret" : appSecret,
				"oAuth" : oAuthToken
			};

			var xhr = cvUtil.loadPageWithPOST(APIs.GET_ACCESS_TOKEN_FB, req, function(data) {
				parseResponse(data, cb, errCb, elmToMask);
			});
			cvUtil.ajaxReqQueue.push(xhr);
		},

		exportSearchView : function(handlerId, reqObj, cb, errCb, elmToMask) {
			mask(elmToMask);

			var req = {
				"handlerId" : handlerId,
				"reqPayload" : JSON.stringify(reqObj)
			};

			var xhr = cvUtil.loadPageWithPOST(APIs.EXPORT_SEARCH_VIEW, req, function(data) {
				parseResponse(data, cb, errCb, elmToMask);
			});
			cvUtil.ajaxReqQueue.push(xhr);
		},

		getExportStatus : function(handlerId, token, cb, errCb, elmToMask) {
			mask(elmToMask);

			var xhr = cvUtil.loadPageWithGET(APIs.GET_EXPORT_STATUS, {
				handlerId : handlerId,
				token : token
			}, function(data) {
				parseResponse(data, cb, errCb, elmToMask);
			});
			cvUtil.ajaxReqQueue.push(xhr);
		},

		exportSearchView : function(handlerId, reqObj, cb, errCb, elmToMask) {
			mask(elmToMask);

			var req = {
				"handlerId" : handlerId,
				"reqPayload" : JSON.stringify(reqObj)
			};

			cvUtil.loadPageWithPOST(APIs.EXPORT_SEARCH_VIEW, req, function(data) {
				parseResponse(data, cb, errCb, elmToMask);
			});
		},

		downloadExported : function(downloadGuid, cb, errCb, elmToMask) {
			mask(elmToMask);
			var req = {
				"downloadGuid" : downloadGuid
			};

			cvUtil.loadPageWithGET(APIs.DOWNLOAD_EXPORTED, req, function(data) {
				parseResponse(data, cb, errCb, elmToMask);
			});
		},

		addFieldType : function(datasourceId, reqObj, cb, errCb, elmToMask) {
			mask(elmToMask);

			var req = {
				"datasourceId" : datasourceId,
				"reqPayload" : JSON.stringify(reqObj)
			};

			return cvUtil.loadPageWithPOST(APIs.ADD_FIELD_TYPE, req, function(data) {
				parseResponse(data, cb, errCb, elmToMask);
			});
		},
		getDynamicHandlerParams : function(cb, errCb, elmToMask) {
			var xhr = cvUtil.loadPageWithGET(APIs.GET_HANDLER_DYNAMIC_PARAMS, null, function(data) {
				parseResponse(data, cb, errCb, elmToMask);
			});
			cvUtil.ajaxReqQueue.push(xhr);
		},
		getContentAnalyzerCloud : function(cb, errCb, elmToMask) {
			mask(elmToMask);
			var successFunc = function(data) {
				var resp = JSON.stringify(data);
				window.sessionStorage.setItem("contentAnalyzerCloudsList", resp);
				if (cb) {
					cb(data);
				}
			};
			var cachedClouds = window.sessionStorage.getItem("contentAnalyzerCloudsList");
			if (cachedClouds == undefined || $.isEmptyObject(cachedClouds)) {
				var xhr = cvUtil.loadPageWithGET(APIs.GET_CONTENT_ANALYZER_CLOUD, null, function(data) {
					parseResponse(data, successFunc, errCb, elmToMask);
				});
				cvUtil.ajaxReqQueue.push(xhr);
			}
			else
			{
				unmask(elmToMask);
				if(cb) {
					cb($.parseJSON(cachedClouds));
				}
			}
		},
		getAllEntities: function(cb, errCb, elmToMask){
			mask(elmToMask);
			var successFunc = function(data) {
				var resp = JSON.stringify(data);
				window.sessionStorage.setItem("entitiesList", resp);
				if (cb) {
					cb(data);
				}
			};
			var cachedEntities = window.sessionStorage.getItem("entitiesList");
			if (cachedEntities == undefined || $.isEmptyObject(cachedEntities)) {
				var xhr = cvUtil.loadPageWithGET(APIs.GET_ALL_ENTITIES, null, function(data) {
					parseResponse(data, successFunc, errCb, elmToMask);
				});
				cvUtil.ajaxReqQueue.push(xhr);
			}
			else
			{
				unmask(elmToMask);
				if(cb) {
					cb($.parseJSON(cachedEntities));
				}
			}
			
		},
		getTwitterOAuth : function(consumerKey, consumerSecret, callbackurl, cb, errCb, elmToMask) {
			mask(elmToMask);
			var req = {
				consumerKey : consumerKey,
				consumerSecret : consumerSecret,
				callbackUrl : callbackurl
			};

			var xhr = cvUtil.loadPageWithGET(APIs.GET_TWITTER_OAUTH, req, function(data) {
				parseResponse(data, cb, errCb, elmToMask);
			});
			cvUtil.ajaxReqQueue.push(xhr);
		},
		getTwitterAccessTokens : function(oauthToken, oauthVerifier, cb, errCb, elmToMask) {
			mask(elmToMask);
			var req = {
				oauth_token : oauthToken,
				oauth_verifier : oauthVerifier
			};

			var xhr = cvUtil.loadPageWithGET(APIs.GET_TWITTER_ACCESS_TOKENS, req, function(data) {
				parseResponse(data, cb, errCb, elmToMask);
			});
			cvUtil.ajaxReqQueue.push(xhr);
		}
	};
})();
