 var sea = sea || {};

//https://gist.github.com/timvasil/5210649
(function($) {
	var re = /([^&=]+)=?([^&]*)/g;
	var decode = function(str) {
		return decodeURIComponent(str.replace(/\+/g, ' '));
	};
	$.parseParamsWithDuplicates = function(query) {
		var params = {}, e;
		if (query) {
			if (query.substr(0, 1) == '?') {
				query = query.substr(1);
			}

			while (e = re.exec(query)) {
				var k = decode(e[1]);
				var v = encodeURIComponent(decode(e[2]));
				if (params[k] !== undefined) {
					if (!$.isArray(params[k])) {
						params[k] = [params[k]];
					}
					params[k].push(v);
				} else {
					params[k] = v;
				}
			}
		}
		return params;
	};
})(jQuery);

//(function(factory) {
//var getDependencyMissingMsg = function(dependency) {
//return "cvShortcut depends on " + dependency
//+ " and seems to be missing. Please include necessary files.";
//};
//if (!jQuery)
//throw getDependencyMissingMsg('jQuery');
//else
//factory(jQuery);

//}(function($) {
//"use strict";

//$.fn.cvShortcut = function(keyList, callback) {
//return this.each(function() {
//var $this = $(this), data = $this.data('cvShortcut');
//if (!data)
//$this.data('cvShortcut', new CvShortcut(this, keyList, callback));
//});
//};
//}));

///*Inspired by
//http://stackoverflow.com/questions/5203407/javascript-multiple-keys-pressed-at-once
//keyList is an array that contains the keys that should be held down to
//trigger the callback
//Right now supports only one key combination*/
//CvShortcut = function(element, keyList, callback){
//this.map = [];
//this.$element = $(element);
//this.callback = callback;
//this.keyList = keyList;
//var self = this;
//this.$element.on('keydown', function(e){
//self.map[e.keyCode] = true;
//self.checkKeyList(e);
//});
//this.$element.on('keyup', function(e){
//self.map[e.keyCode] = false;
//});
//};

//CvShortcut.prototype.checkKeyList = function(e){
//for(var i=0; i<this.keyList.length; i++){
//if(this.map[this.keyList[i]] != true)
//return;
////If any one of the keys in keyList other than the current key is pressed,
//prevent
////the default behavior of the current key
////Also, we don't want to prevent default behavior of alphabets or numbers
//else if(this.keyList[i] != e.keyCode && (e.keyCode < 48 || e.keyCode > 90 ||
//e.keyCode == 32))
//e.preventDefault();

//}
//this.callback();
//};

sea.searchApiController = (function(){

	var containerId = sea.containerId;
	var hvTableId = "";
	var handlerDTConfig = {
			"dom" : 'J<"pull-left"f><"pull-right"l><"clearfix">t<"pull-left"i><"pull-right"p><"clearfix">',
			"order" : [ ]
	};
	var columnList = [];
	var constants = {
			CREATE_FORM: "handler_create_wrapper",
			HANDLER: "handler",
			PARAM_WRAPPER: "param-wrapper",
			PARAM_INPUT_WRAPPER: "param-input-wrapper",
			PARAM_INPUT: "param-input",
			PARAMETER_VAL: "parameter-val",
			PARAMETER_KEY: "parameter-key",
			PARAMETER_CONTAINER: "parameter-container",
			PARAMETER_CONTAINER_INPUT: "parameter-container-input",
			CONTAINER_HEADINGS: "container-headings",
			ADDITIONAL_FIELDS: "additional-fields",
			CONTAINER_HEADING: "container-heading"
	};

	var attachTextInputListener = function($element){
		$element.off("input").on("input", function(){
			if($(this).val().length == 0) {
				return;
			}
			var $holder = $(this).parent().siblings("." + constants.PARAMETER_CONTAINER);
			if(!hasSelectedContainer($holder)){selectContainer(sea.handlerConstants.Containers.DEFAULT, $holder);}
		});
	};

	var attachBooleanInputListener = function($element){
		$element.off("change").on("change", function(){
			var $holder = $(this).parent().siblings("." + constants.PARAMETER_CONTAINER);
			if(!hasSelectedContainer($holder)){selectContainer(sea.handlerConstants.Containers.DEFAULT, $holder);}
		});
	};

	var flSelectCallback = function($select){
		var selected = $("option:selected", $select);
		var $holder = $select.parent().siblings("." + constants.PARAMETER_CONTAINER);
		if(selected.length > 0 && !hasSelectedContainer($holder)){
			selectContainer(sea.handlerConstants.Containers.DEFAULT, $holder);
		}
	};

	//If these are coming from the server, use $.extend to make sure that values from the server
	//take precedence over these default ones.
	var defaultRequiredParams = {
			df: {
				dispName: "Default Search Field",
				paramName: "df",
				helpText: localMsg.DfHelpText,
				isMultiValued: false,
				inputType: sea.handlerConstants.InputTypes.TEXT,
				possibleContainers: [sea.handlerConstants.Containers.DEFAULT, sea.handlerConstants.Containers.INVARIANT]
			},
			q: {
				dispName: "Default Search Keyword",
				isMultiValued: false,
				defaultValue: "*:*",
				defaultContainer:  sea.handlerConstants.Containers.DEFAULT,
				paramName: "q",
				helpText: localMsg.QHelpText,
				inputType: sea.handlerConstants.InputTypes.TEXT,
				possibleContainers: [sea.handlerConstants.Containers.DEFAULT]
			},
			fl: {
				dispName: "Column Names",
				isMultiValued: false,
				paramName: "fl",
				helpText: localMsg.FlHelpText,
				inputType: sea.handlerConstants.InputTypes.COMBO,
				possibleValuesAjax: function(dsId, cb){
					var dfr = $.Deferred();

					sea.services.getDSSchema(dsId, function(resp){
						var schemaFields = sea.schemaController.getDeleteableFields(resp.schemaFields, true);
						var comboList = [];
						$.each(schemaFields, function(i, field){
							comboList.push(field.fieldName);
						});
						comboList.sort(function(str1, str2){
							return str1.localeCompare(str2);
						});
						//scroll up to see this variable declared
						columnList = columnList.concat(comboList);
						//Using 'this' won't work here
						defaultRequiredParams.fl.possibleValues = comboList;
						if(typeof cb === "function"){cb(comboList);}
						dfr.resolve();
					}, null, $(containerId));
					return dfr.promise();
				},
				postProcess: function($select){
					$select.attr('multiple', 'multiple');
					$select.multiselect({
						maxHeight: 300,
						includeSelectAllOption: true,
						numberDisplayed: 0,
						enableFiltering: true,
						enableCaseInsensitiveFiltering: true,
						templates: {
							filterClearBtn : "",
							button: '<button type="button" class="multiselect dropdown-toggle btn btn-default form-control" data-toggle="dropdown" title="None selected">' +
							'<span class="multiselect-selected-text"></span><div class="pull-right"><b class="caret"></b></div></button>'
						},
						onChange: function(){
							flSelectCallback($select);
						},
						onSelectAll: function(){
							flSelectCallback($select);
						}
					});
					$select.multiselect('deselectAll', false);
					$select.multiselect('rebuild');

					//Hacking bootstrap-multiselect so that it won't break our layout
					var btnGroup = $select.siblings(".btn-group");
					btnGroup.removeClass("btn-group");
					btnGroup.find(".multiselect.dropdown-toggle").addClass("form-control");
				},
				possibleContainers: [sea.handlerConstants.Containers.DEFAULT, sea.handlerConstants.Containers.APPEND, sea.handlerConstants.Containers.INVARIANT]
			},
			fq: {
				dispName: "Filter Criteria",
				isMultiValued: true,
				paramName: "fq",
				helpText: localMsg.FqHelpText,
				inputType: sea.handlerConstants.InputTypes.TEXTAREA,
				possibleContainers: [sea.handlerConstants.Containers.DEFAULT, sea.handlerConstants.Containers.APPEND, sea.handlerConstants.Containers.INVARIANT],
				delimiter: "\n"
			},
			sort: {
				dispName: "Sort By",
				isMultiValued: false,
				paramName: "sort",
				helpText: localMsg.SortHelpText,
				inputType: sea.handlerConstants.InputTypes.TEXT,
				possibleContainers: [sea.handlerConstants.Containers.DEFAULT, sea.handlerConstants.Containers.INVARIANT]
			},
			facet: {
				dispName: "Facet",
				paramName: "facet",
				helpText: localMsg.FacetHelpText,
				isMultiValued: false,
				inputType: sea.handlerConstants.InputTypes.BOOLEAN,
				possibleContainers: [sea.handlerConstants.Containers.DEFAULT, sea.handlerConstants.Containers.INVARIANT]
			},
			"facet.field": {
				dispName: "Facets Field",
				paramName: "facet.field",
				helpText: localMsg.FacetFieldHelpText,
				isMultiValued: true,
				inputType: sea.handlerConstants.InputTypes.TEXTAREA,
				possibleContainers: [sea.handlerConstants.Containers.APPEND, sea.handlerConstants.Containers.INVARIANT],
				delimiter: ","
			},
			"facet.query":{
				dispName: "Facets Query",
				helpText: localMsg.FacetQueryHelpText,
				paramName: "facet.query",
				isMultiValued: true,
				inputType: sea.handlerConstants.InputTypes.TEXTAREA,
				possibleContainers: [sea.handlerConstants.Containers.DEFAULT, sea.handlerConstants.Containers.APPEND, sea.handlerConstants.Containers.INVARIANT],
				delimiter: ","
			},
			rows: {
				dispName: "Count",
				defaultValue: 10,
				defaultContainer:  sea.handlerConstants.Containers.DEFAULT,
				isMultiValued: false,
				paramName: "rows",
				helpText: localMsg.RowsHelpText,
				inputType: sea.handlerConstants.InputTypes.NUMBER,
				defaultContainer:  sea.handlerConstants.Containers.DEFAULT,
				possibleContainers: [sea.handlerConstants.Containers.DEFAULT, sea.handlerConstants.Containers.INVARIANT]
			},

			wt: {
				dispName: "Response Type",
				paramName: "wt",
				defaultValue: "json",
				helpText: localMsg.WtHelpText,
				possibleValues: ["csv", "json", "xml"],
				isMultiValued: false,
				inputType: sea.handlerConstants.InputTypes.COMBO,
				defaultContainer:  sea.handlerConstants.Containers.DEFAULT,
				possibleContainers: [sea.handlerConstants.Containers.DEFAULT, sea.handlerConstants.Containers.INVARIANT]
			},
			Raw: {
				dispName: "Raw Query",
				isMultiValued: true,
				helpText: localMsg.RawHelpText,
				paramName: "Raw",
				placeholder: "key1=val1&key2=val2",
				inputType: sea.handlerConstants.InputTypes.TEXTAREA,
				possibleContainers: [sea.handlerConstants.Containers.DEFAULT, sea.handlerConstants.Containers.APPEND, sea.handlerConstants.Containers.INVARIANT],
				delimiter: "\n"
			}
	};


	var collapsedFields = [defaultRequiredParams.wt.paramName, defaultRequiredParams.Raw.paramName, defaultRequiredParams.rows.paramName];

	//Gets called when the user presses the 'Handlers' button in the left submenu
	var onViewAllHandlers = function(coreName, dsName, dsId, dsType){
		var $wrapper = $("<div id='handler_wrapper' class='wrapper_class'></div>");
		$(containerId).append($wrapper);
		var idPrefix = coreName + "_handlersView";
		// hv - handlers view
		// Toolbar with submenu nav
		var headerToolBar = uiControls.util.getTemplate("tmpl_SubMenuToolbar", "div");
		headerToolBar.attr("id", idPrefix + "_header").appendTo("#handler_wrapper");
		var hvToolBar = new ToolBar("#handler_wrapper", idPrefix + "_toolbar", localMsg.Handlers);
		var hvContainerId = idPrefix + "_container";
		hvTableId = idPrefix + "_dt";
		$("<div id='" + hvContainerId + "'></div>").appendTo("#handler_wrapper");
		$(uiControls.util.getDataTableHtml(hvTableId, sea.ColumnConfiguration.handlerViewConfig)).appendTo("#" +
				hvContainerId);
		$("#" + hvTableId).on("click", 'button.handlerEditLink', function(event){
			var table = $("#" + hvTableId).DataTable();
			var data = table.row($(this).parents('tr')).data();
			onEditHandlerClicked(coreName,
					dsName,
					dsId,
					data.handlerId,
					data.handlerName,
					dsType);
		});

    $("#" + hvTableId).on("click", 'button.btnDelete', function(){
      var table = $("#" + hvTableId).DataTable();
      var data = table.row($(this).parents('tr')).data();
      onDeleteHandlerBtnClicked(coreName,
          dsName,
          dsId,
          data.handlerId,
          data.handlerName,
          dsType);
    });

    $("#" + hvTableId).on("click", 'button.btnShare', function(){
        var table = $("#" + hvTableId).DataTable();
        var data = table.row($(this).parents('tr')).data();
        onShareHandlerBtnClicked(coreName,
            dsName,
            dsId,
            data.handlerId,
            data.handlerName,
            dsType);
      });
    // visualize in custom reports
    $("#" + hvTableId).on("click", 'button.btnVisualize', function(){
        var table = $("#" + hvTableId).DataTable();
        var data = table.row($(this).parents('tr')).data();
        window.location = sea.util.getVisulaizeLink(dsId, dsType, data);
      });

    $("#" + hvTableId).on("click", "button.btnExecute", function(){
      var table = $("#" + hvTableId).DataTable();
      var data = table.row($(this).parents('tr')).data();
      onExecuteHandlerBtnClicked(
        data.handlerId,
        data.handlerName
        );
    });

    $("#" + hvTableId).on("click", "button.btnRest", function(){
      var table = $("#" + hvTableId).DataTable();
      var data = table.row($(this).parents('tr')).data();
      onRestAPIBtnClicked(
        data.handlerId,
        data.handlerName
        );
    });

    hvToolBar.addButton(getCreateNewHandlerButton(coreName, dsName, dsId, dsType));
    sea.services.getHandlers(dsId, undefined, function(resp){
     var handlers = resp.handlerInfos;
      var hvList = [];
      if(handlers != null){
        $.each(handlers, function(i, handler){
          hvList.push({
            dataSourceId: dsId,
            handlerId: handler.handlerId,
            handlerName: handler.handlerName
          });
        });
      }
      showHandlerDataTable(coreName, dsName, dsId, dsType, hvList);

    }, null, $(containerId));
  };

  var onDeleteHandlerBtnClicked = function(coreName, dsName, dsId, handlerId, handlerName, dsType){
    var confirmModalElm = $("#confirmDeleteHandler");
    var msg = cvFormatters.formatString(localMsg.DeleteHandlerConfMsg, [handlerName]);
		validateUserPermission(handlerId,sea.constants.Permissions.DELETE,function(isValid){
			if(isValid){
				$(".confirmDeleteMsg", confirmModalElm).html(msg);

			    var deleteBtnHandler = function(){
			      sea.services.deleteHandler(handlerId, function(){
						cvUtil.toast(localMsg.HandlerDeleted);
				goToAllHandlersPage(coreName, dsName, dsId, dsType);
			      }, null, $(containerId));
			    };
			    confirmModalElm.modal('show').find(".modal-dialog").draggable().off("click", ".deleteBtn").on("click", ".deleteBtn", deleteBtnHandler);
			} else {cvUtil.toast(localMsg.PermissionDenied);}
		});
  };

  var onShareHandlerBtnClicked = function(coreName, dsName, dsId, handlerId, handlerName, dsType){
	    var confirmModalElm = $("#shareHandlerModal");
		var holder = $("#shareHandlerModal");
		var msg = cvFormatters.formatString(localMsg.ShareHandler, [handlerName]);
		validateUserPermission(handlerId,sea.constants.Permissions.SHARE,function(isValid){
			if(isValid){
				sea.shareFiles.onViewSharingInfo(coreName,handlerId,"handler");
				$(".modal-title",holder).html(msg);
				confirmModalElm.modal('show').find(".modal-dialog").draggable();
			} else {cvUtil.toast(localMsg.PermissionDenied);}
		});
	};
	var onEditHandlerClicked = function(coreName, dsName, dsId, handlerId, handlerName, dsType){
		validateUserPermission(handlerId,sea.constants.Permissions.EDIT,function(isValid){
			if(isValid){
				var reqObj = getHVBaseReqObj(coreName, dsName, dsId, dsType);
				reqObj[sea.constants.HistoryParams.HANDLER_ID] = handlerId;
				reqObj[sea.constants.HistoryParams.ACTION] = sea.constants.Actions.EDIT_HANDLER;
				reqObj[sea.constants.HistoryParams.FULL_VIEW] = 0;
				reqObj[sea.constants.HistoryParams.HANDLER_NAME] = handlerName;
				sea.history.pushState(reqObj, document.title, $.param(reqObj));
			} else {cvUtil.toast(localMsg.PermissionDenied);}
		});
	};

	var validateUserPermission = function(handlerId, type, callback){
		var isValidRequest=false;
		sea.services.getUserPermissions(handlerId,"handler", function(data) {
			if(data){
				var permissionList = data.permissionList;
				if (permissionList) {
					for	(var j = 0; j < permissionList.length; j++) {
						if(permissionList[j]==type){
							isValidRequest=true;
						}
					}
				}
			}
			callback(isValidRequest);
		}, null, null);
	};

	var getCreateNewHandlerButton = function(coreName, dsName, dsId, dsType){
		var btn = $("<button class='btn btn-primary'>");
		var reqObj = {
				cn: coreName,
				action: sea.constants.Actions.CREATE_HANDLER,
				type: dsType,
				id: dsId,
				dn: dsName
		};

		$(btn).text(localMsg.CreateNewHandler);
		$(btn).cvHyperlink(reqObj);
		return btn;
	};

	var getParamAndValueFromHolder = function($param){
		var $input = $param.parents("." + constants.PARAM_INPUT_WRAPPER).find("." + constants.PARAM_INPUT);
		var key = $input.data('key');
		var val = null;
		var isFacetInput = (key === defaultRequiredParams["facet.field"].paramName || key === defaultRequiredParams["facet.query"].paramName);
		if(defaultRequiredParams[key].inputType == sea.handlerConstants.InputTypes.BOOLEAN){
			val = $input.is(":checked").toString();
		}
		else if(defaultRequiredParams[key].inputType == sea.handlerConstants.InputTypes.COMBO){
			var tempVal = $input.find("option:selected").map(function(a, item){
				return $(item).val();
			});
			// To remove jquery specific properties
			val = tempVal.splice(0, tempVal.length);
		}
		else if(defaultRequiredParams[key].inputType == sea.handlerConstants.InputTypes.TEXTAREA && !isFacetInput){
			val = $input.val().split("\n");
			val = val.filter(function(v){
					if(v.length > 0) {
						return true;
					}
				});
		}
		else if(isFacetInput){
			val = $input.val().replace(/\n/g, ",").split(",");
			if($.isArray(val)){
				val = val.filter(function(v){
					if(v.length > 0) {
						return true;
					}
				});

				val = val.map(function(v){
					return v.trim();
				});
			}
		}
		else {
			val = $input.val();
		}
		var paramData = {};

		if($.isArray(val) && val.length > 0)
		{
			paramData.key = key;
			for(i = 0;i<val.length;i++) {val[i] = encodeURIComponent(val[i].replace(/\+/g, encodeURIComponent("+")));}

			paramData.val = val;
		}
		else{
			if(val !=undefined && val.length > 0){
				paramData.key = key;
				paramData.val = encodeURIComponent(val.replace(/\+/g, encodeURIComponent("+")));
			}
		}

		return paramData;
	};

	/*
	 * Get the input in the 'raw' field and massage them into the required request format If a key in the
	 * 'raw' input is already defined (eg: fl), it will be assigned to the corresponding bucket. If its a
	 * currently unsupported (not predefined) key, we create a new bucket for it. Here bucket refers to
	 * requestObject[bucketEntity]. eg: handlerInfos.defaultParams[fl]
	 */
	var parseRawInput = function(hanlderInfo, paramContainer){
		var parsed = null;

		if(!$.isEmptyObject(paramContainer[defaultRequiredParams.Raw.paramName])){
			for(var i=0; i<paramContainer[defaultRequiredParams.Raw.paramName].length; i++){
				parsed = $.parseParamsWithDuplicates(paramContainer[defaultRequiredParams.Raw.paramName][i]);
				for(var param in parsed){
					if(!$.isEmptyObject(paramContainer[param])){paramContainer[param] = paramContainer[param].concat(parsed[param]);}else{
						if($.isArray(parsed[param])){paramContainer[param] = parsed[param];} else {paramContainer[param] = [parsed[param]];}
					}
				}
			}
			delete paramContainer[defaultRequiredParams.Raw.paramName];
		}
	};

	var onSubmitButton = function(coreName, dsName, dsId, dsType, handlerId, holder, attribute){
		var info = {};
		var $handlerName = $("#handlerName", holder);

		//checks if a valid handler name is provided
		try{
			sea.util.validateInputsAndGetData(holder);
		}
		catch(e){
			return;
		}

		info.dataSourceId = dsId;
		info.handlerName = $handlerName.val();
		info.handlerInfo = {};
		info.handlerInfo.defaultParams = {};
		info.handlerInfo.appendParams = {};
		info.handlerInfo.invariantParams = {};

		/*
		 * attribute will be set only in case of edit. The value of 'attribute' is determined by the backend.
		 * For default handler it is '2' and for user created handlers it is '0'. Backend will decide the
		 * attribute value on handler creation. In case of edit, we just send back the 'attribute' value back
		 * to the server along with the edit request
		 */

		if(attribute != undefined){info.attribute = attribute;}

		if(handlerId != null){info.handlerId = handlerId;}
		var $defaultParams = $("." + constants.PARAMETER_CONTAINER + " .default:checked", holder);
		var $appendParams = $("." + constants.PARAMETER_CONTAINER + " .append:checked", holder);
		var $invariantParams = $("." + constants.PARAMETER_CONTAINER + " .invariant:checked", holder);

		$.each($defaultParams, function(i, param){
			var paramData = getParamAndValueFromHolder($(param));
			if(!$.isEmptyObject(paramData)){
				if(!$.isEmptyObject(info.handlerInfo.defaultParams[paramData.key])){
					if($.isArray(paramData.val) && paramData.val.length > 0){info.handlerInfo.defaultParams[paramData.key] = info.handlerInfo.defaultParams[paramData.key].concat(paramData.val);}else if(paramData.val.length > 0){info.handlerInfo.defaultParams[paramData.key].push(paramData.val);}
				}
				else if($.isEmptyObject(info.handlerInfo.defaultParams[paramData.key])){
					if($.isArray(paramData.val) && paramData.val.length > 0){info.handlerInfo.defaultParams[paramData.key] = paramData.val;}else if(paramData.val.length > 0){info.handlerInfo.defaultParams[paramData.key] = [paramData.val];}
				}
			}
		});

		$.each($appendParams, function(i, param){
			var paramData = getParamAndValueFromHolder($(param));
			if(!$.isEmptyObject(paramData)){
				if(!$.isEmptyObject(info.handlerInfo.appendParams[paramData.key])){
					if($.isArray(paramData.val) && paramData.val.length > 0){info.handlerInfo.appendParams[paramData.key] = info.handlerInfo.appendParams[paramData.key].concat(paramData.val);}else if(paramData.val.length > 0){info.handlerInfo.appendParams[paramData.key].push(paramData.val);}
				}
				else if($.isEmptyObject(info.handlerInfo.appendParams[paramData.key])){
					if($.isArray(paramData.val) && paramData.val.length > 0){info.handlerInfo.appendParams[paramData.key] = paramData.val;}else if(paramData.val.length > 0){info.handlerInfo.appendParams[paramData.key] = [paramData.val];}
				}
			}
		});

		$.each($invariantParams, function(i, param){
			var paramData = getParamAndValueFromHolder($(param));
			if(!$.isEmptyObject(paramData)){
				if(!$.isEmptyObject(info.handlerInfo.invariantParams[paramData.key])){
					if($.isArray(paramData.val) && paramData.val.length > 0){info.handlerInfo.invariantParams[paramData.key] = info.handlerInfo.invariantParams[paramData.key].concat(paramData.val);}else if(paramData.val.length > 0){info.handlerInfo.invariantParams[paramData.key].push(paramData.val);}
				}
				else if($.isEmptyObject(info.handlerInfo.invariantParams[paramData.key])){
					if($.isArray(paramData.val) && paramData.val.length > 0){info.handlerInfo.invariantParams[paramData.key] = paramData.val;}else if(paramData.val.length > 0){info.handlerInfo.invariantParams[paramData.key] = [paramData.val];}
				}
			}
		});

		info.handlerInfo.rawDefaultParams = info.handlerInfo.defaultParams[defaultRequiredParams.Raw.paramName];
		info.handlerInfo.rawAppendParams = info.handlerInfo.appendParams[defaultRequiredParams.Raw.paramName];
		info.handlerInfo.rawInvariantParams = info.handlerInfo.invariantParams[defaultRequiredParams.Raw.paramName];

		delete info.handlerInfo.defaultParams[defaultRequiredParams.Raw.paramName];
		delete info.handlerInfo.appendParams[defaultRequiredParams.Raw.paramName];
		delete info.handlerInfo.invariantParams[defaultRequiredParams.Raw.paramName];

		info.handlerInfo.alwaysDecode = true;
		// parseRawInput(info.handlerInfo, info.handlerInfo.defaultParams);
		// parseRawInput(info.handlerInfo, info.handlerInfo.appendParams);
		// parseRawInput(info.handlerInfo, info.handlerInfo.invariantParams);



		sea.services.saveHandler(info, function(){
			// handlerId variable will be set only when we are editing a handler
			if(handlerId != undefined){cvUtil.toast(localMsg.HandlerUpdated);} else {cvUtil.toast(localMsg.HandlerCreated);}
			goToAllHandlersPage(coreName, dsName, dsId, dsType);
		}, null, holder);
	};

	var goToAllHandlersPage = function(coreName, dsName, dsId, dsType){
		var reqObj = {};
		reqObj[sea.constants.HistoryParams.CORE_NAME] = coreName;
		reqObj[sea.constants.HistoryParams.ACTION] = sea.constants.Actions.HANDLER;
		reqObj[sea.constants.HistoryParams.DS_TYPE] = dsType;
		reqObj[sea.constants.HistoryParams.DS_ID] = dsId;
		reqObj[sea.constants.HistoryParams.DS_NAME] = dsName;
		sea.history.pushState(reqObj, document.title, $.param(reqObj));
	};

	var mapContainerEnumToString = function(num){

		/*
		 * On merging the server values we get enums as arguments. If the merge did not happen or did not
		 * overwrite the existing value, we will get a string. In case of string, just return the string.
		 */
		if(typeof num === "string") {
			return num;
		}

		switch(num){
		case 1:
			return sea.handlerConstants.Containers.DEFAULT;
		case 2:
			return sea.handlerConstants.Containers.APPEND;
		case 3:
			return sea.handlerConstants.Containers.INVARIANT;
		}
	};

	var showCreateHandler = function(coreName, dsName, dsId, dsType, handlerId){
		var $wrapper = $("<div id='handler_wrapper' class='wrapper_class'></div>");
		$(containerId).append($wrapper);
		var formHolder = $("<div class='" + constants.CREATE_FORM + "'></div>");
		// Toolbar with submenu nav
		var headerElm = uiControls.util.getTemplate("tmpl_SubMenuToolbar", "div");
		headerElm.attr("id", coreName + "_header").appendTo("#handler_wrapper");
		var handlerTb = new ToolBar("#handler_wrapper", coreName + "_toolbar", localMsg.NewHandler);
		handlerTb.addClass("new-handler-tb");
		var additionalFieldsHolder = $("<div class = '" + constants.ADDITIONAL_FIELDS + "'><h4 class='panel-title' data-toggle='collapse' data-target='.content'>" +
				"<span class='glyphicon glyphicon-arrow-right'></span>" + localMsg.AdditionalCriteria + "</h4></div>'");
		additionalFieldsHolder.append("<div class='content collapse'></div>");
		var handlerName = uiControls.util.getTemplate(sea.constants.TMPL_PREFIX + sea.constants.Actions.NEW + "_" +
				constants.HANDLER + "_name", "div");
		var containerHeadings = uiControls.util.getTemplate(sea.constants.TMPL_PREFIX + sea.constants.Actions.NEW + "_" +
				constants.HANDLER + "_container_headings", "div");
		formHolder.append($(containerHeadings));
		formHolder.append($(handlerName));
		formHolder.append(additionalFieldsHolder);
		formHolder.find("." + constants.CONTAINER_HEADINGS + " ." + constants.CONTAINER_HEADING + ".default .container-heading-help .glyphicon").tooltip({
			title: localMsg.DefaultContainerHelp,
			container: "body"
		});
		formHolder.find("." + constants.CONTAINER_HEADINGS + " ." + constants.CONTAINER_HEADING + ".append .container-heading-help .glyphicon").tooltip({
			title: localMsg.AppendContainerHelp,
			container: "body"
		});
		formHolder.find("." + constants.CONTAINER_HEADINGS + " ." + constants.CONTAINER_HEADING + ".invariant .container-heading-help .glyphicon").tooltip({
			title: localMsg.InvariantContainerHelp,
			container: "body"
		});

		var isEdit = handlerId == undefined? false: true;
		var attribute;

		/* A list of ajax functions to be called before we show the create form */
		var prefetchList = [];
		for(var param in defaultRequiredParams){
			if(typeof defaultRequiredParams[param].possibleValuesAjax === "function"){// Every possibleValuesAjax method is assumed to return a
			// deferred object
			prefetchList.push(defaultRequiredParams[param].possibleValuesAjax(dsId, function(){}));}
		}

		var searchParamsCallback = function(data){
			var searchParams = data.searchParams;
			delete searchParams.qf;
			defaultRequiredParams = $.extend(true, defaultRequiredParams, searchParams);
			for(var mergedParam in defaultRequiredParams){
				if(defaultRequiredParams[mergedParam].containers != null){
					defaultRequiredParams[mergedParam].possibleContainers = [];
					for(var i=0; i<defaultRequiredParams[mergedParam].containers.length; i++){
						defaultRequiredParams[mergedParam].possibleContainers.push(mapContainerEnumToString(defaultRequiredParams[mergedParam].containers[i]));
					}
				}
				if(defaultRequiredParams[mergedParam].defaultContainer != null){
					defaultRequiredParams[mergedParam].defaultContainer = mapContainerEnumToString(defaultRequiredParams[mergedParam].defaultContainer);
				}
			}
		};

		var attachMainButtons = function(){
			var submitBtn = $("<span class='col-lg-offset-2' style='padding: 5px;'><btn id='btn_ok' class='btn btn-primary'>" + localMsg.Save +
			"<btn></span>");
			var cancelBtn = $("<btn id='btn_cancel' class='btn btn-default' style='margin-left'>" + localMsg.Cancel +
			"<btn>");
			var reqObj = getHVBaseReqObj(coreName, dsName, dsId, dsType);
			reqObj[sea.constants.HistoryParams.ACTION] = sea.constants.Actions.HANDLER;
			reqObj[sea.constants.HistoryParams.FULL_VIEW] = 0;
			cancelBtn.cvHyperlink(reqObj);

			$wrapper.append(submitBtn);
			$wrapper.append(cancelBtn);


			$("#btn_ok", submitBtn).click(function(){
				onSubmitButton(coreName, dsName, dsId, dsType, handlerId, formHolder, attribute);
			});
		}

		var searchParams = window.sessionStorage.getItem("search_params");
		if(searchParams != undefined){searchParamsCallback(JSON.parse(searchParams));}else{
			/*
			 * Do not give a DOM object to be masked. For some weird reason the DOM won't be masked if we pass
			 * $(containerId) as the last argument to sea.services.getSearchParams. Hence keeping it as null.
			 */
			prefetchList.push(sea.services.getSearchParams(function(data){
				window.sessionStorage.setItem("search_params", JSON.stringify(data));
				searchParamsCallback(data);
			}, null, null));
		}

		/*
		 * Dynamic variables has to come up in suggestions. Instead of treating them as seperate from column
		 * names, clubbing them together so that they appear in the same auto suggest
		 */
		var dynamicVariables = window.sessionStorage.getItem("handler_dynamic_variables");
		if(dynamicVariables != null){columnList = columnList.concat(JSON.parse(dynamicVariables));}else{
			prefetchList.push(sea.services.getDynamicHandlerParams(function(data){
				window.sessionStorage.setItem("handler_dynamic_variables", JSON.stringify(data));
				columnList = columnList.concat(data);
			}));
		}


		var createFields = function(){
			for(var param in defaultRequiredParams){
				paramHolder = uiControls.util.getTemplate(sea.constants.TMPL_PREFIX + sea.constants.Actions.NEW + "_" +
						constants.HANDLER, "div");
				$("label." + constants.PARAMETER_KEY, paramHolder).text(defaultRequiredParams[param].dispName);
				createInputField(coreName, defaultRequiredParams[param], paramHolder, isEdit);
				// handleSpecialParams(param, paramHolder);
				if($.inArray(param, collapsedFields) !== -1){$(".content", additionalFieldsHolder).append(paramHolder);} else {additionalFieldsHolder.before(paramHolder);}
			}

			$(".cvToolbar.new-handler-tb", containerId).after(formHolder);
			if(isEdit){
				sea.services.getHandlers(dsId, handlerId, function(resp){
					$("#" + coreName + "_toolbar .cvToolbarTitle", $(containerId)).text(resp.handlerInfos[0].handlerName);
					var params = unmarshallResponse(resp);
					attribute = params.attribute;
					/*
					 * Special handling. For default handler, backend does not send 'rows' But all handlers by
					 * default have '10' as rows property. So we thought we might as well set rows as 10 for
					 * all handlers if it's not mentioned otherwise
					 */
					if(params.rows == undefined){
						params.rows = {
							containers: [sea.handlerConstants.Containers.DEFAULT],
							values: [{
								container: sea.handlerConstants.Containers.DEFAULT,
								value: defaultRequiredParams.rows.defaultValue
							}]
						};
					}
					populateInputFields(params, $("." + constants.CREATE_FORM, $wrapper));
					if(!formHolder.find("input[data-key='" + defaultRequiredParams.facet.paramName + "']").is(":checked")){hideFacetFields(formHolder);}
				}, null, $wrapper);
			} else {hideFacetFields(formHolder);}
		};

		/*
		 * We call createFields() for both success and failure. This is because the form should be rendered to
		 * the DOM even if one or two ajax call fails.
		 */
		$.when.apply($, prefetchList).done(function(){
			createFields();
			attachMainButtons();
		});

		// When clicking on the facet checkbox
		$wrapper.off("click", "input[data-key='" + defaultRequiredParams.facet.paramName + "']").on("click", "input[data-key='" + defaultRequiredParams.facet.paramName + "']", function(){
			var fieldList = [];
			fieldList.push(formHolder.find("textarea[data-key='" + defaultRequiredParams["facet.field"].paramName + "']").parents(".parameter"));
			fieldList.push(formHolder.find("textarea[data-key='" + defaultRequiredParams["facet.query"].paramName + "']").parents(".parameter"));

			toggleFacetFields(fieldList, $(this).is(":checked"));
		});

		$wrapper.off("click",".additional-fields .panel-title").on("click",".additional-fields .panel-title",function (event) {
		var $arrowIcon = $(this).find("span");
		if($arrowIcon.hasClass('glyphicon-arrow-right')) {
			$arrowIcon.removeClass('glyphicon-arrow-right').addClass('glyphicon-arrow-down').css({"vertical-align":"middle"});
		}
		else {
			$arrowIcon.removeClass('glyphicon-arrow-down').addClass('glyphicon-arrow-right').css({"vertical-align":""});
		}
	});
		attachContainerListeners();
	};

	var hideFacetFields = function(holder){
		holder.find("textarea[data-key='" + defaultRequiredParams["facet.field"].paramName + "']").parents(".parameter").hide();
		holder.find("textarea[data-key='" + defaultRequiredParams["facet.query"].paramName + "']").parents(".parameter").hide();
	};

	var hideCollapsibleFields = function(holder){
		for(var i=0; i<additionalFields.length; i++) {holder.find("input[data-key='" + collapsedFields[i] + "']").parents(".parameter").hide();}
	};

	var showCollapsibleFields = function(holder){
		for(var i=0; i<additionalFields.length; i++) {holder.find("input[data-key='" + collapsedFields[i] + "']").parents(".parameter").show();}
	};

	var toggleFacetFields = function(fieldList, checked){
		$.each(fieldList, function(i, field){
			var $field = $(field);
			if(checked){$field.show();} else {$field.hide();}
		});
	};

	var showEditHandler = function(coreName, dsName, dsId, dsType, handlerId){
		var $toolbar, $delete, $share, handlerName;
		showCreateHandler(coreName, dsName, dsId, dsType, handlerId);
		handlerName = $("#handlerName").val();
		$toolbar = $("#" + coreName + "_header .cvToolbarButtonbar", containerId);
		$share = $("<button class='btn btn-primary'>" + localMsg.Share + "</button>");
		$delete = $("<button class='btn btn-danger'>" + localMsg.Delete + "</button>");
		$delete.on('click', function(){
			onDeleteHandlerBtnClicked(coreName, dsName, dsId, handlerId, handlerName, dsType);
		});
		$share.on('click', function(){
			onShareHandlerBtnClicked(coreName, dsName, dsId, handlerId, handlerName, dsType);
		})
		$(".cvToolbar.new-handler-tb .cvToolbarButtonbar").append($delete).append($share);
		//$toolbar.append($delete).append($share);
	};

	var onMultivaluedAddClicked = function(valueToBePopulated, param, holder, currentElm){
		//Limit multivalued inputs to 3 rows - one each for default, append and invariant
		var inputWrapper = getInputField("", param, holder);

		if($("." + constants.PARAM_INPUT_WRAPPER, holder).length < param.possibleContainers.length){inputWrapper.insertAfter(currentElm);}

		if(valueToBePopulated !== null){
			switch(param.inputType){
			case sea.handlerConstants.InputTypes.COMBO:
				$.each(valueToBePopulated, function(i, val){
					inputWrapper.find("select").append("<option value='" + val +"'>" + val + "</option>");
				});
				break;
			}
		}

		if($("." + constants.PARAM_INPUT_WRAPPER, holder).length >= param.possibleContainers.length){
			$(".btn_add", holder).attr("disabled", true);
			return;
		}
	};

	function autoresize(textarea) {
		if(textarea.outerHeight() < textarea[0].scrollHeight){
			$(textarea).css('height', textarea[0].scrollHeight + 2 + 'px');
		}
	}
	var addHelpText = function(inputElements, param){
		$.each(inputElements, function(i, element){
			var inputElement = $(".input-group", element);
			switch(param.inputType){
			case sea.handlerConstants.InputTypes.TEXT:
				inputElement.tooltip({
					trigger: 'focus',
					title: param.helpText,
					placement: 'bottom'
				});
				inputElement.off('keyup').on('keyup', function(){
					$(this).tooltip('hide');
				});
				break;
			case sea.handlerConstants.InputTypes.NUMBER:
				inputElement.tooltip({
					trigger: 'focus',
					title: param.helpText,
					placement: 'bottom'
				});
				inputElement.off('keyup').on('keyup', function(){
					$(this).tooltip('hide');
				});
				break;
			case sea.handlerConstants.InputTypes.BOOLEAN:
				inputElement.find("input").tooltip({
					trigger: 'hover',
					title: param.helpText,
					container: 'body',
					placement: 'bottom'
				});
				break;
			case sea.handlerConstants.InputTypes.COMBO:
				inputElement.tooltip({
					trigger: 'hover',
					title: param.helpText,
					placement: 'top'
				});
				break;
			case sea.handlerConstants.InputTypes.TEXTAREA:
				inputElement.on('input autoresize', 'textarea', function() {
					autoresize($(this));
				});
				inputElement.tooltip({
					trigger: 'hover',
					title: param.helpText,
					placement: 'top'
				});
				break;
			}
		});
	};

	var getInputField = function(coreName, param, holder){
		var inputWrapper = $("<div class='" + constants.PARAM_INPUT_WRAPPER + "'></div>");
		var inputElement = $("<div class='input-group col-lg-6 col-md-6 col-sm-6'></div>");
		var containerInput = uiControls.util.getTemplate(sea.constants.TMPL_PREFIX + sea.constants.Actions.NEW + "_" + constants.HANDLER + "_containers", "div");
		var postProcessElement = inputElement;

		var initTextComplete = function($textElm){
			$textElm.textcomplete([{
				match: /(\$\{$)|((\$\{)?\w+$)/,
				index: 0,
				search: function(term, callback){
					// columnList is populated through possibleValues() function
					// in defaultRequiredParams{}. See the entry for 'fl' in
					// defaultRequiredParams
					callback($.map(columnList, function(word){
						return word.toLowerCase().indexOf(term.toLowerCase()) === 0 ? word: null;
					}));
				},
				replace: function(word){
					return word;
				}
			}]);
		};

		if(param.possibleContainers.length > 0){
			var $containerInput = $(containerInput);
			$("input", $containerInput).attr("disabled", true);
			for(var i=0; i<param.possibleContainers.length; i++) {$("input." + param.possibleContainers[i], $containerInput).attr("disabled", false);}
		}

		switch(param.inputType){
		case sea.handlerConstants.InputTypes.TEXT:
			if(param.placeholder === undefined){param.placeholder = "";}
			var $tempHtml = $("<input type='text' class='form-control " + constants.PARAM_INPUT + "' placeholder='" + param.placeholder + "' data-key=" + param.paramName  + ">");
			inputElement.append($tempHtml);
			$HtmlDiv = $("<div class='suggestion_list_container'></div>")
			inputElement.append($HtmlDiv);
			initTextComplete($tempHtml);
			postProcessElement = $tempHtml;
			attachTextInputListener($tempHtml);
			/*
			 * Support for cvshortcuts with textcomplete. To be removed later when we are really really sure
			 * that we don't need keyboard shortcuts
			 */
			// $tempHtml.textcomplete([]);
			// var completer = $tempHtml.data('textComplete');
			//
			// /*Textcomplete hackery.
			// Manual:
			// https://github.com/yuku-t/jquery-textcomplete/blob/master/doc/how_to_use.md
			// */
			// $tempHtml.on('textComplete:hide', function(){
			// /*When the dropdown disappears, clear strategies
			// Without a strategy, dropdown won't come as we type
			// And strategies array is populated only when we press
			// ctrl+shift+space*/
			// completer.strategies = [];
			// });
			//
			// $tempHtml.cvShortcut([17, 32], function(){
			// //See src/strategy.js here:
			// https://github.com/yuku-t/jquery-textcomplete/blob/master/src/strategy.js
			// var strategy = $.fn.textcomplete.Strategy.parse([{
			// match: /(^|\b)(\w{1,})$/,
			// search: function(term, callback){
			//
			// //columnList is populated through possibleValues() function in
			// defaultRequiredParams{}. See the entry for 'fl'
			// callback($.map(columnList, function(word){
			// return word.indexOf(term) === 0 ? word: null;
			// }));
			// },
			// replace: function(word){
			// completer.strategies = [];
			// return word;
			// }
			// }]);

			/*
			 * Every time the shortcut is pressed, we create a strategy and register. A strategy should be
			 * registered for dropdowns to appear. If we remove this strategy, dropdowns stop appearing
			 */
			// completer.register(strategy);
			// });
			break;
		case sea.handlerConstants.InputTypes.COMBO:
			inputElement.append($("<select class='form-control " + constants.PARAM_INPUT + "' data-key=" + param.paramName  + "></select>"));
			var $selectTag = $("select", inputElement);
			if(typeof param.possibleValues !== "undefined"){
				$.each(param.possibleValues, function(i, val){
					$selectTag.append("<option value='" + val +"'>" + val + "</option>");
				});
				populatedValue = param.possibleValues;
			}
			postProcessElement = $selectTag;
			attachTextInputListener($selectTag);
			break;
		case sea.handlerConstants.InputTypes.TEXTAREA:
			var $tempHtml = $("<textarea class='form-control " + constants.PARAM_INPUT + "' rows = '1' data-key=" + param.paramName  + "></textarea>");
			inputElement.append($tempHtml);
			initTextComplete($tempHtml);
			postProcessElement = $tempHtml;
			attachTextInputListener($tempHtml);
			break;
		case sea.handlerConstants.InputTypes.NUMBER:
			var $numberInput = $("<input type='number' class='form-control " + constants.PARAM_INPUT + "' data-key=" + param.paramName  + ">")
			inputElement.append($numberInput);
			attachTextInputListener($numberInput);
			break;
		case sea.handlerConstants.InputTypes.BOOLEAN:
			var $input = $("<input type='checkbox' class='" + constants.PARAM_INPUT + "' data-key=" + param.paramName  + ">");
			inputElement.append($input);
			postProcessElement = $input;
			attachBooleanInputListener($input);
			break;
		}

		if(typeof param.postProcess == "function"){param.postProcess(postProcessElement);}


		if(param.isMultiValued === true){
			var wrapperList = [];
			$.each(param.possibleContainers, function(i, container){
				var $inputClone = inputWrapper.clone();
				var $containerClone = $(containerInput).clone();
				var $inputElementClone = inputElement.clone();
				if(param.inputType == sea.handlerConstants.InputTypes.TEXTAREA){
					$("textarea", $inputElementClone).attr("placeholder", param.dispName + " (" + getContainerDispName(container) + ")");
				}
				else if(param.inputType == sea.handlerConstants.InputTypes.TEXT){
					$("input", $inputElementClone).attr("placeholder", param.dispName + " (" + getContainerDispName(container) + ")");
				}

				$inputClone.append($inputElementClone).append($containerClone);

				//Preselecting a container. One row for each container.
				selectContainer(container, $containerClone, true);

				if(param.inputType == sea.handlerConstants.InputTypes.TEXT || param.inputType == sea.handlerConstants.InputTypes.TEXTAREA){initTextComplete($("textarea,input", $inputElementClone));}

				wrapperList.push($inputClone);
			});
			return wrapperList;
		}
		else{
			inputWrapper.append(inputElement);
			inputWrapper.append($(containerInput));
		}

		return [inputWrapper];
	};

	var createInputField = function(coreName, param, holder, isEdit){

		var inputWrapper = getInputField(coreName, param, holder);
		addHelpText(inputWrapper, param);

		if(!isEdit){
			$.each(inputWrapper, function(i, wrapper){
				if(param.defaultValue != undefined){
					wrapper.find("." + constants.PARAM_INPUT).val(param.defaultValue);
				}

				//default container is applicable only if there is no container selected already
				if(param.defaultContainer != null && !$("." + constants.PARAMETER_CONTAINER + " ." + constants.PARAMETER_CONTAINER_INPUT + " input", wrapper).is(":checked")){
					var checkBox = wrapper.find("." + param.defaultContainer);
					checkBox.attr("checked", true);
					checkBox.parents("label.btn").addClass("active");
				}
			});

		}

		$("." + constants.PARAMETER_VAL, holder).append(inputWrapper);
	};

	var selectContainer = function(container, $holder, locked){
		$("." + container, $holder).trigger("click");
		if(locked === true){
			$("." + container, $holder).parent().find("label span").addClass("locked");
			$("." + sea.handlerConstants.Containers.DEFAULT, $holder).attr("disabled", true);
			$("." + sea.handlerConstants.Containers.APPEND, $holder).attr("disabled", true);
			$("." + sea.handlerConstants.Containers.INVARIANT, $holder).attr("disabled", true);
		}
	};

	var hasSelectedContainer = function($holder){
		if($("." + constants.PARAMETER_CONTAINER_INPUT + " input:checked", $holder).length > 0) {
			return true;
		} else {
			return false;
		}
	}

	/*
	 * Get all the params that are NOT predefined but are included in server response. These represent the
	 * custom params given by the user through the 'raw' option
	 */
	var getRawParams = function(params){
		var rawParams = {};
		rawParams.default = [];
		rawParams.append = [];
		rawParams.invariant = [];

		for(var param in params){
			if($.isEmptyObject(defaultRequiredParams[param])){
				var values = params[param].values;
				for(var i=0; i<values.length; i++) {rawParams[values[i].container].push({
					paramName: param,
					value: values[i].value
				});}
			}
		}
		return rawParams;
	};

	var getFlParams = function(params){
		var flParams = {};
		flParams.default = [];
		flParams.append = [];
		flParams.invariant = [];

		var fl = params.fl;
		if(!$.isEmptyObject(fl)){
			for(var i=0; i<fl.values.length; i++) {flParams[fl.values[i].container].push({
				columnName: fl.values[i].value
			});}
		}

		return flParams;
	};

	var populateRawField = function(params, holder){
		var populate = function(rawParams, container){
			if(rawParams.length == 0) {
				return;
			}
			var inputField = holder.find("[data-key='" + defaultRequiredParams.Raw.paramName + "']:last");
			var $wrapper = inputField.parents(".form-group");
			var $container = $("input." + container+":checked", $wrapper).parents("." + constants.PARAMETER_CONTAINER);

			inputField = $("." + constants.PARAM_INPUT, $container.parent());


			var rawParamText = rawParams.join("\n");

			inputField.val(rawParamText).trigger("autoresize");
		};
		if(params.rawDefaultParams != null || params.rawAppendParams != null || params.rawInvariantParams != null){$(".additional-fields .panel-title",holder).trigger("click");}
		if(params.rawDefaultParams == null){params.rawDefaultParams = [];}
		if(params.rawAppendParams == null){params.rawAppendParams = [];}
		if(params.rawInvariantParams == null){params.rawInvariantParams = [];}

		migrateRawParams(params);
		populate(params.rawAppendParams, sea.handlerConstants.Containers.APPEND);
		populate(params.rawDefaultParams, sea.handlerConstants.Containers.DEFAULT);
		populate(params.rawInvariantParams, sea.handlerConstants.Containers.INVARIANT);
	};

	/*
	 * To prevent raw queries from dissappearing when the user updates to the new textarea raw params. Should
	 * be eventually removed from codebase
	 */
	var migrateRawParams = function(params){
		var paramClone = $.extend(true, {}, params);
		delete paramClone.rawAppendParams;
		delete paramClone.rawDefaultParams;
		delete paramClone.rawInvariantParams;

		for(var param in paramClone){
			if($.isEmptyObject(defaultRequiredParams[param])){
				var values = params[param].values;
				for(var i=0; i<values.length; i++){
					if(values[i].container === sea.handlerConstants.Containers.DEFAULT){
						params.rawDefaultParams.push(param + "=" + values[i].value);
					}
					else if(values[i].container === sea.handlerConstants.Containers.APPEND){
						params.rawAppendParams.push(param + "=" + values[i].value);
					}
					else if(values[i].container === sea.handlerConstants.Containers.INVARIANT){
						params.rawInvariantParams.push(param + "=" + values[i].value);
					}
				}
			}
		}
	};

	var populateFlField = function(flList, container, holder){
		var inputField = holder.find("select[data-key='" + defaultRequiredParams.fl.paramName + "']:last");
		inputField.multiselect('select', flList.map(function(fl){
			return fl.columnName;
		}));
		if(flList.length !== 0)
		{
			$("option:selected",inputField).prependTo(inputField);//This code is to get all the selected columns at the top in the dropdown, On Edit handler.
			inputField.multiselect('rebuild');
		}
		
		if(flList.length > 0){
			selectContainer(container, inputField.parents("." + constants.PARAMETER_VAL).find("." + constants.PARAMETER_CONTAINER + ":last"));
			inputField.siblings(".btn_add").trigger("click");
		}
	};
	/*
	 * Populates the input fields in the DOM with the given param values. Used when the user is editing a
	 * handler
	 */
	var populateInputFields = function(params, holder){

		$("#handlerName", holder).val(params.handlerName);
		var keys = Object.keys(params);

		// here we call decodeURIComponent on the values twice as we double encode the '+' value if present when saving the handler.
		$.each(keys,function(index,key){
			if(typeof(params[key]) === "object" && params[key] != null && params[key].hasOwnProperty('values'))
			{

				for(var i =0;i<params[key].values.length;i++)
				{
					params[key].values[i].value= decodeURIComponent(decodeURIComponent(params[key].values[i].value));
				}
			}
			else if(typeof(params[key]) === "string")
			{
				params[key] = decodeURIComponent(decodeURIComponent(params[key]));
			}
			else if($.isArray(params[key])){
				for(var i=0; i<params[key].length; i++){
					params[key][i] = decodeURIComponent(decodeURIComponent(params[key][i]));
				}
			}
		});

		var paramsClone = $.extend(true, {}, params);
		delete paramsClone.handlerName;
		delete paramsClone.attribute;
		populateRawField(paramsClone, holder);

		/*
		 * All normal params come with structure {"paramName": x, "value": y} but rawAppendParams don't follow
		 * this structure. Easier to delete raw params since we are done with it than to handle their varied
		 * structure in code
		 */
		delete params.rawAppendParams;
		delete params.rawInvariantParams;
		delete params.rawDefaultParams;

		var flParams = getFlParams(paramsClone);
		if(!$.isEmptyObject(flParams)){
			populateFlField(flParams.default, sea.handlerConstants.Containers.DEFAULT, holder);
			populateFlField(flParams.append, sea.handlerConstants.Containers.APPEND, holder);
			populateFlField(flParams.invariant, sea.handlerConstants.Containers.INVARIANT, holder);
		}

		// So that the below loop won't add fl to the UI again.
		delete params.fl;

		for(var param in params){
			var $inputField = holder.find("." + constants.PARAM_INPUT + "[data-key='" + param + "']");
			var values = params[param].values;
			if(values === undefined) {
				continue;
			}
			var $containerHolder = $inputField.parent().siblings("." + constants.PARAMETER_CONTAINER);

			if(!$.isEmptyObject(defaultRequiredParams[param]) && !defaultRequiredParams[param].isMultiValued){
				for(var i=0,$currentField = $inputField; i<values.length; i++){
					$containerHolder = $currentField.parent().siblings("." + constants.PARAMETER_CONTAINER);

					selectContainer(values[i].container, $containerHolder);
					if(defaultRequiredParams[param].inputType == sea.handlerConstants.InputTypes.BOOLEAN){
						if(values[i].value == "true"){$currentField.attr("checked", true);} else {$currentField.attr("checked", false);}
					} else {$currentField.val(values[i].value);}

					if(i != values.length - 1){
						$currentField.siblings(".btn_add").trigger("click");
						$currentField = $currentField.parents("." + constants.PARAMETER_VAL).children("." + constants.PARAM_INPUT_WRAPPER + ":last").
						find("." + constants.PARAM_INPUT + "[data-key='" + param + "']");
						if($currentField.length === 0) {
							break;
						}
					}
				}
			}
			else if(!$.isEmptyObject(defaultRequiredParams[param]) && defaultRequiredParams[param].isMultiValued){
				/*
				 * For multivalued params the containers would be already selected. We just have to populate
				 * the values into the input field with the right container. See getInputField() to know how
				 * multivalued param UI works
				 */
					var populate = function(paramValue, container, delimiter){
						var inputField = holder.find("[data-key='" + defaultRequiredParams[param].paramName + "']:last");
						var $wrapper = inputField.parents(".form-group");
						var $container = $("input." + container+":checked", $wrapper).parents("." + constants.PARAMETER_CONTAINER);
						inputField = $("." + constants.PARAM_INPUT, $container.parent());

						if(paramValue == null || paramValue.length == 0) {
							return;
						}

						//delimiter: add a newline in text area. Currently all multivalued fields are textarea
						inputField.val(inputField.val() + paramValue + delimiter).trigger("autoresize");
					};

					if(values.length != 0){

						var valueParentList = [];
						var defaultValues = values.filter(function(value){
							if(value.container === sea.handlerConstants.Containers.DEFAULT) {
								return value;
							}
						});
						if(defaultValues.length){valueParentList.push(defaultValues);}
						var appendValues = values.filter(function(value){
							if(value.container === sea.handlerConstants.Containers.APPEND) {
								return value;
							}
						});
						if(appendValues.length){valueParentList.push(appendValues);}

						var invariantValues = values.filter(function(value){
							if(value.container === sea.handlerConstants.Containers.INVARIANT) {
								return value;
							}
						});
						if(invariantValues.length){valueParentList.push(invariantValues);}

						$.each(valueParentList, function(j, valueList){
							var delimiter = defaultRequiredParams[param].delimiter;
							$.each(valueList, function(i, val){
								if(i === valueList.length - 1){delimiter = "";}
								//below logic is to change contanier from default to append for facet.field. 
								//This is the temporary fix as deafult container for facet.field is working like append.
								// we will remove this logic once we get this issues fixed
								if(param === 'facet.field' && val.container === "default") {
									if(i === valueList.length - 1)
										delimiter = ",";
									val.container = "append";
								}
									
								populate(val.value, val.container, delimiter);
							});
						});
					}
			}
		}
	};

	var showHandlerDataTable = function(coreName, dsName, dsId, dsType, hvList){
		var defHVObj = {
				handlerViewId: -1,
				handlerViewName: localMsg.DefaultSearchView,
				attribute: 0,
				modifiedUTCTime: 0,
				createUTCTime: 0
		};

		if(!$.fn.DataTable.isDataTable("#" + hvTableId)){
			var config = $.extend({}, handlerDTConfig);
			config.columns = sea.ColumnConfiguration.getConfigInDTFormat(sea.ColumnConfiguration.handlerViewConfig);
			config.data = hvList;
			config.language = {};
			config.language.emptyTable = localMsg.NoHandlerMsg;
			$("#" + hvTableId).dataTable(config);
		} else {$("#" + hvTableId).DataTable().clear.rows.add(hvList).draw();}
	};

	var getHVBaseReqObj = function(coreName, dsName, dsId, dsType){
		var reqObj = {};
		reqObj[sea.constants.HistoryParams.ACTION] = sea.constants.Actions.EACH_HANDLER;
		reqObj[sea.constants.HistoryParams.DS_ID] = dsId;
		reqObj[sea.constants.HistoryParams.CORE_NAME] = coreName;
		reqObj[sea.constants.HistoryParams.DS_TYPE] = dsType;
		reqObj[sea.constants.HistoryParams.DS_NAME] = dsName;
		reqObj[sea.constants.HistoryParams.FULL_VIEW] = "1";
		return reqObj;
	};

	var viewHandler = function(coreName, dsId, handlerId){
		sea.services.getHandlers(dsId, handlerId, function(resp){
			var configToolBar = new ToolBar(containerId,
					sea.constants.HANDLER + "_config",
					resp.handlerInfos[0].handlerName);
			//configToolBar.addButton(getEditHandlerButton(coreName, dsId, handlerId));
			//configToolBar.addButton(getDeleteHandlerButton(coreName, handlerId));
			var params = unmarshallResponse(resp);
			displayHandler(params);
		}, null, $(containerId));
	};

	var getEditHandlerButton = function(coreName, dsId, handlerId){
		var btn = $("<button class='btn btn-default btn-edit'></button>");
		var reqObj = {
				cn: coreName,
				action: sea.constants.Actions.EDIT_HANDLER,
				id: dsId,
				hid: handlerId
		};

		$(btn).text(localMsg.Edit);
		$(btn).cvHyperlink(reqObj);

		return btn;
	};

	var getDeleteHandlerButton = function(coreName, handlerId){
		return $("<button class='btn btn-default btn-delete'>Delete</button>");
	};

	/*
	 * params - An (initially) empty object paramList - either default, append or invariant list of params
	 * container - Either 'default', 'append', or 'invariant' - string constant.
	 */
	var unmarshallParamsInContainer = function(params, paramList, container){
		for(var param in paramList){
			values = paramList[param];
			if($.isEmptyObject(params[param])){
				params[param] = {};
				params[param].containers = [];
				params[param].values = [];
			}
			params[param].containers.push(container);

			for(var i=0; i<values.length; i++){
				if(values[i].length == 0) {
					continue;
				}
				params[param].values.push({
					value: values[i],
					container: container
				});
			}
		}
	};

	var unmarshallResponse = function(resp){
		var handler = resp.handlerInfos[0];
		var handlerInfo = handler.handlerInfo;
		var defaultParams = handlerInfo.defaultParams;
		var invariantParams = handlerInfo.invariantParams;
		var appendParams = handlerInfo.appendParams;
		var params = {};
		var values = null;

		unmarshallParamsInContainer(params, defaultParams, sea.handlerConstants.Containers.DEFAULT);
		unmarshallParamsInContainer(params, invariantParams, sea.handlerConstants.Containers.INVARIANT);
		unmarshallParamsInContainer(params, appendParams, sea.handlerConstants.Containers.APPEND);

		params.handlerName = handler.handlerName;
		params.attribute = handler.attribute;
		params.rawAppendParams = handlerInfo.rawAppendParams;
		params.rawDefaultParams = handlerInfo.rawDefaultParams;
		params.rawInvariantParams = handlerInfo.rawInvariantParams;

		return params;
	};

	// Display all the details of handler. View handler.
	var displayHandler = function(params){
		for(var param in params){
			var currentParam = params[param];
			var paramHolder = uiControls.util.getTemplate(sea.constants.TMPL_PREFIX + sea.constants.Actions.VIEW + "_" +
					constants.HANDLER, "div");
			var defaultParam = defaultRequiredParams[param];
			var paramName = null;
			if(!$.isEmptyObject(defaultParam)){paramName = defaultParam.dispName;} else {paramName = param;}
			paramHolder.find("label." + constants.PARAMETER_KEY).text(paramName);
			$.each(currentParam, function(i, val){
				displayParamValue(val, paramHolder);
			});
			$(containerId).append(paramHolder);
		}
	};

	// Display a parameter and its value
	var displayParamValue = function(val, holder){
		var wrapper = $("<div class='" + constants.PARAM_WRAPPER + "'></div>");
		var valueElementWrapper = $("<div class='col-lg-6 col-md-6 col-sm-6'></div>");
		var containerInput = uiControls.util.getTemplate(sea.constants.TMPL_PREFIX + sea.constants.Actions.VIew +
				"_" + constants.HANDLER + "_containers", "div");

		valueElementWrapper.append($("<div>" + val + '</div>'));
		wrapper.append(valueElementWrapper);
		wrapper.append(containerInput);
		holder.find("." + constants.PARAMETER_VAL).append(wrapper);

	};

	var onExecuteHandlerBtnClicked = function(handlerId, handlerName){
		var newWindow = window.open(cvUtil.getContextPath() + "/api/dcube/" + cvFormatters.formatString("handler/{0}/{1}", [handlerId, handlerName]), "_blank");
		newWindow.focus();
	};

	var onRestAPIBtnClicked = function(handlerId, handlerName){
		var restDiv = $("#handlerRestApi");
		restDiv.find(".rest-api").text(cvUtil.getTopWindow().location.origin + cvUtil.getContextPath() + "/api/dcube/" + cvFormatters.formatString("handler/{0}/{1}", [handlerId, handlerName]));
		restDiv.modal('show');
	};

	var attachContainerListeners = function(){
		$(containerId).off("click", "." + constants.PARAMETER_CONTAINER_INPUT).on("click", "." + constants.PARAMETER_CONTAINER_INPUT, function(e){
			e.stopPropagation();
			var parent = $(this).parents("." + constants.PARAMETER_CONTAINER);
			var currentInput = $(this).find("input");
			if(currentInput.attr("disabled")) {
				return;
			}
			if(currentInput.attr("checked")){currentInput.attr("checked", false);}else{
				parent.find("input").attr("checked", false);
				currentInput.attr("checked", true);
			}
		});
	};

	var getContainerDispName = function(container){
		switch(container){
			case sea.handlerConstants.Containers.DEFAULT:
				return "Default";
			case sea.handlerConstants.Containers.APPEND:
				return "Append";
			case sea.handlerConstants.Containers.INVARIANT:
				return "Override";
		}
	};

	return {
		showAllHandlers: onViewAllHandlers,
		createHandler: showCreateHandler,
		viewHandler: viewHandler,
		editHandler: showEditHandler
	};
})();
