var sea = sea || {};
sea.isDebug = true;
sea.containerId = "#seaContainer";
sea.homePage = (function() {

	/* private methods section, start */
	// Define only general methods here, otherwise use controllers
	var subMenuActions = [];
	var initSidebarToggleListener = function() {
		$(".cvSidebarMenuToggle").click(function(e) {
			e.preventDefault();
			$("#" + $(this).data("cvSidebarParent")).toggleClass("active");
		});

	};
	

	var goToConfigPage = function() {
		var url = window.location.href.split("?").pop();
		var params = url.split("&");
		var reqObj = {};
		$.map(params,function(param) {
			var keyVal = param.split("=");
			if(keyVal[0] === "action")
				reqObj[keyVal[0]] = sea.constants.Actions.VIEW;
			else
				reqObj[keyVal[0]] = keyVal[1];
		});
		sea.history.pushState(reqObj, document.title, $.param(reqObj));
	};
		
	var createSidebarLinks = function() {
		var htm = "";
		htm += '<li class="row nomargin"><span class="listItemWrapper row nomargin"><a class="col-lg-12 col-md-12 col-sm-12 analyticsLinks" title="' + localMsg.ViewAnalyticsHome + '" data-action="' + sea.constants.Actions.HOME +
				'"><span class="ico-home2 ico-sb-home"></span> Home</a></span>';
		$.each(sea.analyticsHome.getFilteredReportTypes(sea.DSTypeConstants.reportsType), function(key, obj) {
			if (obj) {
				htm += "<li class='row nomargin'><span class='listItemWrapper row nomargin'><a class='col-lg-12 col-md-12 col-sm-12 analyticsLinks' title='" + obj.viewLinkTooltip + "' data-filter-item='" +
						obj.dsDispName.toLowerCase() + "' data-href='" + obj.appUrl + "'><span class='" +
						obj.iconClass + "'></span>" + obj.dsDispName;
				htm += "</a></span></li>";
			}
		});
		$.each(sea.DSTypeConstants.listOfDS, function(key, obj) {
			if (obj) {
				htm += "<li class='row nomargin'><span class='listItemWrapper row nomargin'><a class='col-lg-8 col-md-8 col-sm-8 analyticsLinks' title='" + obj.viewLinkTooltip + "' data-filter-item='" +
						obj.dsDispName.toLowerCase() + "' data-dstype='" + key + "'><span class='" + obj.iconClass +
						"'></span> " + obj.dsDispName + "</a>";
				var oDataSourceHandler = DataSourceHandler.factory(key);
				if (oDataSourceHandler !== undefined) {
					var subTypeKeys = obj.subTypes === undefined ? [] : Object.keys(obj.subTypes);
					if(obj.subTypes === undefined  || subTypeKeys.length == 1) {
						htm += "<div class='col-lg-4 col-md-4 col-sm-4 addBtnWraper pull-right'><button data-subtype='"+subTypeKeys[0]+"' class='btn-add btn btn-xs pull-right' title='" + obj.addNewTooltip + "'>" +
							localMsg.AddNew + "</button></div>";						

					} else {
							var tempHtml = "<div class='col-lg-4 col-md-4 col-sm-4 addBtnWraper pull-right'><div class='dropdown subTypeMenu pull-right'><button type='button' class='btn btn-xs dropdown-toggle addActionBtn' data-toggle='dropdown' aria-haspopup='true' aria-expanded='false'>"+
										localMsg.AddNew + "<span class='caret margin-left-5'></span></button><ul class='dropdown-menu dropdown-menu-right margin-top-2'>";

							$.each(obj.subTypes,function(subType,dispName) {
								tempHtml += "<li class='noPadding submenuListItem'><a class='submenu' href='javascript:void(0);' data-dstype='"+key+"' data-subtype='"+subType+"'>"
											+dispName+"</a></li>";
							});
							tempHtml += "</ul></div></div>";
							htm += tempHtml;
							//console.log(htm);
						}
				}
				htm += "</span></li>";

				
			}
		});

		$("#dsList").append(htm);

	};

	var initSidebarLinksListener = function() {
		$("#dsList a").click(function(e) {
			if (!$(this).data("accordion")) {
				e.preventDefault();
				var dsType = $(this).data("dstype");
				var action = $(this).data("action");
				var reqObj = {};
				if (dsType) {
					reqObj[sea.constants.HistoryParams.DS_TYPE] = dsType;
					sea.history.pushState(reqObj, document.title, $.param(reqObj));
				} else if (action) {
					reqObj[sea.constants.HistoryParams.ACTION] = action;
					sea.history.pushState(reqObj, document.title, $.param(reqObj));
				} else {
					window.location.href = $(this).data("href");
				}
			}
		});
		$("#dsList li .btn-add").click(function(e) {
			e.stopPropagation();
			var reqObj = {};
			var subtype = $(this).data("subtype");
			if(subtype !== "undefined")
				reqObj[sea.constants.HistoryParams.SUBTYPE] = subtype;
			reqObj[sea.constants.HistoryParams.ACTION] = sea.constants.Actions.NEW;
			reqObj[sea.constants.HistoryParams.DS_TYPE] = $(this).parent().siblings().data("dstype");//we are getting dsType data stored in anchor tag
			sea.history.pushState(reqObj, document.title, $.param(reqObj));
		});

		$("#dsList .subTypeMenu a").off("click").on("click", function(event) {
			var reqObj = {};
			reqObj[sea.constants.HistoryParams.SUBTYPE] = $(this).data("subtype");
			reqObj[sea.constants.HistoryParams.ACTION] = sea.constants.Actions.NEW;
			reqObj[sea.constants.HistoryParams.DS_TYPE] = $(this).data("dstype");
			sea.history.pushState(reqObj, document.title, $.param(reqObj));
		
		});
		
		var $btns = $(sea.containerId).on('click', '#dataConnectorFilter [data-filter]', function() {
			if ($(this).data('filter') == 'all') {
				$('#dataAnalyticsItems [id^=portlet_]').fadeIn(450);
			} else {
				var $el = $('[data-category="' + $(this).data('filter') + '"]').fadeIn(450);
				$('#dataAnalyticsItems [id^=portlet_]').not($el).hide();
			}
			$(this).siblings().removeClass('active');
			$(this).addClass('active');
		});

	};
	var handleSideBarSelection = function(action, dsType, reqObj) {
		$("#dsList span.listItemWrapper").removeClass("selected");
		$("#dsList .cvSidebarNavSubMenu").remove();
		if (dsType) {
			var aElm = $("#dsList a[data-dstype='" + dsType + "']").not(".submenu");
			var wrapperDiv = aElm.parent();
			var liElm = wrapperDiv.parent();
			var ulElm = liElm.parent();
			ulElm.collapse('show');
			ulElm.prev().removeClass("collapsed");
			wrapperDiv.addClass("selected");
			var fullView = reqObj[sea.constants.HistoryParams.FULL_VIEW];
			if (fullView === "1") {
				if (!window.matchMedia('(max-width :767px)').matches) {
					$("#cvPageWithSideBar-Main").removeClass("active");
				}
			} else {
				$("#cvPageWithSideBar-Main").addClass("active");
			}
		}
	};

	var addSubMenuToToolbar = function(toolbarClass, dsName, dsType, action, reqObj,dsId) {
		var subMenuActions = [
				sea.constants.Actions.VIEW,
				sea.constants.Actions.VIEW_SCHEMA,
				sea.constants.Actions.REPORT_VIEW,
				sea.constants.Actions.REST_API,
				sea.constants.Actions.ANALYTICS,
				sea.constants.Actions.HANDLER,
				sea.constants.Actions.ENTITY,
				sea.constants.Actions.ENTITY_DETAILS,
				sea.constants.Actions.WEBHOOK,
				sea.constants.Actions.ENTITY_EXTRACTION,
				sea.constants.Actions.DATA_BLENDING
			];
		$(".cvToolbarNavSubMenuGrp", $("." + toolbarClass)).html(getSubMenuHtml(dsType, dsName));
		$(".navDSName",$(sea.containerId)).text(dsName);
		var reqObjCpy = $.extend({}, reqObj);
		$.each(sea.constants.ReportInputParams, function(k, v) {
			delete reqObjCpy[v];
		});
		$.each(subMenuActions, function(i, a) {
			var req = $.extend({}, reqObjCpy);
			req[sea.constants.HistoryParams.ACTION] = a;
			req[sea.constants.HistoryParams.FULL_VIEW] = "0";
			if(a === sea.constants.Actions.REPORT_VIEW) {
				req[sea.constants.ReportInputParams.DS_ID] = dsId;
				req[sea.constants.ReportInputParams.DS_TYPE] = dsType;
				req[sea.constants.HistoryParams.FULL_VIEW] = "1";
			}
			var $actionElementDiv = $("a[data-action='" + a + "']", $(".cvToolbarNavSubMenuGrp"));
			$actionElementDiv.cvHyperlink(req);
		});
		if (action === sea.constants.Actions.EDIT_HANDLER || action === sea.constants.Actions.CREATE_HANDLER) {
			$("a[data-action='" + sea.constants.Actions.HANDLER + "']", $(".cvToolbarNavSubMenuGrp")).parent()
					.removeClass("inactive").addClass("active");
		} else if(subMenuActions.indexOf(action) !== -1) {
			//do the selection only if it is a known action ; FIX FOR PSIRT 225756 			
			$("a[data-action='" + action + "']", $(".cvToolbarNavSubMenuGrp")).parent().removeClass("inactive")
					.addClass("active");
		}

	};

	var getSubMenuHtml = function(dsType, dsName) {
		var dsObj = sea.DSTypeConstants.getDSObject(dsType);
		var isSearchOnly = typeof (dsObj) !== "undefined" && typeof (dsObj.searchOnly) !== "undefined" &&
				dsObj.searchOnly;
		var htm = '<nav class="navbar navbar-default" id="custom-navbar"><div class="col-lg-5 col-md-5 col-sm-5 col-xs-5"><div class="navbar-header"><div class="navbar-brand"><span class="navDSName"></span><small class="dsViewDescription default-cursor"></small></div><button type="button" data-target=".navbar-collapse" data-toggle="collapse" class="navbar-toggle" style="display:none"><span class="sr-only">Toggle navigation</span><span class="icon-bar"></span><span class="icon-bar"></span><span class="icon-bar"></span></button></div></div>'
		htm += "<div class='col-lg-7 col-md-7 col-sm-7 col-xs-7' style='padding-right: 0;'><ul class='nav navbar-nav toolbar-menu-align'>";
		if (!isSearchOnly) {
			htm += "<li class='inactive'><a data-action='" +
					sea.constants.Actions.VIEW +
					"' title='" +
					localMsg.Configuration +
					"'><div class='align-left hidden-md'><i class='ico-cog ico-sb-cog3'></i></div><div class='align-left hidden-sm hidden-xs'>" +
					localMsg.Configuration + "</div></a></li>";
		}
		
		if (dsType != sea.constants.DSTypes.FEDERATED && dsType !== sea.constants.DSTypes.WEB && !isSearchOnly) {
			htm += "<li class='inactive'><a data-action='" +
					sea.constants.Actions.VIEW_SCHEMA +
					"' title='" +
					localMsg.Schema +
					"'><div class='align-left hidden-md'><i class='ico-schema-icon ico-sb-table'></i></div><div class='align-left hidden-sm hidden-xs'>" +
					localMsg.Schema + "</div></a></li>";
		}
		htm += "<li class='inactive'><a data-action='" +
				sea.constants.Actions.REPORT_VIEW +
				"' title='" +
				localMsg.Report +
				"'><div class='align-left hidden-md'><i class='ico-pie-chart ico-sb-table'></i></div><div class='align-left hidden-sm hidden-xs'>" +
				localMsg.Report + "</div></a></li>";
		if (dsType != sea.constants.DSTypes.FEDERATED) {
			if (sea.isDcubeHandlerEnabled == true) {
				htm += "<li class='inactive'><a data-action='" +
						sea.constants.Actions.HANDLER +
						"' title='" +
						localMsg.Handlers +
						"'><div class='align-left hidden-md'><i class='ico-wrench ico-sb-tools2'></i></div><div class='align-left hidden-sm hidden-xs'>" +
						localMsg.Handlers + "</div></a></li>";
			}
			if (dsType !== sea.constants.DSTypes.WEB && !isSearchOnly) {
				htm += "<li class='inactive'><a data-action='" +
						sea.constants.Actions.REST_API +
						"' title='" +
						localMsg.RESTAPI +
						"'><div class='align-left hidden-md'><i class='ico-code ico-sb-embed2'></i></div><div class='align-left hidden-sm hidden-xs'>" +
						localMsg.RESTAPI + "</div></a></li>";
			}
			if (sea.isROCEnabled == true) {
				htm += "<li class='inactive'><a data-action='" +
						sea.constants.Actions.ANALYTICS +
						"' title='" +
						localMsg.Analytics +
						"'><div class='align-left hidden-md'><i class='ico-cog sublvlicon'></i></div><div class='align-left hidden-sm hidden-xs'>" +
						localMsg.Analytics + "</div></a></li>";
			}
			if (sea.isWebhookEnabled === true) {
				htm += "<li class='inactive'><a data-action='" +
						sea.constants.Actions.WEBHOOK +
						"' title='" +
						localMsg.WebHooks +
						"'><div class='align-left hidden-md'><i class='ico-callback ico-sb-tools2'></i></div><div class='align-left hidden-sm hidden-xs'>" +
						localMsg.WebHooks + "</div></a></li>";
			}
			// if (sea.isEntityExtractionEnabled == true) {
			// htm += "<li><div data-action='" +
			// sea.constants.Actions.ENTITY +
			// "' class='cvToolbarNavSubMenu subBtn header-button' role='button'><div class='cvToolbarNavSubMenu-icon'><a title='"+localMsg.Configuration+"'><span class='ico-entity-extraction-icon sublvlicon'></span><span class='sublvllabel'>" +
			// localMsg.EntityExtraction + "</span></a></div></div></li>";
			// }
			if(sea.DSTypeConstants.listOfDS[dsType] !== undefined && sea.DSTypeConstants.listOfDS[dsType].isEEEnabled === true) {
				htm += "<li class='inactive'><a data-action='" +
						sea.constants.Actions.ENTITY_EXTRACTION +
						"' title='" +
						localMsg.EntityExtraction +
						"'><div class='align-left hidden-md'><i class='ico-entity-extraction-icon ico-sb-'></i></div><div class='align-left hidden-sm hidden-xs'>" +
						localMsg.EntityExtraction + "</div></a></li>";
			}
			if(sea.DSTypeConstants.listOfDS[dsType] !== undefined && sea.DSTypeConstants.listOfDS[dsType].isLookupEnabled === true) {
				htm += "<li class='inactive'><a data-action='" +
						sea.constants.Actions.DATA_BLENDING +
						"' title='" +
						localMsg.DataBlending +
						"'><div class='align-left hidden-md'><i class='ico-datablending-icon ico-sb-'></i></div><div class='align-left hidden-sm hidden-xs'>" +
						localMsg.DataBlending + "</div></a></li>";
			}
		}
		htm += "</ul></div></nav></div>";
		return htm;
	};
	var initHistoryListener = function() {
		function MyHistory() {
		}
		MyHistory.prototype.pushState = function(obj, title, queryParams, skipProcess) {
			queryParams = queryParams ? "?" + queryParams : "";
			history.pushState(obj, title, queryParams);
			if (typeof skipProcess === undefined || !skipProcess) {
				handleHistoryChange(obj);
			}

		};
		MyHistory.prototype.replaceState = function(obj, title, queryParams) {
			queryParams = queryParams ? "?" + queryParams : "";
			history.replaceState(obj, title, queryParams);
			handleHistoryChange(obj);
		};
		sea.history = new MyHistory();
		window.addEventListener('popstate', function(event) {
			var stateObj = event.state;
			if (stateObj != null) {
				handleHistoryChange(stateObj);
			}
		});

	};

	var handleHistoryChange = function(stateObj) {
		$(sea.containerId).empty();
		handleBreadCrumb(stateObj);
		if (!$.isEmptyObject(stateObj)) {
			var coreName = stateObj[sea.constants.HistoryParams.CORE_NAME];
			var action = stateObj[sea.constants.HistoryParams.ACTION];
			var dsType = stateObj[sea.constants.HistoryParams.DS_TYPE];
			var dsId = stateObj[sea.constants.HistoryParams.DS_ID];
			var dsName = stateObj[sea.constants.HistoryParams.DS_NAME];
			var jobId = stateObj[sea.constants.HistoryParams.JOB_IB];
			var jobName = stateObj[sea.constants.HistoryParams.JOB_NAME];
			var subtype = stateObj[sea.constants.HistoryParams.SUBTYPE];
			handleSideBarSelection(action, dsType, stateObj);
			cvUtil.CancelAllQueuedAjaxReqs();

			if (typeof action !== 'undefined') {
				if (action == sea.constants.Actions.EACH_SEARCH_VIEW) {
					var viewId = parseInt(stateObj[sea.constants.HistoryParams.VIEW_ID]);
					sea.viewController.showSearchView(coreName, dsName, dsId, dsType, viewId);
				} else if (action == sea.constants.Actions.REPORT_VIEW) {
					var reportName = stateObj[sea.constants.ReportInputParams.NAME];
					sea.viewController.showReportView(coreName, dsName, dsId, dsType, reportName);
				} else if (action == sea.constants.Actions.NEW) {
					sea.dsController.handleCreateDataSource(false, dsType, subtype);
					initTooltip("required-icon", "Required Field", "left");
				} else if (action == sea.constants.Actions.EDIT) {
					sea.dsController.handleCreateDataSource(true, dsType, subtype, dsId, coreName, dsName);
					initTooltip("required-icon", "Required Field", "left");
				} else if (action == sea.constants.Actions.VIEW) {
					sea.dsController.handleViewDataSource(coreName, dsName, dsId, dsType);
				} else if (action == sea.constants.Actions.VIEW_ALL) {
					sea.dsController.handleViewAllDataSource(dsType);
				} else if (action == sea.constants.Actions.HOME) {
					sea.dsController.handleViewHome();
				} else if (action == sea.constants.Actions.VIEW_SCHEMA) {
					sea.schemaController.handleViewSchema(coreName, dsName, dsId);
				} else if (action == sea.constants.Actions.REST_API) {
					sea.restApiController.showRestApiPage(coreName, dsName, dsId);
				} else if (action == sea.constants.Actions.ANALYTICS) {
					sea.analyticsController.initAnalyticsFields(coreName, dsName, dsId, dsType, false);
				} else if (action == sea.constants.Actions.ANALYTICS_VIEW_RESULTS) {
					sea.analyticsController.initAnalyticsFields(coreName, dsName, dsId, dsType, true, jobId, jobName);
				} else if (action == sea.constants.Actions.ENTITY) {
					var handlerId = stateObj[sea.constants.HistoryParams.HANDLER_ID];
					var handlerName = stateObj[sea.constants.HistoryParams.HANDLER_NAME];
					sea.entityExtractor.viewEntityTypes(coreName, dsName, dsId, dsType, handlerId, handlerName);
				} else if (action == sea.constants.Actions.ENTITY_DETAILS) {
					var eeType = stateObj[sea.constants.HistoryParams.ENTITY_TYPE];
					var handlerId = stateObj[sea.constants.HistoryParams.HANDLER_ID];
					var handlerName = stateObj[sea.constants.HistoryParams.HANDLER_NAME];
					sea.entityExtractor.viewEntityDetails(coreName,
							dsName,
							dsId,
							dsType,
							eeType,
							handlerId,
							handlerName);
				} else if (action == sea.constants.Actions.HANDLER) {
					sea.searchApiController.showAllHandlers(coreName, dsName, dsId, dsType);
				} else if (action == sea.constants.Actions.CREATE_HANDLER) {
					sea.searchApiController.createHandler(coreName, dsName, dsId, dsType);
				} else if (action == sea.constants.Actions.EACH_HANDLER) {
					var handlerId = stateObj[sea.constants.HistoryParams.HANDLER_ID];
					sea.searchApiController.viewHandler(coreName, dsId, handlerId);
				} else if (action == sea.constants.Actions.EDIT_HANDLER) {
					var handlerId = stateObj[sea.constants.HistoryParams.HANDLER_ID];
					sea.searchApiController.editHandler(coreName, dsName, dsId, dsType, handlerId);
				} else if (action === sea.constants.Actions.WEBHOOK) {
					sea.webhookController.showWebhookPage(coreName, dsName, dsId);
				} else if (action === sea.constants.Actions.ENTITY_EXTRACTION) {
						sea.ContentAnalyzer.viewEEDetails(dsId,coreName);
				} else if (action === sea.constants.Actions.DATA_BLENDING) {
						sea.lookup.viewLookupDetails(dsId,coreName);
				}
				addSubMenuToToolbar("header-toolbarInPage", dsName, dsType, action, stateObj, dsId);
			} else if (typeof dsType !== "undefined") {
				sea.dsController.handleViewAllDataSource(dsType);
			}
		} else { // Show the list of cores
			handleSideBarSelection();// to reset
			sea.dsController.handleViewHome(sea.DSTypeConstants);
		}
		document.title = localMsg.Analytics;
	};
	/* private methods section, end */
	var goBack = function() {
		if (history && history.state) {
			history.back();
		} else {
			goHome();
		}
	};
	var goHome = function() {
		window.location = $("a#seaHomeLink").attr("href");
	};
	var goAnalyticsHome = function() {
		window.location = cvUtil.CONTEXT_PATH + "/analytics";
	};
	var getQueryParamsObject = function() {
		var q = "";
		if (window.location.search) {
			q = window.location.search.substring(1);
		}
		return q;
	};
	var initTooltip = function(className, titleName, direction) {
		$('.' + className).tooltip({
			placement : direction,
			title : titleName
		});
	};

	var documentReadyHandler = function() {
		var params = {};
		sea.analyticsHome.initConnectorTypes();
		initCrumbListeners(params);
		initSidebarToggleListener();
		createSidebarLinks();
		initSidebarLinksListener();
		initHistoryListener();
		sea.crawlController.init();
		var reqObj = $.parseParams(getQueryParamsObject());
		handleHistoryChange(reqObj);
	};
	var onInit = function() {
		$(document).ready(documentReadyHandler);
	};

	var handleBreadCrumb = function(stateObj) {
		$(sea.containerId).find(".analyticsCrumb").remove();
		$(sea.containerId).prepend("<div class='analyticsCrumb'></div>");

		var crumbHolder = $(sea.containerId).find(".analyticsCrumb");
		crumbHolder.removeData("cvBreadCrumb");
		crumbHolder.cvBreadCrumb({
			fnCrumbTmpl : function(currentCrumb) {
				return analyticsCrumbTmpl(currentCrumb, stateObj[sea.constants.HistoryParams.DS_TYPE]);
			},
			crumbClickSelector : "a"
		});
		var breadCrumb = $(sea.containerId).find(".analyticsCrumb").data("cvBreadCrumb");

		if (!breadCrumb) {
			console.error('cvBreadCrumb not found');
			return;
		}

		var coreName = stateObj[sea.constants.HistoryParams.CORE_NAME];
		var action = stateObj[sea.constants.HistoryParams.ACTION];
		var dsType = stateObj[sea.constants.HistoryParams.DS_TYPE];
		var dsId = stateObj[sea.constants.HistoryParams.DS_ID];
		var dsName = stateObj[sea.constants.HistoryParams.DS_NAME];
		var viewId = stateObj[sea.constants.HistoryParams.VIEW_ID];
		var fullView = stateObj[sea.constants.HistoryParams.FULL_VIEW];
		var handlerId = stateObj[sea.constants.HistoryParams.HANDLER_ID];
		var handlerName = stateObj[sea.constants.HistoryParams.HANDLER_NAME];
		var eeType = stateObj[sea.constants.HistoryParams.ENTITY_TYPE];
		var subtype =  stateObj[sea.constants.HistoryParams.SUBTYPE];
		

		var params = {
			action : action,
			dsType : dsType,
			dsName : dsName,
			coreName : coreName,
			dsId : dsId,
			viewId : viewId,
			fullView : fullView,
			handlerId : handlerId,
			handlerName : handlerName,
			eeType : eeType			
		};

		var tempReqObj = {};
		var url = null;
		breadCrumb.addLevel(localMsg.Analytics);

		if (params && params.dsType) {
			var reqObj = sea.ColumnConfiguration.createBaseReqObj(params);
			tempReqObj[sea.constants.HistoryParams.DS_TYPE] = params.dsType;
			url = $.param(tempReqObj);
			var dsObj = sea.DSTypeConstants.getDSObject(params.dsType);
			if (dsObj !== undefined) {
				breadCrumb.addLevel(dsObj.dsDispName, {
					url : url
				});
			}

			if (params.dsName) {
				//This means the user clicked a data source
				var levelOne = breadCrumb.getParamsByLevel(1);
				var doNotAddType = false;
				if (levelOne.name === localMsg.DataSources) {
					doNotAddType = true;
				}

				tempReqObj[sea.constants.HistoryParams.DS_NAME] = params.dsName;
				tempReqObj[sea.constants.HistoryParams.DS_ID] = params.dsId;
				tempReqObj[sea.constants.HistoryParams.CORE_NAME] = params.coreName;
				tempReqObj[sea.constants.HistoryParams.ACTION] = sea.constants.Actions.VIEW;
				url = $.param(tempReqObj);
				breadCrumb.addLevel(params.dsName, {
					url : url
				});
			}

			if (params.action && params.action !== sea.constants.Actions.VIEW) {
				tempReqObj[sea.constants.HistoryParams.ACTION] = params.action;
				if(params.dsType === sea.constants.DSTypes.FS) {
					tempReqObj[sea.constants.HistoryParams.SUBTYPE] = subtype;
				}
				tempReqObj[sea.constants.HistoryParams.NO_REDIR] = 1;
				url = $.param(tempReqObj);
				switch (params.action) {
				case sea.constants.Actions.NEW:
					breadCrumb.addLevel(localMsg.AddNew + " " +
							sea.DSTypeConstants.getDSObject(params.dsType).dsDispName, {
						url : url
					});
					break;
				
				case sea.constants.Actions.EACH_SEARCH_VIEW:
					tempReqObj[sea.constants.HistoryParams.ACTION] = params.action;
					tempReqObj[sea.constants.HistoryParams.VIEW_ID] = params.viewId;
					tempReqObj[sea.constants.HistoryParams.FULL_VIEW] = params.fullView;
					url = $.param(tempReqObj);
					breadCrumb.addLevel(" ", {
						url : url
					});
					break;
				case sea.constants.Actions.REPORT_VIEW:
					tempReqObj[sea.constants.HistoryParams.ACTION] = params.action;
					tempReqObj[sea.constants.ReportInputParams.NAME] = stateObj[sea.constants.ReportInputParams.NAME];
					tempReqObj[sea.constants.HistoryParams.FULL_VIEW] = params.fullView;
					tempReqObj[sea.constants.ReportInputParams.DS_ID] = params.dsId;
					tempReqObj[sea.constants.ReportInputParams.DS_TYPE] = params.dsType;
					tempReqObj[sea.constants.ReportInputParams.HANDLER_ID] = stateObj[sea.constants.ReportInputParams.HANDLER_ID];
					tempReqObj[sea.constants.ReportInputParams.HANDLER_NAME] = stateObj[sea.constants.ReportInputParams.HANDLER_NAME];
				    
					url = $.param(tempReqObj);
					breadCrumb.addLevel(" ", {
						url : url
					});
					break;
				case sea.constants.Actions.VIEW_SCHEMA:
					breadCrumb.addLevel(localMsg.Schema, {
						url : url
					});
					break;
				case sea.constants.Actions.EDIT:
					breadCrumb.addLevel(localMsg.Edit, {
						url : url
					});
					break;
				case sea.constants.Actions.REST_API:
					breadCrumb.addLevel(localMsg.RESTAPI, {
						url : url
					});
					break;
				case sea.constants.Actions.CREATE_HANDLER:
					tempReqObj[sea.constants.HistoryParams.ACTION] = sea.constants.Actions.HANDLER;
					url = $.param(tempReqObj);
					breadCrumb.addLevel(localMsg.Handlers, {
						url : url
					});
					tempReqObj[sea.constants.HistoryParams.ACTION] = params.action;
					url = $.param(tempReqObj);
					breadCrumb.addLevel(localMsg.CreateNewHandler, {
						url : url
					});
					break;
				case sea.constants.Actions.HANDLER:
					breadCrumb.addLevel(localMsg.Handlers, {
						url : url
					});
					break;
				case sea.constants.Actions.ENTITY:
					breadCrumb.addLevel(localMsg.Entities, {
						url : url
					});
					break;
				case sea.constants.Actions.ENTITY_DETAILS:
					tempReqObj[sea.constants.HistoryParams.ACTION] = sea.constants.Actions.ENTITY;
					tempReqObj[sea.constants.HistoryParams.HANDLER_ID] = params.handlerId;
					tempReqObj[sea.constants.HistoryParams.HANDLER_NAME] = params.handlerName;
					url = $.param(tempReqObj);
					breadCrumb.addLevel(localMsg.Entities, {
						url : url
					});
					tempReqObj[sea.constants.HistoryParams.ACTION] = sea.constants.Actions.ENTITY_DETAILS;
					tempReqObj[sea.constants.HistoryParams.ENTITY_TYPE] = params.eeType;
					tempReqObj[sea.constants.HistoryParams.HANDLER_ID] = params.handlerId;
					tempReqObj[sea.constants.HistoryParams.HANDLER_NAME] = params.handlerName;
					url = $.param(tempReqObj);
					breadCrumb.addLevel(eeType, {
						url : url
					});
					break;
				case sea.constants.Actions.EDIT_HANDLER:
					tempReqObj[sea.constants.HistoryParams.ACTION] = sea.constants.Actions.HANDLER;
					url = $.param(tempReqObj);
					breadCrumb.addLevel(localMsg.Handlers, {
						url : url
					});
					tempReqObj[sea.constants.HistoryParams.ACTION] = params.action;
					tempReqObj[sea.constants.HistoryParams.HANDLER_ID] = params.handlerId;
					tempReqObj[sea.constants.HistoryParams.FULL_VIEW] = params.fullView;
					url = $.param(tempReqObj);
					breadCrumb.addLevel(params.handlerName, {
						url : url
					});
					break;
				case sea.constants.Actions.WEBHOOK:
					breadCrumb.addLevel(localMsg.WebHooks, {
						url : url
					});
					break;
				case sea.constants.Actions.ENTITY_EXTRACTION:
					breadCrumb.addLevel(localMsg.EntityExtraction, {
						url : url
					});
					break;
				case sea.constants.Actions.DATA_BLENDING:
					breadCrumb.addLevel(localMsg.DataBlending, {
						url : url
					});
					break;
				}
			}
		} else {
			url = $.param(tempReqObj);
			breadCrumb.addLevel(localMsg.Home, {
				url : url
			});
		}
	};

	var analyticsCrumbTmpl = function(crumb, type) {
		if (crumb.name == localMsg.Analytics) {
			var urlPaths = window.location.href.split("/");
			var analyticsPath = "dcube.do";
			var returnHtml = $("<a href='" + analyticsPath + "'>" + crumb.name + "</a>");
			return returnHtml.cvHyperlink(reqObj);
		}
		var returnHtml = $("<a></a>");
		returnHtml.text(crumb.name);
		var reqObj = $.parseParams(crumb.params.url);
		if (type === sea.constants.DSTypes.REVIEWSET || type === sea.constants.DSTypes.NAS) {
			if (reqObj.action !== sea.constants.Actions.VIEW) {
				returnHtml.cvHyperlink(reqObj);
			} else {
				returnHtml.addClass("addDefaultCursorPointer");
			}
		} else {
			returnHtml.cvHyperlink(reqObj);
		}
		return returnHtml;
	};

	var hideHeader = function(timeout) {

		if (timeout != null) {
			var handler = window.setTimeout(function() {
				$("#header").stop().slideUp();
			}, timeout);
			return handler;
		} else {
			$("#header").hide();
		}
		$(".vw-container_fullscreen").addClass("remove-margin-top");
	};

	var showHeader = function(timeout) {

		if (timeout != null) {
			var handler = window.setTimeout(function() {
				$("#header").stop().slideDown();
			}, timeout);
			return handler;
		} else {
			$("#header").show();
		}
		$(".vw-container_fullscreen").removeClass("remove-margin-top");
	};

	var hasVerticalScrollbar = function() {
		if (window.innerHeight < document.body.clientHeight) {
			return true;
		}
		return false;
	};

	var initCrumbListeners = function() {
		var cvHeader = $("#header");
		var seaContainer = $("#seaContainer");
		//If cv header is not hidden and the user scrolls the page, hide the header
		$(window).off('scroll').on('scroll', function() {
			if (!cvHeader.is(":hidden") && $(window).scrollTop() > 0) {
				seaContainer.css("margin-bottom", cvHeader.outerHeight() + "px");
				hideHeader();
			}
			//If header is hidden and user scrolls to top, show the header
			else if (cvHeader.is(":hidden") && $(window).scrollTop() === 0) {
				showHeader();
				seaContainer.css("margin-bottom", "0px");
			}
		});
	};
	// return only the methods that need to be exposed
	return {
		init : onInit,
		goBack : goBack,
		goHome : goHome,
		goAnalyticsHome : goAnalyticsHome,
		handleBreadCrumb : handleBreadCrumb,
		handleHistoryChange : handleHistoryChange,
		goToConfigPage : goToConfigPage
	};
}()); // IIFE as it is singleton and by default object has to be created

sea.homePage.init();