var sea = sea || {};

sea.schemaController = (function() {
	var containerId = sea.containerId;
	var fieldTypes = [];
	var schemaFields = [];
	var schemaFieldsHash = {};
	var multieditChanges = {};
	var multieditChangedAttributesList = {};
	var shouldDeleteCrawledData = false;
	var SYSTEM_DEFINED_FIELDS = [ "sea_push_counter", "_version_" ];
	var INCLUDE_ANYWAYS_FIELDS = [ "pushtype", "contentid" ];
	var schemaDTConfig = {
		dom : 'J<"pull-left"f><"toolbar pull-left"><"pull-right"l><"clearfix">t<"pull-left"i><"pull-right"p><"clearfix">',
		pageLength : 15,
		lengthMenu : [ [ 15, 25, 50, -1 ], [ 15, 25, 50, "All" ] ],
		order : [ [ 0, "asc" ] ],
		scrollX : true,
		autoWidth : true
	};

	var copyFieldDivIdCnt = 0;

	var resetMultiEditStates = function() {
		multieditChanges = {};
		multieditChangedAttributesList = {};
		shouldDeleteCrawledData = false;
	}

	//persist - set to true to retian the existing options in the combo
	var populateComboFromArray = function(comboObj, arr, persist) {
		if (typeof comboObj === 'undefined' || comboObj == null) {
			return;
		}
		if (!persist) {
			comboObj.empty();
		}
		for (var i = 0; i < arr.length; i++) {
			comboObj.append("<option value=\"" + arr[i] + "\">" + arr[i] + "</option>");
		}
	};

	var populateFieldsTypesCombo = function(comboObj) {
		comboObj.empty();
		if ($.isEmptyObject(fieldTypes)) {
			console.error("Field types not found in schema response.");
			return;
		}
		if (sea.isAllSchemaFieldDataTypes == false) {
			for (var i = 0; i < fieldTypes.length; i++) {
				if (!fieldTypes[i].startsWith(qb.base.constants.schemaCustomDateFormat)) {
					var fieldDispName = null;
					if (sea.constants.schemaAllowedDataTypes[fieldTypes[i]]) {
						fieldDispName = sea.constants.schemaAllowedDataTypes[fieldTypes[i]].dispName;
					} else {
						fieldDispName = sea.constants.newSchemaAllowedDataTypes[fieldTypes[i]].dispName;
					}
					comboObj.append("<option value=\"" + fieldTypes[i] + "\">" + fieldDispName + "</option>");
				} else {
					comboObj.append("<option value=\"" + fieldTypes[i] + "\">" + fieldTypes[i] + "</option>");
				}
			}
		} else {
			for (var i = 0; i < fieldTypes.length; i++) {

				comboObj.append("<option value=\"" + fieldTypes[i] + "\">" + fieldTypes[i] + "</option>");
			}
		}
	};

	var handleAddNewField = function(coreName, dsId, elementId, tableId, data, btnObj) {

		var isEdit = false;
		var divId = "schema_newTable";
		var divClass = "schema_editTable";
		var copyFieldDivId = "copyFieldDiv";
		var addOneTimeButtonId = "addOneTimeButtonId";
		var currentFieldType = null;
		var currentMultivalued = null;
		var fieldsElm = uiControls.util.getTemplate(sea.constants.TMPL_PREFIX + "schema", "div");

		if (elementId == sea.constants.DATA_SOURCES + "_schema") {
			$("#" + divId).remove();
			fieldsElm.attr("id", divId).show().insertAfter("#" + elementId);
			$(".copyFieldDiv").attr("id", copyFieldDivId).show();
			$(".btn_AddCopyFieldOneTime").attr("id", addOneTimeButtonId).show();
		} else {
			divId = divId + elementId;
			$("#" + divId).remove();
			fieldsElm.attr("id", divId).show().appendTo($("#" + elementId, "#" + tableId));
			fieldsElm.find("[data-toggle='tooltip']").tooltip();
			copyFieldDivId = copyFieldDivId + elementId;
			fieldsElm.find($(".copyFieldDiv")).attr("id", copyFieldDivId).show();
			addOneTimeButtonId = addOneTimeButtonId + elementId;
			fieldsElm.find($(".btn_AddCopyFieldOneTime")).attr("id", addOneTimeButtonId).show();
		}
		var holder = $("#" + divId);
		$(".firstField", holder).focus();
		populateFieldsTypesCombo($("#fieldTypeCombo", holder));
		$("#" + addOneTimeButtonId).on("click",
				function(event) {
					$(this).hide();
					onAddCopyFieldBtnClick(copyFieldDivId,
							addOneTimeButtonId,
							holder,
							null,
							null,
							isEdit,
							tableId,
							function(data) {
								populateComboFromArray($("#" + data.colDropdownId, holder),
										getSchemaFieldsFromTable(tableId));
							});
				});

		if (data) {
			fieldsElm.addClass(divClass);
			var disabled = data.skipdelete;

			$("#fieldName", holder).val(data.fieldName).attr("disabled", true);

			/*
			 * isKnownSchemaFieldType() returns the field name if it is defined in the client side. Or else it
			 * will return the boolean value false.
			 */
			var fieldType = isKnownSchemaFieldType(data.type);
			if (fieldType === false) {
				populateComboFromArray($("#fieldTypeCombo", holder), [ data.type ], true);
				fieldType = data.type;
			}
			$("#fieldTypeCombo", holder).val(fieldType).attr("disabled", disabled);

			$("#isStored", holder).attr("checked", data.stored).attr("disabled", disabled);
			$("#isMultiValued", holder).attr("checked", data.multiValued).attr("disabled", disabled);
			$("#isIndexed", holder).attr("checked", data.indexed).attr("disabled", disabled);
			$("#isSearchDefault", holder).attr("checked", data.searchDefault).attr("disabled", disabled);
			$("#isAutoComplete", holder).attr("checked", data.autocomplete).attr("disabled", disabled);

			if (data.copyFields && data.copyFields.length > 0) {
				populateCopyFields(copyFieldDivId, addOneTimeButtonId, holder, data.copyFields, tableId);
			}
			isEdit = true;
		}

		currentFieldType = $("#fieldTypeCombo", holder).val();
		if (currentFieldType === sea.constants.schemaAllowedDataTypes.tdate.fieldName) {
			$("#fieldTypeCombo")
					.parents(".form-group:first")
					.append("<div class='col-lg-2'><button class='btn btn-default btnAddCustomDateAlternate'>Custom date</button></div>");
		}

		currentMultivalued = $("#isMultiValued", holder).is(":checked");

		var onSaveOrCancelClick = function() {
			var $seaContainer = $("#seaContainer");
			holder.remove();
			//holder refers to the edit field. So using sea container instead
			if ($(".schema_editTable", $seaContainer).length == 0) {
				$(".field-attribute-status", $seaContainer).removeClass("disabled");
				$("a.schema-type", $seaContainer).removeClass("disabled");
			}
			if (elementId != sea.constants.DATA_SOURCES + "_schema") {
				$("#" + elementId, "#" + tableId).remove();
			}
			$(btnObj).attr("action", "show");
		};
		var saveBtnClickHandler = function(e) {
			try {
				sea.util.validateInputsAndGetData(holder);
			} catch (e) {
			}

			var copyFieldData = getCopyFieldData(copyFieldDivId, holder);

			var reqData = {};
			reqData.fieldName = $("#fieldName", holder).val();
			reqData.type = $("#fieldTypeCombo", holder).val();
			reqData.indexed = $("#isIndexed", holder).is(":checked");
			reqData.stored = $("#isStored", holder).is(":checked");
			reqData.multiValued = $("#isMultiValued", holder).is(":checked");
			reqData.searchDefault = $("#isSearchDefault", holder).is(":checked");
			reqData.autocomplete = $("#isAutoComplete", holder).is(":checked");
			reqData.copyFields = copyFieldData;

			var customDate = $(".customDateInput", holder).val();
			var customDateReq = {};
			customDateReq.nameValuePairsLst = [];

			if (customDate) {
				reqData.type = qb.base.constants.schemaCustomDateFormat + customDate;
				customDateReq.nameValuePairsLst.push([ {
					key : "format",
					value : customDate
				}, {
					key : "type",
					value : "dateFormat"
				} ]);
			}
			successFunc = function(resp) {
				onSaveOrCancelClick();
				sea.services.getDSSchema(dsId, function(resp) {
					onSchemaRespReceived(resp);
					getDataTable(tableId, coreName, dsId);
				}, null, $(containerId));
				showCrawlPrompt(dsId);
			};

			var createField = function() {
				if (customDate) {
					sea.services.addFieldType(dsId, customDateReq, function() {
						sea.services.createField(reqData, coreName, isEdit, successFunc, null, holder);
					}, null, holder);
				} else {
					sea.services.createField(reqData, coreName, isEdit, successFunc, null, holder);
				}
			};

			if (isEdit && (reqData.type != currentFieldType || reqData.multiValued != currentMultivalued)) {
				var dataObj = {};
				dataObj.changeType = sea.MiscConstants.deleteCrawledDataChangeType.FIELD;
				dataObj.dsId = dsId;
				dataObj.holder = holder;
				dataObj.callback = function() {
					createField();
				};
				sea.dsController.checkForDeleteRequirement(dataObj);
			} else {
				createField();
			}
		};

		$("#btn_save", holder).off("click").on("click", saveBtnClickHandler);
		$("#btn_cancel", holder).off("click").on("click", function() {
			onSaveOrCancelClick();
		});

	};

	var deleteCrawledData = function(dsId, cb) {
		var promptModalElm = $("#deleteCrawledData");
		$(".deleteCrawledDataMsg", promptModalElm).text(localMsg.PromptFieldChangeDeleteMsg);
		var jobId = 0;
		sea.services.getCrawlStatus(dsId, jobId, function(resp) {
			if (resp.status.totalcount > 0) {
				sea.dsController.deleteCrawledData(dsId, null, function(resp) {
					if (resp === true) {
						cb();
					} else {
						cvUtil.toast(localMsg.E10639);
					}
				});
			} else {
				cb();
			}
		});
	};

	var showCrawlPrompt = function(dsId) {
		var promptModalElm = $("#promptCrawl");
		var msg = localMsg.PromptCrawlMsg;
		$(".promptCrawlMsg", promptModalElm).text(msg);

		var type = $.parseParams(window.location.search.substring(1)).type;
		if (type === sea.constants.DSTypes.BLANK) {
			return;
		}
		var yesBtnHandler = function(e) {
			sea.services.crawl(dsId, sea.constants.Actions.START_CRAWL, function(resp) {
				cvUtil.toast(cvFormatters.formatString(localMsg.CrawlRequestSubmitted, [ sea.crawlController
						.getCrawlStatusDispText(resp) ]));
			}, function(errResp, msg) {
				alert(localMsg.CrawlRequestSubmitFailed);
			});
		};
		promptModalElm.modal('show').find(".modal-dialog").draggable().off("click", ".yesBtn").on("click",
				".yesBtn",
				yesBtnHandler);
	};

	var populateCopyFields = function(copyFieldDivId, addOneTimeButtonId, holder, copyFields, tableId) {
		var len = copyFields.length;
		for (var i = 0; i < len; i++) {
			var entity = copyFields[i];
			onAddCopyFieldBtnClick(copyFieldDivId, addOneTimeButtonId, holder, null, entity, true, tableId, function(
					data) {
				populateComboFromArray($("#" + data.colDropdownId, holder), getSchemaFieldsFromTable(tableId));
				$("#" + data.colDropdownId).val(entity);
			});
		}
	};

	/*
	 * holder - parent table currentElm - element after which the new controls have to be inserted; if null,
	 * it will get appended valueToPoupate - values for populating the input controls for edit; null in case
	 * of creation
	 */
	var onAddCopyFieldBtnClick = function(copyFieldDivId, addOneTimeButtonId, holder, currentElm, valueToPopulate,
			isEdit, tableId, callBack) {

		var templClass = "copyFieldDivTmpl";

		var divToBeAdded = $("." + templClass).clone().removeClass(templClass).show();

		var colDropdownId = $("#" + copyFieldDivId + " > div").size();
		colDropdownId = colDropdownId + 1;

		var selectHtml = "<select id='" + colDropdownId + "' class='form-control copyFieldCombo'></select>";
		$(selectHtml).insertBefore(divToBeAdded.find(".addCopyFieldBtn"));

		if (currentElm) {
			divToBeAdded.insertAfter(currentElm);
		} else {
			divToBeAdded.appendTo($("#" + copyFieldDivId, holder));
			$("#" + addOneTimeButtonId).hide();
		}
		if (valueToPopulate) {
			divToBeAdded.find(".copyFieldCombo").val(valueToPopulate.copyFields);
		}
		$(".addCopyFieldBtn", divToBeAdded).on("click",
				function(event) {
					onAddCopyFieldBtnClick(copyFieldDivId,
							addOneTimeButtonId,
							holder,
							$(this).parent().parent(),
							null,
							isEdit,
							tableId,
							function(data) {
								populateComboFromArray($("#" + data.colDropdownId, holder),
										getSchemaFieldsFromTable(tableId));
							});
				});
		$(".delCopyFieldBtn", divToBeAdded).on("click", function(event) {
			$(this).parent().parent().remove();
			if ($("#" + copyFieldDivId, holder).find(".copyFieldInputDiv").length == 0) {
				$("#" + addOneTimeButtonId).show();
			}
		});

		callBack({
			"colDropdownId" : colDropdownId,
			"entity" : valueToPopulate
		});
	};

	var getCopyFieldData = function(copyFieldDivId, holder) {
		var reqArray = [];
		$("#" + copyFieldDivId, holder).find(".copyFieldInputDiv").each(function(idx, value) {
			var eachRow = {};
			eachRow = $.trim($(this).find(".copyFieldCombo").val());
			reqArray.push(eachRow);
		});
		return reqArray;
	};

	var getAddFieldButton = function(coreName, dsId, toolBarId, tableId) {
		var btn = $("<button id='btnCreateField' class='btn btn-primary'/>");
		$(btn).text(localMsg.CreateNewField);

		$(btn).click(function() {
			handleAddNewField(coreName, dsId, toolBarId, tableId, null);
		});
		return btn;
	};

	var getDeleteableFields = function(fields, showSystemFields, showDynamicFields, removeEEFields) {
		if (!$.isEmptyObject(fields)) {

			if (showSystemFields && showDynamicFields && !removeEEFields) {
				return fields;
			} else {
				var fieldsToReturn = fields
						.filter(function(eachField) {
							if (!eachField.skipdelete) {
								eachField.skipdelete = ($.inArray(eachField.fieldName, SYSTEM_DEFINED_FIELDS) != -1);
							}
							return ((eachField.skipdelete && showSystemFields) ||
									(eachField.dynamicField && showDynamicFields) || (!eachField.skipdelete && !eachField.dynamicField) &&
									(!removeEEFields || (removeEEFields && !eachField.fieldName.startsWith("entity_") &&
											eachField.fieldName !== "entities_extracted" && eachField.fieldName !== "isCAResult")))

						});

				return cvSearchUtil.sortArrayByKey(fieldsToReturn, "fieldName");
			}
		}
		return fields;
	};

	/*
	 * this returns fields which are in INCLUDE_ANYWAYS_FIELDS array if dsType is WEB and only if STORED don't
	 * want to overload getDeleteableFields, so writing as new function
	 */
	var getSearchViewFields = function(fields, dsType) {
		if (!$.isEmptyObject(fields)) {
			var fieldsToReturn = fields
					.filter(function(eachField) {
						return (dsType === sea.constants.DSTypes.WEB && $.inArray(eachField.fieldName,
								INCLUDE_ANYWAYS_FIELDS) >= 0) ||
								(!eachField.skipdelete && $.inArray(eachField.fieldName, SYSTEM_DEFINED_FIELDS) === -1 && (eachField.stored || eachField.docValues));
					});
			return cvSearchUtil.sortArrayByKey(fieldsToReturn, "fieldName");
		}
		return fields;
	};

	var onFieldEditBtnClicked = function(btnObj, tableId, data) {
		var fieldId = data.fieldName;
		var $btn = $(btnObj);
		var $table = $("#" + tableId);

		$("#" + fieldId, $table).remove();
		if ($btn.attr("action") == "hide") {
			$btn.attr("action", "show");
			$(".field-attribute-status", $table).removeClass("disabled");
			$("a.schema-type", $table).removeClass("disabled");
			return;
		} else {
			$btn.attr("action", "hide");
			var trElm = $btn.parent().parent();
			var colsCnt = sea.ColumnConfiguration.schemaConfig.length;
			var html = "<tr><td id=" + fieldId + " colspan=" + colsCnt + ">" + "</td></tr>";
			if (trElm) {
				$(html).insertAfter($(trElm));
			}
		}
	};

	var onFielddeleteBtnClicked = function(coreName, dsId, data, tableId) {
		var confirmModalElm = $("#confirmDeleteField");
		var msg = cvFormatters.formatString(localMsg.DeleteFieldConfMsg, [ data.fieldName ]);
		$(".confirmDeleteMsg", confirmModalElm).html(msg);
		var deleteBtnHandler = function(e) {
			sea.services.deleteField(dsId, data.fieldName, function(resp) {
				sea.services.getDSSchema(dsId, function(resp) {
					onSchemaRespReceived(resp);
					getDataTable(tableId, coreName, dsId);
					showCrawlPrompt(dsId);
				});
			}, null, $(containerId));
		};

		confirmModalElm.modal('show').find(".modal-dialog").draggable().off("click", ".deleteBtn").on("click",
				".deleteBtn",
				deleteBtnHandler);
	};
	/*
	 * There is only one schemaController instance for entire datacube. So all clear state actions should be
	 * executed here - on drawing of a new datatable
	 */
	var getDataTable = function(tableId, coreName, dsId) {
		resetMultiEditStates();
		var tableElm = $("#" + tableId);
		var tableDTObj;
		if (!$.fn.DataTable.isDataTable("#" + tableId)) {
			$(uiControls.util.getDataTableHtml(tableId, sea.ColumnConfiguration.schemaConfig))
					.appendTo("#schema_wrapper");
			tableElm = $("#" + tableId);
			var config = $.extend({}, schemaDTConfig);
			config.data = [];
			config.columns = sea.ColumnConfiguration.getConfigInDTFormat(sea.ColumnConfiguration.schemaConfig);

			config.drawCallback = function() {
				tableElm.find("[data-toggle='tooltip']").tooltip();
				if ($(".btn-save-multiedit").length > 0) {
					$(".btnEdit", tableElm).attr("disabled", true);
					$(".btnDelete", tableElm).attr("disabled", true);
				}
			};

			tableElm.off("column-sizing.dt").on("column-sizing.dt", uiControls.util.getDTResizeHandler(tableId));
			tableElm.off("init.dt").on("init.dt", function() {
				//if the data is populated with array, column-sizing is not fired for the first time, so trigger it
				tableElm.trigger("column-sizing.dt");
			});
			tableDTObj = tableElm.DataTable(config);
			var tbElm = $("div.toolbar");
			tbElm.html("<div class='checkbox'>" + "<label class='showSystemFieldsLabel'>" +
					"<input type='checkbox' id='SystemFields'> " + localMsg.ShowSystemFields + "</label>" + "</div>");
			tbElm.append("<div class='checkbox'>" + "<label class='showDynamicFieldsLabel'>" +
					"<input type='checkbox' id='DynamicFields'> " + localMsg.ShowDynamicFields + "</label>" + "</div>");
			tableElm.off("page.dt").on("page.dt", function() {
				/*
				 * scenario: User pressed the 'edit' button. All multiedit actions are now disabled. With the
				 * 'edit' dialogue still on screen, user navigates to another page. He navigates back to the
				 * original page - edit dialogue won't be there, but multiedit options would still be
				 * disabled. Handling this scenario so that multiedit will be enabled the moment the user
				 * navigates out of the page
				 */
				$(".field-attribute-status").removeClass("disabled");
				$("a.schema-type").removeClass("disabled");
			});

			tbElm.off('change', '#SystemFields, #DynamicFields').on('change',
					'#SystemFields, #DynamicFields',
					function() {
						getDataTable(tableId, coreName, dsId);
					});

			tableElm.off('click', 'button.btnEdit').on('click', 'button.btnEdit', function() {
				var data = tableDTObj.row($(this).parents('tr')).data();
				$(".field-attribute-status").addClass("disabled");
				$("a.schema-type").addClass("disabled");
				onFieldEditBtnClicked(this, tableId, data);
				handleAddNewField(coreName, dsId, data.fieldName, tableId, data, this);
			});

			tableElm.off('click', 'button.btnDelete').on('click', 'button.btnDelete', function() {
				var data = tableDTObj.row($(this).parents('tr')).data();
				onFielddeleteBtnClicked(coreName, dsId, data, tableId);
			});

			tableElm.off("click", ".field-attribute-status").on("click",
					".field-attribute-status",
					function() {
						var changedAttribute = $(this).data("attribute");
						var fieldName = $(this).parent().siblings(".schema-fieldName").find(".schema-fieldName-value")
								.data("value");

						if (changedAttribute !== "type") {
							handleMultieditClick($(this));
						} else {
							return;
						}

						if ($.isEmptyObject(multieditChanges[fieldName])) {
							multieditChanges[fieldName] = $.extend(true, {}, schemaFieldsHash[fieldName]);
						}

						multieditChanges[fieldName][changedAttribute] = $(this).data("value");
					});

			tableElm.off("change", ".schema-type select.field-attribute-status").on("change",
					".schema-type select.field-attribute-status",
					function() {
						var fieldName = $(this).parent().siblings(".schema-fieldName").find(".schema-fieldName-value")
								.data("value");
						var selectedVal = $(this).val();

						if ($.isEmptyObject(multieditChanges[fieldName])) {
							multieditChanges[fieldName] = $.extend(true, {}, schemaFieldsHash[fieldName]);
						}
						multieditChanges[fieldName].type = selectedVal;
						if (selectedVal === sea.constants.schemaAllowedDataTypes.tdate.fieldName) {
							$(this).parent()
									.append("<button class='btn btn-default btnAddCustomDate'>Custom date</button>");
						} else {
							$(this).parent().find(".customDateInput,.btnAddCustomDate").remove();
						}

						handleMultieditClick($(this));
					});

			tableElm.off("input", ".schema-type input.customDateInput").on("input",
					".schema-type input.customDateInput",
					function() {
						var fieldName = $(this).parent().siblings(".schema-fieldName").find(".schema-fieldName-value")
								.data("value");
						if ($.isEmptyObject(multieditChanges[fieldName])) {
							multieditChanges[fieldName] = $.extend(true, {}, schemaFieldsHash[fieldName]);
						}
						multieditChanges[fieldName].customDate = $(this).val();
					});

			var showCustomDateInputField = function($element) {
				var $customDateInput = $("<input class='customDateInput form-control' placeholder='dd/MM/yyyy'>");
				$element.parent().append($customDateInput);
				$customDateInput.focus();
				$element.remove();
			}
			tableElm.off("click", ".btnAddCustomDate").on("click", ".btnAddCustomDate", function() {
				showCustomDateInputField($(this));
				handleMultieditClick($(this));
			});

			//because the 'add custom date' button in the edit dropdown need not call handleMultiEditClick()
			tableElm.off("click", ".btnAddCustomDateAlternate").on("click", ".btnAddCustomDateAlternate", function() {
				showCustomDateInputField($(this));
			});

			tableElm.off("click", ".btnSaveCustomDate").on("click", ".btnSaveCustomDate", function() {
				var customDate = $(this).siblings(".customDateInput").val();
				var reqObj = {};
				reqObj.nameValuePairsLst = [];
				reqObj.nameValuePairsLst.push([ {
					key : "format",
					value : customDate
				}, {
					key : "type",
					value : "dateFormat"
				} ]);
				sea.services.addFieldType(dsId, reqObj, function(resp) {
					onSchemaTypeClicked(resp.error);
				}, null, $(this));
			});

			//The field type combo that comes up after pressing the 'edit' button
			tableElm
					.off("change", "#fieldTypeCombo")
					.on("change",
							"#fieldTypeCombo",
							function() {
								var $parentForm = $(this).parents(".form-group:first");
								if ($(this).val() === sea.constants.schemaAllowedDataTypes.tdate.fieldName) {
									$parentForm
											.append("<div class='col-lg-2'><button class='btn btn-default btnAddCustomDateAlternate'>Custom date</button></div>");
								} else {
									$(".btnAddCustomDateAlternate", $parentForm).parent().remove();
									$(".customDateInput", $parentForm).parent().remove();
								}
							});

			tableElm
					.off("click", "a.schema-type")
					.on("click",
							"a.schema-type",
							function() {
								var $parent = $(this).parent();
								var data = $(this).data("value");
								var $select = $("<select class='form-control field-attribute-status edited' data-attribute='type'></select>");
								//saving the data to the parent so that we can get it from the parent on resetting.
								$parent.data("value", data);
								$(this).hide();
								$parent.append($select);
								populateFieldsTypesCombo($select);

								if (!$select.find("option[value='" + data + "']").length) {
									/*
									 * If the field data type is not among
									 * sea.constants.schemaAllowedDataTypes, it would not appear in the drop
									 * down. In this case, we have to add it to the drop down manually
									 */
									$select.append("<option value='" + data + "'>" + data + "</option>");
								}
								$select.val(data);
								if (data === sea.constants.schemaAllowedDataTypes.tdate.fieldName) {
									$(this)
											.parent()
											.append("<button class='btn btn-default btnAddCustomDate'>Custom date</button>");
								}
							});

			$(containerId).off("click", ".btn-reset-multiedit").on("click", ".btn-reset-multiedit", function() {
				var $active = $(".field-attribute-status.edited");
				var $parent, data;

				$("td.edited", tableElm).removeClass("edited");

				$.each($active, function(index, elem) {
					var $elem = $(elem)
					if ($elem.hasClass("true")) {
						$elem.removeClass("true");
						$elem.addClass("false");
					} else if ($elem.hasClass("false")) {
						$elem.removeClass("false");
						$elem.addClass("true");
					} else if ($elem.prop("tagName") === "SELECT") {
						$parent = $elem.parent();
						data = $elem.parent().data("value");
						$elem.remove();
						$parent.append("<a class='schema-type' data-value='" + data + "'>" + data + "</a>");
					}
					$elem.toggleClass("edited");
					if ($elem.data("value")) {
						$elem.data("value", false);
					} else {
						$elem.data("value", true);
					}
				});

				resetMultiEditStates();
				handleMultieditClick();
			});

			$(containerId).off("click", ".btn-save-multiedit").on("click", ".btn-save-multiedit", function() {
				var reqObj = null;
				var $self = $(this);
				var dataObj = {};
				var $customDates = $(".customDateInput", tableElm);
				var customDateReq = {};
				customDateReq.nameValuePairsLst = [];
				var customDatesList = [];
				for (field in multieditChanges) {
					if (multieditChanges.hasOwnProperty(field)) {
						var customDate = multieditChanges[field].customDate;
						if (customDate != undefined && customDate.length > 0) {
							var index = fieldTypes.indexOf("DateFormat :" + customDate);
							if (index !== -1) {
								multieditChanges[field].type = fieldTypes[index];
							} else {
								var newFieldName = qb.base.constants.schemaCustomDateFormat + customDate;
								multieditChanges[field].type = newFieldName;

								/*
								 * adding to fieldTypes so that if user specifies 2 custom date formats of the
								 * same type in one multi-edit, we don't attempt to create the same custom
								 * date format twice.
								 */
								fieldTypes.push(newFieldName);

								customDateReq.nameValuePairsLst.push([ {
									key : "format",
									value : customDate
								}, {
									key : "type",
									value : "dateFormat"
								} ]);
							}
							//this property is not needed anymore
							delete multieditChanges[field].customDate;
						}
					}
				}
				var schemaFieldsList = $.map(multieditChanges, function(field, index) {
					return field;
				});

				reqObj = {
					schemaFields : schemaFieldsList
				};
				$self.attr("disabled", true);
				dataObj.changeType = sea.MiscConstants.deleteCrawledDataChangeType.FIELD;
				dataObj.dsId = dsId;
				dataObj.callback = function() {
					var createField = function() {
						sea.services.createField(reqObj, coreName, true, function() {
							$self.attr("disabled", false);
							sea.services.getDSSchema(dsId, function(resp) {
								onSchemaRespReceived(resp);
								getDataTable(tableId, coreName, dsId);
								showCrawlPrompt(dsId);
								handleMultieditClick();
							}, null, tableElm);
						}, function(error) {
							cvUtil.errorToast(error.error.errLogMessage);

							$self.attr("disabled", false);
						}, tableElm);
					};

					if (customDateReq.nameValuePairsLst.length) {
						var successFlag = 0;
						sea.services.addFieldType(dsId, customDateReq, function(resp) {
							createField();
						}, null, $(this));
					} else {
						createField();
					}
				};

				//Will get called if the user presses "cancel" when prompted for delete crawled data
				dataObj.errCb = function(error) {
					handleMultieditClick();
					$self.attr("disabled", false);
				};

				if (multieditChangedAttributesList["type"] || multieditChangedAttributesList["multiValued"]) {
					sea.dsController.checkForDeleteRequirement(dataObj);
				} else {
					dataObj.callback();
				}
			});

			var handleMultieditClick = function($clicked) {
				var dtData = null;
				var attribute = null;
				if ($clicked) {
					attribute = $clicked.data("attribute");

					if (attribute !== "type") {
						/*
						 * If element does not have active class, active class will be toggle on. This means
						 * that user is making an edit, and not reverting an edit. So we add it to the list of
						 * edited attributes. If it already has an active class, it means that the user is
						 * reverting an edit.
						 */
						if (!$clicked.hasClass("edited")) {
							multieditChangedAttributesList[attribute] = 1;
						} else {
							multieditChangedAttributesList[attribute] = 0;
						}

						if ($clicked.data("value") == true) {
							$clicked.removeClass("true").addClass("false").toggleClass("edited").data("value", false);
							// $clicked.data("value", false);
							// $clicked.toggleClass("active");
							$clicked.parent().toggleClass("edited");
						} else {
							$clicked.removeClass("false").addClass("true").toggleClass("edited").data("value", true);
							// $clicked.addClass("true");
							// $clicked.data("value", true);
							// $clicked.toggleClass("active");
							$clicked.parent().toggleClass("edited");
						}
					} else if (attribute === "type" && !$clicked.hasClass("edited")) {
						$clicked.addClass("edited");
					} else if (attribute === "type") {
						if ($clicked.val() !== $clicked.siblings(".schema-type").data("value")) {
							multieditChangedAttributesList[attribute] = 1;
						} else {
							$clicked.siblings("a.schema-type").show();
							$clicked.remove();
							multieditChangedAttributesList[attribute] = 0;
						}
					}

				}

				var $multieditSave = $(".btn-save-multiedit");
				var $multieditReset = $(".btn-reset-multiedit");
				var totalEdited = $(".field-attribute-status.edited", tableElm).length;
				if (totalEdited > 0 && $multieditSave.length === 0) {
					tableElm.parents(".dataTables_wrapper").find(".toolbar")
							.append("<button class='btn btn-sm btn-primary btn-save-multiedit'>" + localMsg.Save +
									"</button>" + "<button class='btn btn-sm btn-default btn-reset-multiedit'>" +
									localMsg.Reset + "</button>");
					// $(".btnEdit", tableElm).attr("disabled", true);
					tableElm.find(".btnEdit").attr("disabled", true);
					tableElm.find(".btnEdit:hidden").attr("disabled", true);
					tableElm.find(".btnDelete").attr("disabled", true);
					$("#seaContainer #btnCreateField").attr("disabled", true);
				} else if (totalEdited === 0) {
					if ($multieditSave.length > 0) {
						$multieditSave.remove();
						$multieditReset.remove();
					}
					$(".btnEdit", containerId).attr("disabled", false);
					$(".btnDelete", containerId).attr("disabled", false);
					$("#seaContainer #btnCreateField").attr("disabled", false);
					dtData = tableDTObj.data();
					tableDTObj.clear();
					tableDTObj.rows.add(dtData);
					tableDTObj.draw(false);
				}
			};

		} else {
			tableDTObj = tableElm.DataTable();
		}

		tableDTObj.search("").clear().rows.add(getDeleteableFields(schemaFields,
				$("#SystemFields").is(':checked'),
				$("#DynamicFields").is(':checked'))).draw();

	};

	var getSchemaFieldsFromTable = function(tableId) {
		//this is to make sure the combo is populated with the fields list of the same order as in the data table
		return $("#" + tableId).DataTable().column(0).data();
	};

	var onSchemaRespReceived = function(resp) {
		if (!resp.fieldTypes) {
			resp.fieldTypes = [];
		}
		if (sea.isAllSchemaFieldDataTypes) {
			fieldTypes = resp.fieldTypes.sort();
		} else {
			resp.fieldTypes = resp.fieldTypes.sort();

			fieldTypes = $.map(resp.fieldTypes, function(type, i) {
				if (!$.isEmptyObject(sea.constants.schemaAllowedDataTypes[type]) ||
						type.startsWith(qb.base.constants.schemaCustomDateFormat) ||
						!$.isEmptyObject(sea.constants.newSchemaAllowedDataTypes[type])) {
					return type;
				}
			});
		}
		schemaFields = resp.schemaFields;

		$.each(getDeleteableFields(schemaFields), function(index, schemaField) {
			schemaFieldsHash[schemaField.fieldName] = schemaField;
		});
	};

	var isKnownSchemaFieldType = function(type) {
		var schemaAllowedDataTypes = sea.constants.schemaAllowedDataTypes[type];
		var newSchemaAllowedDataTypes = sea.constants.newSchemaAllowedDataTypes[type];
		return !$.isEmptyObject(schemaAllowedDataTypes) ? schemaAllowedDataTypes.fieldName :
		 (!$.isEmptyObject(newSchemaAllowedDataTypes) ? newSchemaAllowedDataTypes.fieldName : false);
		
	};

	var onViewSchema = function(coreName, dsName, dsId) {
		var $wrapper = $("<div id='schema_wrapper' class='wrapper_class'></div>");
		$(containerId).append($wrapper);
		var tableId = sea.constants.DATA_SOURCES + "_schemaDT";
		// Schema toolbar
		toolBarId = sea.constants.DATA_SOURCES + "_schema";
		// Toolbar with submenu nav
		var headerToolBar = uiControls.util.getTemplate("tmpl_SubMenuToolbar", "div");
		headerToolBar.attr("id", toolBarId + "_headerElm").appendTo("#schema_wrapper");
		var schemaToolBar = new ToolBar("#schema_wrapper", toolBarId, localMsg.Schema); // localize

		sea.services.getDSSchema(dsId, function(resp) {
			onSchemaRespReceived(resp);
			getDataTable(tableId, coreName, dsId);
			schemaToolBar.addButton(getAddFieldButton(coreName, dsId, toolBarId, tableId));
		}, null, $(containerId));
	};

	return {
		handleViewSchema : onViewSchema,
		getDeleteableFields : getDeleteableFields,
		getSearchViewFields : getSearchViewFields
	};

})();
