function SalesforceHandler() {
	this.type = sea.constants.DSTypes.SALESFORCE;
}

SalesforceHandler.prototype.initializeStep = function(step, holder, isEdit) {
	
};

SalesforceHandler.prototype.validateStep = function(step, holder, aggregatedInput, callback, isEdit, dsObj) {
	var $formWrapper = holder.parents(".cvWizard-form-wrapper");
	var reqData = null;
	var self = this;
	var columns = null;
	var tableList = null;
	var tableListHolder = null;

	try {
		sea.util.validateInputsAndGetData(holder);
	} catch (e) {
		callback(false);
		return;
	}

	switch (step) {
	case 1:
		if (!isEdit) {
			this.isDatasourceNameExists(holder, callback);
		} else {
			callback(true);
		}
		break;
	case 2:
		reqData = this.getRequestObject();
		if (!isEdit) {
			reqData.operationtype = sea.constants.Operations.CREATE;

			//tablename should not be present in the request
			if (reqData.properties.tablename) {
				delete reqData.properties.tablename;
			}
			sea.services.getMetaInfo(reqData, function(res) {
				var collections = res.schemaInfo.tablesInfo;
				if (collections && collections.length > 0) {
					self.getTableList(isEdit, $formWrapper, collections, self.type);
					callback(true);
				}
			}, function(error) {
				cvUtil.errorToast(error.error.errLogMessage);
				callback(false);
			}, holder);
		} else {
			reqData.id = dsObj.datasourceId;
			reqData.operationtype = sea.constants.Operations.MODIFY;
			this.initTableList($formWrapper);
			tableListHolder = $("#tableList", $formWrapper);
			tableListHolder.val(dsObj.properties.tablename);
			tableListHolder.attr("disabled", "disabled");
			reqData.properties.tablename = dsObj.properties.tablename;
			this.getTableDetails(dsObj.properties.tablename,
					reqData,
					isEdit,
					$formWrapper,
					dsObj.properties.columns,
					function(resp) {
						self.showMetaPanel();
						self.setTableEventHandlers(isEdit, $formWrapper);
						if (resp != null) {
							callback(true);
						} else {
							callback(false);
						}
					});
		}

		break;
	case 3:
		reqData = this.getRequestObject();
		if (isEdit) {
			columns = dsObj.properties.columns;
		} else if (!this.properties.tablename) {
			cvUtil.errorToast(localMsg.TableEmptyError);
		}

		this.getTableDetails(this.properties.tablename, reqData, isEdit, $formWrapper, columns, function(resp) {
			if (resp != null) {
				self.properties.primary_key = resp.properties.primary_key;
				callback(true);
			} else {
				callback(false);
			}
		});
		break;
	case 4:
		if (!this.checkPrimary) {
			cvUtil.toast(localMsg.PrimaryKeySelection);
			callback(false);
		} else if ($('#table_data tr.selected', holder).length > 99) {
			cvUtil.toast(localMsg.ColumnLimit);
			callback(false);
		} else {
			callback(true);
		}
		break;
	}
};

SalesforceHandler.prototype.submit = function(isEdit, data, holder) {
	if (!isEdit) {
		this.create(null, holder);
	} else {
		this.update(null, data, holder);
	}
};

SalesforceHandler.prototype.fetch = function(step, holder) {
	/*
	 * Some properties are fetched in the validation steps because they involve some calls to the server.
	 */
	var columnJson = {};
	var primaryKey = null;
	var checkPrimary = false;
	var fetchedData = null;

	switch (step) {
	case 1:
		fetchedData = this.fetchBasicDetails(holder);
		break;
	case 2:
		fetchedData = {
			properties : {
				username : $("#dsUserName", holder).val(),
				password : Base64.encode($("#dsPassword", holder).val()),
				securityToken : Base64.encode($("#dsSecurityToken", holder).val())
			}
		};
		break;
	case 3:
		fetchedData = {
			properties : {
				tablename : $("#tableList", holder).val()
			}
		};
		break;
	case 4:
		/*
		 * resetting search so that all rows are there in the dom. Assuming that search() call is synchronous
		 * (since it's client side search)
		 */
		$("#table_data", holder).DataTable().search("").draw();

		primaryKey = $('.primaryKey', holder).text();

		if ($('#table_data tr.selected', holder).length == 0) {
			$('.table-content tbody tr').addClass('selected');
			$('.table-content tbody tr input:checkbox').prop("checked", true);
		}

		/*  Deleting already saved list of columns
			If these are not deleted manually, when this.udpateProperties() is called
			it will not remove previously selected but now unselected columns (in case user goes a 
			step back in the wizard).
		*/
		this.properties.columns = {};
		
		$('#table_data tbody tr.selected', holder).each(function(index, row) {
			var cname = $(row).data("name");
			var ctype = $(row).find("td:eq(2)").html();
			if (cname == primaryKey) {
				checkPrimary = true;
			}
			columnJson[cname] = ctype;
		});

		this.checkPrimary = checkPrimary;

		fetchedData = {
			properties : {
				columns : columnJson,
				always_incremental : $("#dsIncCrawl", holder).is(":checked")
			// retainallversions: $("#isRetainVersions", holder).is(":checked")
			},
			dsCrawl : $("#dsCrawl", holder).is(":checked")
		};
		break;
	}

	this.updateProperties(fetchedData);
	return fetchedData;
};

SalesforceHandler.prototype.initDSSpecificComponents = function(holder, isEdit, fnCallBack) {
	fnCallBack({
		"callBack" : true
	});

	$(holder).off('focus', '#tableList').on('focus', '#tableList', function() {
		$(this).autocomplete("search");
	});
};

SalesforceHandler.prototype.populateDSSpecificProperties = function(props, holder, onEdit) {
	try {
		if (onEdit) {
			$("#dsUserName", holder).val(props.username);
			$("#dsPassword", holder).val(cvUtil.base64Decode(props.password));
			$("#dsSecurityToken", holder).val(cvUtil.base64Decode(props.securityToken));
			$("#dsIncCrawl", holder).attr("checked", Boolean(props.always_incremental));
		} else {
			$("#dsUserName", holder).text(props.username);
			$("#dsTableName", holder).text(props.tablename);
		}
	} catch (e) {
		console.log(e);
	}
};


