function LdapHandler() {
	this.type = sea.constants.DSTypes.LDAP;
}

LdapHandler.prototype.initializeStep = function(step, holder, isEdit) {
	var self = this;
	$('[data-toggle="popover"]').popover({
		html : true,
		placement : "top",
		trigger : "hover"
	});

	switch (step) {
	case 2:
		if (!isEdit && this.properties !== undefined && this.properties.accessnodeclientid === undefined) {
			this.populateLdapClientCombo(holder, isEdit);
		}
		break;
	}
};

LdapHandler.prototype.validateStep = function(step, holder, aggregatedInput, callback, isEdit, dsObj) {
	var reqData = null;
	var $formWrapper = holder.parents(".cvWizard-form-wrapper");
	var self = this;

	try {
		sea.util.validateInputsAndGetData(holder);
	} catch (e) {
		callback(false);
		return;
	}

	switch (step) {
	case 1:
		if (!isEdit) {
			this.isDatasourceNameExists(holder, callback);
		} else {
			callback(true);
		}
		break;
	case 2:
		reqData = this.getRequestObject();
		if (!isEdit) {
			reqData.operationtype = sea.constants.Operations.CREATE;
			sea.services.getMetaInfo(reqData, function(res) {
				var nameValues = res.nameValueMaps.nameValues;
				var collectionLength = nameValues.length;
				if (nameValues && collectionLength > 0) {
					self.getLdapTableDetails(nameValues, collectionLength, isEdit, $formWrapper);
					$("#selectAll", $formWrapper).trigger("click");
					if (typeof callback == "function") {
						callback(true);
					}
				} else {
					cvUtil.toast(localMsg.NoErrorFromServerMsg);
				}

			}, function(error) {
				cvUtil.errorToast(error.error.errLogMessage);
				callback(false);
			}, holder);
		} else {
			reqData.id = dsObj.datasourceId;
			reqData.operationtype = sea.constants.Operations.MODIFY;
			sea.services.getMetaInfo(reqData, function(res) {
				var nameValues = res.nameValueMaps.nameValues;
				var collectionLength = nameValues.length;
				var searchbaselist = dsObj.properties.searchbaselist;
				var name = null;

				if (nameValues && collectionLength > 0) {
					self.getLdapTableDetails(nameValues, collectionLength, isEdit, $formWrapper)
					for ( var key in searchbaselist) {
						name = searchbaselist[key].name;
						$('tr[data-name="' + name + '"]').addClass('selected');
						$('tr[data-name="' + name + '"] td input:checkbox').prop("checked", true);
						if (searchbaselist[key].values) {
							$('tr[data-name="' + name + '"] td input.tableInputTextbox')
									.val(searchbaselist[key].values[0]);
						}
					}
					if (typeof callback == "function") {
						callback(true);
					}
				} else {
					cvUtil.toast(localMsg.NoErrorFromServerMsg);
				}
			}, function(error) {
				cvUtil.errorToast(error.error.errLogMessage);
				callback(false);
			}, holder);
		}
		break;
	case 3:
		callback(true);
		break;
	}
};

LdapHandler.prototype.submit = function(isEdit, data, holder) {
	if (!isEdit) {
		this.create(null, holder);
	} else {
		this.update(null, data, holder);
	}
};

LdapHandler.prototype.fetch = function(step, holder) {
	var fetchedData = null;
	var searchbaselist = [];

	switch (step) {
	case 1:
		fetchedData = this.fetchBasicDetails(holder);
		break;
	case 2:
		fetchedData = {
			properties : {
				username : $("#dsUserName", holder).val(),
				password : Base64.encode($("#dsPassword", holder).val()),
				domain : $("#dsDomainController", holder).val(),
				isSecuredLdap : $("#isSecuredLDAP", holder).is(":checked")
			}
		}

		var accessNode = $("#ldapClientListCombo", holder).val();
		if (accessNode !== undefined && accessNode !== "") {
			fetchedData.properties.accessnodeclientid = accessNode;
		} else {
			delete fetchedData.properties.accessnodeclientid;
		}
		break;
	case 3:
		$("#table_data", holder).DataTable().search("").draw();
		if ($('#table_data tr.selected', holder).length == 0) {
			$('.table-content tbody tr').addClass('selected');
			$('.table-content tbody tr input:checkbox').prop("checked", true);
		}

		/*
		 * Removing previous selections
		 */
		this.properties.searchbaselist = [];

		$('#table_data tbody tr.selected', holder).each(function(index, row) {
			var nameValue = {};
			var row = $(row);
			nameValue.name = row.data("name");
			nameValue.value = row.find("td:eq(0) input").val();
			nameValue.values = [ row.find(".tableInputTextbox").val() ];
			searchbaselist.push(nameValue);
		});

		fetchedData = {
			properties : {
				searchbaselist : searchbaselist
			},
			dsCrawl : $("#dsCrawl", holder).is(":checked")
		};
		break;
	}

	this.updateProperties(fetchedData);
	return fetchedData;
};

LdapHandler.prototype.initDSSpecificComponents = function(holder, isEdit, fnCallBack) {
	fnCallBack({
		"callBack" : true
	});
};

LdapHandler.prototype.getLdapTableDetails = function(nameValues, collectionLength, isEdit, holder) {
	var tableId = 'table_data';
	var tableColumns = [];
	var dataSet = [];
	var tableInfoHtml = '<tbody>';
	for (var i = 0; i < collectionLength; i++) {
		var data = [];
		nameVal = nameValues[i];
		data.push('<input type="checkbox" value="' + nameVal.value + '"/>');
		data.push(nameVal.name);
		data.push('<input type="text" class="form-control tableInputTextbox" placeholder="Enter search filter">');
		dataSet.push(data);
	}
	tableColumns.push({
		"title" : '<input id="selectAll" type="checkbox" />',
		"className" : "checkBoxWidth",
		"orderable" : false
	});
	tableColumns.push({
		"title" : localMsg.SearchBase
	});
	tableColumns.push({
		"title" : localMsg.SearchFilter
	});
	$('#' + tableId, holder).DataTable({
		paging : false,
		data : dataSet,
		columns : tableColumns,
		createdRow : function(row, data, rowIndex) {
			$(row, holder).attr('data-name', data[1]);
		},
		destroy : true
	});
	this.setTableEventHandlers(isEdit, holder);
};

LdapHandler.prototype.populateDSSpecificProperties = function(props, holder, onEdit, engineId) {
	try {
		var self = this;
		if (onEdit) {
			$("#dsUserName", holder).val(props.username);
			$("#dsPassword", holder).val(cvUtil.base64Decode(props.password));
			$("#dsDomainController", holder).val(props.domain);
			$("#isSecuredLDAP", holder).attr("checked", props.isSecuredLdap).change();
			self.populateLdapClientCombo(holder, onEdit, function() {
				$("#ldapClientListCombo", holder).val(props.accessnodeclientid);
			});
		} else {
			$("#dsUserName", holder).text(props.username);
			$("#dsDomainController", holder).text(props.domain);
			self.getAllClients(engineId, function(resp) {
				var accessNode = resp.find(function(val) {
					return val.entityInfo.id === props.accessnodeclientid;
				});
				if(accessNode !== undefined) {
					$("#dsAccessNode", holder).text(accessNode.entityInfo.name);
					$(".accessNodeElement", holder).show();
				}
			});
		}
	} catch (e) {
		console.log(e);
	}
};

LdapHandler.prototype.populateLdapClientCombo = function(holder, isEdit, callback) {
	var indexServerId = $("#dsEngine", holder).find(":selected").data("clientId");		
	this.getAllClients(indexServerId, function(resp) {
		var comboObj = $("#ldapClientListCombo", holder);
		var clientList = [];
		$.each(resp, function(i, val) {
			clientList.push(val.entityInfo);
		});

		clientList = cvSearchUtil.sortArrayByKey(clientList, "name");
		comboObj.empty();
		comboObj.append("<option value selected> --" + localMsg.Select + "-- </option>");

		$.each(clientList, function(i, val) {
			var optHtml = "<option value=\"" + val["id"] + "\">" + val["name"] + "</option>";
			comboObj.append(optHtml);
		});

		if (isEdit === true) {
			callback();//to set clientid in case of edit
		}
	});
};

LdapHandler.prototype.getAllClients = function(indexServerId,callBack) {
	sea.services.getAllClients(indexServerId, this.type, function(resp) {
		callBack(resp);
	}, function(resp) {

	}, holder);
}
