var sea = sea || {};

sea.entityExtractor = (function() {

	var TOP_ENTITIES_NUM = 15;
	var containerId = sea.containerId;
	var eeTableId = "";
	var eeDTConfig = {
		"dom" : 'J<"pull-left"f><"pull-right"l><"clearfix">t<"pull-left"i><"pull-right"p><"clearfix">',
		"order" : []
	};
	var getEntityView = function(coreName, dsName, dsId, columnConfig) {
		var $wrapper = $("<div id='entity_wrapper' class='wrapper_class'></div>");
		$(containerId).append($wrapper);
		var idPrefix = coreName + "_entityView";
		// Toolbar with submenu nav
		var eeToolBar = uiControls.util.getTemplate("tmpl_SubMenuToolbar", "div");
		eeToolBar.attr("id", idPrefix + "_header").appendTo("#entity_wrapper");
		var eeToolBar1 = new ToolBar("#entity_wrapper", idPrefix + "_toolbar", localMsg.EntityExtraction);
		eeToolBar1.addButton(getSettingsButton(dsId));
		var eeContainerId = idPrefix + "_container";
		eeTableId = idPrefix + "_dt";
		$("<div id='" + eeContainerId + "'></div>").appendTo(containerId);
		$(uiControls.util.getDataTableHtml(eeTableId, columnConfig)).appendTo("#" + eeContainerId);
	};

	var getSettingsButton = function(dsId) {
		var btn = $("<button class='btn btn-primary'/>");
		var confirmModalElm = $("#entityExtractionSettings");
		$(btn).text(localMsg.Settings);
		var holder = $(".shared-users");
		$(btn).click(function() {
			confirmModalElm.modal('show');
			getHandlerId(dsId, false, function(handlers) {
				if (handlers) {
					var currentState = history.state;
					var selectedHandlerId = currentState[sea.constants.HistoryParams.HANDLER_ID];
					var handlerHtml = '';
					$.each(handlers, function(i, handler) {
						handlerHtml += '<option data-handlerid="' + handler.handlerId + '"';
						if (selectedHandlerId == handler.handlerId) {
							handlerHtml += ' selected';
						}
						handlerHtml += '>' + handler.handlerName + '</option>';
					});
					$("#entityHandler").html(handlerHtml);
					$(".saveEntityHandler").off('click').on('click', function() {
						var selected = $("#entityHandler option:selected");
						var handlerId = selected.data('handlerid');
						var handlerName = selected.text();
						currentState[sea.constants.HistoryParams.HANDLER_ID] = handlerId;
						currentState[sea.constants.HistoryParams.HANDLER_NAME] = handlerName;
						sea.history.pushState(currentState, document.title, $.param(currentState));
					});
				}
			}, null, null);
		});
		return btn;
	};

	//Called when the user clicks 'Entity Extraction' in left sub-menu
	var viewEntityTypes = function(coreName, dsName, dsId, dsType, handlerId, handlerName) {
		getEntityView(coreName, dsName, dsId, sea.ColumnConfiguration.entityTypeConfig);
		var req = null;
		getHandlerId(dsId,
				true,
				function(res) {
					if (handlerId && handlerName && handlerId != res.handlerId) {
						req = createFacetingRequest(jsonFacet);
					} else {
						handlerName = res.handlerName;
						handlerId = res.handlerId;
						var jsonFacet = '{"Entity_Location" : "unique(NER_LOCATION)","Entity_Person" : "unique(NER_PERSON)","Entity_Organization" : "unique(NER_ORGANIZATION)",  "Documents_Location": { "type":"query", "q":"NER_LOCATION:*"}, "Documents_Person": { "type":"query", "q":"NER_PERSON:*"}, "Documents_Organization": { "type":"query", "q":"NER_ORGANIZATION:*" } }';
						req = createFacetingRequest(jsonFacet);
					}
					sea.services.executeHandler(handlerId, handlerName, req, function(data) {
						if (data.facets) {
							var entity = data.facets;
							var eeList = [];
							var pieChart = [];
							var barChart = {};
							barChart.categories = [];
							barChart.data = [];
							if (entity !== null) {
								var totalEntities = 0;
								$.each(entity, function(entityType, entityNum) {
									if (entityType.includes("Entity_")) {
										entityType = entityType.substring(7);
										var docsNum = entity["Documents_" + entityType].count;
										eeList.push({
											entityType : entityType,
											entityNum : entityNum,
											documentsNum : docsNum
										});
										totalEntities += entityNum;
										pieChart.push([ entityType, entityNum ]);
										barChart.data.push(docsNum);
										barChart.categories.push(entityType);
									}
								});
								$("#" + eeTableId).on("click",
										'button.entity-type',
										function(event) {
											var eeType = $(this).text();
											onEntityTypeClicked(coreName,
													dsName,
													dsId,
													dsType,
													eeType,
													handlerId,
													handlerName);
										});
								showEntityTypeDataTable(coreName,
										dsName,
										dsId,
										dsType,
										eeList,
										sea.ColumnConfiguration.entityTypeConfig);
								if (totalEntities > 0) {
									showEntityTypeChart(pieChart, barChart, dsId);
								}
							}
						} else {
							showEntityTypeDataTable(coreName,
									dsName,
									dsId,
									dsType,
									null,
									sea.ColumnConfiguration.entityTypeConfig);
						}
					}, null, "#" + containerId);
				});

	};

	var viewEntityDetails = function(coreName, dsName, dsId, dsType, eeType, handlerId, handlerName) {
		var entityType = eeType.toUpperCase();
		getEntityView(coreName, dsName, dsId, sea.ColumnConfiguration.entityDetailsConfig);
		getHandlerId(dsId, true, function(res) {
			if (handlerId && handlerName && handlerId != res.handlerId) {
				req = createFacetingRequest(jsonFacet);
			} else {
				handlerName = res.handlerName;
				handlerId = res.handlerId;
			}
			var jsonFacet = '{"Entities":{"type":"terms","field":"NER_' + entityType + '","limit":-1}}';
			var req = createFacetingRequest(jsonFacet);
			sea.services.executeHandler(handlerId, handlerName, req, function(data) {
				var entity = data.facets.Entities.buckets;
				var eeList = [];
				var pieChartData = [];
				if (entity !== null) {
					var entityLen = entity.length;
					for (var i = 0; i < entityLen; i++) {
						var entityName = entity[i].val;
						var entityNum = entity[i].count;
						eeList.push({
							entityName : entityName,
							entityType : eeType,
							entityNum : entityNum
						});
						if (i < TOP_ENTITIES_NUM) {
							pieChartData.push([ entityName, entityNum ]);
						}
					}

				}
				$("#" + eeTableId).on("click", 'button.entity-name-search', function(event) {
					var eeName = $(this).text();
					onEntityNameClicked(coreName, dsName, dsId, dsType, eeName, handlerId, handlerName);
				});
				showEntityTypeDataTable(coreName,
						dsName,
						dsId,
						dsType,
						eeList,
						sea.ColumnConfiguration.entityDetailsConfig);
				showEntityNameChart(pieChartData, eeType, dsId);
			}, null, "#" + containerId);
		});

	};

	var createFacetingRequest = function(facet) {
		var req = {};
		req.q = '*';
		req.wt = 'json';
		req.rows = '0';
		if (facet) {
			req['json.facet'] = facet;
		}
		return req;
	};

	var showEntityTypeDataTable = function(coreName, dsName, dsId, dsType, eeList, columnConfig) {

		if (!$.fn.DataTable.isDataTable("#" + eeTableId)) {
			var config = $.extend({}, eeDTConfig);
			config.columns = sea.ColumnConfiguration.getConfigInDTFormat(columnConfig);
			config.data = eeList;
			config.language = {};
			config.language.emptyTable = localMsg.NoEntityMsg;
			$("#" + eeTableId).dataTable(config);
		} else {
			$("#" + eeTableId).DataTable().clear.rows.add(eeList).draw();
		}
	};

	var createBaseHistoryReq = function(coreName, dsName, dsId, dsType, action, handlerId, handlerName) {
		var reqObj = {};
		reqObj[sea.constants.HistoryParams.DS_ID] = dsId;
		reqObj[sea.constants.HistoryParams.CORE_NAME] = coreName;
		reqObj[sea.constants.HistoryParams.DS_TYPE] = dsType;
		reqObj[sea.constants.HistoryParams.DS_NAME] = dsName;
		reqObj[sea.constants.HistoryParams.ACTION] = action;
		if (handlerId) {
			reqObj[sea.constants.HistoryParams.HANDLER_ID] = handlerId;
		}
		if (handlerName) {
			reqObj[sea.constants.HistoryParams.HANDLER_NAME] = handlerName;
		}
		return reqObj;
	};

	var onEntityTypeClicked = function(coreName, dsName, dsId, dsType, eeType, handlerId, handlerName) {
		var reqObj = createBaseHistoryReq(coreName,
				dsName,
				dsId,
				dsType,
				sea.constants.Actions.ENTITY_DETAILS,
				handlerId,
				handlerName);
		reqObj[sea.constants.HistoryParams.ENTITY_TYPE] = eeType;
		reqObj[sea.constants.HistoryParams.FULL_VIEW] = 0;
		sea.history.pushState(reqObj, document.title, $.param(reqObj));
	};
	var onEntityNameClicked = function(coreName, dsName, dsId, dsType, eeName, handlerId, handlerName) {
		var reqObj = createBaseHistoryReq(coreName,
				dsName,
				dsId,
				dsType,
				sea.constants.Actions.EACH_SEARCH_VIEW,
				handlerId,
				handlerName);
		reqObj[sea.constants.HistoryParams.QUERY] = eeName;
		reqObj[sea.constants.HistoryParams.VIEW_ID] = -1;
		sea.history.pushState(reqObj, document.title, $.param(reqObj));
	};

	var createChartsHtml = function(dsId, containerPie, containerBar) {
		var chartsHtml = "<div class='row entity-charts extended-margin-top'>";
		if (containerBar) {
			chartsHtml += "<div id='" + containerBar + "' class='col-lg-6 col-md-6 mt'></div>";
		}
		if (containerPie) {
			chartsHtml += "<div id='" + containerPie + "' class='col-lg-6 col-md-6 mt'></div>";
		}
		chartsHtml += "</div>";
		$(chartsHtml).appendTo(containerId);
	};

	var showEntityTypeChart = function(pieChart, barChart, dsId) {
		var containerPie = dsId + "-pie-chart";
		var containerBar = dsId + "-bar-chart";
		createChartsHtml(dsId, containerPie, containerBar);
		var additionalInfo = {};
		additionalInfo.title = {
			text : 'Entity Types Distribution'
		};
		additionalInfo.name = 'Entity Types';
		showPieChart(containerPie, pieChart, additionalInfo);
		additionalInfo.title = {
			text : 'Documents containg Entities'
		};
		additionalInfo.name = 'Documents';
		additionalInfo.categories = barChart.categories;
		showBarChart(containerBar, barChart.data, additionalInfo);
	};

	var showEntityNameChart = function(pieChart, eeType, dsId) {
		var containerPie = dsId + "-pie-chart";
		createChartsHtml(dsId, containerPie);
		var additionalInfo = {};
		additionalInfo.title = {
			text : 'Top ' + eeType + ' Entities'
		};
		additionalInfo.name = localMsg.EntityDetected;
		showPieChart(containerPie, pieChart, additionalInfo);
	};

	var showPieChart = function(container, pieChartData, additionalInfo) {
		$("#" + container).highcharts({
			chart : {
				type : 'pie',
				options3d : {
					enabled : true,
					alpha : 45,
					beta : 0,
				}
			},
			credits : {
				enabled : false
			},
			title : additionalInfo.title,
			plotOptions : {
				pie : {
					allowPointSelect : true,
					cursor : 'pointer',
					depth : 25,
					slicedOffset : 20
				}
			},
			series : [ {
				type : 'pie',
				name : additionalInfo.name,
				data : pieChartData
			} ]
		});
	};

	var showBarChart = function(container, barChartData, additionalInfo) {
		$("#" + container).highcharts({
			chart : {
				type : 'bar',
				options3d : {
					enabled : true,
					depth : 30,
					viewDistance : 25
				}
			},
			credits : {
				enabled : false
			},
			xAxis : {
				categories : additionalInfo.categories
			},
			title : additionalInfo.title,
			plotOptions : {
				column : {
					depth : 25
				}
			},
			series : [ {
				type : 'bar',
				name : additionalInfo.name,
				data : barChartData
			} ]
		});
	};

	var getHandlerId = function(dsId, getDefault, cb, holder) {
		sea.services.getHandlers(dsId, undefined, function(resp) {
			var handlers = resp.handlerInfos;
			if (handlers !== null) {
				if (getDefault) {
					$.each(handlers, function(i, handler) {
						if (handler.attribute == 2) {
							var handlerDetails = {};
							handlerDetails.handlerId = handler.handlerId;
							handlerDetails.handlerName = handler.handlerName;
							cb(handlerDetails);
						}
					});
				} else {
					cb(handlers);
				}
			}
		}, null, holder);
	};

	return {
		viewEntityTypes : viewEntityTypes,
		viewEntityDetails : viewEntityDetails
	};
})();
