function EloquaHandler() {
	this.type = sea.constants.DSTypes.ELOQUA;
}

EloquaHandler.prototype.initializeStep = function(step,holder,isEdit) {
	switch(step) {
		case 5:
			sea.lookup.init(null,null,this,isEdit);
			if(isEdit && this.properties.lookupparams)
				sea.lookup.showSavedLookupData(cvUtil.parseJSON(this.properties.lookupparams), holder);
	}
	
};

EloquaHandler.prototype.validateStep = function(step, holder, aggregatedInput, callback, isEdit, dsObj) {
	//Because cvWizard passes the container of the current step in 'holder' where in initializeStep() and fetch() and submit()
	//it passes the the parent container of all the steps
	var $formWrapper = holder.parents(".cvWizard-form-wrapper");

	var reqData = null;
	var self = this;
	var columns = null;
	var tableList = null;
	var tableListHolder = null;

	try {
		sea.util.validateInputsAndGetData(holder);
	} catch (e) {
		callback(false);
		return;
	}

	switch (step) {
	case 1:
		if (!isEdit) {
			this.isDatasourceNameExists(holder, callback);
		} else {
			callback(true);
		}
		break;
	case 2:
		reqData = this.getRequestObject();
		if (!isEdit) {
			reqData.operationtype = sea.constants.Operations.CREATE;

			//tablename should not be present in the request
			if (reqData.properties.tablename) {
				delete reqData.properties.tablename;
			}
			sea.services.getMetaInfo(reqData, function(res) {
				var collections = res.schemaInfo.tablesInfo;
				if (collections && collections.length > 0) {
					self.getTableList(isEdit, $formWrapper, collections, self.type);
					callback(true);
				}
			}, function(error) {
				cvUtil.errorToast(error.error.errLogMessage);
				callback(false);
			}, holder);
		} else {
			reqData.id = dsObj.datasourceId;
			reqData.operationtype = sea.constants.Operations.MODIFY;
			tableList = '<option value="' + dsObj.properties.tablename + '">' + dsObj.properties.tablename +
					'</option>';
			this.initTableList($formWrapper);
			tableListHolder = $("#tableList", $formWrapper);
			tableListHolder.html(tableList);
			tableListHolder.attr("disabled", "disabled");
			reqData.properties.tablename = dsObj.properties.tablename;
			this.getTableDetails(dsObj.properties.tablename,
					reqData,
					isEdit,
					$formWrapper,
					dsObj.properties.columns,
					function(resp) {
						self.showMetaPanel();
						self.setTableEventHandlers(isEdit, $formWrapper);
						if (resp != null) {
							callback(true);
						} else {
							callback(false);
						}
					});
		}

		break;
	case 3:
		reqData = this.getRequestObject();
		if (isEdit) {
			columns = dsObj.properties.columns;
		}

		this.getTableDetails(this.properties.tablename, reqData, isEdit, $formWrapper, columns, function(resp) {
			self.properties.primary_key = resp.properties.primary_key;
			if (resp != null) {
				callback(true);
			} else {
				callback(false);
			}
		});
		break;
	case 4:
		if (!this.checkPrimary) {
			cvUtil.toast(localMsg.PrimaryKeySelection);
			callback(false);
		} else if ($('#table_data tr.selected', holder).length > 99) {
			cvUtil.toast(localMsg.ColumnLimit);
			callback(false);
		} else {
			callback(true);
		}
		break;
	case 5:
		callback(true);
		break;
	}
};

EloquaHandler.prototype.submit = function(isEdit, data, holder) {
	if (!isEdit) {
		this.create(null, holder);
	} else {
		this.update(null, data, holder);
	}
};

EloquaHandler.prototype.fetch = function(step, holder) {
	/*
	 * Some properties are fetched in the validation steps because they involve some calls to the server.
	 */
	var columnJson = {};
	var primaryKey = null;
	var checkPrimary = false;
	var fetchedData = null;

	switch (step) {
	case 1:
		fetchedData = this.fetchBasicDetails(holder);
		break;
	case 2:
		fetchedData = {
			properties : {
				username : $("#dsUserName", holder).val(),
				password : Base64.encode($("#dsPassword", holder).val()),
				companyname : $("#dsCompanyName", holder).val()
			}
		};
		break;
	case 3:
		fetchedData = {
			properties : {
				tablename : $("#tableList", holder).val()
			}
		};
		break;
	case 4:
		$("#table_data", holder).DataTable().search("").draw();
		primaryKey = $('.primaryKey', holder).text();

		if ($('#table_data tr.selected', holder).length == 0) {
			$('.table-content tbody tr').addClass('selected');
			$('.table-content tbody tr input:checkbox').prop("checked", true);
		}

		$('#table_data tbody tr.selected', holder).each(function(index, row) {
			var cname = $(row).data("name");
			var ctype = $(row).find("td:eq(2)").html();
			if (cname == primaryKey) {
				checkPrimary = true;
			}
			columnJson[cname] = ctype;
		});

		this.checkPrimary = checkPrimary;

		fetchedData = {
			properties : {
				columns : columnJson,
				always_incremental : $("#dsIncCrawl", holder).is(":checked")
			}
		};
		break;
	case 5:
		fetchedData = {
			properties : {
				lookupparams : sea.lookup.getData(holder)
			},
			dsCrawl : $("#dsCrawl", holder).is(":checked")
		}
		break;
	}

	this.updateProperties(fetchedData);
	return fetchedData;
};

EloquaHandler.prototype.initDSSpecificComponents = function(holder, isEdit, fnCallBack) {
	$("#dataBlendingWrapper",holder).show();
	fnCallBack({
		"callBack" : true
	});
};

EloquaHandler.prototype.populateDSSpecificProperties = function(props, holder, onEdit) {

	try {
		if (onEdit) {
			$("#dsUserName", holder).val(props.username);
			$("#dsPassword", holder).val(cvUtil.base64Decode(props.password));
			$("#dsCompanyName", holder).val(props.companyname);
			$("#dsIncCrawl", holder).attr("checked", Boolean(props.always_incremental));
		} else {
			$("#dsUserName", holder).text(props.username);
			$("#dsCompanyName", holder).text(props.companyname);
			$("#dsTableName", holder).text(props.tablename);
		}
	} catch (e) {
		console.log(e);
	}
};


EloquaHandler.prototype.getFieldsList = function(isEdit, callback) {
	if (isEdit) {
		sea.services.getDSSchema(this.datasourceId, function(fields) {
			var schemaFields = sea.schemaController.getDeleteableFields(fields.schemaFields);
			var fields = $.map(schemaFields, function(fieldObject) {
				return {
					fieldName : fieldObject.fieldName
				};
			});
			callback(fields);
		});
	} else {
		
		callback([]);
	}
}
