/*
 * As we create object for DataSourceHandler, use prototype instead of closure
 */
function DataSourceHandler() {
	this.type = null;
	this.dsCreated = false;
}

DataSourceHandler.prototype = function() {

	this.type = null;
	this.coreName = null;
	this.engineId = null;
	this.uploadPath = null;
	;

	// For caching on client side
	this.handlerList = {};
	this.dataSourcesList = {};
	constants = {
		DATA_SOURCE_LIST : "data-source-list",
		DATA_SOURCE : "data-source",
		DATA_SOURCE_CONTAINER : "data-sources-container",
		HANDLER_LIST : "handler-list",
		MULTISELECT_BUTTON_CONTAINER : "<div class='btn-group form-control multiselect-button'></div>",
		MULTISELCT_BUTTON_CLASS : "btn btn-default no-padding no-border",
		OAUTH_CODE : "oAuthCode"
	};

	// Abstract methods. Will be replaced by the ones in specific datasource
	// handler files

	function initializeStep() {

	};

	/*
	 * aggregatedInput - An object that contains all user input so fat. Passed
	 * by cvWizard dsObj - if isEdit is true, dsObj will contain the data source
	 * object that came from the server
	 */

	function validateStep(step, holder, aggregatedInput, callback, isEdit, dsObj){

		sea.util.validateInputsAndGetData(holder);
	};

	/*
	 * step - id of the step holder - cvWizard should pass in the form wrapper
	 */
	function fetch(step, holder) {

	};

	function setCoreName(coreName) {
		this.coreName = coreName;
	};

	function setCoreId(coreId) {
		this.coreId = coreId;
	};

	function setEngineId(engineId) {
		this.engineId = engineId;
	};


	function updateProperties(properties) {
		for (var property in properties) {
			//Replace primitive members and merge members which are objects

			if (typeof this[property] == "object" && this[property] != null)
				this[property] = $.extend(true, this[property],
						properties[property]);
			else
				this[property] = properties[property];
		}
	};

	function getHostName(engineId) {
		var hostName = null;
		sea.services.getEngines(true, function(data) {
			var typesList = data.listOfCIServer;
			$.each(typesList, function(itr, value) {
				if (engineId == value.cloudID) {
					// A single host can have multiple engines.
					// Hence enginename, not host name, should be displayed in
					// the UI
					hostName = value.engineName;
					return hostName;
				}
			});
		});
		return hostName;
	};

	function create(successCallback, holder) {
		var reqData = this.getRequestObject();

		if (!this.dsCreated) {
			reqData.operationType = sea.constants.Operations.CREATE;
			this.sendReqToServer(reqData, false, holder, successCallback);
		} else {
			if (this.datasourceId == undefined)
				console
						.error("No datasourceId associated with the current data source");
			else
				this.update(successCallback, {
					datasourceId : this.datasourceId
				}, holder);
		}
	};

	function update(successCallback, data, holder) {
		var reqData = this.getRequestObject();
		if (data != undefined)
			reqData.id = data.datasourceId;
		reqData.operationType = sea.constants.Operations.MODIFY;
		this.sendReqToServer(reqData, true, holder, successCallback);
	};

	function initComponents(holder, isEdit, fnCallBack,type,subtype) {
		if(!isEdit) {
			this.properties = {};
			this.properties["candelete"] = true;
			this.properties["appname"] = "DATACUBE";
			if(subtype && subtype === "seismic")
				this.properties["datasourceSubType"] = subtype;
		}
		$("input.switchHint", holder).change(function(e) {
			var dataAttr = $(this).data("switchHintClass");
			var hintElm = $("." + dataAttr, holder);
			if ($(this).is(":checked"))
				hintElm.html(localMsg[dataAttr + "Enable"]);
			else
				hintElm.html(localMsg[dataAttr + "Disable"]);
		});
		//Gets the list of CA Clouds
		if(sea.DSTypeConstants.listOfDS[type] && sea.DSTypeConstants.listOfDS[type].isEEEnabled === true)
			sea.services.getContentAnalyzerCloud(function(caCloud){
			});
		this.initDSSpecificComponents(holder, isEdit, fnCallBack,subtype);
	};

	function getRequestObject() {
		var reqData = {};
		reqData.name = this.name;
		reqData.type = this.type;
		reqData.corename = this.coreName;
		reqData.engineId = this.dsEngine;
		reqData.dsCrawl = this.dsCrawl;
		reqData.description = this.description;
		reqData.properties = this.properties;

		return reqData;
	};

	function sendReqToServer(reqObj, isEdit, holder, successCallback) {
		var self = this;
		 function successFunc(resp) {
			var dsId = resp.datasourceId;
			var coreName = resp.coreId;
			var dsType = reqObj.type;
			var dsName = reqObj.name;
			$("#coreName").val(coreName);
			$("#dsId").val(dsId);
			if (!sea.isUseSeaServer)
				$("#clientId").val(resp.clientId);
			if (reqObj.operationtype == sea.constants.Operations.CREATE) {
				/*
				 * If the operation is CREATE and type is CSV, we should be just
				 * showing the form for the remaining details to be filled
				 */
				if (reqObj.type == sea.constants.DSTypes.CSV) {
					initCSVEdit(holder);
					$("#dsName", holder).attr("disabled", "disabled");
					$("#dsEngine", holder).attr("disabled", "disabled");
					return;
				}
			}
			// moving the alerts down so that for CSV case, we do not show data
			// source created message in the first step
			if (isEdit)
				cvUtil.toast(localMsg.DataSourceUpdated);
			else
				cvUtil.toast(localMsg.DataSourceCreated);
			// once the wizard is done we don't have to check the DOM for
			// dsCrawl
			if ($("#dsCrawl", holder).is(":checked") || reqObj.dsCrawl === true) {
				sea.services.crawl(dsId, sea.constants.Actions.START_CRAWL,
						function(resp) {
							cvUtil.toast(cvFormatters.formatString(
									localMsg.CrawlRequestSubmitted,
									[ sea.crawlController
											.getCrawlStatusDispText(resp) ]));
							sea.dsController.goToDSConfigPage(coreName, dsName,
									dsId, dsType);
						}, function(errResp, msg) {
							alert(localMsg.CrawlRequestSubmitFailed);
							sea.dsController.goToDSConfigPage(coreName, dsName,
									dsId, dsType);
						}, holder);
			} else
				sea.dsController.goToDSConfigPage(coreName, dsName, dsId,
						dsType);
			if (typeof successCallback == "function")
				successCallback(resp);
		};

		function errorFunc(resp, msg) {
			alert(msg);
			if (resp.coreId) {
				self.dsCreated = true;
				self.setCoreId(resp.coreId);
				self.setCoreName(resp.coreId);
				self.datasourceId = resp.datasourceId;
				$("#coreName").val(resp.coreId);
				$("#dsName", holder).attr("disabled", "disabled");
				if (!sea.isUseSeaServer) {
					$("#clientId").val(resp.clientId);
					$("#dsId").val(resp.datasourceId);
					$("#dsEngine", holder).attr("disabled", "disabled");
				}
			}
		};
		sea.services.createDataSource(reqObj, isEdit, successFunc, errorFunc,
				holder);
	}

	function getEngines(holder, dsType, isAll, fnCallBack) {
		// Get the list of engine ids
		 function populateEngineCombo(typesList, comboObj) {
			if (typeof comboObj === 'undefined' || comboObj == null)
				return;
			// console.log("Engine id combo", comboObj);
			typesList = cvSearchUtil.sortArrayByKey(typesList,"engineName");
			comboObj.empty();
			comboObj.append("<option value disabled selected> --"
					+ localMsg.Select + "-- </option>");
			$.each(typesList, function(i, v) {

				var optHtml = "<option data-client-id=\"" + v.indexServerClientId + "\" value=\"" + v.cloudID + "\">" + v.engineName + "</option>";

				comboObj.append(optHtml);
			});
		};
		sea.services.getEngines(isAll, function(data) {
			var typesList = data.listOfCIServer;
			var engineId = null;
			if (!$.isEmptyObject(typesList)) {
				populateEngineCombo(typesList, $("#dsEngine", holder));
				engineId = $("#dsEngine", holder).val();
			}

			fnCallBack({
				"engineId" : engineId
			});
		});
	};

	function fetchBasicDetails(holder) {
		return {
			name : $("#dsName", holder).val(),
			description : $("#dsDescription", holder).val(),
			dsEngine : $("#dsEngine", holder).val(),
			coreName : $("#coreName", holder).val()
		};
	};




	function populateDataSourceProps(dsObj, holder, onEdit){

		this.updateProperties($.extend(true, {}, dsObj));

		$("#dsName", holder).val(dsObj.displayName);
		$("#dsEngine", holder).val(dsObj.engineId);
		$("#dsDescription", holder).val(dsObj.description);

		if (!onEdit) {
			if (!sea.isUseSeaServer) {
				$("#dsEngine", holder).text(getHostName(dsObj.engineId, true));
			}
		}

		var props = normalizeProperties(dsObj.properties);
		if (props) {
			// Implemented in the corresponding DS handler file
			this.populateDSSpecificProperties(props, holder, onEdit,dsObj.engineId);
			sqlAccessProp(props, dsObj, holder);
		} else
			console.error("Properties not found");

	};

	function normalizeProperties(props) {
		if (!$.isEmptyObject(props)) {
			$.each(props, function(key, eachProp) {
				var normalizedProp = eachProp;
				if (typeof (eachProp) === "string") {
					try {
						normalizedProp = cvUtil.parseJSON(eachProp);
					} catch (e) {
						// if it fails to parse, just assign the value as such
						normalizedProp = eachProp;
					}
					if (normalizedProp == null)// if it results in null
						normalizedProp = undefined;
				}
				props[key] = normalizedProp;
			});
		}
		return props;
	};

	function sqlAccessProp(props, dsObj, holder) {
		var connStr = localMsg.SqlAccessServiceDisabled;
		if (props.isDrillEnabled) {
			var zkQuorum = dsObj.zkQuorum;
			if (zkQuorum && zkQuorum.length > 0) {
				$("#enableSQLAccess").attr("checked", true);
				connStr = cvFormatters.formatString(
						localMsg.SqlAccessConnectionStr, [ zkQuorum ]);
			}
		}
		$(".sqlAccessText").text(connStr);
		$("#enableSQLAccess")
				.off("click")
				.on(
						"click",
						function(event) {
							var isChecked = $(this).is(":checked");
							if (!isChecked) {
								var disableSqlAccessConfirm = $("#disableSqlAccessConfirm");
								var disabled = false;
								function okBtnHandler(ee) {
									disabled = true;
									configureSqlAccessService(isChecked, dsObj,
											holder);
								}
								function cancelBtnHandler(ee) {
									$("#enableSQLAccess").attr("checked", true);
								}

								disableSqlAccessConfirm.modal('show').find(
										".modal-dialog").draggable().off(
										"click", ".okBtn").on("click",
										".okBtn", okBtnHandler).off("click",
										".cancelBtn").on("click", ".cancelBtn",
										cancelBtnHandler);

								disableSqlAccessConfirm.off("hidden.bs.modal")
										.on("hidden.bs.modal", function(ee) {
											if (!disabled) {
												cancelBtnHandler(ee);
											}
										});
							} else {
								configureSqlAccessService(isChecked, dsObj,
										holder);
							}
						});
	}

	function configureSqlAccessService(isChecked, dsObj, holder) {
		var reqData = {};
		reqData.enableSQLAccess = isChecked;
		reqData.maClientId = dsObj.clientId;
		reqData.coreId = dsObj.coreId;
		reqData.datasourceId = dsObj.datasourceId;
		sea.services.configureSqlAccess(reqData, function(res) {
			var isCvDrillEnabled = res.data.isCvDrillEnabled;
			var msg;
			var connStr = localMsg.SqlAccessServiceDisabled;
			if (isCvDrillEnabled) {
				msg = localMsg.SqlAccessEnableSuccess;
				var zkQuorum = res.data.zkQuorum;
				connStr = cvFormatters.formatString(
						localMsg.SqlAccessConnectionStr, [ zkQuorum ]);
			} else {
				msg = localMsg.SqlAccessDisableSuccess;
			}
			$(".sqlAccessText").text(connStr);
			cvUtil.toast(msg);
		}, null, holder);
	}

	function getTableList(isEdit, holder, collections, type) {
		initTableList(holder);
		showMetaPanel(holder);
		var tableList = [];
		for (var i = 0; i < collections.length; i++) {
			tableList.push(collections[i].tableName);
		}

		if (type === sea.constants.DSTypes.SALESFORCE) {
			$("#tableList", holder).autocomplete({
				source : tableList,
				minLength : 0
			});
		} else if (type === sea.constants.DSTypes.ELOQUA) {
			var tableList = '<option value="select"></option>';
			for (var i = 0; i < collections.length; i++) {
				var table = collections[i];
				tableList = tableList + '<option value="' + table.tableName
						+ '">' + '<h5>' + table.tableName + '</h5>'
						+ '</option>';
			}
			$("#tableList", holder).html(tableList);
		}

		setTableEventHandlers(isEdit, holder);
	}

	function initTableList(holder) {
		$("#tableList", holder).html('');
		$('.saveButton', holder).addClass('hidden');
	}

	function showMetaPanel(holder) {
		$("#dbMetaDataPanel", holder).show();
	}

	function setTableEventHandlers(isEdit, holder) {
		$('.table-content', holder).off("click", "#selectAll").on(
				"click",
				"#selectAll",
				function() {
					if ($(this).prop("checked") == true) {
						$('.table-content tbody tr', holder).addClass(
								'selected');
						$('.table-content tbody tr input:checkbox', holder)
								.prop("checked", true);
					} else if ($(this, holder).prop("checked") == false) {
						$('.table-content tbody tr', holder).removeClass(
								'selected');
						$('.table-content tbody tr input:checkbox', holder)
								.prop("checked", false);
						var id = $(".primaryKey", holder).parent().data("name")
						$('[data-name=' + id + ']', holder)
								.addClass('selected');
					}
				});

		$('.table-content', holder).off("click", "#table_data tbody tr").on(
				"click",
				"#table_data tbody tr",
				function(event) {
					// to avoid selecting when clicking on a text input
					if (event.target.type != "text") {
						var value = $(this).data('name');
						if (value == $('.primaryKey', holder).text()) {
							$('.primaryKeyTooltip', holder).tooltip('show');
						} else {
							if ($(this).hasClass('selected')) {
								$(this).removeClass('selected');
								$(this).find('td input:checkbox').prop(
										"checked", false);
								$('#selectAll').prop("checked", false);
							} else {
								$(this).addClass('selected');
								$(this).find('td input:checkbox').prop(
										"checked", true);
							}
						}
					}
				});
	}

	function getTableDetails(tableName, reqData, isEdit, holder, columnsList,
			callback) {
		if (tableName && tableName != "select") {
			var tableId = 'table_data';
			sea.services
					.getMetaInfo(
							reqData,
							function(res) {
								var collections = res.schemaInfo.tablesInfo;
								var tableInfo = collections[0];
								if (tableInfo != null) {
									var tableColumns = [];
									var dataSet = [];
									var primaryKey = tableInfo.primaryKey[0];
									var numColumns = tableInfo.columnNames.length;
									if (!tableInfo.isIncremental) {
										$('.incrementalDiv').addClass('hidden');
									} else {
										$('.incrementalDiv').removeClass(
												'hidden');
									}
									reqData.properties.primary_key = primaryKey;
									for (var i = 0; i < numColumns; i++) {
										var data = [];
										var column = tableInfo.columnNames[i];
										data.push('<input type="checkbox" />');
										data.push(column.columnName);
										data.push(column.dataType);
										dataSet.push(data);
									}
									tableColumns
											.push({
												"title" : '<input id="selectAll" type="checkbox" />',
												"className" : "checkBoxWidth",
												"orderable" : false
											});
									tableColumns.push({
										"title" : localMsg.ColumnName
									});
									tableColumns.push({
										"title" : localMsg.DataType
									});
									$('#' + tableId, holder)
											.DataTable(
													{
														dom : '<"pull-left"f>ti',
														paging : false,
														data : dataSet,
														order : [ 1, 'asc' ],
														columns : tableColumns,
														createdRow : function(
																row, data,
																rowIndex) {
															$(row, holder)
																	.attr(
																			'data-name',
																			data[1]);
															if (data[1] == primaryKey) {
																$('td:eq(0)',
																		row,
																		holder)
																		.html(
																				'<span class="glyphicon glyphicon-info-sign primaryKeyTooltip" data-toggle="tooltip" data-placement="right" title="'
																						+ localMsg.PrimaryKeyTooltip
																						+ '"></span>');
																$('td:eq(1)',
																		row,
																		holder)
																		.addClass(
																				'primaryKey');
															}
														},
														destroy : true
													});
									$('.saveButton', holder).removeClass(
											'hidden');

									if (columnsList && isEdit) {
										highlightSelectedColumns(columnsList);
									} else {
										$("#selectAll", holder)
												.trigger("click");
									}
									if (typeof callback === "function")
										callback(reqData);
								} else {
									cvUtil.toast(localMsg.NoErrorFromServerMsg);
								}
							}, function(error) {
								cvUtil.errorToast(error.error.errLogMessage);
								if (typeof callback === "function")
									callback(null);
							}, holder);
		}

		function highlightSelectedColumns(data) {
			var columns = (data.substring(1, data.length - 1));
			var col = JSON.parse(columns);
			for ( var key in col) {
				$('tr[data-name="' + key + '"]').addClass('selected');
				$('tr[data-name="' + key + '"] td input:checkbox').prop(
						"checked", true);
			}
		}

	}

	function isDatasourceNameExists(holder, callback) {
		sea.services.isDatasourceNameExists(this.name, function(data) {
			if (data.error.errorCode !== 0) {
				callback(false);
				cvUtil.errorToast(localMsg.DatasourceNameExits);
			} else
				callback(true);
		}, null, holder);
	}

	

	return {
		constants : constants,
		initializeStep : initializeStep,
		validateStep : validateStep,
		fetch : fetch,
		sendReqToServer : sendReqToServer,
		setCoreName : setCoreName,
		setCoreId : setCoreId,
		setEngineId : setEngineId,
		updateProperties : updateProperties,
		getHostName : getHostName,
		getEngines : getEngines,
		getRequestObject : getRequestObject,
		create : create,
		update : update,
		populateDataSourceProps : populateDataSourceProps,
		initComponents : initComponents,
		fetchBasicDetails: fetchBasicDetails,
		/*
		 * The only reason the below functions are here is because they are
		 * reused between multiple data sources
		 */
		getTableList : getTableList,
		getTableDetails : getTableDetails,
		initTableList : initTableList,
		setTableEventHandlers : setTableEventHandlers,
		showMetaPanel : showMetaPanel,
		isDatasourceNameExists : isDatasourceNameExists
	};
}();

DataSourceHandler.factory = function(type) {
	if (type == undefined)
		return new DataSourceHandler();
	else if ($.inArray(type, sea.DSTypeConstants.socialDSTypes) != -1) {
		return fromPrototype(DataSourceHandler.prototype,
				DataSourceHandler['social'](type));
	} else
	{
		if(DataSourceHandler[type] != undefined)
			return fromPrototype(DataSourceHandler.prototype,
				DataSourceHandler[type]());
		return undefined;
	}
};

DataSourceHandler.jdbc = function() {
	var handler = new JdbcHandler();
	return handler;
};

DataSourceHandler.web = function() {
	return new WebHandler();
};

DataSourceHandler.csv = function() {
	return new CsvHandler();
};

DataSourceHandler.file = function() {
	return new FsHandler();
};

DataSourceHandler.eloqua = function() {
	return new EloquaHandler();
};

DataSourceHandler.salesforce = function() {
	return new SalesforceHandler();
};

DataSourceHandler.ldap = function() {
	return new LdapHandler();
};

DataSourceHandler.federated = function() {
	return new FederatedHandler();
};

DataSourceHandler.blank = function() {
	return new BlankHandler();
};

DataSourceHandler.http = function(type) {
	return new HttpHandler(type);
};

DataSourceHandler.facebook = function() {
	return new FacebookHandler();
};

DataSourceHandler.twitter = function() {
	return new TwitterHandler();
}

DataSourceHandler.social = function(type) {
	return new SocialHandler(type);
};

// helper function described at
// http://robdodson.me/javascript-design-patterns-factory/
 function fromPrototype(prototype, object) {  

	var newObject = Object.create(prototype);
	for ( var prop in object) {
		newObject[prop] = object[prop];
	}

	return newObject
}
