function CsvHandler() {
	this.type = sea.constants.DSTypes.CSV;
}

CsvHandler.prototype.initializeStep = function(step, holder, isEdit) {
	switch (step) {
	case 2:
		initCSVEdit(holder, isEdit);
		break;
	case 3:
		// check if preview is generated
		if (this.preview) {
			var columns = [];
			var $selectHtmlRow = $('<tr role="row" id="csvDataTypes"></tr>');
			var rows = this.preview.rows;
			var csvColumns = this.preview.columns;
			var csvNumFields = csvColumns.length;
			var schemaFields = '';
			$("#dsCSVPreview", holder).find("table").remove().show();
			$('.detect-data-type-div', holder).show();
			$("#isDTAutoDetect", holder).prop("checked", false);
			var $selectHtml = $('<select class="form-control input-sm"></select>');
			// get only the allowed data types in select data type options
			$.map(sea.constants.schemaAllowedDataTypes, function(type, i) {
				$("<option />", {
					value : type.fieldName,
					text : type.dispName
				}).appendTo($selectHtml);
			});

			for(var i = 0; i < rows.length; i++) {
				var row = rows[i];
				row.row = (row.row || []).map(function(val) {
					return DOMPurify.sanitize(val);
				});
			}
			for (var i = 0; i < csvNumFields; i++) {
				var csvCol = csvColumns[i];
				var columnName = DOMPurify.sanitize(csvCol.columnName);
				columns.push({
					"data" : "row." + i,
					"title" : columnName,
					"render" : function(data, type, row, meta) {
						return SearchResultsView.prototype.getCellDisplayValue(data);
					}
				});
				var $selectHtmlNode = $('<th data-colname="' + columnName + '"></th>');
				$selectHtml.clone().val(csvCol.dataType).appendTo($selectHtmlNode);
				$selectHtmlNode.appendTo($selectHtmlRow);
			}
			var table = $("<table class='table table-bordered dataTable'></table>");
			table.DataTable({
				dom : 'Jt',
				data : rows,
				columns : columns,
				aaSorting : []
			});
			$("#dsCSVPreview", holder).append(table);
			// appends the data types when the detect data type option is selected 
			$("#isDTAutoDetect", holder).off("click").on("click", function(event) {
				if ($("#isDTAutoDetect", holder).is(":checked")) {
					$('#dsCSVPreview thead').append($selectHtmlRow);
				} else {
					$('#dsCSVPreview thead tr#csvDataTypes').remove();
				}
			});
		} else {
			$("#dsCSVPreview", holder).find("table").remove().hide();
			$('.detect-data-type-div', holder).hide();
		}
		break;
	}
	$('#dataTypeDetectionPopover').popover({
		placement : "top",
		trigger : "hover"
	});
};

//dsObj - data from server, passed if editing
CsvHandler.prototype.validateStep = function(step, holder, aggregatedInput, callback, isEdit, dsObj) {
	var reqObj = null;
	var self = this;
	try {
		sea.util.validateInputsAndGetData(holder);
	} catch (e) {
		callback(false);
		return;
	}

	switch (step) {
	case 1:
		/*
		 * If user is in step 2 and goes back to step 1, changes description and presses next, the below code
		 * used to throw an error since the csv data source with this name already exists. Hence we make use
		 * of a 'dsCreated' flag and by pass creation of ds if it is already created
		 */
		if (this.dsCreated != true) {
			reqObj = this.getRequestObject();
			reqObj.operationtype = sea.constants.Operations.CREATE;
			if (isEdit) {
				//Data source already exists. There's nothing to do here.
				callback(true);
				return;
			}
			reqObj.properties = {};
			reqObj.properties.emptydatasource = "true";
			sea.services.createDataSource(reqObj, isEdit, function(resp) {
				var dsId = resp.datasourceId;
				var coreName = resp.coreId;

				//Pressing submit on step 2 will do an 'edit' operation. id and corename is needed then.
				self.coreName = coreName;
				self.id = dsId;

				//legacy code start
				$("#coreName").val(coreName);
				$("#dsId").val(dsId);
				if (!sea.isUseSeaServer) {
					$("#clientId").val(resp.clientId);
					//legacy code end
				}

				$("#dsName", holder).attr("disabled", "disabled");
				$("#dsEngine", holder).attr("disabled", "disabled");
				self.dsCreated = true;
				callback(true);
			}, function(error) {
				cvUtil.errorToast(error.error.errLogMessage);
				callback(false);
			}, holder);
		} else {
			callback(true);
		}
		break;
	case 2:
		try {
			validateCVSPropInputs(holder);
		} catch (e) {
			callback(false);
			return;
		}
		if ($("input[name=csvLocType]:checked", holder).val() != "folder") {
			sea.services.getMetaInfo(self, function(resp, data) {
				self.preview = {};
				self.preview.rows = resp.queryInfo.outputInfos.rows;
				self.preview.columns = resp.queryInfo.columnNames;
				callback(true);
			}, function(resp, msg) {
				if (resp.error.errorCode == "10802") {
					cvUtil.toast(msg);
				} else {
					cvUtil.toast(localMsg.CSVPreviewFailed);
				}
				delete self.preview;
				callback(true);
			}, holder);
		} else {
			delete self.preview;
			cvUtil.toast(localMsg.CSVPreviewNotAvailable);
			callback(true);
		}
		break;
	case 3:
		if ($("#isDTAutoDetect", holder).is(":checked")) {
			// check if the data type mapping has been changed by the user. If yes, then prompt for deletion of crawled data
			if (checkDataTypeMappingChange(self.preview.columns, holder)) {
				var promptModalElm = $("#deleteCrawledData");
				$(".deleteCrawledDataMsg", promptModalElm).text(localMsg.PromptFieldChangeDeleteMsg);
				var dsIdValue;
				if (self.datasourceId) {
					dsIdValue = self.datasourceId;
				} else {
					dsIdValue = $("#dsId").val();
				}
				var jobId = 0;
				sea.services.getCrawlStatus(dsIdValue, jobId, function(res) {
					if (res && res.status && res.status.totalcount > 0) {
						sea.dsController.deleteCrawledData(dsIdValue, null, function(resp) {
							if (resp === true) {
								callback(true);
							}
						});
					} else {
						callback(true);
					}
				}, null, holder);
			} else {
				callback(true);
			}
		} else {
			callback(true);
		}
		break;
	}
};

CsvHandler.prototype.submit = function(isEdit, dsObj, holder) {
	var self = this;
	var keyChangeData = {};

	if (!isEdit) {
		//The actual creation of an empty csv ds is done in validation step 1
		//Hence all further actions are edit rather than create
		//this.id is set at the end of validation step 1
		this.update(null, {
			datasourceId : this.id
		}, holder);
	} else if (dsObj) {
		keyChangeData.changeType = sea.MiscConstants.deleteCrawledDataChangeType.PRIMARY_KEY;
		keyChangeData.oldKey = dsObj.properties.primary_key;
		keyChangeData.newKey = this.properties.primary_key.length > 0 ? this.properties.primary_key : undefined;
		keyChangeData.dsId = dsObj.datasourceId;
		keyChangeData.holder = holder;
		keyChangeData.callback = function() {
			self.update(null, dsObj, holder);
		};
		sea.dsController.checkForDeleteRequirement(keyChangeData);
	}
};

CsvHandler.prototype.fetch = function(step, holder) {
	var fetchedData = null;
	var separator = null;
	var fieldName = null;
	var fieldnames = null;
	var filePaths = [];
	var paths = null;
	var csvLocType = null;

	switch (step) {
	case 1:
		fetchedData = this.fetchBasicDetails(holder);
		break;
	case 2:

		if ($("input[name=colSepGroup][value=others]", holder).is(":checked")) {
			separator = $("#dsColSeparator", holder).val();
		} else {
			separator = $("input[name=colSepGroup]:checked").val();
		}
		fieldName = $("#dsCSVCols", holder).val();
		if (fieldName) {
			fieldnames = fieldName;
		} else {
			fieldnames = "";
		}
		csvLocType = $("input[name=csvLocType]:checked", holder).val();
		if (csvLocType === "upload") {
			paths = $("#dsCSVUploadPath", holder).val().split("\n");
			$.each(paths, function(index, value) {
				if (value.length > 0) {
					filePaths.push(value);
				}
			});

			/*
			 * filePaths is an array. If pre-existing values are not deleted like this, it will be merged when
			 * calling this.properties()
			 * 
			 * Elaborate explanation:
			 * 
			 * user goes to step 2 and presses submit. Now this.properties.filePaths contains, for eg, 2
			 * paths. Submit failed due to some reason and user removed the 2 csv files and uploaded another
			 * 2. If we don't delete this.properties.filepaths, the submit request will contain 4 paths
			 * instead of the expected 2.
			 */
			if (this.properties && this.properties.filePaths) {
				delete this.properties.filePaths;
			}
		}
		fetchedData = {
			type : sea.constants.DSTypes.CSV,
			name : this.name,
			engineId : parseInt(this.dsEngine),
			properties : {
				header : $("#dsFirstRowAsColNames", holder).is(":checked"),
				separator : separator,
				fieldnames : fieldnames,
				filePaths : filePaths,
				folder : $("input#folderPath", holder).val(),
				username : $("input#csvUserName", holder).val(),
				password : Base64.encode($("input#csvPassword", holder).val())
			}
		}
		break;
	case 3:
		fetchedData = {
			properties : {
				field_datatype : getDataTypeMapping(holder),
				always_incremental : $("#isIncrementalCrawl", holder).is(":checked"),
				primary_key : $("#incrPrimaryKey", holder).val()
			},
			dsCrawl : $("#dsCrawl", holder).is(":checked")
		}
		break;
	}
	this.updateProperties(fetchedData);
	return fetchedData;
};

CsvHandler.prototype.initDSSpecificComponents = function(holder, isEdit, fnCallBack) {
	var self = this;
	$("#uploadLink", holder).on("click", function(event) {
		getUploadPath(holder, event, function(resp) {
			self.uploadPath = resp.uploadPath;
		});
	});
	$("input[name=csvLocType]", holder).on("change", function(e) {
		$("div.csvLocTypeDiv").hide();
		$("div#csvLocTypeDiv_" + $(this).val()).show();
		if ($(this).val() === "folder") {
			$("input#folderPath").focus();
		}
	});
	$("input[name=colSepGroup]", holder).on("change", function(e) {
		var el = $("input#dsColSeparator");
		if ($(this).val() === "others") {
			el.show().focus();
		} else {
			el.hide();
		}
	});

	holder.off("click", ".inputItemUser .removeItem").on("click", ".inputItemUser .removeItem", function() {
		var fullFilePaths = $("#dsCSVUploadPath").val();
		var fileGuid = $(this).parent().data("value");

		$(this).parent().remove();
		fullFilePaths = fullFilePaths.replace(fileGuid, "");
		$("#dsCSVUploadPath").val(fullFilePaths);

	});

	fnCallBack({
		"callBack" : true
	});
};

CsvHandler.prototype.populateDSSpecificProperties = function(props, holder, onEdit) {
	var truncatedFilePaths = [];
	var uploadPath = null;
	var colSepText = null;

	if (!$.isEmptyObject(props.filePaths)) {
		uploadPath = props.filePaths[0];
		uploadPath = uploadPath.substr(0, uploadPath.lastIndexOf('\\'));

		$.each(props.filePaths, function(index, value) {
			fileName = value.substr(value.lastIndexOf('\\') + 1);
			if (!fileName) {
				fileName = value;
			}
			truncatedFilePaths.push(fileName);
		});
	}

	if (props.separator) {
		colSepText = sea.MiscConstants.getDispForColSep(props.separator);
	}

	if (onEdit) {
		initCSVEdit(holder);
		if (!$.isEmptyObject(truncatedFilePaths)) {
			$("input[name=csvLocType][value=upload]", holder).attr("checked", "checked").change();
			var $filePaths = $.map(truncatedFilePaths, function(file, index) {
				return getAsDeleteableItem(file, props.filePaths[index]);
			});

			$.each($filePaths, function(i, $filePath) {
				$("#dsCsvLocation", holder).append($filePath);
			});
			// $("#dsCsvLocation", holder).text($.map(truncatedFilePaths, function(file, index){
			// 	return getAsDeleteableItem(file);
			// }).join("\n"));
			$("#dsCSVUploadPath").val(props.filePaths.join("\n"));
		} else if (props.folder) {
			$("input[name=csvLocType][value=folder]", holder).attr("checked", "checked").change();
			$("#folderPath", holder).val(props.folder);
			if (props.username) {
				$("#csvUserName", holder).val(props.username);
			}
			$("#csvPassword", holder).val(cvUtil.base64Decode(props.password));
		}

		$("#dsFirstRowAsColNames", holder).attr("checked", props.header);
		if (props.separator) {
			if (colSepText == null) // if null, then others
			{
				$("input[name=colSepGroup][value=others]", holder).attr("checked", "checked").change();
				$("#dsColSeparator", holder).val(props.separator);
			} else {
				$("input[name=colSepGroup][value='" + props.separator + "']", holder).attr("checked", "checked")
						.change();
			}
		}

		if (props.fieldnames) {
			$("#dsCSVCols", holder).val(props.fieldnames);
		}

		$("#isIncrementalCrawl", holder).attr("checked", props.always_incremental).change();
		if (props.primary_key) {
			$("#incrPrimaryKey", holder).val(props.primary_key);
		}
		
	} else {
		if (!$.isEmptyObject(truncatedFilePaths)) {
			$("#dsCsvLocation", holder).html(truncatedFilePaths.join(", "));
		} else if (props.folder) {
			$("#dsCsvLocation", holder).html(props.folder);
		}
		if (colSepText != null) {
			$("#dsColSeparator", holder).html(colSepText);
		} else {
			$("#dsColSeparator", holder).html(props.separator); // default
		}
		if (props.fieldnames) {
			$("#dsCSVCols", holder).html(props.fieldnames);
		}
	}
};

function getUploadPath(holder, event, fnCallBack) {
	uploadFile.uploadAction($("#dsId").val(), event);
}

function initCSVEdit(holder, isEdit) {
	if (!isEdit && !$("#folderPath", holder).val() && !$("#dsCsvLocation").text()) {
		$("input[name=csvLocType][value=upload]", holder).attr("checked", "checked").change();
		$("input[name=colSepGroup][value=',']", holder).attr("checked", "checked").change();
	}
	uploadFile.init({
		startCallback : function() {
			$(".btn-submit", holder).attr("disabled", true);
		},
		endCallback : function() {
			$(".btn-submit", holder).attr("disabled", false);
		},
		errorCallback : function() {
			$(".btn-submit", holder).attr("disabled", false);
		},
		holder : holder
	});
}

function validateCVSPropInputs(holder) {
	var csvLocType = $("input[name=csvLocType]:checked", holder).val();
	if (csvLocType === "upload") {
		if ($("#dsCSVUploadPath", holder).val().length == 0) {
			throw new SeaException.RequiredFieldException($("#csvLocTypeDiv_upload", holder));
		}
	} else {
		if ($("#folderPath", holder).val().length == 0) {
			throw new SeaException.RequiredFieldException($("#csvLocTypeDiv_folder", holder));
		}
		if (!$("#dsFirstRowAsColNames", holder).is(":checked") && $("#dsCSVCols", holder).val().length == 0) {
			throw new SeaException.RequiredFieldException($("#dsCSVColsDiv", holder));
		}
	}
	if ($("input[name=colSepGroup][value=others]", holder).is(":checked") &&
			$("#dsColSeparator", holder).val().length == 0) {
		throw new SeaException.RequiredFieldException($("#dsColSeparatorDiv"));
	}
}

function getAsDeleteableItem(itemName, val) {
	var $wrapper = $("<div class='inputItemUser'>" + itemName +
			"<span class='removeItem'>x</span></div>");
	$wrapper.data("value", val);
	return $wrapper;
}

// function to format the data type mapping for the API
function getDataTypeMapping(holder) {
	var dataTypeMap = {};
	$("#csvDataTypes th", holder).each(function(i, tr) {
		var colname = $(tr).data("colname");
		var dataType = $('select > option:selected', $(tr)).val();
		dataTypeMap[colname] = dataType;
	});
	return dataTypeMap;
}

//function to check if the data type mapping has been modified by the user
function checkDataTypeMappingChange(columns, holder) {
	var isChanged = false;
	$("#csvDataTypes th", holder).each(function(i, tr) {
		var initialCsvCol = columns[i];
		var colname = $(tr).data("colname");
		var dataType = $('select > option:selected', $(tr)).val();
		if (initialCsvCol.dataType !== dataType) {
			isChanged = true;
		}
	});
	return isChanged;
}


