//'datasource' is a reference to a datasourceHandler object
var sea = sea || {};
sea.ContentAnalyzer = (function() {
	this.datasource = null;
	this.isEdit;
	this.holder = null;
	this.caCloud = {};
	var containerId = sea.containerId;
	var self = this;

	var constants = {
		ENTITY_EXTRACTION_RER : "EntityExtractionRER",
		ENTITY_EXTRACTION_NER : "EntityExtractionNER",
		ENTITY_EXTRACTION_DE : "EntityExtractionDE",
		ENTITY_EXTRACTION_FIELDS : "EntityExtractionFields",
		ENTITIES_TO_EXTRACT : "entitiesToExtract",
		ENTITY_EXTRACTION : "EntityExtraction",
	};

	function saveEEDetails() {

		var reqObj = {
			name : self.datasource.displayName,
			type : self.datasource.dataSourceType,
			corename : self.datasource.coreId,
			engineId : self.datasource.engineId,
			dscrawl : false,
			description : self.datasource.description,
			properties : self.datasource.properties,
			id : self.datasource.datasourceId,
			operationType : "MODIFY"
		};
		sea.services.createDataSource(reqObj, true, function() {
			cvUtil.toast(localMsg.EESaveSuccess);
			sea.crawlController.showCrawlPrompt(self.datasource.datasourceId,localMsg.PromptCrawlMsgForChanges);
			
		},function(resp, msg) {
			alert(msg);
			alert(localMsg.EESaveFailed);
		}, self.holder);
	}

	function attachActionButtonListener($eeBtnsWrapper) {
		$("#saveEEDetails", $eeBtnsWrapper).off("click").on("click", function(event) {
			self.datasource.properties.iscaenabled = $("#isEntityExtractionEnabled", self.holder).is(":checked");
			if(self.datasource.dataSourceType === sea.constants.DSTypes.FS)
				self.datasource.properties.enableImageExtraction = $("#enableOCR", self.holder).is(":checked");
			self.datasource.properties.caconfig = getConfig();
			self.datasource.properties.cacloudid = getContentAnalyzerCloud();
			delete self.datasource.properties.catargeturl;			
			if(self.datasource.properties && self.datasource.properties.iscaenabled) {
				var $select = $("#entitiesToExtract");
				var entitiesSelected = $select.val();
				if (entitiesSelected === undefined || entitiesSelected.trim().length === 0) {
					cvUtil.errorToast(localMsg.EENoEntitiesError);
					return;
				}

				var $fieldsHolder = $("#EntityExtractionFields", self.holder);
				if ($fieldsHolder !== undefined && $fieldsHolder.length > 0) {
					var fields = $fieldsHolder.val();
					if (fields === undefined || fields.trim().length === 0) {
						cvUtil.errorToast(localMsg.EENoFieldsError);
						return;
					}
				}
			} 
			saveEEDetails();
		});

		$("#cancelEEDetails", $eeBtnsWrapper).off("click").on("click", function(event) {
			sea.homePage.goToConfigPage();
		});
	}

	function viewEEDetails(dsId, coreName) {
		var isEdit = true;
		var templateId = sea.constants.TMPL_PREFIX + sea.constants.Actions.VIEW + "_entity_extraction";
		var sel = "div[data-templateId=" + templateId + "]";
		var $entityExtractionElm = ($(sel).clone(false).removeAttr("data-templateId"))[0];
		var $wrapper = $("<div id='eeWrapper' class='wrapper_class'></div>");
		var $holder = $(containerId);
		$holder.append($wrapper);
		// Toolbar with submenu nav
		var headerElm = uiControls.util.getTemplate("tmpl_SubMenuToolbar", "div");
		headerElm.attr("id", sea.constants.DATA_SOURCES + "_dsName").appendTo("#eeWrapper");
		//EE toolbar
		var eeToolBar = new ToolBar("#eeWrapper", "entityExtraction", localMsg.EntityExtraction);
		$wrapper.append($entityExtractionElm);
		var $eeBtnsWrapper = $("#eeBtnsWrapper", $wrapper);
		attachActionButtonListener($eeBtnsWrapper);
		sea.services.getDataSource(coreName, dsId, isEdit, function(datasource) {
			if (datasource.properties.caconfig === undefined || datasource.properties.caconfig === "[]") {
				isEdit = false;
			}
			init(datasource, isEdit, $holder)
		}, null, $holder);
	}
	//$holder - jquery element to which all the controls should be added
	function init(_datasource, _isEdit, $holder) {
		self.holder = $holder;
		self.datasource = _datasource;
		self.isEdit = _isEdit;
		self.selectedEntities = null;
		self.planName = null;
		if(self.datasource.dataSourceType === sea.constants.DSTypes.FS)	
			$(".ocrElm", self.holder).removeClass("hidden");	

		if(self.datasource.properties.dcplanid !== undefined && self.datasource.properties.dcplanid !== "0") {
			getPlanDetails(function() {
				attachListeners();
				getCloudList();						
			});					
		} else {
			enableOCRForDataCubeDS();
			attachListeners();
			getCloudList();
		}			
	}

	function getCloudList() {

		var ShowOrHideEEDetails = function() {
			var $eeBtnsWrapper = $("#eeBtnsWrapper", self.holder);
			if ($.isEmptyObject(self.caCloud)) {
				$("#entity-extraction-toggle-btn", self.holder).hide();
				var $noCACloudMsg = $("#entity-extraction-msg", self.holder);
				var link = "<a href='http://documentation.commvault.com/commvault/v11/article?p=features/data_cube/t_data_cube_config_ca_cloud_entity_extraction.htm'>"+localMsg.configureCA+"</a>";
				var configureCAMsg = cvFormatters.formatString(localMsg.NoCACloudConfiguredMsg,[link]);
				$("span",$noCACloudMsg).html(configureCAMsg);
				$noCACloudMsg.show();
				self.datasource.properties.iscaenabled = false;
				$eeBtnsWrapper.addClass("hidden");
				return;
			}
			//Enable Entity Extration only if CA clouds are configured
			if (self.isEdit && self.datasource.properties.iscaenabled === "true") {
				$("#isEntityExtractionEnabled", self.holder).trigger("click");
			}
			$("#entity-extraction-toggle-btn", self.holder).show();
			$("#entity-extraction-msg", self.holder).hide();
		};

		sea.services.getContentAnalyzerCloud(function(caCloud) {
			self.caCloud = caCloud;
			var $entityExtractionElm = $("#entityExtractionWrapper", self.holder);
			$entityExtractionElm.show();
			ShowOrHideEEDetails();
		}, null, self.holder);
	}

	function populateFieldsList(callback) {
		/*
		 * fields - array of json objects defaultFields - array of strings
		 */
		var $holder;
		if (!callback)
			$holder = self.holder;
		getFieldsList(function (fields, defaultFields) {
			var hasFields = true;
			if (fields.length === 0) {
				hasFields = false;
			}
			var $fieldsHolder = createEEFieldsHolder(hasFields);

			if ($fieldsHolder !== null) {
				//populate list of fields
				if (hasFields) {
					$fieldsHolder.empty();
					$.each(fields, function(i, field) {
						$fieldsHolder.append("<option value='" + field.fieldName + "'>" + field.displayName +
							"</option>");
					});
					if ($fieldsHolder.data('multiselect') === undefined) {
						initMultiselect($fieldsHolder);
					}					
				}

				//In case of edit, select fields based on server data
				if (self.isEdit) {
					var caConfig = self.datasource.properties.caconfig;
					if (caConfig != undefined) {
						if (typeof caConfig != "object") {
							caConfig = JSON.parse(caConfig);
						}
						$.each(caConfig, function (i, config) {
							if (config.task === constants.ENTITY_EXTRACTION_FIELDS) {
								if (!$.isArray(config.arguments)) {
									config.arguments = config.arguments.split(",")
								}

								if (!hasFields) {
									$fieldsHolder.val(config.arguments.join(","));
								} else {
									$fieldsHolder.multiselect('select', config.arguments);
								}
							}
						});
					}
				} else { //Not edit. Select all fields or default fields

					if (hasFields) {
						//select 'defaultFields'. Depends on the datasource
						if (defaultFields && defaultFields.length > 0) {
							$fieldsHolder.multiselect('select', defaultFields)
						}
						//Selecting all fields for EE by default
						else {
							$fieldsHolder.multiselect('select', $.map(fields, function(field) {
								return field.fieldName;
							}));
						}
					} else {
						if (defaultFields && defaultFields.length > 0) {
							$fieldsHolder.val(defaultFields.join(','));
						}
					}
					
				}
				if(hasFields) {
					$("option:selected", $fieldsHolder).prependTo($fieldsHolder);//This code is to get all the selected columns at the top in the dropdown, On Edit handler.
					$fieldsHolder.multiselect('rebuild');
				}
					
			}
			if (self.datasource.properties.dcplanid !== undefined && self.datasource.properties.dcplanid !== "0") {
				var $eeFieldsDropDown = $("#entityExtractionFieldsWrapper ul.dropdown-menu",self.holder);
				$("li:not(:first-child)",$eeFieldsDropDown).addClass("disabled");
			}
			if(callback)
				callback();
			
		}, $holder);
	}

	function populateFieldsListPromise() {		
		var deferred = $.Deferred();
		populateFieldsList(function() {
			deferred.resolve();			
		});
		return deferred.promise();
				
	}

	function createEEFieldsHolder(hasFields) {
		var $fieldsCombo = $("#" + constants.ENTITY_EXTRACTION_FIELDS, self.holder);
		var $eeFieldsWraper = $("#entityExtractionFieldsWrapper", self.holder);
		var createHolder = false;
		if ($fieldsCombo.length > 0) {
			$eeFieldsWraper.empty();
			createHolder = true;
		}

		if ($fieldsCombo.length === 0 || createHolder) {
			if (hasFields) {
				$fieldsCombo = $("<select id='" + constants.ENTITY_EXTRACTION_FIELDS +
					"' class='form-control' multiple='multiple'></select>");
			} else {
				$fieldsCombo = $("<input id='" + constants.ENTITY_EXTRACTION_FIELDS +
					"' class='form-control' placeholder='field1, field2'>");
			}
			$eeFieldsWraper.append($fieldsCombo);
		}
		return $fieldsCombo;
	}

	function getFieldsList(callback, $holder) {		
		sea.services.getDSSchema(self.datasource.datasourceId, function(fields) {
			if (fields !== undefined) {
				var schemaFields = sea.schemaController
					.getDeleteableFields(fields.schemaFields, false, false, true);
				var fields = $.map(schemaFields, function (fieldObject) {
					return {
						fieldName : fieldObject.fieldName,
						displayName : fieldObject.fieldName
					};
				});
				fields.sort();
				var defaultFields = self.datasource.dataSourceType === sea.constants.DSTypes.FS ? ['content'] : undefined;
				callback(fields,defaultFields);
			} else {
				callback([]);
			}

		}, null, $holder);
		 
	}

	function attachListeners() {
		var $entityListHolder = $("#" + constants.ENTITIES_TO_EXTRACT, self.holder);

		//Listener for the toggle button
		$("#isEntityExtractionEnabled", self.holder).off("click").on("click", function() {
			onEnableEntityExtraction($(this));
		});
	}


	function initMultiselect($select, isMultiple, enableClickableOptGroups, onChangeListener, onSelectAllListner) {
		var self = this;
		if ($.isEmptyObject($select.data('multiselect'))) {
			var dropUp = false;
			var maxHeight = 300;
			if (isMultiple !== false) {
				$select.attr('multiple', 'multiple');
			}
			if ($select.offset().top + maxHeight > $(document).height()) {
				dropUp = true;
			}
			$select
				.multiselect({
					enableFiltering: true,
					enableCaseInsensitiveFiltering: true,
					enableClickableOptGroups: enableClickableOptGroups === true,
					maxHeight: maxHeight,
					numberDisplayed: 1,
					buttonContainer: "<div class='btn-group multiselect-button'></div>",
					buttonClass: "multiselect-button", //self.datasource.constants.MULTISELECT_BUTTON_CLASS,
					includeSelectAllOption: isMultiple !== false,
					dropUp: dropUp,
					onChange: onChangeListener,
					onSelectAll: onSelectAllListner,
					onDropdownShown: function () {

						var $search = this.$filter.find("div.multiselect-button");
						/*
						 * Jquery multiselect is doing something that takes away the focus from the search
						 * box as soon as we focus it. Using a setTimeout makes sure that the current
						 * execution queue is done before focusing. Reference:
						 * http://stackoverflow.com/questions/9596419/what-are-some-reasons-for-jquery-focus-not-working
						 */
						setTimeout(function () {
							$search.focus();
						});
					},
					templates: {
						filterClearBtn: "",
						button: '<button type="button" class="multiselect dropdown-toggle btn btn-default form-control" data-toggle="dropdown" title="None selected">' +
							'<span class="multiselect-selected-text"></span><div class="pull-right"><b class="caret"></b></div></button>'
					}
				});
		} else {
			$select.multiselect('rebuild');
		}
	}

	
	var populateCACloudOptionsPromise = function () {
		var deferred = $.Deferred();
		var $caTargetURL = $("#caTargetURL", self.holder);
		var $availableClouds = self.caCloud.contentAnalyzerList.map(function (ca) {
			return $("<option value='" + ca.cloudId + "'>" + ca.cloudName + "</option>");
		});
		$caTargetURL.empty().append($availableClouds);
		// initMultiselect($caTargetURL, false);
		var cloudId = self.datasource.properties.cacloudid;
		var caTargetURL = self.datasource.properties.catargeturl;
			
		if (self.isEdit && ((caTargetURL !== undefined && caTargetURL.length > 0) || cloudId)) {
			// $caTargetURL.multiselect('select', self.datasource.properties.catargeturl);
			//to handle upgrade case. Old data source would still be having caTargetUrl and not cacloudid.
			if(!cloudId && caTargetURL) {
				var selectedContentAnalyzer = self.caCloud.contentAnalyzerList.find(function(contentAnalyzer) {
					return contentAnalyzer.caUrl === caTargetURL;
				});
				if(selectedContentAnalyzer)	{
					self.datasource.properties.cacloudid = cloudId = selectedContentAnalyzer.cloudId;
				}
			}
			$caTargetURL.val(cloudId);
			if (self.datasource.properties.dcplanid !== undefined && self.datasource.properties.dcplanid !== "0") {
				$("#caTargetURL option",self.holder).attr("disabled","disabled");

			}

		}
		deferred.resolve();
		return deferred.promise();
	}

	function populateAllEEDropdowns() {
		self.holder.mask("");
		var combinedPromise = $.when(populateCACloudOptionsPromise(),
			populateFieldsListPromise(),
			populateSupportedEntitiesToExtractPromise());
		combinedPromise.done(function () {
			self.holder.unmask();
		});			
	}

	
	function getSelectedEntities() {
		var entities = [];
		if (self.selectedEntities !== null) {
			$.map(self.selectedEntities,function(entity) {
				if(entity.tags && entity.tags.length > 0) {
					$.map(entity.tags,function(tag) {
					 	entities.push(tag.entityDetail.entityId);
					});
				}				 			 
			});
		} else if(self.isEdit) {
			var caConfig = self.datasource.properties.caconfig;
			if(caConfig != undefined) {
				caConfig = JSON.parse(caConfig);
				var entitiesToExtract = [], REREntitiesToExtract = [], NEREntitiesToExtract = [], DEEntitiesToExtract = [];
				$.each(caConfig, function (i, config) {
					if (config.task === constants.ENTITY_EXTRACTION) {
						entitiesToExtract = config.arguments;
					} else if (config.task === constants.ENTITY_EXTRACTION_RER) {
						REREntitiesToExtract = config.arguments;
					} else if (config.task === constants.ENTITY_EXTRACTION_NER) {
						NEREntitiesToExtract = config.arguments;
					} else if (config.task === constants.ENTITY_EXTRACTION_DE) {
						DEEntitiesToExtract = config.arguments;
					}
				});
				
				if (entitiesToExtract.length > 0) {
					return entitiesToExtract;
				} else {
					return (REREntitiesToExtract.concat(NEREntitiesToExtract).concat(DEEntitiesToExtract));
				}
			}
		} 
		
		return entities;
	}

	function getPlanDetails(callback) {
		var planId = self.datasource.properties.dcplanid;
		sea.services.getPlanDetails(planId, function (resp) {
			var plan = resp.plan, enableImageExtraction, EntitiesToExtract = plan.eePolicy.detail.eePolicy.extractionPolicy.extractionPolicyList;
			self.selectedEntities = EntitiesToExtract;
			self.planName = plan.summary.plan.planName;
			enableImageExtraction =  plan.ciPolicy && plan.ciPolicy.detail.ciPolicy.enableImageExtraction;
			enableImageExtraction = enableImageExtraction ? enableImageExtraction.toString().toLowerCase() === "true" : false;
			$("#enableOCR", self.holder).attr("checked",enableImageExtraction);
			callback();			
		}, null, self.holder);

	}

	function enableOCRForDataCubeDS() {
		var enableImageExtraction =  self.datasource.properties.enableImageExtraction;
		enableImageExtraction = enableImageExtraction ? enableImageExtraction.toString().toLowerCase() === "true" : false;
		$("#enableOCR", self.holder).attr("checked",enableImageExtraction);
	}
	function onEnableEntityExtraction($button) {		
		var $stepHolder = $button.parents("#entityExtractionWrapper");
		var entityExtractionContainer = $stepHolder.find(".entity-extraction-container");
		var pushOnlyMetaData = self.datasource.properties.pushonlymetadata;
		pushOnlyMetaData = pushOnlyMetaData ? self.datasource.properties.pushonlymetadata.toString().toLowerCase() : undefined;
		if (!$button.is(":checked")) {
			entityExtractionContainer.hide();			
		} else if (entityExtractionContainer.length > 0) {	
			var $planNameContainer = $("#planNameContainer",self.holder);	
			if (self.isEdit && self.datasource.properties.dcplanid !== undefined &&
				self.datasource.properties.dcplanid !== "0") {
				$planNameContainer.removeClass("hidden");
				$(".eeToggleBtnDiv", self.holder).addClass("disabled");
				$("#eeBtnsWrapper", self.holder).addClass("disabled");	
				$(".ocrInputDiv", self.holder).addClass("disabled");
						
				if(pushOnlyMetaData === "false") {	
					$("#planName", $planNameContainer).val(self.planName).addClass("disabled");				
					populateAllEEDropdowns();	
				} else {
					getPlanDetails(function(){							
						$("#planName", $planNameContainer).val(self.planName).addClass("disabled");												
						populateAllEEDropdowns();
					});	
				}	
			
			} else {
				$planNameContainer.addClass("hidden");
				populateAllEEDropdowns();
			}
			entityExtractionContainer.show();
		}

	}

	function populateSupportedEntitiesToExtractPromise() {
		var deferred = $.Deferred();
		var $select = $("#" + constants.ENTITIES_TO_EXTRACT, self.holder);
		var maxHeight = 300;
		var entitiesList = [];
		var entityDetails = null;

		var populateEntitiesList = function() {
			/*
			 * entityDetails is the getAllEntitiesByCategory API call response format.
			 */
			
			entityDetails = entityDetails.sort(function(category1 , category2) {
 				return category1.container.containerName > category2.container.containerName ? 1 : -1;
 			});
 			$.map(entityDetails, function(category) {
 				var subCategories = category.tagSetsAndItems;
 				subCategories = subCategories.sort(function(subCategory1 , subCategory2){
	 				return subCategory1.container.containerName > subCategory2.container.containerName ? 1 : -1;
	 			});
	 			$.map(subCategories, function(subCategory) {
	 				if(subCategory.tags && subCategory.tags.length > 0) {
		 				subCategory.tags = subCategory.tags.sort(function(entity1 , entity2) {
			 				return entity1.description > entity2.description ? 1 : -1;
			 			});
		 			}
	 			});
	 			
 			}); 			 

			var displayName = null,entityName, optionValue,subCategories,categoryName,subCategoryName,
			isRebuild = false;
			if($select.children().length > 0) {
				$select.empty();
				isRebuild = true;				
			} 
			$.map(entityDetails, function (category) {
				categoryName = category.container.containerName;
				subCategories = category.tagSetsAndItems;
				$.map(subCategories,function(subCategory) {
					subCategoryName = subCategory.container.containerName;
					if(subCategory.tags && subCategory.tags.length >0) {
						$.map(subCategory.tags,function(tag) {
							entityInfo = tag.entityDetail;
							displayName = tag.description;
							optionValue = entityInfo.entityId;
							var selected  = self.selectedEntities.length === 0 || (self.selectedEntities.indexOf(optionValue.toString()) !== -1 || self.selectedEntities.indexOf(optionValue) !== -1);
							var dataSection = categoryName + (subCategoryName ? "/"+subCategoryName : "");
							$select.append("<option data-section='"+dataSection+"' data-entity-type='"+entityInfo.entityType+"' value='" + optionValue + "'" 
								+ (selected ? " selected>" : ">") + displayName + "</option");
							entitiesList.push(optionValue);
						});
					}
				});
			});

			$("option:selected", $select).prependTo($select);//This code is to get all the selected items at the top in the dropdown.
					
			if(isRebuild) {
				self.treeMultiselect[0].reload();
			} else {
				var readOnly =  self.datasource.properties.dcplanid !== undefined && self.datasource.properties.dcplanid !== "0";
				var params = {
					searchable: true,
					allowBatchSelection: true,
					startCollapsed: true,
					enableSelectAll: !readOnly,
					selectAllText: 'Select All',
	 				unselectAllText: 'Unselect All',
	 				hideSidePanel: true,
	 				searchParams: ['value', 'text', 'section'],
					freeze : readOnly
				};
				self.treeMultiselect = $select.treeMultiselect(params);								
			}			
			
		}	
		

		sea.services.getEntitiesByCategory(function (entityDetailsResp) {
			entityDetails = entityDetailsResp.containerTypesList.filter(containerType => {
				return containerType.container.containerGuid !== 'C99E55EF-5875-425C-98A9-8DF5F5F0DF27';
			});
			self.selectedEntities =  getSelectedEntities();
			populateEntitiesList();			
			deferred.resolve();
		});
		return deferred.promise();
	}

	function getEntityExtractionFields() {
		var eeFields = null;
		eeFields = $("#" + constants.ENTITY_EXTRACTION_FIELDS, self.holder).val();
		if (eeFields != null) {
			return eeFields.split(",").map(function(value) {
				return value.trim();
			});
		} else {
			return [];
		}
	}
	

	function getConfig() {
		var caConfig = [];
		var $eeToggleBtn = $("#isEntityExtractionEnabled", self.holder);
		if ($eeToggleBtn.is(":checked")) {
			var $entities = $("#" + constants.ENTITIES_TO_EXTRACT + " option:selected", self.holder);
			var entityExtractionFields = [];
			var RERArguments = [], NERArguments = [], DEArguments = [];			
			entityExtractionFields = getEntityExtractionFields();
			$entities.each(function(a, item) {
				var val = $(item).val();
				var eType = $(item).data("entityType");
				if (eType === "NER") {
					NERArguments.push(val);
				} else if (eType === "DE") {
					DEArguments.push(val);
				} else {
					RERArguments.push(val);
				}
			});

			caConfig = [ {
				task : constants.ENTITY_EXTRACTION_RER,
				arguments : RERArguments,
			}, {
				task : constants.ENTITY_EXTRACTION_NER,
				arguments : NERArguments
			}, {
				task : constants.ENTITY_EXTRACTION_DE,
				arguments : DEArguments
			}, {
				task : constants.ENTITY_EXTRACTION_FIELDS,
				arguments : entityExtractionFields
			}];
		}
		return caConfig;
	}

	function getContentAnalyzerCloud() {
		var $eeToggleBtn = $("#isEntityExtractionEnabled", self.holder);
		if($eeToggleBtn.is(":checked")) 
			return $("#caTargetURL", self.holder).val();
		return "";
	}


	return {
		viewEEDetails : viewEEDetails
	};

})();
