function BlankHandler() {
	this.type = sea.constants.DSTypes.BLANK;
	this.schemaFields = [];
}

BlankHandler.prototype.initializeStep = function(step, holder, isEdit) {
	switch (step) {
	case 2:
		if (isEdit) {
			$("#dsSchemaCols", holder).attr("disabled", "disabled");
			$("[data-step=2] .help-block", holder).text(localMsg.UseSchemaToEdit);
		}
		break;
	}

};

BlankHandler.prototype.validateStep = function(step, holder, aggregatedInput, callback, isEdit, dsObj) {
	var reqData = null;
	var self = this;

	try {
		sea.util.validateInputsAndGetData(holder);
	} catch (e) {
		callback(false);
		return;
	}

	switch (step) {
	case 1:
		/*
		 * Not using this.create() to do this because sendReqToServer() will in turn redirect to the config
		 * page. We don't want that after step 1. this.dsCreated is a flag that lets us skip creation (since
		 * ds would be already created after step 1) if user goes from step 2 to step 1
		 */
		if (this.dsCreated != true && !isEdit) {
			reqData = this.getRequestObject();
			reqData.operationType = sea.constants.Operations.CREATE;
			sea.services.createDataSource(reqData, isEdit, function(resp) {
				cvUtil.toast(localMsg.DataSourceCreated);
				self.coreName = resp.coreId;
				self.id = resp.datasourceId;
				self.displayName = resp.displayName;
				$("#dsName", holder).attr("disabled", "disabled");
				$("#dsEngine", holder).attr("disabled", "disabled");
				self.dsCreated = true;
				callback(true);
			}, function(error) {
				cvUtil.errorToast(error.error.errLogMessage);
				callback(false);
			}, holder);
		} else {
			callback(true);
		}
		break;
	case 2:
		callback(true);
		break;
	}
};

BlankHandler.prototype.submit = function(isEdit, dsObj, holder) {
	var self = this;
	var schemaFields = this.getSchemaFieldsArray();

	if (isEdit && this.description !== dsObj.description) {
		/*
		 * The only thing that can change in the ds when editing is the description.
		 */
		delete this.properties.emptydatasource;
		this.update(null, dsObj, holder);
	}

	if (schemaFields.length > 0 && !isEdit) {
		var reqObj = {
			schemaFields : schemaFields
		};

		sea.services.createField(reqObj, this.coreName, false, function() {
			sea.dsController.goToDSConfigPage(self.coreName, self.name, self.id, self.type);
		}, function(error) {
			cvUtil.errorToast(error.error.errLogMessage);
		}, holder);
		var data = {
			datasourceId: self.id
		};

		self.update(null, data, holder);
	} else if (isEdit) {
		self.update(null, dsObj, holder);
	} else if (!isEdit) {
		//When user creates blank ds and the fields list is empty
		sea.dsController.goToDSConfigPage(this.coreName, this.displayName, this.id, this.type);
	}
};

BlankHandler.prototype.fetch = function(step, holder) {
	var fetchedData = {};
	var schemaFields = null;

	switch (step) {
		case 1:
			fetchedData = this.fetchBasicDetails(holder);
			fetchedData.properties = {};
			// fetchedData.properties.emptydatasource = "true";
			break;
		case 2:
			schemaFields = $("#dsSchemaCols", holder).val();
			if (schemaFields.length > 0) {
				schemaFields = schemaFields.split(",");
				this.schemaFields = $.map(schemaFields, function(field, index) {
					return field.trim();
				});
			}
			break;
	};
	this.updateProperties(fetchedData);
	return fetchedData;
};

BlankHandler.prototype.initDSSpecificComponents = function(holder, isEdit, fnCallBack) {
	fnCallBack({
		"callBack" : true
	});
};

BlankHandler.prototype.populateDSSpecificProperties = function(props, holder, onEdit) {
	
};

/*
 * The comma separated fields list will be created as string field. The user has to go to the schema page and
 * change the type of each field manually after creation of DS
 */
BlankHandler.prototype.getSchemaFieldsArray = function() {
	var schemaFields = $.map(this.schemaFields, function(field, index) {
		return {
			fieldName : field,
			type : "string",
			indexed : "true",
			stored : "true",
			multiValued : "false",
			searchDefault : "true",
			autocomplete : "false",
			copyFields : []
		};
	});

	return schemaFields;
};

