var sea = sea || {};

sea.auth = (function() {

	var callbackUrl = sea.util.getLocationOrigin() + cvUtil.getContextPath() + "/authcallback.do";

	function init(holder) {
		$(".authDivs", holder).hide();
		$(".oauth2PasswordGrantField", holder).hide();
		$("#oauth2CallbackUrl", holder).text(callbackUrl);

		holder.off("change", "#authType").on("change", "#authType", function() {
			$(".authDivs", holder).hide();
			$("." + $(this).val().toLowerCase() + "Div", holder).show();
		});

		holder.off("change", "#oauth2GrantType").on("change", "#oauth2GrantType", function() {
			if ($(this).val() === "password") {
				$(".oauth2PasswordGrantField", holder).show();
			} else {
				$(".oauth2PasswordGrantField", holder).hide();
			}
		});

		setPasswordFieldEvent($(".oauth2PassowrdIcon", holder), $('#oauth2UserPassword', holder));
		setPasswordFieldEvent($(".basicAuthPasswordIcon", holder), $('#basicAuthUserPassword', holder));
		setPasswordFieldEvent($(".cvAuthPasswordIcon", holder), $("#cvAuthUserPassword", holder));
	}

	function setPasswordFieldEvent(iconSelector, passwordInput) {
		iconSelector.off("click").on("click", function() {
			var inputType = passwordInput.attr('type');
			if (inputType === "password") {
				passwordInput.attr('type', 'text');
			} else {
				passwordInput.attr('type', 'password');
			}
			iconSelector.toggle();
		});
	}

	function getAuthInputData(holder, url) {
		var authType = $("#authType", holder).val();
		var inputs = {};
		switch (authType) {
		case "BASIC":
			inputs = {
				username : $("#basicAuthUserName", holder).val(),
				password : Base64.encode($("#basicAuthUserPassword", holder).val())
			};
			break;
		case "OAUTH1":
			inputs = {
				apiKey : $("#oauth1ConsumerKey", holder).val(),
				apiSecret : Base64.encode($("#oauth1ConsumerSecret", holder).val()),
				authorizationUrl : $("#oauth1AuthUrl", holder).val(),
				requestTokenVerb : $("#oauth1RequestTokenVerb", holder).val(),
				requestTokenUrl : $("#oauth1RequestTokenUrl", holder).val(),
				accessTokenVerb : $("#oauth1AccessTokenVerb", holder).val(),
				accessTokenUrl : $("#oauth1AccessTokenUrl", holder).val(),
				signatureMethod : $("#oauth1SignatureMethod", holder).val(),
				callbackUrl : callbackUrl,
				url : url
			};
			break;
		case "OAUTH2":
			inputs = {
				username : $("#oauth2UserName", holder).val(),
				password : Base64.encode($("#oauth2UserPassword", holder).val()),
				apiKey : $("#oauth2ConsumerKey", holder).val(),
				apiSecret : Base64.encode($("#oauth2ConsumerSecret", holder).val()),
				authorizationUrl : $("#oauth2AuthUrl", holder).val(),
				accessTokenVerb : $("#oauth2AccessTokenVerb", holder).val(),
				accessTokenUrl : $("#oauth2AccessTokenUrl", holder).val(),
				scope : $("#oauth2Scope", holder).val(),
				grantType : $("#oauth2GrantType", holder).val(),
				callbackUrl : callbackUrl,
				authParams : getHeaders($("#authHeaders", holder))
			};
			break;
		case "COMMVAULT":
			inputs = {
				webserviceLoginUrl : $("#webServiceUrl", holder).val(),
				username : $("#cvAuthUserName", holder).val(),
				password : Base64.encode($("#cvAuthUserPassword", holder).val())
			};
			break;
		default:
			break;
		}

		// To support backward compatibility.
		inputs.isEncrypted = true;
		inputs.authType = authType;
		return inputs;
	}

	function populateAuthInputData(dataObj, holder) {

		if (dataObj.isEncrypted) {
			dataObj.password = cvUtil.base64Decode(dataObj.password);
			dataObj.apiSecret = cvUtil.base64Decode(dataObj.apiSecret);
		}

		if (dataObj && dataObj.authType) {
			$("#authType", holder).val(dataObj.authType).trigger("change");
			switch (dataObj.authType) {
			case "BASIC":
				$("#basicAuthUserName", holder).val(dataObj.username);
				$("#basicAuthUserPassword", holder).val(dataObj.password);
				break;
			case "OAUTH1":
				$("#oauth1ConsumerKey", holder).val(dataObj.apiKey);
				$("#oauth1ConsumerSecret", holder).val(dataObj.apiSecret);
				$("#oauth1AuthUrl", holder).val(dataObj.authorizationUrl);
				$("#oauth1RequestTokenVerb", holder).val(dataObj.requestTokenVerb);
				$("#oauth1RequestTokenUrl", holder).val(dataObj.requestTokenUrl);
				$("#oauth1AccessTokenVerb", holder).val(dataObj.accessTokenVerb);
				$("#oauth1AccessTokenUrl", holder).val(dataObj.accessTokenUrl);
				$("#oauth1SignatureMethod", holder).val(dataObj.signatureMethod);
				break;
			case "OAUTH2":
				$("#oauth2UserName", holder).val(dataObj.username);
				$("#oauth2UserPassword", holder).val(dataObj.password);
				$("#oauth2ConsumerKey", holder).val(dataObj.apiKey);
				$("#oauth2ConsumerSecret", holder).val(dataObj.apiSecret);
				$("#oauth2AuthUrl", holder).val(dataObj.authorizationUrl);
				$("#oauth2AccessTokenVerb", holder).val(dataObj.accessTokenVerb);
				$("#oauth2AccessTokenUrl", holder).val(dataObj.accessTokenUrl);
				$("#oauth2Scope", holder).val(dataObj.scope);
				$("#oauth2GrantType", holder).val(dataObj.grantType);
				populateHeaders(dataObj.authParams, $("#authHeaders", holder));
				break;
			case "COMMVAULT":
				$("#webServiceUrl", holder).val(dataObj.webserviceLoginUrl);
				$("#cvAuthUserName", holder).val(dataObj.username);
				$("#cvAuthUserPassword", holder).val(dataObj.password);
				break;
			default:
				break;
			}
		}
	}

	function getHeaders(holder) {
		var $headers = $(".http-header", holder);
		var headers = {};
		$.each($headers, function(i, $header) {
			var key = $(".header-key", $header).val();
			var value = $(".header-value", $header).val();
			if (key && key.length) {
				headers[key] = value;
			}
		});
		return headers;
	}

	function removeHeader($removeBtn, $parentHeaderDiv) {
		$removeBtn.parents(".http-header").remove();
		if ($(".http-header", $parentHeaderDiv).length < 1) {
			var addButton = $("<button class='btn btn-default'>" + localMsg.Add + "</button>");
			addButton.on("click", function() {
				addHeader($parentHeaderDiv);
				$(this).remove();
			});
			$parentHeaderDiv.append(addButton);
		}
	}

	function addHeader($parentHeaderDiv) {
		var headerHtml = $(uiControls.util.getTemplate(sea.constants.TMPL_PREFIX + sea.constants.Actions.NEW + "_" +
				sea.constants.DSTypes.HTTP + "_header", "div"));
		headerHtml[0].style.removeProperty('display');
		var headersCount = $(".http-header", $parentHeaderDiv).length;
		if (headersCount > 0) {
			headerHtml[0].style.setProperty('margin-top', '15px');
		}
		$parentHeaderDiv.append(headerHtml);
		return headerHtml;
	}

	function populateHeaders(headerVal, holder) {
		var headers = null;
		try {
			// the string coming from the server has an extra set of qoutes.
			// Removing them
			if (headerVal !== undefined && headerVal !== null) {
				if (typeof (headerVal) === "string") {
					headers = JSON.parse(headerVal.replace(/^\"/, "").replace(/\"$/, ""));
				} else if (typeof (headerVal) === "object") {
					headers = headerVal;
				}
				for ( var header in headers) {
					setHeader(header, headers[header], holder);
				}
			}
		} catch (e) {
			console.error(e);
		}
	}

	function setHeader(key, value, holder) {
		var $headerHolders = $(".http-header", holder);
		var $headerHolder = null;

		if ($headerHolders.length === 1 && !$('.header-key', $headerHolders).val()) {
			$('.header-key', $headerHolders).val(key);
			$('.header-value', $headerHolders).val(value);
		} else {
			$headerHolder = addHeader(holder);
			$(".header-key", $headerHolder).val(key);
			$(".header-value", $headerHolder).val(value);
		}
	}

	function getAuthPropertyInChunks(input) {
		// Chunking in 128 bytes for the Authentication properties.
		var chunkArray = input.match(/.{1,128}/g);
		var encodedChunks = "";
		$.each(chunkArray, function(index, val) {
			encodedChunks += Base64.encode(val) + ".";
		});

		return encodedChunks;
	}

	function getAuthPropertyFromChunks(input) {
		// retrieving the encoded value from chunks
		var chunkArray = input.split('.');
		var decodedVal = "";
		$.each(chunkArray, function(index, val) {
			decodedVal += Base64.decode(val);
		});

		return decodedVal;
	}

	return {
		init : init,
		getData : getAuthInputData,
		populateData : populateAuthInputData,
		getHeaders : getHeaders,
		removeHeader : removeHeader,
		addHeader : addHeader,
		populateHeaders : populateHeaders,
		getAuthPropertyInChunks : getAuthPropertyInChunks,
		getAuthPropertyFromChunks : getAuthPropertyFromChunks
	};

})();