var sea = sea || {};

sea.analyticsHome = (function() {
	var isConnectorsProcessed = false;

	var init = function(fnCallBack) {
		buildTilesStructure(getFilteredReportTypes(sea.DSTypeConstants.reportsType));
		buildTilesStructure(sea.DSTypeConstants.listOfDS);
		fnCallBack(sea.DSTypeConstants.enableAnalyticsEngineSelection);
	};

	var initConnectorTypes = function() {
		if (isConnectorsProcessed) {
			return;
		}
		var connectorTypes = {};
		var supportedConnectors = sea.dataConnectorsList ? sea.dataConnectorsList.split(",") : [];
		if (!$.isEmptyObject(supportedConnectors)) {
			$.each(supportedConnectors, function(index, eachConnector) {
				var clientObj = sea.DSTypeConstants.listOfDS[eachConnector];
				var obj = typeof clientObj !== "undefined" ? clientObj : {
					searchOnly : true,
					statsEnabled : true
				//default unimplemented connectors are search only
				};
				obj.dsDispName = sea.util.getLocalizedString(eachConnector.toUpperCase());
				obj.iconPath = "sea/img/types/" + eachConnector + "-icon.svg";
				obj.viewLinkTooltip = sea.util.getLocalizedString("View_" + eachConnector.toUpperCase());
				obj.addNewTooltip = sea.util.getLocalizedString("Add_" + eachConnector.toUpperCase());
				obj.appUrl = "dcube.do?type=" + eachConnector;
				obj.iconClass = "ico-sb- ico-" + eachConnector + "-icon";
				connectorTypes[eachConnector] = obj;
			});
		}
		sea.DSTypeConstants.listOfDS = connectorTypes;
		isConnectorsProcessed = true;
	};

	var getFilteredReportTypes = function(reportTypePortlets) {
		var reportTypes = $.extend(true, {}, reportTypePortlets);
		if (!$.isEmptyObject(reportTypePortlets)) {
			var enabledReportsListArr = sea.enabledReportsList.split(",");
			$.each(reportTypePortlets, function(type, typeObj) {
				if (enabledReportsListArr.indexOf(type) === -1) {
					delete reportTypes[type];
				}
			});
		}
		return reportTypes;
	};

	var buildTilesStructure = function(portletStyles) {
		//$("#initLoading").hide();
		$.each(portletStyles, function(key, dsObj) {
			if (dsObj) {
				var portlet = $("#portlet").html();
				var portletId = "portlet_" + key;
				var portletDiv = $("<div>", {
					"id" : portletId,
					"class" : "col-lg-3 col-md-custom col-md-6 col-sm-12 col-xs-12"
				});
				portletDiv.appendTo($("#dataAnalyticsItems"));
				$(portlet).appendTo(portletDiv);
				if (!dsObj.statsEnabled) {
					$('.border-left', portletDiv).hide();
				}
				portletDiv.find(".data-connector-title").text(dsObj.dsDispName);
				var args = [];
				args.push(key);
				var appUrl = dsObj.appUrl;
				dsObj.appUrl = cvFormatters.formatString(appUrl, args);
				portletDiv.find(".appspecificIcon").attr("src", dsObj.iconPath).attr("onerror",
						"this.src='sea/img/types/default-icon.svg'");
				attachPortletBodyClickEvent(portletDiv.find(".panel-body-link"), key, dsObj.appUrl);
			}
		});
		//showDataLoading(true);
	};

	var getAllAnalyticsEngines = function(getAllAnalyticsEngines, fnCallBack) {
		if (getAllAnalyticsEngines) {
			sea.services.getEngines(true, function(serverData) {
				$(".analyticsEngineContainer").show();
				var listOfAnalyticsEngines = serverData != null ? serverData.listOfCIServer : [];
				if (!$.isEmptyObject(listOfAnalyticsEngines)) {
					if (listOfAnalyticsEngines.length == 1) {
						$("#analyticsEngine").hide();
						var engineName = listOfAnalyticsEngines[0].engineName;
						updateHeaderTitle(engineName);
						$("#singleAnalyticsEngine").show().text(listOfAnalyticsEngines[0].engineName);
					} else {
						$("#analyticsEngine").show();
						updateHeaderTitle("All");
						$.each(listOfAnalyticsEngines, function(i, eachServer) {
							var option = $("<option/>", {
								"value" : eachServer.cloudID,
								"data-itemprops" : JSON.stringify(eachServer),
								"text" : eachServer.engineName
							});

							option.appendTo($("#analyticsEngine"));
						});
					}

					fnCallBack("done");
				} else {
					fnCallBack("nodata");
				}

			}, function(xhr, ajaxOptions, thrownError) {
				cvUtil.handleError(xhr, ajaxOptions, thrownError);
				fnCallBack("error");
			});
		}
		fnCallBack("done");
	};
	var getEngineDetailsById = function(cloudId, fnCallBack) {
		sea.services.getEngineDetails(cloudId, null, function(engineDetails) {
			var error = engineDetails.error;
			if (error && error.errorCode > 0) {
				//TODO: This method doesn't exist. check error handling part
				mapErrorObjectToTile(error.errLogMessage, "connectors");
			} else {
				mapDataToDashboardInfoTiles(engineDetails.typesStats);
				mapDataToAppConfig(engineDetails.typesStats);
			}

		}, function(xhr, ajaxOptions, thrownError) {
			//showDataLoading(false);
			cvUtil.handleError(xhr, ajaxOptions, thrownError);
			$(".data-connector-ds").text("-");
		});
	};

	var mapDataToDashboardInfoTiles = function(engineDetails, appType, holder) {
		var infoData = {
			totalDS : 0,
			activeDS : 0,
			totalDocs : 0,
			totalData : 0
		};
		var serverRespGroup = getGroupByType(engineDetails);
		if (appType) {
			infoTilesDataFormatting(serverRespGroup[appType], infoData);
		} else {
			for ( var type in serverRespGroup) {
				infoTilesDataFormatting(serverRespGroup[type], infoData);
			}
		}
		$('#totalDS', holder).html(infoData.totalDS);
		$('#activeDS', holder).html(infoData.activeDS);
		$('#totalDocs', holder).html(cvFormatters.formatNumberToString(infoData.totalDocs));
		$('#totalData', holder).html(cvFormatters.formatSize(infoData.totalData));

	};

	var infoTilesDataFormatting = function(resp, infoData) {
		if (resp) {
			infoData.totalDS += (resp.active !== undefined ? resp.active : 0) +
					(resp.inactive !== undefined ? resp.inactive : 0);
			infoData.activeDS += resp.active !== undefined ? resp.active : 0;
			infoData.totalDocs += resp.totalDocs !== undefined ? resp.totalDocs : 0;
			infoData.totalData += resp.totalSizeInBytes !== undefined ? resp.totalSizeInBytes : 0;
		}
	};

	var mapDataToAppConfig = function(engineDetails) {
		var supportedConnectors = sea.dataConnectorsList.split(",");
		if (!$.isEmptyObject(supportedConnectors)) {
			var serverRespGroup = getGroupByType(engineDetails);
			$.each(supportedConnectors, function(index, eachConnector) {
				if (serverRespGroup.hasOwnProperty(eachConnector)) {
					var eachServerResp = serverRespGroup[eachConnector];
					var numDs = (eachServerResp.active !== undefined ? eachServerResp.active : 0) +
							(eachServerResp.inactive !== undefined ? eachServerResp.inactive : 0);
					var portletId = "#portlet_" + eachConnector;
					$(portletId).find(".data-connector-ds").text(numDs);
				} else {
					var portletId = "#portlet_" + eachConnector;
					$(portletId).find(".data-connector-ds").text(0);
				}
			});
		}
	};
	var getGroupByType = function(engineStatsArr) {
		var respGroup = {};
		try {
			$.each(engineStatsArr, function(i, item) {
				respGroup[item.type] = item;
			});
		} catch (err) {
			$("#initLoading").hide();
		}

		return respGroup;
	};
	var attachPortletBodyClickEvent = function(portletDiv, key, appUrl) {
		portletDiv.on("click", function(event) {
			var dataConnectorsList = sea.dataConnectorsList.split(",");
			if ($.inArray(key, dataConnectorsList) !== -1) {
				var obj = {
					'type' : key
				};
				var queryParams = "?type=" + key;
				history.pushState(obj, "Analytics", queryParams);
				sea.homePage.handleHistoryChange(obj);
			} else {
				event.preventDefault();
				event.stopPropagation();
				window.location = appUrl;
			}
		});
	};
	return {
		init : init,
		initConnectorTypes : initConnectorTypes,
		getAllAnalyticsEngines : getAllAnalyticsEngines,
		getEngineDetailsById : getEngineDetailsById,
		mapDataToDashboardInfoTiles : mapDataToDashboardInfoTiles,
		buildTilesStructure : buildTilesStructure,
		getFilteredReportTypes : getFilteredReportTypes
	};

})();