var sea = sea || {};

sea.analyticsServices = (function() {
	var APIs = {
		ROC_JOB_CREATION : "/server/rocCreateJob",
		JOB_DETAILS : "/server/rocGetJobDetails",
		ROC_RUN_JOB : "/server/rocRunJob",
		ROC_JOB_DELETION : "/server/rocDeleteJob",
		ROC_JOB_CONFIG : "/server/rocGetJobConfig",
		ROC_JOB_EDIT : "/server/rocEditJob",
		ROC_JOB_STATUS : "/server/rocJobStatus"
	};

	return {
		createROCJob : function(tableId, datasourceId, jobConfig, jobName, callback) {
			var serverURL = cvUtil.getContextPath() + APIs.ROC_JOB_CREATION + '?json=' +
					window.encodeURIComponent(JSON.stringify(jobConfig));
			cvUtil.loadPageWithGET(serverURL, {
				jobName : jobName,
				datasourceId : datasourceId
			}, function(data1) {
				var data = jQuery.parseJSON(data1);
				if (data.error) {
					alert(data.error.errLogMessage);
				} else {
					callback(data, tableId);
				}
			});
		},
		getROCJobConfig : function(datasourceId, jobId, isEdit, callback) {
			cvUtil.loadPageWithGET(cvUtil.getContextPath() + APIs.ROC_JOB_CONFIG, {
				jobId : jobId,
				datasourceId : datasourceId
			}, function(data1) {
				var data = jQuery.parseJSON(data1);
				if (data.error) {
					alert(data.error.errLogMessage);
				} else {
					callback(data, isEdit);
				}
			});
		},
		runROCJob : function(tableId, datasourceId, jobId, callback) {
			cvUtil.loadPageWithGET(cvUtil.getContextPath() + APIs.ROC_RUN_JOB, {
				jobId : jobId,
				datasourceId : datasourceId
			}, function(data1) {
				var data = jQuery.parseJSON(data1);
				if (data.error) {
					alert(data.error.errLogMessage);
				} else {
					callback(data, tableId);
				}
			});
		},
		deleteROCJob : function(tableId, datasourceId, jobId, callback) {
			cvUtil.loadPageWithGET(cvUtil.getContextPath() + APIs.ROC_JOB_DELETION, {
				jobId : jobId,
				datasourceId : datasourceId
			}, function(data1) {
				var data = jQuery.parseJSON(data1);
				if (data.error) {
					alert(data.error.errLogMessage);
				} else {
					callback(data, tableId);
				}
			});
		},
		getROCJobDetails : function(tableId, datasourceId, callback) {
			cvUtil.loadPageWithGET(cvUtil.getContextPath() + APIs.JOB_DETAILS, {
				datasourceId : datasourceId
			}, function(data1) {
				var data = jQuery.parseJSON(data1);
				if (data.error) {
					alert(data.error.errLogMessage);
				} else {
					var data = jQuery.parseJSON(data);
					callback(data, tableId);
				}
			});
		},
		editROCJob : function(tableId, datasourceId, jobConfig, jobName, callback) {
			var serverURL = cvUtil.getContextPath() + APIs.ROC_JOB_EDIT + '?json=' +
					window.encodeURIComponent(JSON.stringify(jobConfig));
			cvUtil.loadPageWithGET(serverURL, {
				jobName : jobName,
				datasourceId : datasourceId
			}, function(data1) {
				var data = jQuery.parseJSON(data1);
				if (data.error) {
					alert(data.error.errLogMessage);
				} else {
					callback(data, tableId);
				}
			});
		},
		getROCJobStatus : function(jobId, datasourceId, callback) {
			cvUtil.loadPageWithGET(cvUtil.getContextPath() + APIs.ROC_JOB_STATUS, {
				jobId : jobId,
				datasourceId : datasourceId
			}, function(data1) {
				var data = jQuery.parseJSON(data1);
				data = jQuery.parseJSON(data);
				callback(data, jobId);
			});
		},
		editROCJobFormat : function(datasourceId, jobConfig, jobName, jobId, callback) {
			var serverURL = cvUtil.getContextPath() + APIs.ROC_JOB_EDIT + '?json=' +
					window.encodeURIComponent(JSON.stringify(jobConfig));
			cvUtil.loadPageWithGET(serverURL, {
				jobName : jobName,
				datasourceId : datasourceId
			}, function(data1) {
				var data = jQuery.parseJSON(data1);
				if (data.error) {
					alert(data.error.errLogMessage);
				} else {
					callback(datasourceId, jobId, jobName);
				}
			});
		}
	};

}());