var sea = sea || {};

sea.analyticsPolling = (function() {

	var pollObject = {};

	var addJob = function(jobId, datasourceId) {
		if (!pollObject[jobId]) {
			pollObject[jobId] = setInterval(function() {
				var callback = function(data, jobId) {
					var outData = sea.analyticsController.getJobStatusDataView(data.status);
					if (outData == "Job Completed" || (outData.indexOf("Failed") > -1) || outData == "Not Started") {
						sea.analyticsPolling.removeJob(jobId);
					}
					$(".pollStatus" + jobId).empty().text(outData);
				};

				sea.analyticsServices.getROCJobStatus(jobId, datasourceId, callback);
			}, 10000);
		}
	};

	var removeJob = function(jobId) {
		if (pollObject[jobId]) {
			clearInterval(pollObject[jobId]);
		}
	}

	return {
		addJob : addJob,
		removeJob : removeJob
	};
}());

sea.analyticsController = (function() {
	var containerId;
	var mathFunctionInputs = [];
	var idColumn = null;
	var timeSeriesColumn = null;
	var schemaFieldsResp = [];
	var addiCol = [];
	var inputParam = {};
	var getAddCreateButton = function(coreName, dsId, toolBarId, tableId) {
		var btn = $("<button class='btn btn-primary'/>");
		$(btn).text(localMsg.CreateAnalytics);

		$(btn).click(function() {
			removeAnalyticsPage();
			handleAddNewAnalyticsJob(coreName, tableId);
		});
		return btn;
	};

	var hasDateFields = function(fields) {
		var i = 0;
		for (i = 0; i < fields.length; i++) {
			if (fields[i].type == 'date')
				return true;
		}
		return false;
	};

	var getSchemaField = function(data) {
		for (i = 0; i < schemaFieldsResp.length; i++) {
			if (schemaFieldsResp[i].fieldName == data) {
				return schemaFieldsResp[i];
			}
		}
	};

	var formInputJson = function(mathFunctionInputs, idColumn, timeSeriesColumn, additionalColumn) {

		//formation of Id Column, which is present in left side of the view
		var idObj = {};
		idObj.name = idColumn;
		idObj.dispName = idColumn;
		idObj.dispOrder = 0;
		idObj.formatter = "none";
		var idSchema = getSchemaField(idColumn);
		idObj.type = idSchema.type;
		idObj.role = roc.constants.columnRole.id;
		idObj.pushFlags = 3; //for python to push for both left and right sides view or to push doctype 1 and 2
		idObj.uiFlags = 1;

		//formation of Time Column, which is present in right side of the view
		var timeSeries = {};
		timeSeries.name = timeSeriesColumn;
		timeSeries.dispName = timeSeriesColumn;
		timeSeries.dispOrder = 1;
		var timeSeriesSchema = getSchemaField(timeSeriesColumn);
		timeSeries.type = "secondsDate";
		timeSeries.role = roc.constants.columnRole.time;
		timeSeries.formatter = "Date";
		timeSeries.pushFlags = 2; //for python to push for both right sides view or to push 2
		timeSeries.uiFlags = 2;

		//formation of Additional Column, which is present in right side of the view which are given by user for information
		var addiColumns = [];
		if (additionalColumn != null) {
			for (var eachCol = 0; eachCol < additionalColumn.length; eachCol++) {
				var addiColumn = {};
				addiColumn.name = additionalColumn[eachCol];
				addiColumn.dispName = additionalColumn[eachCol];
				addiColumn.dispOrder = eachCol + 2;
				var addiColumnSchema = getSchemaField(additionalColumn[eachCol]);
				addiColumn.type = addiColumnSchema.type;
				addiColumn.role = roc.constants.columnRole.additionalCol;
				addiColumn.formatter = "none";
				addiColumn.pushFlags = 2; //for python to push for right sides view or to push doctype 2
				addiColumn.uiFlags = 2;
				addiColumns.push(addiColumn);
			}
		}
		var mathanalytics = {};
		mathanalytics.id = idObj;
		mathanalytics.timeSeries = timeSeries;
		mathanalytics.addiColumns = addiColumns;
		mathanalytics.mathFunctions = mathFunctionInputs;
		return mathanalytics;
	};

	var attachClickListener = function(tableId, isEdit) {

		$("#btnSchSubmit")
				.click(function() {

					mathFunctionInputs = [];
					/*
					 * var inputElements = document.getElementsByClassName('mathInput'); for(var i=0;
					 * inputElements[i]; ++i){ if(inputElements[i].checked){
					 * mathFunctionInputs.push(inputElements[i].name); } }
					 */
					var rocValue = $("#mathFuncInput").val();
					if (rocValue == roc.constants.fnType.ROC) {
						mathFunctionInputs.push(rocValue);
						mathFunctionInputs.push(roc.constants.fnType.FreqCount);

						idColumn = $("#idGroupColumn").val();
						timeSeriesColumn = $("#timeSeriesColumn").val();
						var addtionalColumnList = $(".additionalColumn");
						addtionalColumn = [];
						for (var i = 0; i < addtionalColumnList.length - 1; i++) {
							addtionalColumn.push(addtionalColumnList[i].value);
						}

						jobName = $("#jobName").val();
						var jobConfig = formInputJson(mathFunctionInputs,
								idColumn,
								timeSeriesColumn,
								addtionalColumn,
								jobName);
						if (isEdit) {
							var callback = function(data, tableId) {
								if (data != null)
									alert(data.msg);
								createTable(tableId);
								/*
								 * if(isEdit){ createTable(tableId); }else
								 * viewResultJob(containerId,datasourceId,jobId,jobName);
								 */
							}
							sea.analyticsServices.editROCJob(tableId,
									inputParam.datasourceId,
									jobConfig,
									jobName,
									callback);
						} else {
							var callback = function(data, tableId) {
								if (data != null)
									alert(data.msg);
								createTable(tableId);
							}
							sea.analyticsServices.createROCJob(tableId,
									inputParam.datasourceId,
									jobConfig,
									jobName,
									callback);
						}
					}
				});

		$("#btnSchCancel", container).click(function() {
			var tableId = sea.constants.DATA_SOURCES + "_analyticsDT";
			createTable(tableId);
		});

		$("#btn_AddColmByOptsOneTime").click(function() {
			$(this).hide();
			addColInfo($(this));
		});
	};

	var addColInfo = function(currentElm) {
		var templClass = "addColumnsDivTmpl";
		var divToBeAdded = $("." + templClass).clone().removeClass(templClass).show();
		var colDropdownId = $("#splitByDiv > div").size();
		colDropdownId = colDropdownId + 1;
		if (currentElm) {
			divToBeAdded.insertAfter(currentElm);
		} else {
			divToBeAdded.appendTo($("#splitByDiv"));

		}

		$(".addAddiColmByBtn", divToBeAdded).on("click", function(event) {
			addColInfo($(this).parent().parent());
		});

		$(".delAddiColmByBtn", divToBeAdded).on("click", function(event) {
			$(this).parent().parent().remove();
			if ($("#splitByDiv").find(".addColumnsDivTmpl").length == 0)
				$("#btn_AddColmByOptsOneTime").show();
		});
	};

	var appendDataToDropDown = function(data) {
		var i;
		for (i = 0; i < data.length; i++) {
			if (data[i].type != 'date') {
				comboObj = $('#idGroupColumn');
				var optHtml = "<option value=\"" + data[i].fieldName + "\">" + data[i].fieldName + "</option>";
				comboObj.append(optHtml);
			}
			if (data[i].type == 'date') {
				comboObj = $('#timeSeriesColumn');
				var optHtml = "<option value=\"" + data[i].fieldName + "\">" + data[i].fieldName + "</option>";
				comboObj.append(optHtml);
			}
			var optHtml = "<option value=\"" + data[i].fieldName + "\">" + data[i].fieldName + "</option>";
			$(".additionalColumn").append(optHtml);
		}
	};

	var getJobDetails = function(jobId, dsId, isEdit) {
		var callback = function(data, isEdit) {
			var msg = jQuery.parseJSON(data);
			if (isEdit) {
				appendJobDetails(msg);
				$("#jobName").attr("disabled", "disabled")
			} else {
				roc.rocController.putColConfig(msg);
			}
		};
		sea.analyticsServices.getROCJobConfig(dsId, jobId, isEdit, callback);
	};

	var handleAddNewAnalyticsJob = function(coreName, tableId, jobId, dsId, isEdit) {

		sea.services.getDSSchema(dsId, function(resp) {
			schemaFieldsResp = sea.schemaController.getDeleteableFields(resp.schemaFields, false);
			if (hasDateFields(schemaFieldsResp)) {
				var analyticsJobTmpl = $("#analyticsJobTmpl").html();
				$(containerId).append(analyticsJobTmpl);
				var optHtml = "<option value=101>" + localMsg.ROC + "</option>";
				$("#mathFuncInput").append(optHtml);
				appendDataToDropDown(schemaFieldsResp);
				//appendDataToDropDown(schemaFieldsResp,true);
				//addCustomTags(schemaFieldsResp);
				addiCol = schemaFieldsResp;
				attachClickListener(tableId, isEdit);
				if (isEdit) {
					getJobDetails(jobId, dsId, isEdit);
				}
			} else {
				alert("There is no date Field.. Please Check the Prerequisites");
			}

		}, function(errResp) {
		}, $(containerId));
	};

	var createViewTable = function(tableid) {
		/*
		 * var thead ="<tr>"; var eachHead=0; for(eachHead=0;eachHead<3;eachHead++){ thead+= "<th></th>"; }
		 * thead+="</tr>";
		 */
		return '<table class="table table-bordered" id=' + tableid + '></table>'
	};

	var formulateJobViewColumn = function() {
		var columTable = [];
		var column = sea.analyticsColumnConfig.jobViewConfig;
		for (var i = 0; i < column.length; i++) {
			columTable.push(column[i]);
		}
		return columTable;
	}

	var getJobStatusDataView = function(data) {
		var outData = null;
		if (data == "Not Started")
			outData = data;
		else {
			var splitData = data.split("_");
			var jobStatusValue = splitData[0];
			var jobPhaseValue = splitData[1];
			var status, phase;
			var jobStatus = sea.analyticsConstants.jobStatus;
			var jobPhase = sea.analyticsConstants.jobPhase;
			if (jobStatusValue != null) {
				if (jobStatusValue == jobStatus.Created) {
					status = "Created";
				} else if (jobStatusValue == jobStatus.Running) {
					status = "Running";
				} else if (jobStatusValue == jobStatus.Completed) {
					status = "Completed";
				} else if (jobStatusValue == jobStatus.Pending) {
					status = "Pending";
				} else if (jobStatusValue == jobStatus.Failed) {
					status = "Failed";
				}
			}
			if (jobPhaseValue != null) {
				if (jobPhaseValue == jobPhase.Crawl) {
					phase = "Crawl Phase";
				} else if (jobPhaseValue == jobPhase.Analyze) {
					phase = "Analyze Phase";
				}
			}
			if (phase == null && status == null) {
				outData = data;
			} else if (status == "Completed" && phase == "Analyze Phase") {
				outData = "Job Completed";
			} else {
				outData = phase + " " + status;
			}

		}
		return outData;
	}

	var populateJobDetails = function(column, data, tableId) {

		var dataTable = $('#' + tableId).dataTable({
			"searching" : false,
			"pageLength" : 10,
			"data" : data,
			"paging" : true,
			"pagingType" : "simple_numbers",
			"iTotalRecords" : data.length,
			"dom" : 'lfrt<"pull-left"i><"pull-right"p>',
			"autowidth" : true,
			"lengthChange" : false,
			"columns" : column,
			"searching" : true,
			"initComplete" : function(oSettings, json) {
				iTotalRecords = oSettings.fnRecordsTotal();
			},
			"drawCallback" : function(oSettings, json) {
				renderAnalyticsLink(tableId,
						inputParam.coreName,
						inputParam.dsName,
						inputParam.datasourceId,
						inputParam.dsType);
			},
			"order" : [],
			"language" : {
				"zeroRecords" : "No Job is created"
			}
		});
	};

	var renderAnalyticsLink = function(tableId, coreName, dsName, dsId, dsType) {
		var reqObj = {};
		reqObj[sea.constants.HistoryParams.ACTION] = sea.constants.Actions.ANALYTICS_VIEW_RESULTS;
		reqObj[sea.constants.HistoryParams.DS_ID] = dsId;
		reqObj[sea.constants.HistoryParams.CORE_NAME] = coreName;
		reqObj[sea.constants.HistoryParams.DS_TYPE] = dsType;
		reqObj[sea.constants.HistoryParams.DS_NAME] = dsName;
		reqObj[sea.constants.HistoryParams.FULL_VIEW] = "1";
		$.each($(".viewResult", "#" + tableId), function(i, elm) {
			reqObj[sea.constants.HistoryParams.JOB_IB] = $(this).data("jobid");
			reqObj[sea.constants.HistoryParams.JOB_NAME] = $(this).data("jobname");
			$(elm).cvHyperlink(reqObj);
		});
	};

	var getJobView = function(tableId) {
		var callback = function(data, tableId, containerId, datasourceId, jobId, jobName, isEdit) {
			var col = formulateJobViewColumn(data);
			if (data != null) {
				populateJobDetails(col, data, tableId);
				attachClickListenerTable(tableId);
			}
		};
		sea.analyticsServices.getROCJobDetails(tableId, inputParam.datasourceId, callback);
	};

	var appendJobDetails = function(data) {
		var jobConfig = data.DM2ContentIndexing_AnalyticsJobRequest.jobConfig;
		var rocConfig;

		for (var i = 0; i < jobConfig.length; i++) {
			if (jobConfig[i].fnType == 101) {
				rocConfig = jobConfig[i];
			}
		}

		var initial = true;

		var addInfo = [];

		$("#jobName").val(data.DM2ContentIndexing_AnalyticsJobRequest.name);
		for (var i = 0; i < rocConfig.columnConfig.length; i++) {
			if (rocConfig.columnConfig[i].role == roc.constants.columnRole.id) {
				$("#idGroupColumn").val(rocConfig.columnConfig[i].name);
			}
			if (rocConfig.columnConfig[i].role == roc.constants.columnRole.time) {
				$("#timeSeriesColumn").val(rocConfig.columnConfig[i].name);
			}
			if (rocConfig.columnConfig[i].role == roc.constants.columnRole.additionalCol) {
				/*
				 * if(initial){ $("#btn_AddColmByOptsOneTime").click(); initial=false; }else{
				 * $(".addSplitByBtn").click(); }
				 */
				$("#btn_AddColmByOptsOneTime").click();
				addInfo.push(rocConfig.columnConfig[i].name);
			}
		}

		var addtionalColumnList = $(".additionalColumn");
		addtionalColumn = [];
		for (var i = 0; i < addtionalColumnList.length - 1; i++) {
			$(addtionalColumnList[i]).val(addInfo[i]);
		}

	};

	var attachClickListenerTable = function(tableId) {
		$("#" + tableId).on("click", "a.runJob", function(event) {
			event.preventDefault();
			var jobId = $(this).data('jobid');
			var dsId = $(this).data('dsid');
			var callback = function(data, tableId) {
				alert(data);
				createTable(tableId);
			};
			sea.analyticsServices.runROCJob(tableId, inputParam.datasourceId, jobId, callback);
		});

		$("#" + tableId).on("click", "a.deleteJob", function(event) {
			event.preventDefault();
			var jobId = $(this).data('jobid');
			var dsId = $(this).data('dsid');
			var callback = function(data, tableId) {
				alert(data.msg);
				createTable(tableId);
			};
			sea.analyticsServices.deleteROCJob(tableId, inputParam.datasourceId, jobId, callback);
		});

		$("#" + tableId).on("click", "a.editJob", function(event) {
			event.preventDefault();
			var jobId = $(this).data('jobid');
			var dsId = $(this).data('dsid');
			/*
			 * var callback=function(data,tableId,containerId,datasourceId,jobId,jobName,isEdit){ if(isEdit){
			 * createTable(tableId); }else viewResultJob(containerId,datasourceId,jobId,jobName); };
			 * sea.analyticsServices.processRequest(tableId,inputParam.datasourceId,callback,null,null,jobId,true);
			 */
			removeAnalyticsPage();
			toolBarId = sea.constants.DATA_SOURCES + "_analytics";
			handleAddNewAnalyticsJob(inputParam.coreName, tableId, jobId, dsId, true);
		});
	};

	var removeAnalyticsPage = function() {
		$("#jobViewTable").remove();
		$("#mathAnalytics").remove();
		$("#rocPage").remove();
	};

	var viewResultJob = function(containerId, dsId, jobId, jobName) {
		removeAnalyticsPage();
		roc.rocController.init(containerId, dsId, jobId, true, jobName);
	};

	var createTable = function(tableId) {
		removeAnalyticsPage();
		var tableDiv = $("<div id='jobViewTable'></div>");
		var jobView = $(tableDiv).html(createViewTable(tableId));
		$(jobView).appendTo(containerId);
		getJobView(tableId);
	};

	var initAnalyticsFields = function(coreName, dsName, dsId, dsType, viewResult, jobId, jobName) {
		inputParam = {};
		inputParam.coreName = coreName;
		inputParam.dsName = dsName;
		inputParam.datasourceId = dsId;
		inputParam.dsType = dsType;
		containerId = sea.containerId;
		var headerElm = uiControls.util.getTemplate("tmpl_Header", "h3");
		headerElm.text(dsName).prependTo(containerId);
		var tableId = sea.constants.DATA_SOURCES + "_analyticsDT";
		toolBarId = sea.constants.DATA_SOURCES + "_analytics";
		var schemaToolBar = new ToolBar(containerId, toolBarId, "Analytics");
		schemaToolBar.addButton(getAddCreateButton(coreName, dsId, toolBarId, tableId));
		if (viewResult) {
			viewResultJob(containerId, dsId, jobId, jobName);
		} else
			createTable(tableId);
	};

	return {
		initAnalyticsFields : initAnalyticsFields,
		getJobStatusDataView : getJobStatusDataView,
		getJobDetails : getJobDetails,
		removeAnalyticsPage : removeAnalyticsPage
	};
}());