<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
 <fmt:bundle basename="localization.ReportsPlusMessages">
 <div class="ng-scope">
	<div class="setup-title" data-ng-class="{'modal-header': appName !== 'adminconsole'}">
		<h4 data-ng-if="!editMode" class="ng-scope"><fmt:message key='CustomReport.Views.CreateView'/></h4>
	</div>
	<div class="setup-content" data-ng-class="{'modal-header': appName !== 'adminconsole'}">
			<form name="createViewform" novalidate="" data-cv-submit="saveView()" autocomplete="off" class="create-view-form" id="create-view-form">
				<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
				<div>
					<div class="cv-modal-wrapper">
						<label class="cv-label" for="viewName"><fmt:message key='CustomReport.Views.SaveViewAs'/></label>
						<div class="cv-inline-wrapper">
							<input type="text" name="viewName" id="viewName"
								data-ng-model="currentView.view.reportViewName" required="true"
								data-ng-class="{'has-error': cv.createViewform.needsAttention(createViewform.viewName)}"
								autofocus="" class="">
							<span class="help-block ng-hide" data-ng-show="cv.createViewform.needsAttention(createViewform.viewName)"><fmt:message key='CustomReport.Views.SpecifyName'/></span>
						</div>
					</div>				
					<div class="cv-modal-wrapper">
						<label for="chkSetAsDefault" class="cv-inline-checkbox create-view-checkbox">
							<input name="chkSetAsDefault" id="chkSetAsDefault" type="checkbox" data-ng-model="isDefault">
								<label for="chkSetAsDefault" class="cv-checkbox-label"><fmt:message key='CustomReport.Views.SetAsDefault'/></label>
						</label>
					</div>
					<hr>
				</div>			
				<div class="cv-modal-wrapper">
					<h4 class="text-left section-heading"><fmt:message key='CustomReport.Views.Rules'/></h4>
				</div>			
				<div id="rules-widget-wrapper">				
					<p class="text-center ng-scope" data-ng-if="!rules.length"><fmt:message key='CustomReport.Views.Rules.NoRulesAdded'/></p>
					
					<ul class="list-inline ng-scope" data-ng-repeat="rule in rules">
					<li>
						<label for="rule-$index" class="select-label">
							<select name="rule-$index" id="rule-$index"
								class="rule-column-name" data-ng-model="rule.columnId"
								data-ng-options="column.id as column.displayName for column in component.columns | filter:column.hidden == 'false'"
								data-ng-change="getConditions(rule)"></select>
						</label>
					</li>
					<li>					
						<label for="ruleCondition-$index" class="select-label">
							<select name="ruleCondition-$index" id="ruleCondition-$index"
							class="override-select rule-condition"							
							data-ng-model="rule.condition" data-ng-options="condition.id as condition.label for condition in rule.conditions">								
						</select>
						</label>
					</li>
					<li>
						<span id="ruleFilter-$index" class="grid-column-field-filter rule-filter">
								<div class="ui-grid-filter-container ng-scope ui-grid-filter-cancel-button-hidden"  ng-class="{'ui-grid-filter-cancel-button-hidden' : colFilter.disableCancelFilterButton === true }">
									<div ng-if="colFilter.type !== 'select'" class="ng-scope">
										<input type="text"
											class="ui-grid-filter-input"
											ng-model="rule.value"
											ng-attr-placeholder="{{colFilter.placeholder || ''}}"
											placeholder="">									
									</div>
								</div>								
						</span>
					</li>					
					<li>
						<span class="glyphicon glyphicon-remove rule-remove" data-ng-click="removeRule($index)" title="Remove Name"></span>
					</li>
					
					</ul>
				</div>			
				<div class="cv-button-wrapper">
					<button data-ng-disabled="!component.columns.length" type="button" class="btn btn-default" data-ng-click="addRule(component.columns[2]['id'],component.columns[0]['type'],'')"><fmt:message key='CustomReport.Views.Rules.AddRule'/></button>
				</div>
				<div class="button-container">				
					<button type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="$close()"><fmt:message key='CustomReport.Cancel'/></button>
					<button type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-disabled="rules.length === 0"><fmt:message key='CustomReport.Save'/></button>
				</div>
			</form>
	</div>
</div>

 </fmt:bundle>


