<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsPlusMessages">
	<div data-ng-if="chartProperties" data-ng-include="'${pageContext.request.contextPath}/reportsplus/templates/reportComponents/header.jsp'"></div>
	<div id="autoRefreshOptions" class="auto-refresh" data-ng-show="page.body.isAutoRefreshShow" >
		<button data-ng-click="toggleTimerOptionsVisibility()" class="btn btn-sm btn-default hideOnReadme pull-right refresh-button" 
		data-ng-class="{'margin-right-47' : appName == 'adminconsole', 'margin-right-24' : appName == 'webconsole'}">
			<fmt:message key="CustomReport.AutoRefresh"/><span class="caret"></span></button>	
		<div data-ng-show="showTimerOptions" class="timer-input-options hideOnReadme" data-ng-class="{'margin-right-47' : appName == 'adminconsole', 'margin-right-24' : appName == 'webconsole'}">
			<div class="row noLftRghtMargin margin-bottom-5">
				<input class="toggle-input" type="checkbox" data-ng-model="page.body.autoRefresh"
						 data-ng-change="startAutoRefreshTimer()" id="enableAutoRefresh">
				<label title='<fmt:message key="CustomReport.AutoRefresh.EnableTimer"/>' class="toggle-label" for="enableAutoRefresh"><fmt:message key="CustomReport.AutoRefresh.EnableTimer"/></label>
			</div>
			
			<div class="row noLftRghtMargin">
				<div class="input-group mb-3">
					<input type="number" class="input-sm margin-0 form-control" data-ng-model="page.body.autoRefreshTime" data-ng-blur="startAutoRefreshTimer(true)" ng-disabled="!page.body.autoRefresh">
					<div class="input-group-addon">
						<span class="input-group-text" id="basic-addon2"><fmt:message key="CustomReport.AutoRefresh.Sec"/></span>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div id="reportViewerArea" data-ng-controller="ComponentsCtrl">
		<div class="tabs row" data-ng-if="customReport.showPagesAsTabs">
			<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
				<ul class="primary-background-color">
					<li class="page-tab center-tab-bg" data-ng-repeat="p in customReport.pages" data-ng-click="setActivePageByName(p.pageName,true);setActiveComponent(p, 'page')" data-ng-class="{'page-tab-active': selectedPage.pageName === p.pageName}">
						<div title="{{p.pageTitle.text}}">{{p.pageTitle.text}}</div>
					</li>
				</ul>
			</div>
		</div>
		<div class="view-area" data-ng-include="'${pageContext.request.contextPath}/reportsplus/templates/reportComponents/body.jsp'" data-ng-class="{'tab-area': customReport.showPagesAsTabs}"></div>
	</div>
	<div data-ng-if="columnProperties" data-ng-include="'${pageContext.request.contextPath}/reportsplus/templates/reportComponents/footer.jsp'"></div>
</fmt:bundle>