
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<fmt:bundle basename="localization.ReportsPlusMessages">
<fmt:message key="CustomReport.Component.HeatMap" var="heatmap" />
<div ng-controller="reportChartCtrl" class="maskLayer full-height" data-ng-class="{'isMasked':masked}">
<div data-ng-hide="component.showInTabularForm">
<div class="chartArea full-height {{component.chartType}}" id="chart_{{$index}}" data-ng-if="component.chartType !='heatmap'">
	<label class='maskLayerLabel hideOnExportFriendly' data-ng-show="masked" ><fmt:message key="CustomReport.Loading"/></label>
	<div class="timeLineGrouping" data-ng-if="component.chartType=='TimeSeries' && reportMode=='viewer'">
		<div data-ng-repeat="field in component.dimensionDataField" class="chartColumns groupingCol"
				data-ng-class="{'hidden':component.dimensionDataField == undefined || component.dimensionDataField.length == 0 }"
				data-ng-show="field.showTimeGrouping">
				<label data-ng-show="component.dimensionDataField.length == 1 && component.measureDataField.length == 1 && compareOptions.length > 0">Compare:&nbsp;</label><label class="select-label"><select data-ng-model="compareInfo.selectedCompareOption" data-ng-show="component.dimensionDataField.length == 1 && component.measureDataField.length == 1 && compareOptions.length > 0" data-ng-options="compareOption.dispName for compareOption in compareOptions" data-ng-change="compareOptionChanged()" class="colNoBorder">
				<option><
			</select></label>
		<label><fmt:message key="CustomReport.Group"/>:&nbsp;</label>
			<label class="select-label"><select data-ng-model="field.timeGrouping" data-ng-change="timeGroupingSelectionChanged(field.timeGrouping)" class="colNoBorder">
				<option value="None" data-ng-if="component.chartType != 'TimeSeries'"><fmt:message key="CustomReport.None"/></option>
				<option value="auto">Auto</option>
				<option value="Hourly" data-ng-if="field.showHourlyGrouping"><fmt:message key="CustomReport.Hourly"/></option>
				<option value="Daily"><fmt:message key="CustomReport.Daily"/></option>
				<option value="Weekly"><fmt:message key="CustomReport.Weekly"/></option>
             	<option value="Monthly"><fmt:message key="CustomReport.Monthly"/></option>
				<option value="Yearly"><fmt:message key="CustomReport.Yearly"/></option>
			</select></label>
		</div>
	</div>
	<div class="clearFloat"></div>
	<div class="xAxisColGroup" data-ng-if="reportMode == 'builder'">
			<fieldset class="axisColumnDrop" data-droptype="xAxis"
				data-ng-class="{'dashboardAxisColumnDrop' : isDcubeEnabledInCustomReports}"
				data-ng-class="{'disableColumnDrop':!component.isSelected}"
				x-lvl-drop-target="true"
				x-on-drop="dropped(dragEl, dropEl)">
				<legend class="fieldsetLegend"><fmt:message key="CustomReport.Drop"/> {{getFieldLabel(component.chartType, 'x')}}</legend>
				<div data-ng-repeat="field in component.dimensionDataField" class="chartColumns groupingCol" data-ng-class="{'hidden':component.dimensionDataField == undefined || component.dimensionDataField.length == 0 }">
						<label>
		 				<select data-ng-show="component.chartType == 'TimeSeries' && field.showTimeGrouping" data-ng-model="field.timeGrouping" data-ng-change="timeGroupingSelectionChanged(field.timeGrouping)" class="colNoBorder">
			                <option value="None" data-ng-if="component.chartType != 'TimeSeries'"><fmt:message key="CustomReport.None"/></option>
			                <option value="auto">Auto</option>
			                <option value="Hourly" data-ng-if="field.showHourlyGrouping"><fmt:message key="CustomReport.Hourly"/></option>
			                <option value="Daily"><fmt:message key="CustomReport.Daily"/></option>
			                <option value="Weekly"><fmt:message key="CustomReport.Weekly"/></option>
			              	<option value="Monthly"><fmt:message key="CustomReport.Monthly"/></option>
			              	<option value="Yearly"><fmt:message key="CustomReport.Yearly"/></option>
		               </select>
						({{field.column}})
					</label>
					<!-- No need of a delete button on the dimension data field as it is a mandatory column for all chart types -->
					<span class="deleteColumn" data-ng-click="deleteColumn(component.dimensionDataField, $index)">&times;</span>
				</div>
			</fieldset>
	</div>
	<div class="yAxisColGroup" data-ng-if="reportMode == 'builder' && component.chartType !='Histogram'">
		<fieldset class="axisColumnDrop" data-ng-class="{'dashboardAxisColumnDrop' : isDcubeEnabledInCustomReports}"
			data-ng-class="{'disableColumnDrop':  !component.isSelected || disableMeasureDrop}"
			x-lvl-drop-target="true"
			data-droptype="yAxis"
			x-on-drop="dropped(dragEl, dropEl)">
			<legend class="fieldsetLegend"><fmt:message key="CustomReport.Drop"/>{{getFieldLabel(component.chartType, 'y')}}</legend>
			<div data-ng-if ="!disableMeasureDrop && component.measureDataField.length!=0" data-ng-repeat="field in component.measureDataField" class="chartColumns groupingCol">
	 				<label>
	 				<select data-ng-model="field.aggrType" data-ng-change="aggregateSelectionChanged()" class="colNoBorder">
	                <option data-ng-if="field.showNumberOps && component.chartType != 'TimeSeries'" value="None"><fmt:message key="CustomReport.None"/></option>
	                   <option value="Count"><fmt:message key="CustomReport.Count"/></option>
	                   <option value="CountDistinct" data-ng-if="component.chartType != 'TimeSeries'"><fmt:message key="CustomReport.Distinct"/></option>
	                   <option data-ng-if="field.showNumberOps" value="Sum"><fmt:message key="CustomReport.Sum"/></option>
	                   <option data-ng-if="field.showNumberOps" value="Avg"><fmt:message key="CustomReport.Avg"/></option>
	                   <option data-ng-if="field.showNumberOps"  value="Min"><fmt:message key="CustomReport.Min"/></option>
	                   <option data-ng-if="field.showNumberOps" value="Max"><fmt:message key="CustomReport.Max"/></option>
	               </select> ({{field.column}})
	               </label>
	        	<span class="deleteColumn" data-ng-click="deleteColumn(component.measureDataField, $index)">&times;</span>
			</div>
		</fieldset>
	</div>
		<!-- <div class="pull-right filter-btn">
			<button type="button" class="btn btn-sm" data-ng-class="{'btn-default': (component.filters[component.dimensionDataField[0].column]['include'] || []).length == 0, 'btn-info': (component.filters[component.dimensionDataField[0].column]['include'] || []).length > 0 }" data-ng-click="showFilteredValues($event,'include')">Include
			<span class="badge" data-ng-show="(component.filters[component.dimensionDataField[0].column]['include'] || []).length > 0" data-ng-bind="component.filters[component.dimensionDataField[0].column]['include'].length"></span>
			</button> //TODO localize
			<button type="button" class="btn btn-sm"  data-ng-class="{'btn-default': (component.filters[component.dimensionDataField[0].column]['exclude'] || []).length == 0, 'btn-info': (component.filters[component.dimensionDataField[0].column]['exclude'] || []).length > 0 }" data-ng-click="showFilteredValues($event,'exclude')">Exclude
			<span class="badge" data-ng-show="(component.filters[component.dimensionDataField[0].column]['exclude'] || []).length > 0" data-ng-bind="component.filters[component.dimensionDataField[0].column]['exclude'].length"></span>
			</button> //TODO localize
		</div> -->
		<div class="clearFloat"></div>

			<div class="noChartDiv"  data-ng-show="isShowNoChartDiv()" data-ng-click="setActiveComponent()">
					<label data-ng-show="componentLoaded && !component.isChartExist "><fmt:message key="CustomReport.NoDataAvailable"/></label>
			</div>
			<highchart  data-ng-show="!$scope.masked && component.isChartExist"  config="chartConfig"  data-ng-class="{'viewer-chart-height' : reportMode == 'viewer' && isDcubeEnabledInCustomReports ,'builder-chart-height' : reportMode == 'builder' && isDcubeEnabledInCustomReports}">
			</highchart>

		<div class="clearFloat"></div>
  </div>
<div id="{{component.id}}"
		class="clearFloat reportTable reportView previewTable_table" data-ng-if="component.chartType =='heatmap'" >

		<div ng-controller="reportChartCtrl" class="maskLayer full-height" data-ng-class="{'isMasked':masked}">
		<div class="tableOptions" data-ng-hide="tableOptions">
			<div class="pivotOptions"
				data-ng-show="reportMode == 'builder' && component.type === 'HEAT_MAP' && !isFullScreen">

				<fieldset class="axisColumnDrop ng-isolate-scope"
					x-lvl-drop-target="true" data-droptype="heatMapRow"
					x-on-drop="dropped(dragEl, dropEl)">

					<legend class="fieldsetLegend ng-binding">
						<fmt:message key="CustomReport.Component.Drop.Row">
							<fmt:param value="${heatmap}" />
						</fmt:message>
					</legend>
					<div class="chartColumns groupingCol"
						data-ng-class="{'hidden':component.heatMapRow == undefined || component.heatMapRow.column == undefined }">
						<label> ({{component.heatMapRow.column}}) <span
							class="deleteColumn" data-ng-click="deleteHeatMapCol(component.dimensionDataField, component.heatMapRow.column,'heatMapRow')">&times;</span>
						</label>
						<!-- No need of a delete button on the dimension data field as it is a mandatory column for all chart types -->

					</div>
				</fieldset>

				<fieldset class="axisColumnDrop ng-isolate-scope"
					x-lvl-drop-target="true" data-droptype="heatMapColumn"
					x-on-drop="dropped(dragEl, dropEl)">

					<legend class="fieldsetLegend ng-binding">
						<fmt:message key="CustomReport.Component.Drop.Column">
							<fmt:param value="${heatmap}" />
						</fmt:message>
					</legend>
					<div class="chartColumns groupingCol"
						data-ng-class="{'hidden':component.heatMapColumn == undefined || component.heatMapColumn.column == undefined }">
						<label> ({{component.heatMapColumn.column}}) <span
							class="deleteColumn" data-ng-click="deleteHeatMapCol(component.dimensionDataField, component.heatMapColumn.column,'heatMapColumn')">&times;</span></label>
					</div>
				</fieldset>

				<fieldset class="axisColumnDrop ng-isolate-scope"
					x-lvl-drop-target="true" data-droptype="heatMapCell"
					x-on-drop="dropped(dragEl, dropEl)">

					<legend class="fieldsetLegend ng-binding">
						<fmt:message key="CustomReport.Component.Drop.Cell">
							<fmt:param value="${heatmap}" />
						</fmt:message>
					</legend>
					<div class="chartColumns groupingCol"
						data-ng-class="{'hidden':component.heatMapCell == undefined || component.heatMapCell.column == undefined }">

						<label> <select
							data-ng-model="component.heatMapCell.aggrType"
							data-ng-change="aggregateSelectionChanged()" class="colNoBorder">
								<option value="None">None</option>
								<option value="Count">Count</option>
								<option value="CountDistinct">Distinct</option>
								<option data-ng-if="component.heatMapCell.showNumberOps"
									value="Sum"><fmt:message key="CustomReport.Sum" /></option>
								<option data-ng-if="component.heatMapCell.showNumberOps"
									value="Avg">Avg</option>
								<option data-ng-if="component.heatMapCell.showNumberOps"
									value="Min">Min</option>
								<option data-ng-if="component.heatMapCell.showNumberOps"
									value="Max">Max</option>
						</select> ({{component.heatMapCell.column}})
						</label> <span class="deleteColumn"
							data-ng-click="deleteHeatMapCol(component.measureDataField, component.heatMapCell.column,'heatMapCell')">&times;</span>
					</div>
				</fieldset>
			</div>
		</div>
		<div class="clearFloat"></div>
			<div class="noChartDiv"  data-ng-show="isShowNoChartDiv()" data-ng-click="setActiveComponent()">
					<label data-ng-show="componentLoaded && !component.isChartExist "><fmt:message key="CustomReport.NoDataAvailable"/></label>
			</div>
			<highchart  data-ng-show="!$scope.masked && component.isChartExist"  config="chartConfig"  data-ng-class="{'viewer-chart-height' : reportMode == 'viewer' && isDcubeEnabledInCustomReports ,'builder-chart-height' : reportMode == 'builder' && isDcubeEnabledInCustomReports}">
			</highchart>
	</div>
</div>
</div>
<div data-ng-if="component.showInTabularForm" style="height: 100%; overflow-y: scroll;">
	<table class="table" style="font-size: 12px;">
		<thead>
			<tr>
					<th data-ng-repeat="field in component.dimensionDataField" data-ng-hide="reportMode!='builder'&&field.hideColumn">
					<span class="cursor-pointer" data-ng-class="{'glyphicon glyphicon-eye-open': !field.hideColumn,'glyphicon glyphicon-eye-close': field.hideColumn}" data-ng-hide="reportMode!='builder'" data-ng-attr-title="{{field.hideColumn? 'Show Column': 'Hide Column'}}" data-ng-click="field.hideColumn=!field.hideColumn"></span>&nbsp;{{field.title.text}}</th>
					<th data-ng-repeat="field in component.measureDataField" data-ng-hide="reportMode!='builder'&&field.hideColumn">
					<span class="cursor-pointer" data-ng-class="{'glyphicon glyphicon-eye-open': !field.hideColumn,'glyphicon glyphicon-eye-close': field.hideColumn}" data-ng-hide="reportMode!='builder'" data-ng-attr-title="{{field.hideColumn? 'Show Column': 'Hide Column'}}" data-ng-click="field.hideColumn=!field.hideColumn"></span>&nbsp;{{field.title.text}}</th>
			</tr>
		</thead>
		<tbody>
			<tr data-ng-repeat="record in tempComponent.tabularData.records">
					<td data-ng-repeat="val in record track by $index" data-ng-bind-html="getFormattedValueTabularData(val, $index)" data-ng-hide="reportMode!='builder'&&isHiddenColumn($index)"></td>
			</tr>
		</tbody>
	</table>
	</div>
</div>
</fmt:bundle>